/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.output.markdown;

import java.io.PrintWriter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\bJ\u0011\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\r\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\bH\u0086\u0002J\u0006\u0010\u0010\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bJ\r\u0010\u0012\u001a\u00020\u0006*\u00020\bH\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/pluginverifier/output/markdown/Markdown;", "", "out", "Ljava/io/PrintWriter;", "(Ljava/io/PrintWriter;)V", "h1", "", "header", "", "h2", "h3", "paragraph", "content", "plus", "markdown", "value", "unorderedListEnd", "unorderedListItem", "unaryPlus", "verifier-cli"})
public final class Markdown {
    @NotNull
    private final PrintWriter out;

    public Markdown(@NotNull PrintWriter out) {
        Intrinsics.checkNotNullParameter(out, "out");
        this.out = out;
    }

    public final void h1(@NotNull String header) {
        Intrinsics.checkNotNullParameter(header, "header");
        this.out.println("# " + header);
        this.out.println();
    }

    @NotNull
    public final Markdown h2(@NotNull String header) {
        Intrinsics.checkNotNullParameter(header, "header");
        this.out.println("## " + header);
        this.out.println();
        return this;
    }

    public final void h3(@NotNull String header) {
        Intrinsics.checkNotNullParameter(header, "header");
        this.out.println("### " + header);
        this.out.println();
    }

    public final void unorderedListItem(@NotNull String content) {
        Intrinsics.checkNotNullParameter(content, "content");
        this.out.println("* " + content);
    }

    public final void unorderedListEnd() {
        this.out.println();
    }

    @NotNull
    public final Markdown paragraph(@NotNull String content) {
        Intrinsics.checkNotNullParameter(content, "content");
        this.out.println(content);
        Intrinsics.checkNotNullExpressionValue(((Appendable)this.out).append('\n'), "append('\\n')");
        return this;
    }

    public final void unaryPlus(@NotNull String $this$unaryPlus) {
        Intrinsics.checkNotNullParameter($this$unaryPlus, "<this>");
        this.out.println($this$unaryPlus);
    }

    public final void plus(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.out.println(value);
    }

    public final void plus(@NotNull Markdown markdown) {
        Intrinsics.checkNotNullParameter(markdown, "markdown");
    }
}

