/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.network;

import com.jetbrains.pluginverifier.network.BaseNetworkException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0014\u0010\t\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/pluginverifier/network/TimeOutException;", "Lcom/jetbrains/pluginverifier/network/BaseNetworkException;", "serverUrl", "", "timeOut", "", "timeOutUnit", "Ljava/util/concurrent/TimeUnit;", "(Ljava/lang/String;JLjava/util/concurrent/TimeUnit;)V", "message", "getMessage", "()Ljava/lang/String;", "verifier-repository"})
public final class TimeOutException
extends BaseNetworkException {
    private final long timeOut;
    @NotNull
    private final TimeUnit timeOutUnit;

    public TimeOutException(@NotNull String serverUrl, long timeOut, @NotNull TimeUnit timeOutUnit) {
        Intrinsics.checkNotNullParameter(serverUrl, "serverUrl");
        Intrinsics.checkNotNullParameter((Object)timeOutUnit, "timeOutUnit");
        super(serverUrl);
        this.timeOut = timeOut;
        this.timeOutUnit = timeOutUnit;
    }

    @Override
    @NotNull
    public String getMessage() {
        String string2 = this.getServerUrl();
        String string3 = this.timeOutUnit.toString();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault()");
        String string4 = string3.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String).toLowerCase(locale)");
        return "Request to " + string2 + " hasn't been completed in " + this.timeOut + " " + string4;
    }
}

