/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.jdk;

import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.pluginverifier.jdk.JdkVersion;
import java.io.Closeable;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/pluginverifier/jdk/JdkDescriptor;", "Ljava/io/Closeable;", "jdkPath", "Ljava/nio/file/Path;", "jdkResolver", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "jdkVersion", "Lcom/jetbrains/pluginverifier/jdk/JdkVersion;", "(Ljava/nio/file/Path;Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;Lcom/jetbrains/pluginverifier/jdk/JdkVersion;)V", "getJdkPath", "()Ljava/nio/file/Path;", "getJdkResolver", "()Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "getJdkVersion", "()Lcom/jetbrains/pluginverifier/jdk/JdkVersion;", "close", "", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "verifier-intellij"})
public final class JdkDescriptor
implements Closeable {
    @NotNull
    private final Path jdkPath;
    @NotNull
    private final Resolver jdkResolver;
    @NotNull
    private final JdkVersion jdkVersion;

    public JdkDescriptor(@NotNull Path jdkPath, @NotNull Resolver jdkResolver, @NotNull JdkVersion jdkVersion) {
        Intrinsics.checkNotNullParameter(jdkPath, "jdkPath");
        Intrinsics.checkNotNullParameter(jdkResolver, "jdkResolver");
        Intrinsics.checkNotNullParameter(jdkVersion, "jdkVersion");
        this.jdkPath = jdkPath;
        this.jdkResolver = jdkResolver;
        this.jdkVersion = jdkVersion;
    }

    @NotNull
    public final Path getJdkPath() {
        return this.jdkPath;
    }

    @NotNull
    public final Resolver getJdkResolver() {
        return this.jdkResolver;
    }

    @NotNull
    public final JdkVersion getJdkVersion() {
        return this.jdkVersion;
    }

    @NotNull
    public String toString() {
        return ((Object)this.jdkPath.toAbsolutePath()).toString();
    }

    @Override
    public void close() {
        this.jdkResolver.close();
    }

    @NotNull
    public final Path component1() {
        return this.jdkPath;
    }

    @NotNull
    public final Resolver component2() {
        return this.jdkResolver;
    }

    @NotNull
    public final JdkVersion component3() {
        return this.jdkVersion;
    }

    @NotNull
    public final JdkDescriptor copy(@NotNull Path jdkPath, @NotNull Resolver jdkResolver, @NotNull JdkVersion jdkVersion) {
        Intrinsics.checkNotNullParameter(jdkPath, "jdkPath");
        Intrinsics.checkNotNullParameter(jdkResolver, "jdkResolver");
        Intrinsics.checkNotNullParameter(jdkVersion, "jdkVersion");
        return new JdkDescriptor(jdkPath, jdkResolver, jdkVersion);
    }

    public static /* synthetic */ JdkDescriptor copy$default(JdkDescriptor jdkDescriptor, Path path, Resolver resolver, JdkVersion jdkVersion, int n, Object object) {
        if ((n & 1) != 0) {
            path = jdkDescriptor.jdkPath;
        }
        if ((n & 2) != 0) {
            resolver = jdkDescriptor.jdkResolver;
        }
        if ((n & 4) != 0) {
            jdkVersion = jdkDescriptor.jdkVersion;
        }
        return jdkDescriptor.copy(path, resolver, jdkVersion);
    }

    public int hashCode() {
        int result2 = ((Object)this.jdkPath).hashCode();
        result2 = result2 * 31 + this.jdkResolver.hashCode();
        result2 = result2 * 31 + this.jdkVersion.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JdkDescriptor)) {
            return false;
        }
        JdkDescriptor jdkDescriptor = (JdkDescriptor)other;
        if (!Intrinsics.areEqual(this.jdkPath, jdkDescriptor.jdkPath)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.jdkResolver, jdkDescriptor.jdkResolver)) {
            return false;
        }
        return Intrinsics.areEqual(this.jdkVersion, jdkDescriptor.jdkVersion);
    }
}

