/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.ide.repositories;

import com.jetbrains.pluginverifier.ide.repositories.Product;
import com.jetbrains.pluginverifier.misc.RestApiFailed;
import com.jetbrains.pluginverifier.misc.RestApiOk;
import com.jetbrains.pluginverifier.misc.RestApiResult;
import com.jetbrains.pluginverifier.misc.RestApis;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/pluginverifier/ide/repositories/DataServicesConnector;", "", "dataServicesUrl", "", "(Ljava/lang/String;)V", "restApi", "Lcom/jetbrains/pluginverifier/misc/RestApis;", "getProducts", "", "Lcom/jetbrains/pluginverifier/ide/repositories/Product;", "verifier-repository"})
final class DataServicesConnector {
    @NotNull
    private final String dataServicesUrl;
    @NotNull
    private final RestApis restApi;

    public DataServicesConnector(@NotNull String dataServicesUrl) {
        Intrinsics.checkNotNullParameter(dataServicesUrl, "dataServicesUrl");
        this.dataServicesUrl = dataServicesUrl;
        this.restApi = new RestApis();
    }

    @NotNull
    public final List<Product> getProducts() {
        List<Product> list;
        String uri = this.dataServicesUrl + "/products";
        RestApiResult apiResult = RestApis.getList$default(this.restApi, uri, Product.class, null, 4, null);
        if (apiResult instanceof RestApiOk) {
            list = (List<Product>)((RestApiOk)apiResult).getPayload();
        } else if (apiResult instanceof RestApiFailed) {
            list = CollectionsKt.emptyList();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }
}

