/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.ide.repositories;

import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import com.jetbrains.pluginverifier.ide.AvailableIde;
import com.jetbrains.pluginverifier.ide.repositories.IdeRepository;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/pluginverifier/ide/repositories/CompositeIdeRepository;", "Lcom/jetbrains/pluginverifier/ide/repositories/IdeRepository;", "ideRepositories", "", "(Ljava/util/List;)V", "fetchIndex", "Lcom/jetbrains/pluginverifier/ide/AvailableIde;", "Companion", "verifier-repository"})
public final class CompositeIdeRepository
implements IdeRepository {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final List<IdeRepository> ideRepositories;
    @NotNull
    private static final Logger LOG;

    public CompositeIdeRepository(@NotNull List<? extends IdeRepository> ideRepositories) {
        Intrinsics.checkNotNullParameter(ideRepositories, "ideRepositories");
        this.ideRepositories = ideRepositories;
    }

    @Override
    @NotNull
    public List<AvailableIde> fetchIndex() {
        HashMap versionToIde = new HashMap();
        for (IdeRepository ideRepository : this.ideRepositories) {
            List<AvailableIde> list;
            try {
                list = ideRepository.fetchIndex();
            }
            catch (Exception e) {
                LOG.warn("Failed to request index from " + ideRepository + ": " + e.getMessage());
                continue;
            }
            List<AvailableIde> index = list;
            for (AvailableIde availableIde : index) {
                AvailableIde ide = (AvailableIde)versionToIde.get(availableIde.getVersion());
                if (ide != null && !availableIde.isRelease()) continue;
                ((Map)versionToIde).put(availableIde.getVersion(), availableIde);
            }
        }
        Collection collection = versionToIde.values();
        Intrinsics.checkNotNullExpressionValue(collection, "versionToIde.values");
        return CollectionsKt.toList(collection);
    }

    @Override
    @Nullable
    public AvailableIde fetchAvailableIde(@NotNull IdeVersion ideVersion) throws InterruptedException {
        return IdeRepository.DefaultImpls.fetchAvailableIde(this, ideVersion);
    }

    static {
        Logger logger = LoggerFactory.getLogger(CompositeIdeRepository.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(CompositeIdeRepository::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/pluginverifier/ide/repositories/CompositeIdeRepository$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "getLOG", "()Lorg/slf4j/Logger;", "verifier-repository"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

