/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.ide;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.base.utils.ZipUtilKt;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import com.jetbrains.pluginverifier.ide.AvailableIde;
import com.jetbrains.pluginverifier.ide.IdeDownloader;
import com.jetbrains.pluginverifier.repository.downloader.DownloadResult;
import com.jetbrains.pluginverifier.repository.downloader.Downloader;
import com.jetbrains.pluginverifier.repository.downloader.UrlDownloader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/pluginverifier/ide/IdeDownloader;", "Lcom/jetbrains/pluginverifier/repository/downloader/Downloader;", "Lcom/jetbrains/pluginverifier/ide/AvailableIde;", "()V", "urlDownloader", "Lcom/jetbrains/pluginverifier/repository/downloader/UrlDownloader;", "download", "Lcom/jetbrains/pluginverifier/repository/downloader/DownloadResult;", "key", "tempDirectory", "Ljava/nio/file/Path;", "downloadIde", "availableIde", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "extractIdeToTempDir", "archivedIde", "Companion", "verifier-repository"})
@SourceDebugExtension(value={"SMAP\nIdeDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeDownloader.kt\ncom/jetbrains/pluginverifier/ide/IdeDownloader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1#2:142\n*E\n"})
public final class IdeDownloader
implements Downloader<AvailableIde> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UrlDownloader<AvailableIde> urlDownloader = new UrlDownloader(urlDownloader.1.INSTANCE);

    @Override
    @NotNull
    public DownloadResult download(@NotNull AvailableIde key, @NotNull Path tempDirectory) throws InterruptedException {
        DownloadResult downloadResult;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(tempDirectory, "tempDirectory");
        try {
            downloadResult = this.downloadIde(key, key.getVersion(), tempDirectory);
        }
        catch (Exception e) {
            LanguageUtilsKt.rethrowIfInterrupted(e);
            downloadResult = new DownloadResult.FailedToDownload("Unable to download " + key, e);
        }
        return downloadResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DownloadResult downloadIde(AvailableIde availableIde, IdeVersion ideVersion, Path tempDirectory) {
        DownloadResult downloadResult;
        DownloadResult $this$downloadIde_u24lambda_u240 = this.urlDownloader.download(availableIde, tempDirectory);
        boolean bl = false;
        DownloadResult downloadResult2 = $this$downloadIde_u24lambda_u240;
        if (downloadResult2 instanceof DownloadResult.Downloaded) {
            DownloadResult downloadResult3;
            try {
                downloadResult3 = this.extractIdeToTempDir(((DownloadResult.Downloaded)$this$downloadIde_u24lambda_u240).getDownloadedFileOrDirectory(), tempDirectory);
            }
            finally {
                FileUtilKt.deleteLogged(((DownloadResult.Downloaded)$this$downloadIde_u24lambda_u240).getDownloadedFileOrDirectory());
            }
            downloadResult = downloadResult3;
        } else if (downloadResult2 instanceof DownloadResult.NotFound) {
            downloadResult = new DownloadResult.NotFound("IDE " + ideVersion + " is not found: " + ((DownloadResult.NotFound)$this$downloadIde_u24lambda_u240).getReason());
        } else if (downloadResult2 instanceof DownloadResult.FailedToDownload) {
            downloadResult = new DownloadResult.FailedToDownload("Failed to download IDE " + ideVersion + ": " + ((DownloadResult.FailedToDownload)$this$downloadIde_u24lambda_u240).getReason(), ((DownloadResult.FailedToDownload)$this$downloadIde_u24lambda_u240).getError());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return downloadResult;
    }

    private final DownloadResult extractIdeToTempDir(Path archivedIde, Path tempDirectory) {
        DownloadResult downloadResult;
        Path destinationDir = Files.createTempDirectory(tempDirectory, "", new FileAttribute[0]);
        try {
            Intrinsics.checkNotNullExpressionValue(destinationDir, "destinationDir");
            ZipUtilKt.extractTo$default(archivedIde, destinationDir, null, 2, null);
            Path path = destinationDir.resolve("__MACOSX");
            Intrinsics.checkNotNullExpressionValue(path, "destinationDir.resolve(\"__MACOSX\")");
            if (FileUtilKt.isDirectory(path)) {
                if (!(FileUtilKt.listFiles(destinationDir).size() == 2)) {
                    boolean $i$a$-require-IdeDownloader$extractIdeToTempDir$32 = false;
                    List<Path> $i$a$-require-IdeDownloader$extractIdeToTempDir$32 = FileUtilKt.listFiles(destinationDir);
                    throw new IllegalArgumentException($i$a$-require-IdeDownloader$extractIdeToTempDir$32.toString());
                }
                Path path2 = destinationDir.resolve("__MACOSX");
                Intrinsics.checkNotNullExpressionValue(path2, "destinationDir.resolve(\"__MACOSX\")");
                FileUtilKt.deleteQuietly(path2);
                Companion.stripTopLevelDirectory(destinationDir);
                if (!Intrinsics.areEqual(FileUtilKt.listFiles(destinationDir), CollectionsKt.listOf(destinationDir.resolve("Contents")))) {
                    boolean $i$a$-require-IdeDownloader$extractIdeToTempDir$42 = false;
                    List<Path> $i$a$-require-IdeDownloader$extractIdeToTempDir$42 = FileUtilKt.listFiles(destinationDir);
                    throw new IllegalArgumentException($i$a$-require-IdeDownloader$extractIdeToTempDir$42.toString());
                }
            }
            Companion.stripTopLevelDirectory(destinationDir);
            downloadResult = new DownloadResult.Downloaded(destinationDir, "", true);
        }
        catch (Throwable e) {
            Intrinsics.checkNotNullExpressionValue(destinationDir, "destinationDir");
            FileUtilKt.deleteLogged(destinationDir);
            throw e;
        }
        return downloadResult;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/pluginverifier/ide/IdeDownloader$Companion;", "", "()V", "stripTopLevelDirectory", "", "directory", "Ljava/nio/file/Path;", "verifier-repository"})
    @SourceDebugExtension(value={"SMAP\nIdeDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeDownloader.kt\ncom/jetbrains/pluginverifier/ide/IdeDownloader$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1#2:142\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void stripTopLevelDirectory(@NotNull Path directory) {
            Intrinsics.checkNotNullParameter(directory, "directory");
            List<Path> entries2 = FileUtilKt.listFiles(directory);
            if (entries2.size() != 1) {
                return;
            }
            Path single2 = CollectionsKt.single(entries2);
            if (!FileUtilKt.isDirectory(single2)) {
                return;
            }
            List<Path> contents = FileUtilKt.listFiles(single2);
            if (contents.isEmpty()) {
                Files.delete(single2);
                return;
            }
            Path conflict = null;
            for (Path from : contents) {
                if (Intrinsics.areEqual(FileUtilKt.getSimpleName(from), FileUtilKt.getSimpleName(single2))) {
                    conflict = from;
                    continue;
                }
                Path to = directory.resolve(FileUtilKt.getSimpleName(from));
                Files.move(from, to, new CopyOption[0]);
            }
            if (conflict != null) {
                Object object;
                Comparable comparable;
                Iterator iterator2 = ((Iterable)contents).iterator();
                if (!iterator2.hasNext()) {
                    comparable = null;
                } else {
                    Path it = (Path)iterator2.next();
                    boolean bl = false;
                    object = (Comparable)((Object)FileUtilKt.getSimpleName(it));
                    while (iterator2.hasNext()) {
                        Path it2 = (Path)iterator2.next();
                        $i$a$-maxOfOrNull-IdeDownloader$Companion$stripTopLevelDirectory$uniqueTempName$1 = false;
                        Comparable comparable2 = (Comparable)((Object)FileUtilKt.getSimpleName(it2));
                        if (object.compareTo(comparable2) >= 0) continue;
                        object = comparable2;
                    }
                    comparable = object;
                }
                String uniqueTempName = comparable + ".temp";
                Path tempDestination = directory.resolve(uniqueTempName);
                Intrinsics.checkNotNullExpressionValue(tempDestination, "tempDestination");
                if (!(!FileUtilKt.exists(tempDestination))) {
                    object = "Failed requirement.";
                    throw new IllegalArgumentException(object.toString());
                }
                Files.move(conflict, tempDestination, new CopyOption[0]);
                if (!FileUtilKt.listFiles(single2).isEmpty()) {
                    object = "Failed requirement.";
                    throw new IllegalArgumentException(object.toString());
                }
                FileUtilKt.deleteLogged(single2);
                Files.move(tempDestination, single2, new CopyOption[0]);
            } else {
                FileUtilKt.deleteLogged(single2);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

