/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.dependencies.resolution;

import com.jetbrains.plugin.structure.ide.Ide;
import com.jetbrains.pluginverifier.dependencies.resolution.DependencyFinder;
import com.jetbrains.pluginverifier.plugin.PluginDetailsCache;
import com.jetbrains.pluginverifier.repository.repositories.bundled.BundledPluginInfo;
import com.jetbrains.pluginverifier.repository.repositories.bundled.BundledPluginsRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/pluginverifier/dependencies/resolution/BundledPluginDependencyFinder;", "Lcom/jetbrains/pluginverifier/dependencies/resolution/DependencyFinder;", "ide", "Lcom/jetbrains/plugin/structure/ide/Ide;", "pluginDetailsCache", "Lcom/jetbrains/pluginverifier/plugin/PluginDetailsCache;", "(Lcom/jetbrains/plugin/structure/ide/Ide;Lcom/jetbrains/pluginverifier/plugin/PluginDetailsCache;)V", "bundledPluginsRepository", "Lcom/jetbrains/pluginverifier/repository/repositories/bundled/BundledPluginsRepository;", "getIde", "()Lcom/jetbrains/plugin/structure/ide/Ide;", "presentableName", "", "getPresentableName", "()Ljava/lang/String;", "findPluginDependency", "Lcom/jetbrains/pluginverifier/dependencies/resolution/DependencyFinder$Result;", "dependencyId", "isModule", "", "verifier-intellij"})
public final class BundledPluginDependencyFinder
implements DependencyFinder {
    @NotNull
    private final Ide ide;
    @NotNull
    private final PluginDetailsCache pluginDetailsCache;
    @NotNull
    private final BundledPluginsRepository bundledPluginsRepository;

    public BundledPluginDependencyFinder(@NotNull Ide ide, @NotNull PluginDetailsCache pluginDetailsCache) {
        Intrinsics.checkNotNullParameter(ide, "ide");
        Intrinsics.checkNotNullParameter(pluginDetailsCache, "pluginDetailsCache");
        this.ide = ide;
        this.pluginDetailsCache = pluginDetailsCache;
        this.bundledPluginsRepository = new BundledPluginsRepository(this.ide);
    }

    @NotNull
    public final Ide getIde() {
        return this.ide;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return "Bundled plugins of " + this.ide.getVersion().asString();
    }

    @Override
    @NotNull
    public DependencyFinder.Result findPluginDependency(@NotNull String dependencyId, boolean isModule) {
        BundledPluginInfo bundledPluginInfo;
        Intrinsics.checkNotNullParameter(dependencyId, "dependencyId");
        BundledPluginInfo bundledPluginInfo2 = bundledPluginInfo = isModule ? this.bundledPluginsRepository.findPluginByModule(dependencyId) : this.bundledPluginsRepository.findPluginById(dependencyId);
        if (bundledPluginInfo != null) {
            return new DependencyFinder.Result.DetailsProvided(this.pluginDetailsCache.getPluginDetailsCacheEntry(bundledPluginInfo));
        }
        return new DependencyFinder.Result.NotFound("Dependency " + dependencyId + " is not found among the bundled plugins of " + this.ide);
    }
}

