/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.analysis;

import com.jetbrains.plugin.structure.classes.resolvers.ResolutionResult;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.ModuleDescriptor;
import com.jetbrains.plugin.structure.intellij.plugin.OptionalPluginDescriptor;
import com.jetbrains.plugin.structure.intellij.plugin.PluginDependency;
import com.jetbrains.plugin.structure.intellij.plugin.PluginXmlUtil;
import com.jetbrains.pluginverifier.analysis.ReachabilityGraph;
import com.jetbrains.pluginverifier.analysis.TypeGraph;
import com.jetbrains.pluginverifier.analysis.TypeReferences;
import com.jetbrains.pluginverifier.analysis.TypeReferencesClassVisitor;
import com.jetbrains.pluginverifier.dependencies.DependenciesGraph;
import com.jetbrains.pluginverifier.dependencies.MissingDependency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0014\u0010\u000f\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002*\f\b\u0002\u0010\u0012\"\u00020\u00132\u00020\u0013\u00a8\u0006\u0014"}, d2={"buildClassReachabilityGraph", "Lcom/jetbrains/pluginverifier/analysis/ReachabilityGraph;", "idePlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "pluginResolver", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "dependenciesGraph", "Lcom/jetbrains/pluginverifier/dependencies/DependenciesGraph;", "buildTypeGraph", "Lcom/jetbrains/pluginverifier/analysis/TypeGraph;", "addConstantDynamic", "", "Lcom/jetbrains/pluginverifier/analysis/TypeReferences;", "constantDynamic", "Lorg/objectweb/asm/ConstantDynamic;", "addHandle", "handle", "Lorg/objectweb/asm/Handle;", "ClassName", "", "verifier-intellij"})
@SourceDebugExtension(value={"SMAP\nClassReachabilityAnalysis.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassReachabilityAnalysis.kt\ncom/jetbrains/pluginverifier/analysis/ClassReachabilityAnalysisKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,332:1\n766#2:333\n857#2,2:334\n766#2:337\n857#2:338\n1549#2:339\n1620#2,3:340\n858#2:343\n1549#2:344\n1620#2,3:345\n1855#2,2:348\n1#3:336\n*S KotlinDebug\n*F\n+ 1 ClassReachabilityAnalysis.kt\ncom/jetbrains/pluginverifier/analysis/ClassReachabilityAnalysisKt\n*L\n92#1:333\n92#1:334,2\n96#1:337\n96#1:338\n96#1:339\n96#1:340,3\n96#1:343\n97#1:344\n97#1:345,3\n98#1:348,2\n*E\n"})
public final class ClassReachabilityAnalysisKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ReachabilityGraph buildClassReachabilityGraph(@NotNull IdePlugin idePlugin, @NotNull Resolver pluginResolver, @NotNull DependenciesGraph dependenciesGraph) {
        MissingDependency it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(idePlugin, "idePlugin");
        Intrinsics.checkNotNullParameter(pluginResolver, "pluginResolver");
        Intrinsics.checkNotNullParameter(dependenciesGraph, "dependenciesGraph");
        TypeGraph typeGraph = ClassReachabilityAnalysisKt.buildTypeGraph(pluginResolver);
        ReachabilityGraph reachabilityGraph = new ReachabilityGraph(typeGraph);
        Set<String> set = PluginXmlUtil.getAllClassesReferencedFromXml(idePlugin);
        Intrinsics.checkNotNullExpressionValue(set, "getAllClassesReferencedFromXml(idePlugin)");
        Set<String> mainClasses = set;
        for (String className : mainClasses) {
            Intrinsics.checkNotNullExpressionValue(className, "className");
            reachabilityGraph.markClass(className, ReachabilityGraph.ReachabilityMark.MAIN_PLUGIN);
        }
        Iterable $this$filter$iv = dependenciesGraph.getDirectMissingDependencies();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (MissingDependency)element$iv$iv;
            boolean bl = false;
            if (!it.getDependency().isOptional()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List missingOptionalDependencies = (List)destination$iv$iv;
        for (MissingDependency missingOptionalDependency : missingOptionalDependencies) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ModuleDescriptor it2;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2;
            MissingDependency missingDependency;
            Object element$iv$iv;
            block9: {
                Iterable iterable2 = idePlugin.getOptionalDescriptors();
                element$iv$iv = iterable2.iterator();
                while (element$iv$iv.hasNext()) {
                    it = element$iv$iv.next();
                    OptionalPluginDescriptor it3 = (OptionalPluginDescriptor)((Object)it);
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it3.getDependency(), missingOptionalDependency.getDependency())) continue;
                    missingDependency = it;
                    break block9;
                }
                missingDependency = null;
            }
            OptionalPluginDescriptor optionalPluginDescriptor = (OptionalPluginDescriptor)((Object)missingDependency);
            IdePlugin optionalPlugin = optionalPluginDescriptor != null ? optionalPluginDescriptor.getOptionalPlugin() : null;
            Iterable $i$f$filterTo2 = idePlugin.getModulesDescriptors();
            boolean $i$f$filter2 = false;
            element$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                void $this$mapTo$iv$iv2;
                it2 = (ModuleDescriptor)element$iv$iv2;
                boolean bl = false;
                Iterable $this$map$iv2 = it2.getDependencies();
                boolean $i$f$map = false;
                Iterable iterable3 = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it4;
                    PluginDependency pluginDependency = (PluginDependency)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl2 = false;
                    collection.add(it4.getId());
                }
                if (!((List)destination$iv$iv3).contains(missingOptionalDependency.getDependency().getId())) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv2 = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (ModuleDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it2.getModule());
            }
            List<IdePlugin> modules = (List<IdePlugin>)destination$iv$iv2;
            Iterable $this$forEach$iv = optionalPlugin != null ? CollectionsKt.plus((Collection)modules, optionalPlugin) : modules;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Set<String> optionalClasses;
                IdePlugin it5 = (IdePlugin)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(PluginXmlUtil.getAllClassesReferencedFromXml(it5), "getAllClassesReferencedFromXml(it)");
                for (String className : optionalClasses) {
                    Intrinsics.checkNotNullExpressionValue(className, "className");
                    reachabilityGraph.markClass(className, ReachabilityGraph.ReachabilityMark.OPTIONAL_PLUGIN);
                }
            }
        }
        return reachabilityGraph;
    }

    private static final TypeGraph buildTypeGraph(Resolver pluginResolver) {
        TypeGraph graph = new TypeGraph();
        pluginResolver.processAllClasses((Function1<? super ResolutionResult<? extends ClassNode>, Boolean>)new Function1<ResolutionResult<? extends ClassNode>, Boolean>(pluginResolver, graph){
            final /* synthetic */ Resolver $pluginResolver;
            final /* synthetic */ TypeGraph $graph;
            {
                this.$pluginResolver = $pluginResolver;
                this.$graph = $graph;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ResolutionResult<? extends ClassNode> resolutionResult) {
                Intrinsics.checkNotNullParameter(resolutionResult, "resolutionResult");
                if (!(resolutionResult instanceof ResolutionResult.Found)) {
                    return true;
                }
                ClassNode classNode = (ClassNode)((ResolutionResult.Found)resolutionResult).getValue();
                TypeReferences references = new TypeReferences();
                classNode.accept(new TypeReferencesClassVisitor(references));
                HashSet<String> typeReferences = references.getTypeReferences();
                for (String typeReference : typeReferences) {
                    Intrinsics.checkNotNullExpressionValue(typeReference, "typeReference");
                    if (!this.$pluginResolver.containsClass(typeReference)) continue;
                    String string2 = classNode.name;
                    Intrinsics.checkNotNullExpressionValue(string2, "classNode.name");
                    this.$graph.addEdge(string2, typeReference);
                }
                return true;
            }
        });
        return graph;
    }

    private static final void addHandle(TypeReferences $this$addHandle, Handle handle) {
        Type type2 = Type.getObjectType(handle.getOwner());
        Intrinsics.checkNotNullExpressionValue(type2, "getObjectType(handle.owner)");
        $this$addHandle.addReferences(type2);
        Type handleType = Type.getType(handle.getDesc());
        Intrinsics.checkNotNullExpressionValue(handleType, "handleType");
        $this$addHandle.addReferences(handleType);
    }

    private static final void addConstantDynamic(TypeReferences $this$addConstantDynamic, ConstantDynamic constantDynamic) {
        Type type2 = Type.getType(constantDynamic.getDescriptor());
        Intrinsics.checkNotNullExpressionValue(type2, "getType(constantDynamic.descriptor)");
        $this$addConstantDynamic.addReferences(type2);
        Handle handle = constantDynamic.getBootstrapMethod();
        Intrinsics.checkNotNullExpressionValue(handle, "constantDynamic.bootstrapMethod");
        ClassReachabilityAnalysisKt.addHandle($this$addConstantDynamic, handle);
    }

    public static final /* synthetic */ void access$addHandle(TypeReferences $receiver, Handle handle) {
        ClassReachabilityAnalysisKt.addHandle($receiver, handle);
    }

    public static final /* synthetic */ void access$addConstantDynamic(TypeReferences $receiver, ConstantDynamic constantDynamic) {
        ClassReachabilityAnalysisKt.addConstantDynamic($receiver, constantDynamic);
    }
}

