/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.jar;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.jar.JarArchiveCannotBeOpenException;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/plugin/structure/jar/UriJarFileSystemProvider;", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "pathToUri", "Lkotlin/Function1;", "Ljava/nio/file/Path;", "Ljava/net/URI;", "(Lkotlin/jvm/functions/Function1;)V", "log", "Lorg/slf4j/Logger;", "close", "", "jarPath", "getFileSystem", "Ljava/nio/file/FileSystem;", "structure-base"})
public final class UriJarFileSystemProvider
implements JarFileSystemProvider {
    private final Logger log;
    private final Function1<Path, URI> pathToUri;

    @Override
    @NotNull
    public FileSystem getFileSystem(@NotNull Path jarPath) throws JarArchiveCannotBeOpenException {
        FileSystem fileSystem;
        Intrinsics.checkNotNullParameter(jarPath, "jarPath");
        URI jarUri = this.pathToUri.invoke(jarPath);
        try {
            if (!FileUtilKt.isZip(jarPath) && !FileUtilKt.isJar(jarPath)) {
                throw (Throwable)new JarArchiveCannotBeOpenException(jarPath, "must end with '.zip' or '.jar'");
            }
            try {
                FileSystem it = fileSystem = FileSystems.getFileSystem(jarUri);
                boolean bl = false;
                this.log.debug("Reusing JAR filesystem from JVM cache <{}>", (Object)jarUri);
            }
            catch (FileSystemNotFoundException e) {
                FileSystem fileSystem2;
                FileSystem it = fileSystem2 = FileSystems.newFileSystem(jarUri, MapsKt.emptyMap());
                boolean bl = false;
                this.log.debug("JAR filesystem not found. Creating a new one for <{}>", (Object)jarUri);
                fileSystem = fileSystem2;
            }
            FileSystem fileSystem3 = fileSystem;
            Intrinsics.checkNotNullExpressionValue(fileSystem3, "try {\n        FileSystem\u2026jarUri)\n        }\n      }");
            fileSystem = fileSystem3;
        }
        catch (JarArchiveCannotBeOpenException e) {
            throw (Throwable)e;
        }
        catch (Throwable e) {
            throw (Throwable)new JarArchiveCannotBeOpenException(jarUri, e);
        }
        return fileSystem;
    }

    @Override
    public void close(@NotNull Path jarPath) {
        Intrinsics.checkNotNullParameter(jarPath, "jarPath");
    }

    public UriJarFileSystemProvider(@NotNull Function1<? super Path, URI> pathToUri) {
        Intrinsics.checkNotNullParameter(pathToUri, "pathToUri");
        this.pathToUri = pathToUri;
        Logger logger = LoggerFactory.getLogger(UriJarFileSystemProvider.class);
        Intrinsics.checkNotNullExpressionValue(logger, "LoggerFactory.getLogger(\u2026stemProvider::class.java)");
        this.log = logger;
    }

    public /* synthetic */ UriJarFileSystemProvider(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = 1.INSTANCE;
        }
        this(function1);
    }

    public UriJarFileSystemProvider() {
        this(null, 1, null);
    }
}

