/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.jar;

import com.jetbrains.plugin.structure.jar.CachingJarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.JarArchiveCannotBeOpenException;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.JarsKt;
import com.jetbrains.plugin.structure.jar.UriJarFileSystemProvider;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/plugin/structure/jar/CachingJarFileSystemProvider;", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "Ljava/lang/AutoCloseable;", "()V", "delegateJarFileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/UriJarFileSystemProvider;", "fsCache", "", "Ljava/net/URI;", "Ljava/nio/file/FileSystem;", "close", "", "jarPath", "Ljava/nio/file/Path;", "getFileSystem", "structure-base"})
public final class CachingJarFileSystemProvider
implements JarFileSystemProvider,
AutoCloseable {
    private final Map<URI, FileSystem> fsCache = new ConcurrentHashMap();
    private final UriJarFileSystemProvider delegateJarFileSystemProvider = new UriJarFileSystemProvider(delegateJarFileSystemProvider.1.INSTANCE);

    @Override
    @NotNull
    public FileSystem getFileSystem(@NotNull Path jarPath) {
        Intrinsics.checkNotNullParameter(jarPath, "jarPath");
        URI jarUri = JarsKt.toJarFileUri(jarPath);
        try {
            FileSystem fileSystem = this.fsCache.computeIfAbsent(jarUri, new Function(this, jarPath){
                final /* synthetic */ CachingJarFileSystemProvider this$0;
                final /* synthetic */ Path $jarPath;

                @NotNull
                public final FileSystem apply(@NotNull URI it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return CachingJarFileSystemProvider.access$getDelegateJarFileSystemProvider$p(this.this$0).getFileSystem(this.$jarPath);
                }
                {
                    this.this$0 = cachingJarFileSystemProvider;
                    this.$jarPath = path;
                }
            });
            Intrinsics.checkNotNullExpressionValue(fileSystem, "fsCache.computeIfAbsent(\u2026.getFileSystem(jarPath) }");
            return fileSystem;
        }
        catch (Throwable e) {
            throw (Throwable)new JarArchiveCannotBeOpenException(jarPath, jarUri, e);
        }
    }

    @Override
    public void close(@NotNull Path jarPath) {
        block0: {
            FileSystem fileSystem;
            Intrinsics.checkNotNullParameter(jarPath, "jarPath");
            URI jarUri = JarsKt.toJarFileUri(jarPath);
            FileSystem fileSystem2 = this.fsCache.get(jarUri);
            if (fileSystem2 == null) break block0;
            FileSystem fs = fileSystem = fileSystem2;
            boolean bl = false;
            fs.close();
            this.fsCache.remove(jarUri);
        }
    }

    @Override
    public void close() {
        this.fsCache.clear();
    }

    public static final /* synthetic */ UriJarFileSystemProvider access$getDelegateJarFileSystemProvider$p(CachingJarFileSystemProvider $this) {
        return $this.delegateJarFileSystemProvider;
    }
}

