/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.version;

import com.jetbrains.plugin.structure.base.utils.Version;
import com.jetbrains.plugin.structure.intellij.version.IdeVersionImpl;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdeVersion
implements Version<IdeVersion> {
    public static final IdeVersion maxVersion = IdeVersion.createIdeVersion("999.99999");

    @NotNull
    public static IdeVersion createIdeVersion(@NotNull String version) throws IllegalArgumentException {
        return IdeVersionImpl.Companion.fromString(version);
    }

    @Nullable
    public static IdeVersion createIdeVersionIfValid(@NotNull String version) {
        try {
            return IdeVersionImpl.Companion.fromString(version);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static boolean isValidIdeVersion(@NotNull String version) {
        return IdeVersion.createIdeVersionIfValid(version) != null;
    }

    @NotNull
    public abstract String asString(boolean var1, boolean var2);

    @Override
    @NotNull
    public String asString() {
        return this.asString(true, true);
    }

    @Override
    @NotNull
    public String asStringWithoutProductCode() {
        return this.asString(false, true);
    }

    public String asStringWithoutProductCodeAndSnapshot() {
        return this.asString(false, false);
    }

    public abstract int getBaselineVersion();

    public abstract int getBuild();

    public abstract boolean isSnapshot();

    public abstract int[] getComponents();

    public abstract long asLong();

    public final int hashCode() {
        return Arrays.hashCode(this.getComponents()) + Objects.hash(this.getProductCode(), this.isSnapshot());
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IdeVersion) {
            IdeVersion other = (IdeVersion)obj;
            return this.getProductCode().equals(other.getProductCode()) && this.isSnapshot() == other.isSnapshot() && Arrays.equals(this.getComponents(), other.getComponents());
        }
        return false;
    }

    @Override
    public final int compareTo(@NotNull IdeVersion other) {
        String thisCode = this.getProductCode();
        String otherCode = other.getProductCode();
        int compareProductCodes = thisCode.compareTo(otherCode);
        if (!thisCode.isEmpty() && !otherCode.isEmpty() && compareProductCodes != 0) {
            return compareProductCodes;
        }
        int[] c1 = this.getComponents();
        int[] c2 = other.getComponents();
        for (int i = 0; i < Math.min(c1.length, c2.length); ++i) {
            if (c1[i] == c2[i] && c1[i] == Integer.MAX_VALUE) {
                return 0;
            }
            if (c1[i] == Integer.MAX_VALUE) {
                return 1;
            }
            if (c2[i] == Integer.MAX_VALUE) {
                return -1;
            }
            int result2 = Integer.compare(c1[i], c2[i]);
            if (result2 == 0) continue;
            return result2;
        }
        return Integer.compare(c1.length, c2.length);
    }
}

