/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.problems;

import com.jetbrains.plugin.structure.base.plugin.Plugin;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.PluginProblemsKt;
import com.jetbrains.plugin.structure.base.problems.ReclassifiedPluginProblem;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.problems.IgnoredLevel;
import com.jetbrains.plugin.structure.intellij.problems.PluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.problems.RemappedLevel;
import com.jetbrains.plugin.structure.intellij.problems.StandardLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0018\b\u0002\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0016J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0019H\u0002J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J$\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0016J\u0012\u0010\u001f\u001a\u00020\b*\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\r*\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J\u0018\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\r*\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/plugin/structure/intellij/problems/LevelRemappingPluginCreationResultResolver;", "Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;", "delegatedResolver", "remappedLevel", "", "Lkotlin/reflect/KClass;", "Lcom/jetbrains/plugin/structure/intellij/problems/RemappedLevel;", "unwrapRemappedProblems", "", "(Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;Ljava/util/Map;Z)V", "classify", "Lcom/jetbrains/plugin/structure/base/problems/PluginProblem;", "pluginProblem", "", "plugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "problems", "remapErrorsAndWarnings", "errorsAndWarnings", "remapFailure", "Lcom/jetbrains/plugin/structure/base/plugin/PluginCreationResult;", "pluginCreationResult", "Lcom/jetbrains/plugin/structure/base/plugin/PluginCreationFail;", "remapPluginProblemLevel", "remapSuccess", "Lcom/jetbrains/plugin/structure/base/plugin/PluginCreationSuccess;", "remapUnacceptableWarnings", "unacceptableWarnings", "remapWarnings", "warnings", "resolve", "hasNoErrors", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nLevelRemappingPluginCreationResultResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LevelRemappingPluginCreationResultResolver.kt\ncom/jetbrains/plugin/structure/intellij/problems/LevelRemappingPluginCreationResultResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1603#2,9:99\n1855#2:108\n1856#2:110\n1612#2:111\n1603#2,9:112\n1855#2:121\n1856#2:123\n1612#2:124\n1603#2,9:125\n1855#2:134\n1856#2:136\n1612#2:137\n1603#2,9:138\n1855#2:147\n1856#2:149\n1612#2:150\n2624#2,3:151\n766#2:154\n857#2,2:155\n766#2:157\n857#2,2:158\n1#3:109\n1#3:122\n1#3:135\n1#3:148\n*E\n*S KotlinDebug\n*F\n+ 1 LevelRemappingPluginCreationResultResolver.kt\ncom/jetbrains/plugin/structure/intellij/problems/LevelRemappingPluginCreationResultResolver\n*L\n49#1,9:99\n49#1:108\n49#1:110\n49#1:111\n53#1,9:112\n53#1:121\n53#1:123\n53#1:124\n57#1,9:125\n57#1:134\n57#1:136\n57#1:137\n79#1,9:138\n79#1:147\n79#1:149\n79#1:150\n92#1,3:151\n96#1:154\n96#1,2:155\n97#1:157\n97#1,2:158\n49#1:109\n53#1:122\n57#1:135\n79#1:148\n*E\n"})
public final class LevelRemappingPluginCreationResultResolver
implements PluginCreationResultResolver {
    private final PluginCreationResultResolver delegatedResolver;
    private final Map<KClass<?>, RemappedLevel> remappedLevel;
    private final boolean unwrapRemappedProblems;

    @Override
    @NotNull
    public PluginCreationResult<IdePlugin> resolve(@NotNull IdePlugin plugin, @NotNull List<? extends PluginProblem> problems) {
        PluginCreationResult<IdePlugin> pluginCreationResult;
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(problems, "problems");
        PluginCreationResult<IdePlugin> pluginCreationResult2 = this.delegatedResolver.resolve(plugin, problems);
        if (pluginCreationResult2 instanceof PluginCreationSuccess) {
            pluginCreationResult = this.remapSuccess((PluginCreationSuccess)pluginCreationResult2);
        } else if (pluginCreationResult2 instanceof PluginCreationFail) {
            pluginCreationResult = this.remapFailure(plugin, (PluginCreationFail)pluginCreationResult2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pluginCreationResult;
    }

    private final PluginCreationResult<IdePlugin> remapSuccess(PluginCreationSuccess<? extends IdePlugin> pluginCreationResult) {
        PluginCreationSuccess<? extends IdePlugin> $this$with = pluginCreationResult;
        boolean bl = false;
        List allRemappedProblems = CollectionsKt.plus((Collection)this.remapWarnings($this$with.getWarnings()), (Iterable)this.remapUnacceptableWarnings($this$with.getUnacceptableWarnings()));
        return this.hasNoErrors(allRemappedProblems) ? (PluginCreationResult)PluginCreationSuccess.copy$default($this$with, null, this.warnings(allRemappedProblems), this.unacceptableWarnings(allRemappedProblems), null, 9, null) : (PluginCreationResult)new PluginCreationFail(allRemappedProblems);
    }

    private final PluginCreationResult<IdePlugin> remapFailure(IdePlugin plugin, PluginCreationFail<? extends IdePlugin> pluginCreationResult) {
        PluginCreationFail<? extends IdePlugin> $this$with = pluginCreationResult;
        boolean bl = false;
        List<PluginProblem> remappedErrorsAndWarnings = this.remapErrorsAndWarnings($this$with.getErrorsAndWarnings());
        if (this.hasNoErrors(remappedErrorsAndWarnings)) {
            return new PluginCreationSuccess<Plugin>(plugin, remappedErrorsAndWarnings);
        }
        return $this$with.copy(this.remapErrorsAndWarnings($this$with.getErrorsAndWarnings()));
    }

    /*
     * WARNING - void declaration
     */
    private final List<PluginProblem> remapWarnings(List<? extends PluginProblem> warnings) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable iterable = warnings;
        LevelRemappingPluginCreationResultResolver levelRemappingPluginCreationResultResolver = this;
        boolean $i$f$mapNotNull = false;
        void var5_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PluginProblem pluginProblem;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            PluginProblem p1 = (PluginProblem)element$iv$iv;
            boolean bl2 = false;
            if (levelRemappingPluginCreationResultResolver.remapPluginProblemLevel(p1) == null) continue;
            PluginProblem it$iv$iv = pluginProblem;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PluginProblem> remapUnacceptableWarnings(List<? extends PluginProblem> unacceptableWarnings) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable iterable = unacceptableWarnings;
        LevelRemappingPluginCreationResultResolver levelRemappingPluginCreationResultResolver = this;
        boolean $i$f$mapNotNull = false;
        void var5_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PluginProblem pluginProblem;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            PluginProblem p1 = (PluginProblem)element$iv$iv;
            boolean bl2 = false;
            if (levelRemappingPluginCreationResultResolver.remapPluginProblemLevel(p1) == null) continue;
            PluginProblem it$iv$iv = pluginProblem;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PluginProblem> remapErrorsAndWarnings(List<? extends PluginProblem> errorsAndWarnings) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable iterable = errorsAndWarnings;
        LevelRemappingPluginCreationResultResolver levelRemappingPluginCreationResultResolver = this;
        boolean $i$f$mapNotNull = false;
        void var5_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PluginProblem pluginProblem;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            PluginProblem p1 = (PluginProblem)element$iv$iv;
            boolean bl2 = false;
            if (levelRemappingPluginCreationResultResolver.remapPluginProblemLevel(p1) == null) continue;
            PluginProblem it$iv$iv = pluginProblem;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final PluginProblem remapPluginProblemLevel(PluginProblem pluginProblem) {
        return this.remapPluginProblemLevel(pluginProblem, this.unwrapRemappedProblems);
    }

    private final PluginProblem remapPluginProblemLevel(PluginProblem pluginProblem, boolean unwrapRemappedProblems) {
        PluginProblem pluginProblem2;
        PluginProblem problem = unwrapRemappedProblems ? PluginProblemsKt.getUnwrapped(pluginProblem) : pluginProblem;
        RemappedLevel remappedLevel = this.remappedLevel.get(Reflection.getOrCreateKotlinClass(problem.getClass()));
        if (remappedLevel instanceof StandardLevel) {
            pluginProblem2 = new ReclassifiedPluginProblem(((StandardLevel)remappedLevel).getOriginalLevel(), pluginProblem);
        } else if (remappedLevel instanceof IgnoredLevel) {
            pluginProblem2 = null;
        } else if (remappedLevel == null) {
            pluginProblem2 = pluginProblem;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pluginProblem2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PluginProblem> classify(@NotNull IdePlugin plugin, @NotNull List<? extends PluginProblem> problems) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(problems, "problems");
        Iterable $this$mapNotNull$iv = this.delegatedResolver.classify(plugin, problems);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PluginProblem pluginProblem;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            PluginProblem it = (PluginProblem)element$iv$iv;
            boolean bl2 = false;
            if (this.classify(PluginProblemsKt.getUnwrapped(it)) == null) continue;
            PluginProblem it$iv$iv = pluginProblem;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final PluginProblem classify(PluginProblem pluginProblem) {
        PluginProblem pluginProblem2;
        RemappedLevel remappedLevel = this.remappedLevel.get(Reflection.getOrCreateKotlinClass(pluginProblem.getClass()));
        if (remappedLevel instanceof StandardLevel) {
            pluginProblem2 = new ReclassifiedPluginProblem(((StandardLevel)remappedLevel).getOriginalLevel(), pluginProblem);
        } else if (remappedLevel instanceof IgnoredLevel) {
            pluginProblem2 = null;
        } else if (remappedLevel == null) {
            pluginProblem2 = pluginProblem;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pluginProblem2;
    }

    private final boolean hasNoErrors(List<? extends PluginProblem> $this$hasNoErrors) {
        boolean bl;
        block3: {
            Iterable $this$none$iv = $this$hasNoErrors;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    PluginProblem it = (PluginProblem)element$iv;
                    boolean bl2 = false;
                    if (!(it.getLevel() == PluginProblem.Level.ERROR)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PluginProblem> warnings(List<? extends PluginProblem> $this$warnings) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$warnings;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PluginProblem it = (PluginProblem)element$iv$iv;
            boolean bl = false;
            if (!(it.getLevel() == PluginProblem.Level.WARNING)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PluginProblem> unacceptableWarnings(List<? extends PluginProblem> $this$unacceptableWarnings) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$unacceptableWarnings;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PluginProblem it = (PluginProblem)element$iv$iv;
            boolean bl = false;
            if (!(it.getLevel() == PluginProblem.Level.UNACCEPTABLE_WARNING)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public LevelRemappingPluginCreationResultResolver(@NotNull PluginCreationResultResolver delegatedResolver, @NotNull Map<KClass<?>, ? extends RemappedLevel> remappedLevel, boolean unwrapRemappedProblems) {
        Intrinsics.checkNotNullParameter(delegatedResolver, "delegatedResolver");
        Intrinsics.checkNotNullParameter(remappedLevel, "remappedLevel");
        this.delegatedResolver = delegatedResolver;
        this.remappedLevel = remappedLevel;
        this.unwrapRemappedProblems = unwrapRemappedProblems;
    }

    public /* synthetic */ LevelRemappingPluginCreationResultResolver(PluginCreationResultResolver pluginCreationResultResolver, Map map2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        this(pluginCreationResultResolver, map2, bl);
    }

    @Override
    public boolean isError(@NotNull PluginProblem problem) {
        Intrinsics.checkNotNullParameter(problem, "problem");
        return PluginCreationResultResolver.DefaultImpls.isError(this, problem);
    }
}

