/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.problems;

import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.PluginProblems;
import com.jetbrains.plugin.structure.intellij.problems.IgnoredLevel;
import com.jetbrains.plugin.structure.intellij.problems.LevelRemappingDefinitions;
import com.jetbrains.plugin.structure.intellij.problems.ProblemLevelRemappingManager;
import com.jetbrains.plugin.structure.intellij.problems.RemappedLevel;
import com.jetbrains.plugin.structure.intellij.problems.StandardLevel;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0006\u0010\t\u001a\u00020\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/plugin/structure/intellij/problems/JsonUrlProblemLevelRemappingManager;", "Lcom/jetbrains/plugin/structure/intellij/problems/ProblemLevelRemappingManager;", "pluginProblemsJsonUrl", "Ljava/net/URL;", "(Ljava/net/URL;)V", "json", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "initialize", "Lcom/jetbrains/plugin/structure/intellij/problems/LevelRemappingDefinitions;", "load", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nProblemLevelRemappingManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProblemLevelRemappingManager.kt\ncom/jetbrains/plugin/structure/intellij/problems/JsonUrlProblemLevelRemappingManager\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n49#2:110\n43#2:111\n125#3:112\n152#3,2:113\n135#3,9:115\n215#3:124\n216#3:126\n144#3:127\n154#3:128\n1#4:125\n*E\n*S KotlinDebug\n*F\n+ 1 ProblemLevelRemappingManager.kt\ncom/jetbrains/plugin/structure/intellij/problems/JsonUrlProblemLevelRemappingManager\n*L\n38#1:110\n38#1:111\n40#1:112\n40#1,2:113\n41#1,9:115\n41#1:124\n41#1:126\n41#1:127\n40#1:128\n41#1:125\n*E\n"})
public final class JsonUrlProblemLevelRemappingManager
implements ProblemLevelRemappingManager {
    private final ObjectMapper json;
    private final URL pluginProblemsJsonUrl;

    @Override
    @NotNull
    public LevelRemappingDefinitions initialize() throws IOException {
        return this.load();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LevelRemappingDefinitions load() throws IOException {
        LevelRemappingDefinitions definitions = new LevelRemappingDefinitions();
        try {
            void $this$mapTo$iv$iv;
            void $this$readValue$iv;
            Map rawRemapping;
            ObjectMapper objectMapper2 = this.json;
            URL src$iv = this.pluginProblemsJsonUrl;
            boolean $i$f$readValue22 = false;
            boolean $i$f$jacksonTypeRef = false;
            Map $this$map$iv = rawRemapping = (Map)$this$readValue$iv.readValue(src$iv, (TypeReference)new TypeReference<Map<String, ? extends Map<String, ? extends String>>>(){});
            boolean $i$f$map = false;
            Map $i$f$readValue22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                void problemSetName;
                void $this$mapNotNullTo$iv$iv;
                Map problemRemapping;
                void $dstr$problemSetName$problemRemapping;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var12_18 = $dstr$problemSetName$problemRemapping;
                String string2 = (String)var12_18.getKey();
                var12_18 = $dstr$problemSetName$problemRemapping;
                Map $this$mapNotNull$iv = problemRemapping = (Map)var12_18.getValue();
                boolean $i$f$mapNotNull = false;
                Map map2 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator3 = $this$forEach$iv$iv$iv.entrySet().iterator();
                while (iterator3.hasNext()) {
                    Pair<KClass<? extends Object>, IgnoredLevel> pair;
                    Pair<KClass<? extends Object>, RemappedLevel> pair2;
                    void problemId;
                    Map.Entry element$iv$iv$iv;
                    Map.Entry element$iv$iv = element$iv$iv$iv = iterator3.next();
                    boolean bl2 = false;
                    Map.Entry $dstr$problemId$problemLevel = element$iv$iv;
                    boolean bl3 = false;
                    Map.Entry entry2 = $dstr$problemId$problemLevel;
                    String string3 = (String)entry2.getKey();
                    entry2 = $dstr$problemId$problemLevel;
                    String problemLevel = (String)entry2.getValue();
                    if (PluginProblems.INSTANCE.resolveClass((String)problemId) == null) {
                        pair2 = null;
                    } else {
                        switch (problemLevel) {
                            case "ignore": {
                                KClass<? extends Object> pluginProblemKClass;
                                pair2 = TuplesKt.to(pluginProblemKClass, IgnoredLevel.INSTANCE);
                                break;
                            }
                            case "warning": {
                                KClass<? extends Object> pluginProblemKClass;
                                pair2 = TuplesKt.to(pluginProblemKClass, new StandardLevel(PluginProblem.Level.WARNING));
                                break;
                            }
                            case "unacceptable-warning": {
                                KClass<? extends Object> pluginProblemKClass;
                                pair2 = TuplesKt.to(pluginProblemKClass, new StandardLevel(PluginProblem.Level.UNACCEPTABLE_WARNING));
                                break;
                            }
                            case "error": {
                                KClass<? extends Object> pluginProblemKClass;
                                pair2 = TuplesKt.to(pluginProblemKClass, new StandardLevel(PluginProblem.Level.ERROR));
                                break;
                            }
                            default: {
                                pair2 = null;
                            }
                        }
                    }
                    if (pair2 == null) continue;
                    Pair<KClass<? extends Object>, IgnoredLevel> it$iv$iv = pair = pair2;
                    boolean bl4 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                Map levelRemapping = MapsKt.toMap((List)destination$iv$iv2);
                definitions.set((String)problemSetName, levelRemapping);
                Unit unit = Unit.INSTANCE;
                collection.add(unit);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
        }
        catch (IOException e) {
            throw (Throwable)new IOException("Cannot load plugin problems definitions from <" + this.pluginProblemsJsonUrl + ">", e);
        }
        catch (StreamReadException e) {
            throw (Throwable)new IOException("Cannot parse plugin problems definitions from JSON in <" + this.pluginProblemsJsonUrl + ">", e);
        }
        catch (DatabindException e) {
            throw (Throwable)new IOException("Cannot deserialize plugin problems definitions from JSON in <" + this.pluginProblemsJsonUrl + ">", e);
        }
        return definitions;
    }

    public JsonUrlProblemLevelRemappingManager(@NotNull URL pluginProblemsJsonUrl) {
        Intrinsics.checkNotNullParameter(pluginProblemsJsonUrl, "pluginProblemsJsonUrl");
        this.pluginProblemsJsonUrl = pluginProblemsJsonUrl;
        this.json = new ObjectMapper();
    }
}

