/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.ide;

import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.ide.Ide;
import com.jetbrains.plugin.structure.ide.IdeImpl;
import com.jetbrains.plugin.structure.ide.IdeManager;
import com.jetbrains.plugin.structure.ide.IdeManagerImpl;
import com.jetbrains.plugin.structure.ide.IntelliJPlatformProduct;
import com.jetbrains.plugin.structure.ide.InvalidIdeException;
import com.jetbrains.plugin.structure.ide.RepositoryLibrariesUtilKt;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginManager;
import com.jetbrains.plugin.structure.intellij.plugin.JarFilesResourceResolver;
import com.jetbrains.plugin.structure.intellij.resources.CompiledModulesResourceResolver;
import com.jetbrains.plugin.structure.intellij.resources.CompositeResourceResolver;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J*\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J4\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J&\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J<\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010 \u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006#"}, d2={"Lcom/jetbrains/plugin/structure/ide/IdeManagerImpl;", "Lcom/jetbrains/plugin/structure/ide/IdeManager;", "()V", "createBundledPluginExceptionally", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "idePath", "Ljava/nio/file/Path;", "pluginFile", "pathResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "descriptorPath", "", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "createIde", "Lcom/jetbrains/plugin/structure/ide/Ide;", "version", "readBuildNumber", "versionFile", "readBundledPlugin", "readBundledPlugins", "", "platformResourceResolver", "readCompiledBundledPlugins", "moduleRoots", "readDistributionBundledPlugins", "product", "Lcom/jetbrains/plugin/structure/ide/IntelliJPlatformProduct;", "readIdeVersionFromBuildNumberFile", "readIdeVersionFromDistribution", "readPlatformPlugins", "jarFiles", "readVersionFromIdeSources", "Companion", "PlatformResourceResolver", "structure-ide"})
@SourceDebugExtension(value={"SMAP\nIdeManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeManagerImpl.kt\ncom/jetbrains/plugin/structure/ide/IdeManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,291:1\n1#2:292\n1#2:309\n2624#3,3:293\n766#3:296\n857#3,2:297\n1603#3,9:299\n1855#3:308\n1856#3:310\n1612#3:311\n766#3:312\n857#3,2:313\n*E\n*S KotlinDebug\n*F\n+ 1 IdeManagerImpl.kt\ncom/jetbrains/plugin/structure/ide/IdeManagerImpl\n*L\n231#1:309\n215#1,3:293\n230#1:296\n230#1,2:297\n231#1,9:299\n231#1:308\n231#1:310\n231#1:311\n260#1:312\n260#1,2:313\n*E\n"})
public final class IdeManagerImpl
extends IdeManager {
    private static final Logger LOG;
    @NotNull
    public static final String PLATFORM_PLUGIN_XML = "PlatformLangPlugin.xml";
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public Ide createIde(@NotNull Path idePath) {
        Intrinsics.checkNotNullParameter(idePath, "idePath");
        return this.createIde(idePath, null);
    }

    @Override
    @NotNull
    public Ide createIde(@NotNull Path idePath, @Nullable IdeVersion version) {
        IntelliJPlatformProduct intelliJPlatformProduct;
        IdeVersion ideVersion;
        IdeVersion ideVersion2;
        IdeVersion readIdeVersion;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter(idePath, "idePath");
        if (!FileUtilKt.isDirectory(idePath)) {
            throw (Throwable)new IOException("Specified path does not exist or is not a directory: " + idePath);
        }
        boolean fromCompiled = Companion.isCompiledCommunity(idePath) || Companion.isCompiledUltimate(idePath);
        boolean fromDistribution = Companion.isDistributionIde(idePath);
        if (!fromCompiled && !fromDistribution) {
            throw (Throwable)new InvalidIdeException(idePath, "IDE directory content is invalid");
        }
        IdeVersion ideVersion3 = version;
        if (ideVersion3 == null) {
            ideVersion3 = fromCompiled ? this.readVersionFromIdeSources(idePath) : this.readIdeVersionFromDistribution(idePath);
        }
        if ((charSequence = (CharSequence)(readIdeVersion = ideVersion3).getProductCode()).length() > 0) {
            ideVersion2 = readIdeVersion;
        } else {
            ideVersion2 = this.readIdeVersionFromBuildNumberFile(idePath);
            if (ideVersion2 == null) {
                ideVersion2 = ideVersion = readIdeVersion;
            }
        }
        if ((intelliJPlatformProduct = IntelliJPlatformProduct.Companion.fromIdeVersion(ideVersion)) == null) {
            intelliJPlatformProduct = IntelliJPlatformProduct.IDEA;
        }
        IntelliJPlatformProduct product = intelliJPlatformProduct;
        List<IdePlugin> bundledPlugins = fromCompiled ? this.readCompiledBundledPlugins(idePath, ideVersion) : this.readDistributionBundledPlugins(idePath, product, ideVersion);
        return new IdeImpl(idePath, ideVersion, bundledPlugins);
    }

    private final List<IdePlugin> readDistributionBundledPlugins(Path idePath, IntelliJPlatformProduct product, IdeVersion ideVersion) {
        Path path = idePath.resolve("lib");
        Intrinsics.checkNotNullExpressionValue(path, "idePath.resolve(\"lib\")");
        List<Path> platformJarFiles = FileUtilKt.listJars(path);
        Path path2 = idePath.resolve("lib").resolve("modules");
        Intrinsics.checkNotNullExpressionValue(path2, "idePath.resolve(\"lib\").resolve(\"modules\")");
        List<Path> platformModuleJarFiles = FileUtilKt.listJars(path2);
        PlatformResourceResolver platformResourceResolver = new PlatformResourceResolver(CollectionsKt.plus((Collection)platformJarFiles, (Iterable)platformModuleJarFiles));
        List<IdePlugin> bundledPlugins = this.readBundledPlugins(idePath, platformResourceResolver, ideVersion);
        List<IdePlugin> platformPlugins = this.readPlatformPlugins(idePath, product, platformJarFiles, platformResourceResolver, ideVersion);
        return CollectionsKt.plus((Collection)bundledPlugins, (Iterable)platformPlugins);
    }

    private final IdeVersion readIdeVersionFromDistribution(Path idePath) {
        Object v1;
        List<Path> locations;
        block2: {
            Iterable iterable;
            locations = CollectionsKt.listOf(idePath.resolve("build.txt"), idePath.resolve("Resources").resolve("build.txt"), idePath.resolve("community").resolve("build.txt"), idePath.resolve("ultimate").resolve("community").resolve("build.txt"));
            Iterable iterable2 = iterable = (Iterable)locations;
            for (Object t2 : iterable2) {
                Path it = (Path)t2;
                boolean bl = false;
                Path path = it;
                Intrinsics.checkNotNullExpressionValue(path, "it");
                if (!FileUtilKt.exists(path)) continue;
                v1 = t2;
                break block2;
            }
            v1 = null;
        }
        Path path = v1;
        if (path == null) {
            throw (Throwable)new InvalidIdeException(idePath, "Build number is not found in the following files relative to " + idePath + ": " + CollectionsKt.joinToString$default(locations, null, null, null, 0, null, new Function1<Path, CharSequence>(idePath){
                final /* synthetic */ Path $idePath;

                @NotNull
                public final CharSequence invoke(Path it) {
                    return "'" + this.$idePath.relativize(it) + "'";
                }
                {
                    this.$idePath = path;
                    super(1);
                }
            }, 31, null));
        }
        Path buildTxtFile2 = path;
        return this.readBuildNumber(buildTxtFile2);
    }

    private final IdeVersion readIdeVersionFromBuildNumberFile(Path idePath) {
        Path buildNumberFile;
        Path path = buildNumberFile = idePath.resolve("build.number");
        Intrinsics.checkNotNullExpressionValue(path, "buildNumberFile");
        if (FileUtilKt.exists(path)) {
            List lines = FileUtilKt.readLines$default(buildNumberFile, null, 1, null);
            for (String line : lines) {
                if (!StringsKt.startsWith$default(line, "build.number=", false, 2, null)) continue;
                return IdeVersion.createIdeVersionIfValid(StringsKt.substringAfter$default(line, "build.number=", null, 2, null));
            }
        }
        return null;
    }

    private final IdeVersion readVersionFromIdeSources(Path idePath) {
        Object v1;
        block2: {
            Iterable iterable;
            List<Path> locations = CollectionsKt.listOf(idePath.resolve("build.txt"), idePath.resolve("community").resolve("build.txt"));
            Iterable iterable2 = iterable = (Iterable)locations;
            for (Object t2 : iterable2) {
                Path it = (Path)t2;
                boolean bl = false;
                Path path = it;
                Intrinsics.checkNotNullExpressionValue(path, "it");
                if (!FileUtilKt.exists(path)) continue;
                v1 = t2;
                break block2;
            }
            v1 = null;
        }
        Path path = v1;
        if (path == null) {
            throw (Throwable)new InvalidIdeException(idePath, "Unable to find IDE version file 'build.txt' or 'community/build.txt'");
        }
        Path buildTxtFile2 = path;
        return this.readBuildNumber(buildTxtFile2);
    }

    private final IdeVersion readBuildNumber(Path versionFile) {
        String string2 = FileUtilKt.readText$default(versionFile, null, 1, null);
        String buildNumberString = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        IdeVersion ideVersion = IdeVersion.createIdeVersion(buildNumberString);
        Intrinsics.checkNotNullExpressionValue(ideVersion, "IdeVersion.createIdeVersion(buildNumberString)");
        return ideVersion;
    }

    private final List<IdePlugin> readCompiledBundledPlugins(Path idePath, IdeVersion ideVersion) {
        Path path = Companion.getCompiledClassesRoot(idePath);
        Intrinsics.checkNotNull(path);
        Path compilationRoot = path;
        List moduleRoots = CollectionsKt.toList((Iterable)FileUtilKt.listFiles(compilationRoot));
        List<Path> librariesJars = RepositoryLibrariesUtilKt.getRepositoryLibrariesJars(idePath);
        CompositeResourceResolver pathResolver = new CompositeResourceResolver(CollectionsKt.listOf(new CompiledModulesResourceResolver(moduleRoots), new JarFilesResourceResolver(librariesJars)));
        return this.readCompiledBundledPlugins(idePath, moduleRoots, pathResolver, ideVersion);
    }

    private final List<IdePlugin> readCompiledBundledPlugins(Path idePath, List<? extends Path> moduleRoots, ResourceResolver pathResolver, IdeVersion ideVersion) {
        ArrayList plugins = new ArrayList();
        for (Path path : moduleRoots) {
            Path pluginXmlFile;
            Path path2 = pluginXmlFile = path.resolve("META-INF").resolve("plugin.xml");
            Intrinsics.checkNotNullExpressionValue(path2, "pluginXmlFile");
            if (!FileUtilKt.isFile(path2)) continue;
            Collection collection = plugins;
            IdePlugin idePlugin = this.createBundledPluginExceptionally(idePath, path, pathResolver, "plugin.xml", ideVersion);
            collection.add(idePlugin);
        }
        return plugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<IdePlugin> readPlatformPlugins(Path idePath, IntelliJPlatformProduct product, List<? extends Path> jarFiles, ResourceResolver platformResourceResolver, IdeVersion ideVersion) {
        boolean bl;
        List<String> descriptorPaths2;
        ArrayList platformPlugins;
        block13: {
            platformPlugins = new ArrayList();
            descriptorPaths2 = CollectionsKt.listOf(product.getPlatformPrefix() + "Plugin.xml", "plugin.xml", PLATFORM_PLUGIN_XML);
            for (Path path : jarFiles) {
                Object object = FileSystems.newFileSystem(path, IdeManagerImpl.class.getClassLoader());
                Object object2 = null;
                try {
                    Object v1;
                    Object jarFs;
                    block11: {
                        Iterable iterable;
                        jarFs = (FileSystem)object;
                        boolean bl2 = false;
                        Iterable iterable2 = iterable = (Iterable)descriptorPaths2;
                        for (Object t2 : iterable2) {
                            String it = (String)t2;
                            boolean bl3 = false;
                            Path path2 = ((FileSystem)jarFs).getPath("META-INF", new String[0]).resolve(it);
                            Intrinsics.checkNotNullExpressionValue(path2, "jarFs.getPath(IdePluginM\u2026ger.META_INF).resolve(it)");
                            if (!FileUtilKt.exists(path2)) continue;
                            v1 = t2;
                            break block11;
                        }
                        v1 = null;
                    }
                    jarFs = v1;
                }
                catch (Throwable jarFs) {
                    object2 = jarFs;
                    throw jarFs;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                }
                Object descriptorPath = jarFs;
                if (descriptorPath == null) continue;
                object = platformPlugins;
                object2 = this.createBundledPluginExceptionally(idePath, path, platformResourceResolver, (String)descriptorPath, ideVersion);
                object.add(object2);
            }
            Iterable iterable = platformPlugins;
            boolean $i$f$none = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : iterable) {
                    IdePlugin it = (IdePlugin)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual(it.getPluginId(), "com.intellij")) continue;
                    bl = false;
                    break block13;
                }
                bl = true;
            }
        }
        if (bl) {
            throw (Throwable)new InvalidIdeException(idePath, "Platform plugins are not found. They must be declared in one of " + CollectionsKt.joinToString$default(descriptorPaths2, null, null, null, 0, null, null, 63, null));
        }
        return platformPlugins;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IdePlugin> readBundledPlugins(Path idePath, ResourceResolver platformResourceResolver, IdeVersion ideVersion) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Path path = idePath.resolve("plugins");
        Intrinsics.checkNotNullExpressionValue(path, "idePath\n      .resolve(\"plugins\")");
        Iterable iterable = FileUtilKt.listFiles(path);
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            if (!FileUtilKt.isDirectory(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IdePlugin idePlugin;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Path it = (Path)element$iv$iv;
            boolean bl2 = false;
            if (this.readBundledPlugin(idePath, it, platformResourceResolver, ideVersion) == null) continue;
            IdePlugin it$iv$iv = idePlugin;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final IdePlugin readBundledPlugin(Path idePath, Path pluginFile, ResourceResolver pathResolver, IdeVersion ideVersion) {
        IdePlugin idePlugin;
        try {
            idePlugin = this.createBundledPluginExceptionally(idePath, pluginFile, pathResolver, "plugin.xml", ideVersion);
        }
        catch (InvalidIdeException e) {
            LOG.warn("Failed to read bundled plugin '" + idePath.relativize(pluginFile) + "': " + e.getReason());
            idePlugin = null;
        }
        return idePlugin;
    }

    /*
     * WARNING - void declaration
     */
    private final IdePlugin createBundledPluginExceptionally(Path idePath, Path pluginFile, ResourceResolver pathResolver, String descriptorPath, IdeVersion ideVersion) {
        PluginCreationResult creationResult = IdePluginManager.createBundledPlugin$default(IdePluginManager.Companion.createManager(pathResolver), pluginFile, ideVersion, descriptorPath, null, 8, null);
        if (!(creationResult instanceof PluginCreationSuccess)) {
            if (creationResult instanceof PluginCreationFail) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Iterable iterable = ((PluginCreationFail)creationResult).getErrorsAndWarnings();
                Path path = idePath.relativize(pluginFile);
                Path path2 = idePath;
                boolean $i$f$filter = false;
                void var9_11 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PluginProblem it = (PluginProblem)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getLevel() == PluginProblem.Level.ERROR)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list = (List)destination$iv$iv;
                String string2 = "Plugin '" + path + "' is invalid: " + CollectionsKt.joinToString$default(list, null, null, null, 0, null, createBundledPluginExceptionally.2.INSTANCE, 31, null);
                Path path3 = path2;
                throw (Throwable)new InvalidIdeException(path3, string2);
            }
            throw new NoWhenBranchMatchedException();
        }
        return (IdePlugin)((PluginCreationSuccess)creationResult).getPlugin();
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(IdeManagerImpl.class);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/plugin/structure/ide/IdeManagerImpl$PlatformResourceResolver;", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "platformJarFiles", "", "Ljava/nio/file/Path;", "(Ljava/util/List;)V", "jarFilesResourceResolver", "Lcom/jetbrains/plugin/structure/intellij/plugin/JarFilesResourceResolver;", "resolveResource", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver$Result;", "relativePath", "", "basePath", "structure-ide"})
    private static final class PlatformResourceResolver
    implements ResourceResolver {
        private final JarFilesResourceResolver jarFilesResourceResolver;

        @Override
        @NotNull
        public ResourceResolver.Result resolveResource(@NotNull String relativePath, @NotNull Path basePath) {
            Intrinsics.checkNotNullParameter(relativePath, "relativePath");
            Intrinsics.checkNotNullParameter(basePath, "basePath");
            ResourceResolver.Result resolveResult = this.jarFilesResourceResolver.resolveResource(relativePath, basePath);
            if (!(resolveResult instanceof ResourceResolver.Result.NotFound)) {
                return resolveResult;
            }
            if (basePath.startsWith("META-INF")) {
                Path metaInf = basePath;
                while (!metaInf.endsWith("META-INF")) {
                    Intrinsics.checkNotNullExpressionValue(metaInf.getParent(), "metaInf.parent");
                }
                ResourceResolver.Result metaInfResult = this.jarFilesResourceResolver.resolveResource(relativePath, metaInf);
                if (!(metaInfResult instanceof ResourceResolver.Result.NotFound)) {
                    return metaInfResult;
                }
            }
            if (!StringsKt.startsWith$default(relativePath, "/", false, 2, null)) {
                return this.jarFilesResourceResolver.resolveResource("/META-INF/" + relativePath, basePath);
            }
            return ResourceResolver.Result.NotFound.INSTANCE;
        }

        public PlatformResourceResolver(@NotNull List<? extends Path> platformJarFiles) {
            Intrinsics.checkNotNullParameter(platformJarFiles, "platformJarFiles");
            this.jarFilesResourceResolver = new JarFilesResourceResolver(platformJarFiles);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/plugin/structure/ide/IdeManagerImpl$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "PLATFORM_PLUGIN_XML", "", "getCompiledClassesRoot", "Ljava/nio/file/Path;", "ideaDir", "isCompiledCommunity", "", "isCompiledUltimate", "isDistributionIde", "structure-ide"})
    @SourceDebugExtension(value={"SMAP\nIdeManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeManagerImpl.kt\ncom/jetbrains/plugin/structure/ide/IdeManagerImpl$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,291:1\n1#2:292\n*E\n"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isCompiledUltimate(@NotNull Path ideaDir) {
            Intrinsics.checkNotNullParameter(ideaDir, "ideaDir");
            if (this.getCompiledClassesRoot(ideaDir) == null) return false;
            Path path = ideaDir.resolve(".idea");
            Intrinsics.checkNotNullExpressionValue(path, "ideaDir.resolve(\".idea\")");
            if (!FileUtilKt.isDirectory(path)) return false;
            Path path2 = ideaDir.resolve("community").resolve(".idea");
            Intrinsics.checkNotNullExpressionValue(path2, "ideaDir.resolve(\"community\").resolve(\".idea\")");
            if (!FileUtilKt.isDirectory(path2)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isCompiledCommunity(@NotNull Path ideaDir) {
            Intrinsics.checkNotNullParameter(ideaDir, "ideaDir");
            if (this.getCompiledClassesRoot(ideaDir) == null) return false;
            Path path = ideaDir.resolve(".idea");
            Intrinsics.checkNotNullExpressionValue(path, "ideaDir.resolve(\".idea\")");
            if (!FileUtilKt.isDirectory(path)) return false;
            Path path2 = ideaDir.resolve("community").resolve(".idea");
            Intrinsics.checkNotNullExpressionValue(path2, "ideaDir.resolve(\"community\").resolve(\".idea\")");
            if (FileUtilKt.isDirectory(path2)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isDistributionIde(@NotNull Path ideaDir) {
            Intrinsics.checkNotNullParameter(ideaDir, "ideaDir");
            Path path = ideaDir.resolve("lib");
            Intrinsics.checkNotNullExpressionValue(path, "ideaDir.resolve(\"lib\")");
            if (!FileUtilKt.isDirectory(path)) return false;
            Path path2 = ideaDir.resolve(".idea");
            Intrinsics.checkNotNullExpressionValue(path2, "ideaDir.resolve(\".idea\")");
            if (FileUtilKt.isDirectory(path2)) return false;
            return true;
        }

        @Nullable
        public final Path getCompiledClassesRoot(@NotNull Path ideaDir) {
            Object v1;
            block1: {
                Iterable iterable;
                Intrinsics.checkNotNullParameter(ideaDir, "ideaDir");
                Iterable iterable2 = iterable = (Iterable)CollectionsKt.listOf(ideaDir.resolve("out").resolve("production"), ideaDir.resolve("out").resolve("classes").resolve("production"), ideaDir.resolve("out").resolve("compilation").resolve("classes").resolve("production"));
                for (Object t2 : iterable2) {
                    Path it = (Path)t2;
                    boolean bl = false;
                    Path path = it;
                    Intrinsics.checkNotNullExpressionValue(path, "it");
                    if (!FileUtilKt.isDirectory(path)) continue;
                    v1 = t2;
                    break block1;
                }
                v1 = null;
            }
            return v1;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

