/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils.contentBuilder;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.contentBuilder.ChildrenOwnerSpec;
import com.jetbrains.plugin.structure.base.utils.contentBuilder.ContentBuilder;
import com.jetbrains.plugin.structure.base.utils.contentBuilder.ContentBuilderKt;
import com.jetbrains.plugin.structure.base.utils.contentBuilder.ContentSpec;
import com.jetbrains.plugin.structure.base.utils.contentBuilder.FileSpec;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J)\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\r\u00a2\u0006\u0002\b\u000eH\u0016J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0013H\u0016J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0015H\u0016J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0016J)\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\r\u00a2\u0006\u0002\b\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/contentBuilder/ContentBuilderImpl;", "Lcom/jetbrains/plugin/structure/base/utils/contentBuilder/ContentBuilder;", "result", "Lcom/jetbrains/plugin/structure/base/utils/contentBuilder/ChildrenOwnerSpec;", "(Lcom/jetbrains/plugin/structure/base/utils/contentBuilder/ChildrenOwnerSpec;)V", "addChild", "", "name", "", "spec", "Lcom/jetbrains/plugin/structure/base/utils/contentBuilder/ContentSpec;", "dir", "content", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "localDirectory", "Ljava/nio/file/Path;", "file", "textProvider", "Lkotlin/Function0;", "localFile", "", "text", "zip", "structure-base"})
@SourceDebugExtension(value={"SMAP\nContentBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentBuilder.kt\ncom/jetbrains/plugin/structure/base/utils/contentBuilder/ContentBuilderImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
final class ContentBuilderImpl
implements ContentBuilder {
    private final ChildrenOwnerSpec result;

    @Override
    public void file(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.file(name, "");
    }

    @Override
    public void file(@NotNull String name, @NotNull Function0<String> textProvider) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(textProvider, "textProvider");
        this.file(name, textProvider.invoke());
    }

    @Override
    public void file(@NotNull String name, @NotNull String text) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(text, "text");
        String string2 = text;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        this.file(name, byArray);
    }

    @Override
    public void file(@NotNull String name, @NotNull byte[] content) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(content, "content");
        this.addChild(name, new FileSpec(content));
    }

    @Override
    public void file(@NotNull String name, @NotNull Path localFile) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(localFile, "localFile");
        this.file(name, FileUtilKt.readBytes(localFile));
    }

    @Override
    public void dir(@NotNull String name, @NotNull Function1<? super ContentBuilder, Unit> content) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(content, "content");
        ContentSpec directorySpec = ContentBuilderKt.buildDirectoryContent(content);
        this.addChild(name, directorySpec);
    }

    @Override
    public void dir(@NotNull String name, @NotNull Path localDirectory) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(localDirectory, "localDirectory");
        boolean bl = FileUtilKt.isDirectory(localDirectory);
        if (!bl) {
            boolean bl2 = false;
            String string2 = "Not a directory: " + localDirectory;
            throw new IllegalStateException(string2.toString());
        }
        this.dir(name, (Function1<? super ContentBuilder, Unit>)new Function1<ContentBuilder, Unit>(localDirectory){
            final /* synthetic */ Path $localDirectory;

            public final void invoke(@NotNull ContentBuilder $this$dir) {
                Intrinsics.checkNotNullParameter($this$dir, "$receiver");
                List<Path> list = FileUtilKt.listFiles(this.$localDirectory);
                List<Path> list2 = list;
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                for (Path child : list2) {
                    if (FileUtilKt.isFile(child)) {
                        $this$dir.file(FileUtilKt.getSimpleName(child), child);
                        continue;
                    }
                    if (FileUtilKt.isDirectory(child)) {
                        $this$dir.dir(FileUtilKt.getSimpleName(child), child);
                        continue;
                    }
                    throw (Throwable)new IllegalArgumentException("Unknown file type: " + child.toAbsolutePath());
                }
            }
            {
                this.$localDirectory = path;
                super(1);
            }
        });
    }

    @Override
    public void zip(@NotNull String name, @NotNull Function1<? super ContentBuilder, Unit> content) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(content, "content");
        ContentSpec zipFileContent = ContentBuilderKt.buildZipFileContent(content);
        this.addChild(name, zipFileContent);
    }

    private final void addChild(String name, ContentSpec spec) {
        this.result.addChild(name, spec);
    }

    public ContentBuilderImpl(@NotNull ChildrenOwnerSpec result2) {
        Intrinsics.checkNotNullParameter(result2, "result");
        this.result = result2;
    }
}

