/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.ide;

import com.jetbrains.plugin.structure.ide.PluginQueryMatcher;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.PluginProvider;
import com.jetbrains.plugin.structure.intellij.plugin.PluginProviderResult;
import com.jetbrains.plugin.structure.intellij.plugin.PluginProvision;
import com.jetbrains.plugin.structure.intellij.plugin.PluginQuery;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Ide
implements PluginProvider {
    private final PluginQueryMatcher queryMatcher = new PluginQueryMatcher();

    @NotNull
    public abstract IdeVersion getVersion();

    @NotNull
    public abstract List<IdePlugin> getBundledPlugins();

    public boolean hasBundledPlugin(@NotNull String pluginId) {
        return this.findPluginById(pluginId) != null;
    }

    @Nullable
    public final IdePlugin findPluginById(@NotNull String pluginId) {
        for (IdePlugin plugin : this.getBundledPlugins()) {
            String id = this.getId(plugin);
            if (!Objects.equals(id, pluginId)) continue;
            return plugin;
        }
        return null;
    }

    @Nullable
    public final IdePlugin findPluginByModule(@NotNull String moduleId) {
        for (IdePlugin plugin : this.getBundledPlugins()) {
            if (!plugin.getDefinedModules().contains(moduleId)) continue;
            return plugin;
        }
        return null;
    }

    @Nullable
    public PluginProviderResult findPluginByIdOrModuleId(@NotNull String pluginIdOrModuleId) {
        for (IdePlugin plugin : this.getBundledPlugins()) {
            String id = this.getPluginId(plugin);
            if (Objects.equals(id, pluginIdOrModuleId)) {
                return new PluginProviderResult(PluginProviderResult.Type.PLUGIN, plugin);
            }
            if (!plugin.getDefinedModules().contains(pluginIdOrModuleId)) continue;
            return new PluginProviderResult(PluginProviderResult.Type.MODULE, plugin);
        }
        return null;
    }

    @NotNull
    public PluginProvision query(@NotNull PluginQuery query) {
        for (IdePlugin plugin : this.getBundledPlugins()) {
            PluginProvision pluginProvision = this.queryMatcher.matches(plugin, query);
            if (!(pluginProvision instanceof PluginProvision.Found)) continue;
            return pluginProvision;
        }
        return PluginProvision.NotFound.INSTANCE;
    }

    @Nullable
    protected String getId(@NotNull IdePlugin plugin) {
        String id = plugin.getPluginId();
        if (id == null) {
            id = plugin.getPluginName();
        }
        return id;
    }

    @NotNull
    public abstract Path getIdePath();

    @Nullable
    protected String getPluginId(IdePlugin plugin) {
        return plugin.getPluginId() != null ? plugin.getPluginId() : plugin.getPluginName();
    }

    public String getPresentableName() {
        return this.getVersion().asString();
    }
}

