/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.ide;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.ide.IdeVersionProvider;
import com.jetbrains.plugin.structure.ide.IdeVersionResolution;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/plugin/structure/ide/BuildTxtIdeVersionProvider;", "Lcom/jetbrains/plugin/structure/ide/IdeVersionProvider;", "()V", "readBuildNumber", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "versionFile", "Ljava/nio/file/Path;", "readIdeVersion", "Lcom/jetbrains/plugin/structure/ide/IdeVersionResolution;", "idePath", "structure-ide"})
@SourceDebugExtension(value={"SMAP\nIdeVersionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeVersionProvider.kt\ncom/jetbrains/plugin/structure/ide/BuildTxtIdeVersionProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,40:1\n1#2:41\n*E\n"})
public final class BuildTxtIdeVersionProvider
implements IdeVersionProvider {
    @Override
    @NotNull
    public IdeVersionResolution readIdeVersion(@NotNull Path idePath) {
        IdeVersionResolution ideVersionResolution;
        Object v0;
        List locations;
        block4: {
            Intrinsics.checkNotNullParameter((Object)idePath, (String)"idePath");
            Object[] objectArray = new Path[]{idePath.resolve("build.txt"), idePath.resolve("Resources").resolve("build.txt"), idePath.resolve("community").resolve("build.txt"), idePath.resolve("ultimate").resolve("community").resolve("build.txt")};
            locations = CollectionsKt.listOf((Object[])objectArray);
            Iterable iterable = locations;
            for (Object t : iterable) {
                Path it = (Path)t;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!FileUtilKt.exists((Path)it)) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        Path path = v0;
        if (path == null) {
            return new IdeVersionResolution.NotFound(locations);
        }
        Path buildTxtFile2 = path;
        try {
            ideVersionResolution = new IdeVersionResolution.Found(this.readBuildNumber(buildTxtFile2), ((Object)buildTxtFile2).toString());
        }
        catch (IllegalArgumentException e) {
            ideVersionResolution = new IdeVersionResolution.Failed(e);
        }
        return ideVersionResolution;
    }

    private final IdeVersion readBuildNumber(Path versionFile) {
        String buildNumberString = ((Object)StringsKt.trim((CharSequence)FileUtilKt.readText$default((Path)versionFile, null, (int)1, null))).toString();
        IdeVersion ideVersion = IdeVersion.createIdeVersion((String)buildNumberString);
        Intrinsics.checkNotNullExpressionValue((Object)ideVersion, (String)"createIdeVersion(buildNumberString)");
        return ideVersion;
    }
}

