/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.codehaus.plexus.archiver.AbstractArchiver;
import org.codehaus.plexus.archiver.AbstractUnArchiver;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.tar.TarArchiver;
import org.codehaus.plexus.archiver.tar.TarBZip2UnArchiver;
import org.codehaus.plexus.archiver.tar.TarGZipUnArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u000f\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u00a8\u0006\u0010"}, d2={"archiveDirectory", "", "directory", "Ljava/io/File;", "destination", "includeDirectory", "", "includeEmptyDirectories", "createArchiver", "Lorg/codehaus/plexus/archiver/AbstractArchiver;", "extension", "", "createUnArchiver", "Lorg/codehaus/plexus/archiver/AbstractUnArchiver;", "archive", "extractTo", "structure-base"})
public final class ZipUtilKt {
    public static final void archiveDirectory(@NotNull File directory, @NotNull File destination, boolean includeDirectory, boolean includeEmptyDirectories) throws IOException {
        AbstractArchiver abstractArchiver;
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        FileUtilKt.deleteLogged(destination);
        FileUtils.forceMkdirParent((File)destination.getAbsoluteFile());
        AbstractArchiver $receiver = abstractArchiver = ZipUtilKt.createArchiver(FilesKt.getExtension((File)destination));
        $receiver.enableLogging((Logger)new ConsoleLogger(3, "Unarchive logger"));
        $receiver.addFileSet((FileSet)((DefaultFileSet)DefaultFileSet.fileSet((File)directory).prefixed(includeDirectory ? directory.getName() + "/" : "")).includeEmptyDirs(includeEmptyDirectories));
        $receiver.setDestFile(destination.getAbsoluteFile());
        AbstractArchiver archiver = abstractArchiver;
        archiver.createArchive();
    }

    public static /* bridge */ /* synthetic */ void archiveDirectory$default(File file, File file2, boolean bl, boolean bl2, int n, Object object) throws IOException {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        ZipUtilKt.archiveDirectory(file, file2, bl, bl2);
    }

    private static final AbstractArchiver createArchiver(String extension) {
        AbstractArchiver abstractArchiver;
        switch (extension) {
            case "tar.gz": {
                abstractArchiver = (AbstractArchiver)new TarArchiver();
                break;
            }
            case "zip": {
                abstractArchiver = (AbstractArchiver)new ZipArchiver();
                break;
            }
            case "jar": {
                abstractArchiver = (AbstractArchiver)new JarArchiver();
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Unknown file extension: " + extension);
            }
        }
        return abstractArchiver;
    }

    @NotNull
    public static final File extractTo(@NotNull File $receiver, @NotNull File destination) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        if (!$receiver.isFile()) {
            throw (Throwable)new IllegalArgumentException("The file " + $receiver + " is not an archive");
        }
        String string = $receiver.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        if (!StringsKt.endsWith$default((String)string, (String)".zip", (boolean)false, (int)2, null)) {
            String string2 = $receiver.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
            if (!StringsKt.endsWith$default((String)string2, (String)".tar.gz", (boolean)false, (int)2, null)) {
                String string3 = $receiver.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"name");
                if (!StringsKt.endsWith$default((String)string3, (String)".tar.bz2", (boolean)false, (int)2, null)) {
                    throw (Throwable)new IllegalArgumentException("Unsupported archive type: " + $receiver);
                }
            }
        }
        FileUtils.forceMkdir((File)destination);
        AbstractUnArchiver unArchiver = ZipUtilKt.createUnArchiver($receiver);
        unArchiver.enableLogging((Logger)new ConsoleLogger(2, ""));
        unArchiver.setDestDirectory(destination);
        unArchiver.extract();
        return destination;
    }

    private static final AbstractUnArchiver createUnArchiver(File archive) {
        AbstractUnArchiver abstractUnArchiver;
        String string;
        String string2 = archive.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"archive.name");
        String string3 = string = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        String name = string4;
        if (StringsKt.endsWith$default((String)name, (String)".tar.gz", (boolean)false, (int)2, null)) {
            abstractUnArchiver = (AbstractUnArchiver)new TarGZipUnArchiver(archive);
        } else if (StringsKt.endsWith$default((String)name, (String)".tar.bz2", (boolean)false, (int)2, null)) {
            abstractUnArchiver = (AbstractUnArchiver)new TarBZip2UnArchiver(archive);
        } else if (StringsKt.endsWith$default((String)name, (String)".zip", (boolean)false, (int)2, null)) {
            abstractUnArchiver = (AbstractUnArchiver)new ZipUnArchiver(archive);
        } else {
            throw (Throwable)new RuntimeException("Unable to extract - unknown file extension: " + name);
        }
        return abstractUnArchiver;
    }
}

