/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0010\"\n\u0000\u001a\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a\u001b\u0010\u0007\u001a\u00020\u0003\"\n\b\u0000\u0010\b*\u0004\u0018\u00010\u0006*\u0002H\b\u00a2\u0006\u0002\u0010\t\u001a8\u0010\n\u001a\u0002H\u000b\"\n\b\u0000\u0010\b*\u0004\u0018\u00010\u0006\"\u0004\b\u0001\u0010\u000b*\u0002H\b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\u000b0\rH\u0086\b\u00a2\u0006\u0002\u0010\u000e\u001a\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\b0\u0005\"\u0004\b\u0000\u0010\b*\b\u0012\u0004\u0012\u0002H\b0\u0010\u001a\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\b0\u0012\"\u0004\b\u0000\u0010\b*\b\u0012\u0004\u0012\u0002H\b0\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"logger", "Lorg/slf4j/Logger;", "checkIfInterrupted", "", "closeAll", "", "Ljava/io/Closeable;", "closeLogged", "T", "(Ljava/io/Closeable;)V", "closeOnException", "R", "block", "Lkotlin/Function1;", "(Ljava/io/Closeable;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "toList", "", "toSet", "", "structure-base"})
public final class LanguageUtilsKt {
    private static final Logger logger;

    public static final void checkIfInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw (Throwable)new InterruptedException();
        }
    }

    public static final <T extends Closeable> void closeLogged(T $receiver) {
        try {
            T t = $receiver;
            if (t != null) {
                t.close();
            }
        }
        catch (Exception e) {
            logger.error("Unable to close " + $receiver, (Throwable)e);
        }
    }

    public static final <T extends Closeable, R> R closeOnException(T $receiver, @NotNull Function1<? super T, ? extends R> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        try {
            return (R)block.invoke($receiver);
        }
        catch (Throwable e) {
            block2: {
                T t = $receiver;
                if (t == null) break block2;
                LanguageUtilsKt.closeLogged(t);
            }
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void closeAll(@NotNull List<? extends Closeable> $receiver) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Iterable iterable = $receiver$iv = (Iterable)$receiver;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator = $receiver$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Exception exception;
            Exception exception2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            Closeable it = (Closeable)element$iv$iv;
            try {
                it.close();
                exception2 = null;
            }
            catch (Exception e) {
                exception2 = e;
            }
            if (exception2 == null) continue;
            Exception it$iv$iv = exception;
            destination$iv$iv.add(it$iv$iv);
        }
        List exceptions = (List)destination$iv$iv;
        $receiver$iv = exceptions;
        if (!$receiver$iv.isEmpty()) {
            IOException closeException = new IOException("Exceptions while closing multiple resources");
            Iterable $receiver$iv2 = exceptions;
            for (Object element$iv : $receiver$iv2) {
                Exception it = (Exception)element$iv;
                closeException.addSuppressed(it);
            }
            throw (Throwable)closeException;
        }
    }

    @NotNull
    public static final <T> List<T> toList(@NotNull Iterator<? extends T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return SequencesKt.toList((Sequence)SequencesKt.asSequence($receiver));
    }

    @NotNull
    public static final <T> Set<T> toSet(@NotNull Iterator<? extends T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return SequencesKt.toSet((Sequence)SequencesKt.asSequence($receiver));
    }

    static {
        Logger logger = LoggerFactory.getLogger((String)"LanguageUtils");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(\"LanguageUtils\")");
        LanguageUtilsKt.logger = logger;
    }
}

