/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0010\"\n\u0000\u001a\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u001a\u0010\u0010\u0006\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u001b\u0010\t\u001a\u00020\u0003\"\n\b\u0000\u0010\n*\u0004\u0018\u00010\b*\u0002H\n\u00a2\u0006\u0002\u0010\u000b\u001a;\u0010\f\u001a\u0002H\r\"\n\b\u0000\u0010\n*\u0004\u0018\u00010\b\"\u0004\b\u0001\u0010\r*\u0002H\n2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\r0\u000fH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010\u001aG\u0010\f\u001a\u0002H\r\"\n\b\u0000\u0010\n*\u0004\u0018\u00010\b\"\u0004\b\u0001\u0010\r*\b\u0012\u0004\u0012\u0002H\n0\u00072\u0018\u0010\u000e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\u0007\u0012\u0004\u0012\u0002H\r0\u000fH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0014\u001a\n\u0010\u0015\u001a\u00020\u0013*\u00020\u0014\u001a\n\u0010\u0016\u001a\u00020\u0003*\u00020\u0014\u001a\u001a\u0010\u0017\u001a\u00020\u0003*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\n0\u0007\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u001e\u001a\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\n0 \"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u001e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006!"}, d2={"logger", "Lorg/slf4j/Logger;", "checkIfInterrupted", "", "action", "Lkotlin/Function0;", "closeAll", "", "Ljava/io/Closeable;", "closeLogged", "T", "(Ljava/io/Closeable;)V", "closeOnException", "R", "block", "Lkotlin/Function1;", "(Ljava/io/Closeable;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "(Ljava/util/List;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "getShortExceptionMessage", "", "", "getStackTraceAsString", "rethrowIfInterrupted", "shutdownAndAwaitTermination", "Ljava/util/concurrent/ExecutorService;", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "toList", "", "toSet", "", "structure-base"})
@SourceDebugExtension(value={"SMAP\nLanguageUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageUtils.kt\ncom/jetbrains/plugin/structure/base/utils/LanguageUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1855#2,2:160\n1603#2,9:162\n1855#2:171\n1856#2:173\n1612#2:174\n1855#2,2:175\n1#3:172\n*E\n*S KotlinDebug\n*F\n+ 1 LanguageUtils.kt\ncom/jetbrains/plugin/structure/base/utils/LanguageUtilsKt\n*L\n82#1,2:160\n92#1,9:162\n92#1:171\n92#1:173\n92#1:174\n106#1,2:175\n92#1:172\n*E\n"})
public final class LanguageUtilsKt {
    @NotNull
    private static final Logger logger;

    public static final void checkIfInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void checkIfInterrupted(@NotNull Function0<Unit> action) throws InterruptedException {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (Thread.interrupted()) {
            try {
                action.invoke();
            }
            finally {
                throw new InterruptedException();
            }
        }
    }

    public static final void rethrowIfInterrupted(@NotNull Throwable $this$rethrowIfInterrupted) {
        Intrinsics.checkNotNullParameter((Object)$this$rethrowIfInterrupted, (String)"<this>");
        if ($this$rethrowIfInterrupted instanceof InterruptedException) {
            throw $this$rethrowIfInterrupted;
        }
        LanguageUtilsKt.checkIfInterrupted();
    }

    public static final <T extends Closeable> void closeLogged(T $this$closeLogged) {
        try {
            T t = $this$closeLogged;
            if (t != null) {
                t.close();
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            logger.info("Cannot close because of interruption: " + $this$closeLogged);
        }
        catch (Exception e) {
            logger.error("Unable to close " + $this$closeLogged, (Throwable)e);
        }
    }

    public static final <T extends Closeable, R> R closeOnException(T $this$closeOnException, @NotNull Function1<? super T, ? extends R> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$closeOnException = false;
        try {
            return (R)block.invoke($this$closeOnException);
        }
        catch (Throwable e) {
            block2: {
                T t = $this$closeOnException;
                if (t == null) break block2;
                LanguageUtilsKt.closeLogged(t);
            }
            throw e;
        }
    }

    public static final <T extends Closeable, R> R closeOnException(@NotNull List<? extends T> $this$closeOnException, @NotNull Function1<? super List<? extends T>, ? extends R> block) {
        Intrinsics.checkNotNullParameter($this$closeOnException, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$closeOnException = false;
        try {
            return (R)block.invoke($this$closeOnException);
        }
        catch (Throwable e) {
            Iterable $this$forEach$iv = $this$closeOnException;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Closeable t = (Closeable)element$iv;
                boolean bl = false;
                Closeable closeable = t;
                if (closeable == null) continue;
                LanguageUtilsKt.closeLogged(closeable);
            }
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void closeAll(@NotNull List<? extends Closeable> $this$closeAll) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$closeAll, (String)"<this>");
        Iterable $this$mapNotNull$iv = $this$closeAll;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Exception it$iv$iv;
            Exception exception;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Closeable it = (Closeable)element$iv$iv;
            boolean bl2 = false;
            try {
                it.close();
                exception = null;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                exception = null;
            }
            catch (Exception e) {
                exception = e;
            }
            if (exception == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List exceptions = (List)destination$iv$iv;
        LanguageUtilsKt.checkIfInterrupted();
        if (!((Collection)exceptions).isEmpty()) {
            IOException closeException = new IOException("Exceptions while closing multiple resources");
            Iterable $this$forEach$iv = exceptions;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                Exception it = (Exception)element$iv;
                boolean bl = false;
                ExceptionsKt.addSuppressed((Throwable)closeException, (Throwable)it);
            }
            throw closeException;
        }
    }

    @NotNull
    public static final <T> List<T> toList(@NotNull Iterator<? extends T> $this$toList) {
        Intrinsics.checkNotNullParameter($this$toList, (String)"<this>");
        return SequencesKt.toList((Sequence)SequencesKt.asSequence($this$toList));
    }

    @NotNull
    public static final <T> Set<T> toSet(@NotNull Iterator<? extends T> $this$toSet) {
        Intrinsics.checkNotNullParameter($this$toSet, (String)"<this>");
        return SequencesKt.toSet((Sequence)SequencesKt.asSequence($this$toSet));
    }

    @NotNull
    public static final String getStackTraceAsString(@NotNull Throwable $this$getStackTraceAsString) {
        Intrinsics.checkNotNullParameter((Object)$this$getStackTraceAsString, (String)"<this>");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        $this$getStackTraceAsString.printStackTrace(pw);
        String string = sw.getBuffer().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sw.buffer.toString()");
        return string;
    }

    @NotNull
    public static final String getShortExceptionMessage(@NotNull Throwable $this$getShortExceptionMessage) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$getShortExceptionMessage, (String)"<this>");
        StringBuilder $this$getShortExceptionMessage_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getShortExceptionMessage_u24lambda_u243.append($this$getShortExceptionMessage.getClass().getName());
        String eMessage = $this$getShortExceptionMessage.getMessage();
        if (eMessage != null) {
            $this$getShortExceptionMessage_u24lambda_u243.append(" (" + eMessage + ")");
        }
        for (Throwable cause = $this$getShortExceptionMessage.getCause(); cause != null; cause = cause.getCause()) {
            $this$getShortExceptionMessage_u24lambda_u243.append(" caused by ").append(cause.getClass().getName());
            String causeMessage = cause.getMessage();
            if (causeMessage == null) continue;
            $this$getShortExceptionMessage_u24lambda_u243.append(" (" + causeMessage + ")");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static final void shutdownAndAwaitTermination(@NotNull ExecutorService $this$shutdownAndAwaitTermination, long timeout, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)$this$shutdownAndAwaitTermination, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        $this$shutdownAndAwaitTermination.shutdown();
        try {
            if (!$this$shutdownAndAwaitTermination.awaitTermination(timeout, timeUnit)) {
                $this$shutdownAndAwaitTermination.shutdownNow();
                if (!$this$shutdownAndAwaitTermination.awaitTermination(timeout, timeUnit)) {
                    throw new RuntimeException("Executor didn't terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            $this$shutdownAndAwaitTermination.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger((String)"LanguageUtils");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\"LanguageUtils\")");
        LanguageUtilsKt.logger = logger;
    }
}

