/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils;

import java.nio.CharBuffer;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/CharSequenceComparator;", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "()V", "compare", "", "cs1", "cs2", "structure-base"})
public final class CharSequenceComparator
implements Comparator<CharSequence> {
    @NotNull
    public static final CharSequenceComparator INSTANCE = new CharSequenceComparator();

    private CharSequenceComparator() {
    }

    @Override
    public int compare(@NotNull CharSequence cs1, @NotNull CharSequence cs2) {
        Intrinsics.checkNotNullParameter((Object)cs1, (String)"cs1");
        Intrinsics.checkNotNullParameter((Object)cs2, (String)"cs2");
        if (cs1 == cs2) {
            return 0;
        }
        if (cs1 instanceof CharBuffer && cs2 instanceof CharBuffer) {
            return ((CharBuffer)cs1).compareTo((CharBuffer)cs2);
        }
        if (cs1 instanceof String && cs2 instanceof String) {
            return ((String)cs1).compareTo((String)cs2);
        }
        int len1 = cs1.length();
        int len2 = cs2.length();
        int shorterLen = Math.min(len1, len2);
        for (int i = 0; i < shorterLen; ++i) {
            int comparison = Intrinsics.compare((int)cs1.charAt(i), (int)cs2.charAt(i));
            if (comparison == 0) continue;
            return comparison;
        }
        return len1 - len2;
    }
}

