/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0018\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/FileUtil;", "", "()V", "TEMP_DIR_ATTEMPTS", "", "createDir", "Ljava/io/File;", "dir", "createTempDir", "parent", "prefix", "", "hasExtension", "", "file", "extension", "isJar", "isZip", "structure-base_main"})
public final class FileUtil {
    private static final int TEMP_DIR_ATTEMPTS = 10000;
    public static final FileUtil INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized File createTempDir(@NotNull File parent, @NotNull String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        String baseName = prefix + "_" + System.currentTimeMillis();
        IOException lastException = null;
        int n = 0;
        int n2 = TEMP_DIR_ATTEMPTS - 1;
        if (n <= n2) {
            while (true) {
                void counter;
                File tempDir;
                if (!(tempDir = new File(parent, baseName + "_" + (int)counter)).exists()) {
                    try {
                        FileUtils.forceMkdir((File)tempDir);
                        return tempDir;
                    }
                    catch (IOException ioe) {
                        lastException = ioe;
                    }
                }
                if (counter == n2) break;
                ++counter;
            }
        }
        throw (Throwable)new IllegalStateException("Failed to create directory under " + parent.getAbsolutePath() + " within " + TEMP_DIR_ATTEMPTS + " attempts (tried " + baseName + "_0 to " + baseName + "_" + (TEMP_DIR_ATTEMPTS - 1) + ')', lastException);
    }

    @NotNull
    public final File createDir(@NotNull File dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        if (!dir.isDirectory()) {
            FileUtils.forceMkdir((File)dir);
            if (!dir.isDirectory()) {
                throw (Throwable)new IOException("Failed to create directory " + dir);
            }
        }
        return dir;
    }

    private final boolean hasExtension(File file, String extension) {
        return file.isFile() && Intrinsics.areEqual((Object)extension, (Object)Files.getFileExtension((String)file.getName()));
    }

    public final boolean isZip(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.hasExtension(file, "zip");
    }

    public final boolean isJar(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.hasExtension(file, "jar");
    }

    private FileUtil() {
        INSTANCE = this;
        TEMP_DIR_ATTEMPTS = 10000;
    }

    static {
        new FileUtil();
    }
}

