/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils;

import java.io.Closeable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010(\n\u0000\n\u0002\u0010\"\n\u0000\u001a\u001b\u0010\u0002\u001a\u00020\u0003\"\n\b\u0000\u0010\u0004*\u0004\u0018\u00010\u0005*\u0002H\u0004\u00a2\u0006\u0002\u0010\u0006\u001a8\u0010\u0007\u001a\u0002H\b\"\n\b\u0000\u0010\u0004*\u0004\u0018\u00010\u0005\"\u0004\b\u0001\u0010\b*\u0002H\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\b0\nH\u0086\b\u00a2\u0006\u0002\u0010\u000b\u001a\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00040\r\"\u0004\b\u0000\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00040\u000e\u001a\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0010\"\u0004\b\u0000\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00040\u000e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"logger", "Lorg/slf4j/Logger;", "closeLogged", "", "T", "Ljava/io/Closeable;", "(Ljava/io/Closeable;)V", "closeOnException", "R", "block", "Lkotlin/Function1;", "(Ljava/io/Closeable;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "toList", "", "", "toSet", "", "structure-base"})
public final class LanguageUtilsKt {
    private static final Logger logger;

    public static final <T extends Closeable> void closeLogged(T $receiver) {
        try {
            T t = $receiver;
            if (t != null) {
                t.close();
            }
        }
        catch (Exception e) {
            logger.error("Unable to close " + $receiver, (Throwable)e);
        }
    }

    public static final <T extends Closeable, R> R closeOnException(T $receiver, @NotNull Function1<? super T, ? extends R> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        try {
            return (R)block.invoke($receiver);
        }
        catch (Throwable e) {
            block2: {
                T t = $receiver;
                if (t == null) break block2;
                LanguageUtilsKt.closeLogged(t);
            }
            throw e;
        }
    }

    @NotNull
    public static final <T> List<T> toList(@NotNull Iterator<? extends T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return SequencesKt.toList((Sequence)SequencesKt.asSequence($receiver));
    }

    @NotNull
    public static final <T> Set<T> toSet(@NotNull Iterator<? extends T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return SequencesKt.toSet((Sequence)SequencesKt.asSequence($receiver));
    }

    static {
        Logger logger = LoggerFactory.getLogger((String)"LanguageUtils");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(\"LanguageUtils\")");
        LanguageUtilsKt.logger = logger;
    }
}

