/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils;

import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0004\u001d\u001e\u001f B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0018\u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0013\u001a\u00020\fH\u0016J \u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00170\u0015J*\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0006\u0010\u0019\u001a\u00020\u00062\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001c0\u001bH\u0002R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/ExecutorWithProgress;", "T", "Ljava/io/Closeable;", "executorName", "", "concurrentWorkers", "", "failFastOnException", "", "progress", "Lkotlin/Function1;", "Lcom/jetbrains/plugin/structure/base/utils/ExecutorWithProgress$ProgressData;", "", "(Ljava/lang/String;IZLkotlin/jvm/functions/Function1;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "nameCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "close", "executeTasks", "", "tasks", "Lcom/jetbrains/plugin/structure/base/utils/ExecutorWithProgress$Task;", "waitAllFutures", "futuresNumber", "completionService", "Ljava/util/concurrent/ExecutorCompletionService;", "Lcom/jetbrains/plugin/structure/base/utils/ExecutorWithProgress$TimedResult;", "ProgressData", "Task", "TimedCallable", "TimedResult", "structure-base"})
public final class ExecutorWithProgress<T>
implements Closeable {
    private final AtomicInteger nameCounter;
    private final ExecutorService executor;
    private final boolean failFastOnException;
    private final Function1<ProgressData<T>, Unit> progress;

    @Override
    public void close() {
        ExecutorService executorService = this.executor;
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"executor");
        LanguageUtilsKt.shutdownAndAwaitTermination(executorService, 1L, TimeUnit.MINUTES);
    }

    @NotNull
    public final List<T> executeTasks(@NotNull List<Task<T>> tasks) throws InterruptedException {
        Intrinsics.checkParameterIsNotNull(tasks, (String)"tasks");
        ExecutorCompletionService<TimedResult<T>> completionService = new ExecutorCompletionService<TimedResult<T>>(this.executor);
        boolean bl = false;
        ArrayList<Future<TimedResult<T>>> futures = new ArrayList<Future<TimedResult<T>>>();
        try {
            for (Task<T> task : tasks) {
                Future<TimedResult<T>> future;
                TimedCallable<T> timedCallable = new TimedCallable<T>(task);
                try {
                    future = completionService.submit(timedCallable);
                }
                catch (RejectedExecutionException e) {
                    ExecutorService executorService = this.executor;
                    Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"executor");
                    if (executorService.isShutdown()) {
                        throw (Throwable)new InterruptedException();
                    }
                    throw (Throwable)new RuntimeException("Failed to schedule task " + task.getPresentableName(), e);
                }
                Future<TimedResult<T>> future2 = future;
                futures.add(future2);
            }
            return this.waitAllFutures(futures.size(), completionService);
        }
        catch (Throwable e) {
            for (Future future : futures) {
                future.cancel(true);
            }
            throw e;
        }
    }

    private final List<T> waitAllFutures(int futuresNumber, ExecutorCompletionService<TimedResult<T>> completionService) {
        int finished22;
        boolean bl = false;
        ArrayList results = new ArrayList();
        int n = 0;
        ArrayList exceptions = new ArrayList();
        n = 1;
        int n2 = futuresNumber;
        if (n <= n2) {
            while (true) {
                TimedResult<T> timedResult;
                LanguageUtilsKt.checkIfInterrupted();
                Future<TimedResult<T>> future = completionService.poll(100L, TimeUnit.MILLISECONDS);
                if (future == null) continue;
                try {
                    timedResult = future.get();
                }
                catch (InterruptedException e) {
                    throw (Throwable)e;
                }
                catch (CancellationException e) {
                    throw (Throwable)new InterruptedException("Worker has been cancelled");
                }
                catch (ExecutionException e) {
                    Throwable workerException;
                    Throwable throwable = e.getCause();
                    if (throwable == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((workerException = throwable) instanceof InterruptedException) {
                        throw (Throwable)new InterruptedException("Worker has been interrupted");
                    }
                    Throwable throwable2 = e.getCause();
                    if (throwable2 == null) {
                        Intrinsics.throwNpe();
                    }
                    throw throwable2;
                }
                TimedResult<T> timedResult2 = timedResult;
                Throwable exception = timedResult2.getException();
                if (exception != null) {
                    if (this.failFastOnException) {
                        throw (Throwable)new RuntimeException("Worker '" + timedResult2.getPresentableTaskName() + "' finished with error", exception);
                    }
                    Collection e = exceptions;
                    boolean workerException = false;
                    e.add(exception);
                    this.progress.invoke(new ProgressData<Object>(finished22, futuresNumber, null, exception, timedResult2.getElapsedTime()));
                } else {
                    T result;
                    if (timedResult2.getResult() == null) {
                        Intrinsics.throwNpe();
                    }
                    this.progress.invoke(new ProgressData<T>(finished22, futuresNumber, result, null, timedResult2.getElapsedTime()));
                    Collection workerException = results;
                    boolean bl2 = false;
                    workerException.add(result);
                }
                if (finished22 == n2) break;
                ++finished22;
            }
        }
        finished22 = exceptions.isEmpty() || !this.failFastOnException ? 1 : 0;
        n2 = 0;
        boolean future = false;
        future = false;
        boolean bl3 = false;
        if (finished22 == 0) {
            boolean exception = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Collection finished22 = exceptions;
        n2 = 0;
        if (!finished22.isEmpty()) {
            RuntimeException error = new RuntimeException("Some workers finished with error");
            Iterable $this$forEach$iv = exceptions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Throwable it = (Throwable)element$iv;
                boolean bl4 = false;
                error.addSuppressed(it);
            }
            throw (Throwable)error;
        }
        return results;
    }

    public ExecutorWithProgress(@NotNull String executorName, int concurrentWorkers, boolean failFastOnException, @NotNull Function1<? super ProgressData<T>, Unit> progress) {
        Intrinsics.checkParameterIsNotNull((Object)executorName, (String)"executorName");
        Intrinsics.checkParameterIsNotNull(progress, (String)"progress");
        this.failFastOnException = failFastOnException;
        this.progress = progress;
        this.nameCounter = new AtomicInteger();
        this.executor = Executors.newFixedThreadPool(concurrentWorkers, new ThreadFactory(this, executorName){
            final /* synthetic */ ExecutorWithProgress this$0;
            final /* synthetic */ String $executorName;

            @NotNull
            public final Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                boolean bl = false;
                boolean bl2 = false;
                Thread $this$apply = thread;
                boolean bl3 = false;
                $this$apply.setDaemon(true);
                $this$apply.setName(this.$executorName + "_" + String.valueOf(ExecutorWithProgress.access$getNameCounter$p(this.this$0).incrementAndGet()));
                return thread;
            }
            {
                this.this$0 = executorWithProgress;
                this.$executorName = string;
            }
        });
    }

    public static final /* synthetic */ AtomicInteger access$getNameCounter$p(ExecutorWithProgress $this) {
        return $this.nameCounter;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\t\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00018\u0001\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0016\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0004H\u00c6\u0003J\u0010\u0010\u0018\u001a\u0004\u0018\u00018\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0013J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\nH\u00c6\u0003JJ\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00018\u00012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010 \u001a\u00020\u0004H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\u0006\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011\u00a8\u0006#"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/ExecutorWithProgress$ProgressData;", "T", "", "finishedNumber", "", "totalNumber", "result", "exception", "", "elapsedTime", "", "(IILjava/lang/Object;Ljava/lang/Throwable;J)V", "getElapsedTime", "()J", "getException", "()Ljava/lang/Throwable;", "getFinishedNumber", "()I", "getResult", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getTotalNumber", "component1", "component2", "component3", "component4", "component5", "copy", "(IILjava/lang/Object;Ljava/lang/Throwable;J)Lcom/jetbrains/plugin/structure/base/utils/ExecutorWithProgress$ProgressData;", "equals", "", "other", "hashCode", "toString", "", "structure-base"})
    public static final class ProgressData<T> {
        private final int finishedNumber;
        private final int totalNumber;
        @Nullable
        private final T result;
        @Nullable
        private final Throwable exception;
        private final long elapsedTime;

        public final int getFinishedNumber() {
            return this.finishedNumber;
        }

        public final int getTotalNumber() {
            return this.totalNumber;
        }

        @Nullable
        public final T getResult() {
            return this.result;
        }

        @Nullable
        public final Throwable getException() {
            return this.exception;
        }

        public final long getElapsedTime() {
            return this.elapsedTime;
        }

        public ProgressData(int finishedNumber, int totalNumber, @Nullable T result, @Nullable Throwable exception, long elapsedTime) {
            this.finishedNumber = finishedNumber;
            this.totalNumber = totalNumber;
            this.result = result;
            this.exception = exception;
            this.elapsedTime = elapsedTime;
        }

        public final int component1() {
            return this.finishedNumber;
        }

        public final int component2() {
            return this.totalNumber;
        }

        @Nullable
        public final T component3() {
            return this.result;
        }

        @Nullable
        public final Throwable component4() {
            return this.exception;
        }

        public final long component5() {
            return this.elapsedTime;
        }

        @NotNull
        public final ProgressData<T> copy(int finishedNumber, int totalNumber, @Nullable T result, @Nullable Throwable exception, long elapsedTime) {
            return new ProgressData<T>(finishedNumber, totalNumber, result, exception, elapsedTime);
        }

        public static /* synthetic */ ProgressData copy$default(ProgressData progressData, int n, int n2, Object object, Throwable throwable, long l, int n3, Object object2) {
            if ((n3 & 1) != 0) {
                n = progressData.finishedNumber;
            }
            if ((n3 & 2) != 0) {
                n2 = progressData.totalNumber;
            }
            if ((n3 & 4) != 0) {
                object = progressData.result;
            }
            if ((n3 & 8) != 0) {
                throwable = progressData.exception;
            }
            if ((n3 & 0x10) != 0) {
                l = progressData.elapsedTime;
            }
            return progressData.copy(n, n2, object, throwable, l);
        }

        @NotNull
        public String toString() {
            return "ProgressData(finishedNumber=" + this.finishedNumber + ", totalNumber=" + this.totalNumber + ", result=" + this.result + ", exception=" + this.exception + ", elapsedTime=" + this.elapsedTime + ")";
        }

        public int hashCode() {
            T t = this.result;
            Throwable throwable = this.exception;
            long l = this.elapsedTime;
            return (((this.finishedNumber * 31 + this.totalNumber) * 31 + (t != null ? t.hashCode() : 0)) * 31 + (throwable != null ? throwable.hashCode() : 0)) * 31 + (int)(l ^ l >>> 32);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ProgressData)) break block3;
                    ProgressData progressData = (ProgressData)object;
                    if (this.finishedNumber != progressData.finishedNumber || this.totalNumber != progressData.totalNumber || !Intrinsics.areEqual(this.result, progressData.result) || !Intrinsics.areEqual((Object)this.exception, (Object)progressData.exception) || this.elapsedTime != progressData.elapsedTime) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006H\u00c6\u0003J)\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/ExecutorWithProgress$Task;", "T", "", "presentableName", "", "callable", "Ljava/util/concurrent/Callable;", "(Ljava/lang/String;Ljava/util/concurrent/Callable;)V", "getCallable", "()Ljava/util/concurrent/Callable;", "getPresentableName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "structure-base"})
    public static final class Task<T> {
        @NotNull
        private final String presentableName;
        @NotNull
        private final Callable<T> callable;

        @NotNull
        public final String getPresentableName() {
            return this.presentableName;
        }

        @NotNull
        public final Callable<T> getCallable() {
            return this.callable;
        }

        public Task(@NotNull String presentableName, @NotNull Callable<T> callable) {
            Intrinsics.checkParameterIsNotNull((Object)presentableName, (String)"presentableName");
            Intrinsics.checkParameterIsNotNull(callable, (String)"callable");
            this.presentableName = presentableName;
            this.callable = callable;
        }

        @NotNull
        public final String component1() {
            return this.presentableName;
        }

        @NotNull
        public final Callable<T> component2() {
            return this.callable;
        }

        @NotNull
        public final Task<T> copy(@NotNull String presentableName, @NotNull Callable<T> callable) {
            Intrinsics.checkParameterIsNotNull((Object)presentableName, (String)"presentableName");
            Intrinsics.checkParameterIsNotNull(callable, (String)"callable");
            return new Task<T>(presentableName, callable);
        }

        public static /* synthetic */ Task copy$default(Task task, String string, Callable callable, int n, Object object) {
            if ((n & 1) != 0) {
                string = task.presentableName;
            }
            if ((n & 2) != 0) {
                callable = task.callable;
            }
            return task.copy(string, callable);
        }

        @NotNull
        public String toString() {
            return "Task(presentableName=" + this.presentableName + ", callable=" + this.callable + ")";
        }

        public int hashCode() {
            String string = this.presentableName;
            Callable<T> callable = this.callable;
            return (string != null ? string.hashCode() : 0) * 31 + (callable != null ? callable.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Task)) break block3;
                    Task task = (Task)object;
                    if (!Intrinsics.areEqual((Object)this.presentableName, (Object)task.presentableName) || !Intrinsics.areEqual(this.callable, task.callable)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B)\u0012\b\u0010\u0003\u001a\u0004\u0018\u00018\u0001\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0014\u001a\u0004\u0018\u00018\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0012J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J@\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00018\u00012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0003\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lcom/jetbrains/plugin/structure/base/utils/ExecutorWithProgress$TimedResult;", "T", "", "result", "exception", "", "elapsedTime", "", "presentableTaskName", "", "(Ljava/lang/Object;Ljava/lang/Throwable;JLjava/lang/String;)V", "getElapsedTime", "()J", "getException", "()Ljava/lang/Throwable;", "getPresentableTaskName", "()Ljava/lang/String;", "getResult", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Object;Ljava/lang/Throwable;JLjava/lang/String;)Lcom/jetbrains/plugin/structure/base/utils/ExecutorWithProgress$TimedResult;", "equals", "", "other", "hashCode", "", "toString", "structure-base"})
    private static final class TimedResult<T> {
        @Nullable
        private final T result;
        @Nullable
        private final Throwable exception;
        private final long elapsedTime;
        @NotNull
        private final String presentableTaskName;

        @Nullable
        public final T getResult() {
            return this.result;
        }

        @Nullable
        public final Throwable getException() {
            return this.exception;
        }

        public final long getElapsedTime() {
            return this.elapsedTime;
        }

        @NotNull
        public final String getPresentableTaskName() {
            return this.presentableTaskName;
        }

        public TimedResult(@Nullable T result, @Nullable Throwable exception, long elapsedTime, @NotNull String presentableTaskName) {
            Intrinsics.checkParameterIsNotNull((Object)presentableTaskName, (String)"presentableTaskName");
            this.result = result;
            this.exception = exception;
            this.elapsedTime = elapsedTime;
            this.presentableTaskName = presentableTaskName;
        }

        @Nullable
        public final T component1() {
            return this.result;
        }

        @Nullable
        public final Throwable component2() {
            return this.exception;
        }

        public final long component3() {
            return this.elapsedTime;
        }

        @NotNull
        public final String component4() {
            return this.presentableTaskName;
        }

        @NotNull
        public final TimedResult<T> copy(@Nullable T result, @Nullable Throwable exception, long elapsedTime, @NotNull String presentableTaskName) {
            Intrinsics.checkParameterIsNotNull((Object)presentableTaskName, (String)"presentableTaskName");
            return new TimedResult<T>(result, exception, elapsedTime, presentableTaskName);
        }

        public static /* synthetic */ TimedResult copy$default(TimedResult timedResult, Object object, Throwable throwable, long l, String string, int n, Object object2) {
            if ((n & 1) != 0) {
                object = timedResult.result;
            }
            if ((n & 2) != 0) {
                throwable = timedResult.exception;
            }
            if ((n & 4) != 0) {
                l = timedResult.elapsedTime;
            }
            if ((n & 8) != 0) {
                string = timedResult.presentableTaskName;
            }
            return timedResult.copy(object, throwable, l, string);
        }

        @NotNull
        public String toString() {
            return "TimedResult(result=" + this.result + ", exception=" + this.exception + ", elapsedTime=" + this.elapsedTime + ", presentableTaskName=" + this.presentableTaskName + ")";
        }

        public int hashCode() {
            T t = this.result;
            Throwable throwable = this.exception;
            long l = this.elapsedTime;
            String string = this.presentableTaskName;
            return (((t != null ? t.hashCode() : 0) * 31 + (throwable != null ? throwable.hashCode() : 0)) * 31 + (int)(l ^ l >>> 32)) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof TimedResult)) break block3;
                    TimedResult timedResult = (TimedResult)object;
                    if (!Intrinsics.areEqual(this.result, timedResult.result) || !Intrinsics.areEqual((Object)this.exception, (Object)timedResult.exception) || this.elapsedTime != timedResult.elapsedTime || !Intrinsics.areEqual((Object)this.presentableTaskName, (Object)timedResult.presentableTaskName)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/ExecutorWithProgress$TimedCallable;", "T", "Ljava/util/concurrent/Callable;", "Lcom/jetbrains/plugin/structure/base/utils/ExecutorWithProgress$TimedResult;", "task", "Lcom/jetbrains/plugin/structure/base/utils/ExecutorWithProgress$Task;", "(Lcom/jetbrains/plugin/structure/base/utils/ExecutorWithProgress$Task;)V", "call", "structure-base"})
    private static final class TimedCallable<T>
    implements Callable<TimedResult<T>> {
        private final Task<T> task;

        @Override
        @NotNull
        public TimedResult<T> call() {
            long start = System.nanoTime();
            Object result = null;
            Throwable exception = null;
            try {
                result = this.task.getCallable().call();
            }
            catch (Throwable e) {
                exception = e;
            }
            long elapsedTime = System.nanoTime() - start;
            return new TimedResult<Object>(result, exception, elapsedTime / (long)1000000, this.task.getPresentableName());
        }

        public TimedCallable(@NotNull Task<T> task) {
            Intrinsics.checkParameterIsNotNull(task, (String)"task");
            this.task = task;
        }
    }
}

