/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u0003\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0014\u001a\n\u0010\u0013\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\u0015\u001a\u00020\u0014*\u00020\u0014\u001a\n\u0010\u0015\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\u0016\u001a\u00020\u0017*\u00020\u0014\u001a\n\u0010\u0018\u001a\u00020\t*\u00020\u0014\u001a\n\u0010\u0018\u001a\u00020\u0017*\u00020\u0005\u001a\n\u0010\u0019\u001a\u00020\t*\u00020\u0005\u001a\n\u0010\u001a\u001a\u00020\u0017*\u00020\u0014\u001a\n\u0010\u001a\u001a\u00020\u0017*\u00020\u0005\u001a\u0012\u0010\u001b\u001a\u00020\t*\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0004\u001a\n\u0010\u001d\u001a\u00020\t*\u00020\u0014\u001a\n\u0010\u001e\u001a\u00020\t*\u00020\u0014\u001a\u0010\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050 *\u00020\u0005\u001a\u0018\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00140\"*\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0018\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00140\"*\u00020\u00142\u0006\u0010$\u001a\u00020\u0004\u001a\u0010\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040 *\u00020\u0005\u001a\n\u0010&\u001a\u00020\u0004*\u00020\u0005\u001a\n\u0010'\u001a\u00020\u0004*\u00020\u0004\u001a\n\u0010(\u001a\u00020\u0004*\u00020\u0004\u001a\u0012\u0010)\u001a\u00020\u0017*\u00020\u00052\u0006\u0010*\u001a\u00020+\u001a\u0012\u0010,\u001a\u00020\u0017*\u00020\u00052\u0006\u0010-\u001a\u00020\u0004\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0015\u0010\b\u001a\u00020\t*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\"\u0015\u0010\u000b\u001a\u00020\f*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0015\u0010\u000f\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007\"\u0015\u0010\u0011\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007\u00a8\u0006."}, d2={"LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "extension", "", "Ljava/nio/file/Path;", "getExtension", "(Ljava/nio/file/Path;)Ljava/lang/String;", "isDirectory", "", "(Ljava/nio/file/Path;)Z", "length", "", "getLength", "(Ljava/nio/file/Path;)J", "nameWithoutExtension", "getNameWithoutExtension", "simpleName", "getSimpleName", "create", "Ljava/io/File;", "createDir", "createParentDirs", "", "deleteLogged", "exists", "forceDeleteIfExists", "hasExtension", "expected", "isJar", "isZip", "listFiles", "", "listRecursivelyAllFilesWithExtension", "", "listRecursivelyAllFilesWithName", "name", "readLines", "readText", "replaceInvalidFileNameCharacters", "toSystemIndependentName", "writeBytes", "bytes", "", "writeText", "text", "structure-base"})
public final class FileUtilKt {
    private static final Logger LOG = LoggerFactory.getLogger((String)"structure.FileUtil");

    public static final boolean isZip(@NotNull File $this$isZip) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isZip, (String)"$this$isZip");
        return FileUtilKt.hasExtension($this$isZip, "zip");
    }

    public static final boolean isJar(@NotNull File $this$isJar) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isJar, (String)"$this$isJar");
        return FileUtilKt.hasExtension($this$isJar, "jar");
    }

    public static final boolean hasExtension(@NotNull File $this$hasExtension, @NotNull String expected) {
        Intrinsics.checkParameterIsNotNull((Object)$this$hasExtension, (String)"$this$hasExtension");
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        return $this$hasExtension.isFile() && Intrinsics.areEqual((Object)expected, (Object)FilesKt.getExtension((File)$this$hasExtension));
    }

    public static final void forceDeleteIfExists(@NotNull File $this$forceDeleteIfExists) {
        Intrinsics.checkParameterIsNotNull((Object)$this$forceDeleteIfExists, (String)"$this$forceDeleteIfExists");
        if ($this$forceDeleteIfExists.exists()) {
            FileUtils.forceDelete((File)$this$forceDeleteIfExists);
        }
    }

    @NotNull
    public static final Collection<File> listRecursivelyAllFilesWithName(@NotNull File $this$listRecursivelyAllFilesWithName, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$this$listRecursivelyAllFilesWithName, (String)"$this$listRecursivelyAllFilesWithName");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Collection collection = FileUtils.listFiles((File)$this$listRecursivelyAllFilesWithName, (IOFileFilter)((IOFileFilter)new NameFileFilter(name)), (IOFileFilter)TrueFileFilter.TRUE);
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"FileUtils.listFiles(this\u2026me), TrueFileFilter.TRUE)");
        return collection;
    }

    @NotNull
    public static final Collection<File> listRecursivelyAllFilesWithExtension(@NotNull File $this$listRecursivelyAllFilesWithExtension, @NotNull String extension) {
        Intrinsics.checkParameterIsNotNull((Object)$this$listRecursivelyAllFilesWithExtension, (String)"$this$listRecursivelyAllFilesWithExtension");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        Collection collection = FileUtils.listFiles((File)$this$listRecursivelyAllFilesWithExtension, (IOFileFilter)((IOFileFilter)new WildcardFileFilter("*." + extension)), (IOFileFilter)TrueFileFilter.TRUE);
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"FileUtils.listFiles(this\u2026n\"), TrueFileFilter.TRUE)");
        return collection;
    }

    public static final boolean deleteLogged(@NotNull File $this$deleteLogged) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$this$deleteLogged, (String)"$this$deleteLogged");
        try {
            FileUtilKt.forceDeleteIfExists($this$deleteLogged);
            bl = true;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            LOG.info("Cannot delete file because of interruption:  " + $this$deleteLogged);
            bl = false;
        }
        catch (Exception e) {
            LOG.error("Unable to delete " + $this$deleteLogged, (Throwable)e);
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final String toSystemIndependentName(@NotNull String $this$toSystemIndependentName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toSystemIndependentName, (String)"$this$toSystemIndependentName");
        return StringsKt.replace$default((String)$this$toSystemIndependentName, (char)'\\', (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String replaceInvalidFileNameCharacters(@NotNull String $this$replaceInvalidFileNameCharacters) {
        Intrinsics.checkParameterIsNotNull((Object)$this$replaceInvalidFileNameCharacters, (String)"$this$replaceInvalidFileNameCharacters");
        CharSequence charSequence = $this$replaceInvalidFileNameCharacters;
        Regex regex = new Regex("[^a-zA-Z0-9.#\\-() ]");
        String string = "_";
        boolean bl = false;
        return regex.replace(charSequence, string);
    }

    @NotNull
    public static final File createDir(@NotNull File $this$createDir) {
        Intrinsics.checkParameterIsNotNull((Object)$this$createDir, (String)"$this$createDir");
        if (!$this$createDir.isDirectory()) {
            FileUtils.forceMkdir((File)$this$createDir);
            if (!$this$createDir.isDirectory()) {
                throw (Throwable)new IOException("Failed to create directory " + $this$createDir);
            }
        }
        return $this$createDir;
    }

    public static final void createParentDirs(@NotNull File $this$createParentDirs) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)$this$createParentDirs, (String)"$this$createParentDirs");
            File file = $this$createParentDirs.getParentFile();
            if (file == null) break block0;
            FileUtilKt.createDir(file);
        }
    }

    @NotNull
    public static final File create(@NotNull File $this$create) {
        Intrinsics.checkParameterIsNotNull((Object)$this$create, (String)"$this$create");
        if ($this$create.getParentFile() != null) {
            FileUtils.forceMkdir((File)$this$create.getParentFile());
        }
        $this$create.createNewFile();
        return $this$create;
    }

    public static final void writeText(@NotNull Path $this$writeText, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)$this$writeText, (String)"$this$writeText");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        File file = $this$writeText.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"toFile()");
        FilesKt.writeText$default((File)FileUtilKt.create(file), (String)text, null, (int)2, null);
    }

    @NotNull
    public static final String readText(@NotNull Path $this$readText) {
        Intrinsics.checkParameterIsNotNull((Object)$this$readText, (String)"$this$readText");
        File file = $this$readText.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"toFile()");
        return FilesKt.readText$default((File)file, null, (int)1, null);
    }

    @NotNull
    public static final List<String> readLines(@NotNull Path $this$readLines) {
        Intrinsics.checkParameterIsNotNull((Object)$this$readLines, (String)"$this$readLines");
        File file = $this$readLines.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"toFile()");
        return FilesKt.readLines$default((File)file, null, (int)1, null);
    }

    public static final void writeBytes(@NotNull Path $this$writeBytes, @NotNull byte[] bytes) {
        Intrinsics.checkParameterIsNotNull((Object)$this$writeBytes, (String)"$this$writeBytes");
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        File file = $this$writeBytes.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"toFile()");
        FilesKt.writeBytes((File)file, (byte[])bytes);
    }

    @NotNull
    public static final Path createDir(@NotNull Path $this$createDir) {
        Intrinsics.checkParameterIsNotNull((Object)$this$createDir, (String)"$this$createDir");
        File file = $this$createDir.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"toFile()");
        FileUtilKt.createDir(file);
        return $this$createDir;
    }

    @NotNull
    public static final Path create(@NotNull Path $this$create) {
        Intrinsics.checkParameterIsNotNull((Object)$this$create, (String)"$this$create");
        File file = $this$create.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"toFile()");
        FileUtilKt.create(file);
        return $this$create;
    }

    public static final void forceDeleteIfExists(@NotNull Path $this$forceDeleteIfExists) {
        Intrinsics.checkParameterIsNotNull((Object)$this$forceDeleteIfExists, (String)"$this$forceDeleteIfExists");
        File file = $this$forceDeleteIfExists.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"toFile()");
        FileUtilKt.forceDeleteIfExists(file);
    }

    public static final void deleteLogged(@NotNull Path $this$deleteLogged) {
        Intrinsics.checkParameterIsNotNull((Object)$this$deleteLogged, (String)"$this$deleteLogged");
        File file = $this$deleteLogged.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"toFile()");
        FileUtilKt.deleteLogged(file);
    }

    public static final boolean exists(@NotNull Path $this$exists) {
        Intrinsics.checkParameterIsNotNull((Object)$this$exists, (String)"$this$exists");
        return Files.exists($this$exists, new LinkOption[0]);
    }

    @NotNull
    public static final List<Path> listFiles(@NotNull Path $this$listFiles) {
        Intrinsics.checkParameterIsNotNull((Object)$this$listFiles, (String)"$this$listFiles");
        List<Path> list = Files.list($this$listFiles).collect(Collectors.toList());
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Files.list(this).collect(Collectors.toList())");
        return list;
    }

    public static final boolean isDirectory(@NotNull Path $this$isDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isDirectory, (String)"$this$isDirectory");
        return Files.isDirectory($this$isDirectory, new LinkOption[0]);
    }

    @NotNull
    public static final String getSimpleName(@NotNull Path $this$simpleName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$simpleName, (String)"$this$simpleName");
        return ((Object)$this$simpleName.getFileName()).toString();
    }

    @NotNull
    public static final String getNameWithoutExtension(@NotNull Path $this$nameWithoutExtension) {
        Intrinsics.checkParameterIsNotNull((Object)$this$nameWithoutExtension, (String)"$this$nameWithoutExtension");
        return StringsKt.substringBeforeLast$default((String)FileUtilKt.getSimpleName($this$nameWithoutExtension), (String)".", null, (int)2, null);
    }

    @NotNull
    public static final String getExtension(@NotNull Path $this$extension) {
        Intrinsics.checkParameterIsNotNull((Object)$this$extension, (String)"$this$extension");
        return StringsKt.substringAfterLast((String)FileUtilKt.getSimpleName($this$extension), (String)".", (String)"");
    }

    public static final long getLength(@NotNull Path $this$length) {
        Intrinsics.checkParameterIsNotNull((Object)$this$length, (String)"$this$length");
        return Files.size($this$length);
    }
}

