/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.tools.ant.util.TeeOutputStream;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.internal.ExecException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.utils.LatestVersionResolver;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 32\u00020\u0001:\u00013B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\t0*H\u0002J\b\u0010+\u001a\u00020\tH\u0002J\u0017\u0010,\u001a\u00020\t2\b\u0010-\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0002\b.J\u0017\u0010/\u001a\u00020\t2\b\u0010-\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0002\b0J\b\u00101\u001a\u000202H\u0007R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u000e\u0010\u0014\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000fR\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000bR\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000bR\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000bR\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u000bR\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u000fR\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u000bR\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u000bR\u0016\u0010'\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u000f\u00a8\u00064"}, d2={"Lorg/jetbrains/intellij/tasks/SignPluginTask;", "Lorg/gradle/api/internal/ConventionTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "execOperations", "Lorg/gradle/process/ExecOperations;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/process/ExecOperations;)V", "certificateChain", "Lorg/gradle/api/provider/Property;", "", "getCertificateChain", "()Lorg/gradle/api/provider/Property;", "certificateChainFile", "Lorg/gradle/api/file/RegularFileProperty;", "getCertificateChainFile", "()Lorg/gradle/api/file/RegularFileProperty;", "cliPath", "getCliPath", "cliVersion", "getCliVersion", "context", "inputArchiveFile", "getInputArchiveFile", "keyStore", "getKeyStore", "keyStoreKeyAlias", "getKeyStoreKeyAlias", "keyStorePassword", "getKeyStorePassword", "keyStoreProviderName", "getKeyStoreProviderName", "keyStoreType", "getKeyStoreType", "outputArchiveFile", "getOutputArchiveFile", "password", "getPassword", "privateKey", "getPrivateKey", "privateKeyFile", "getPrivateKeyFile", "getOptions", "", "resolveCliPath", "resolveCliUrl", "version", "resolveCliUrl$gradle_intellij_plugin", "resolveCliVersion", "resolveCliVersion$gradle_intellij_plugin", "signPlugin", "", "Companion", "gradle-intellij-plugin"})
public class SignPluginTask
extends ConventionTask {
    @InputFile
    @SkipWhenEmpty
    @NotNull
    private final RegularFileProperty inputArchiveFile;
    @OutputFile
    @NotNull
    private final RegularFileProperty outputArchiveFile;
    @Input
    @Optional
    @NotNull
    private final Property<String> cliVersion;
    @Input
    @Optional
    @NotNull
    private final Property<String> cliPath;
    @Input
    @Optional
    @NotNull
    private final Property<String> keyStore;
    @Input
    @Optional
    @NotNull
    private final Property<String> keyStorePassword;
    @Input
    @Optional
    @NotNull
    private final Property<String> keyStoreKeyAlias;
    @Input
    @Optional
    @NotNull
    private final Property<String> keyStoreType;
    @Input
    @Optional
    @NotNull
    private final Property<String> keyStoreProviderName;
    @Input
    @Optional
    @NotNull
    private final Property<String> privateKey;
    @InputFile
    @Optional
    @NotNull
    private final RegularFileProperty privateKeyFile;
    @Input
    @Optional
    @NotNull
    private final Property<String> password;
    @Input
    @Optional
    @NotNull
    private final Property<String> certificateChain;
    @InputFile
    @Optional
    @NotNull
    private final RegularFileProperty certificateChainFile;
    private final String context;
    private final ObjectFactory objectFactory;
    private final ExecOperations execOperations;
    private static final String MARKETPLACE_ZIP_SIGNER_URL = "https://github.com/JetBrains/marketplace-zip-signer";
    private static final String RELEASE_DOWNLOAD_URL = "https://github.com/JetBrains/marketplace-zip-signer/releases/download/%VERSION%/marketplace-zip-signer-cli.jar";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final RegularFileProperty getInputArchiveFile() {
        return this.inputArchiveFile;
    }

    @NotNull
    public final RegularFileProperty getOutputArchiveFile() {
        return this.outputArchiveFile;
    }

    @NotNull
    public final Property<String> getCliVersion() {
        return this.cliVersion;
    }

    @NotNull
    public final Property<String> getCliPath() {
        return this.cliPath;
    }

    @NotNull
    public final Property<String> getKeyStore() {
        return this.keyStore;
    }

    @NotNull
    public final Property<String> getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @NotNull
    public final Property<String> getKeyStoreKeyAlias() {
        return this.keyStoreKeyAlias;
    }

    @NotNull
    public final Property<String> getKeyStoreType() {
        return this.keyStoreType;
    }

    @NotNull
    public final Property<String> getKeyStoreProviderName() {
        return this.keyStoreProviderName;
    }

    @NotNull
    public final Property<String> getPrivateKey() {
        return this.privateKey;
    }

    @NotNull
    public final RegularFileProperty getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    @NotNull
    public final Property<String> getPassword() {
        return this.password;
    }

    @NotNull
    public final Property<String> getCertificateChain() {
        return this.certificateChain;
    }

    @NotNull
    public final RegularFileProperty getCertificateChainFile() {
        return this.certificateChainFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void signPlugin() {
        RegularFile file = (RegularFile)this.inputArchiveFile.getOrNull();
        if (file == null || !file.getAsFile().exists()) {
            throw (Throwable)new IllegalStateException("Plugin file does not exist: " + file);
        }
        if (this.privateKey.getOrNull() == null && this.privateKeyFile.getOrNull() == null) {
            throw (Throwable)new InvalidUserDataException("Private key not found. One of the 'signPlugin.privateKey' or 'signPlugin.privateKeyFile' properties has to be provided.");
        }
        if (this.certificateChain.getOrNull() == null && this.certificateChainFile.getOrNull() == null) {
            throw (Throwable)new InvalidUserDataException("Certificate chain not found. One of the 'signPlugin.certificateChain' or 'signPlugin.certificateChainFile' properties has to be provided.");
        }
        String cliPath = this.resolveCliPath();
        List cliArgs = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"sign"), (Iterable)this.getOptions());
        StringBuilder stringBuilder = new StringBuilder().append("Distribution file: ");
        File file2 = file.getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file.asFile");
        Utils.debug$default(this.context, stringBuilder.append(file2.getCanonicalPath()).toString(), null, 4, null);
        Utils.debug$default(this.context, "Marketplace ZIP Signer CLI path: " + cliPath, null, 4, null);
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ExecResult execResult;
            ByteArrayOutputStream os = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            try {
                execResult = this.execOperations.javaexec(new Action(os, this, cliPath, cliArgs){
                    final /* synthetic */ ByteArrayOutputStream $os;
                    final /* synthetic */ SignPluginTask this$0;
                    final /* synthetic */ String $cliPath$inlined;
                    final /* synthetic */ List $cliArgs$inlined;
                    {
                        this.$os = byteArrayOutputStream;
                        this.this$0 = signPluginTask;
                        this.$cliPath$inlined = string;
                        this.$cliArgs$inlined = list2;
                    }

                    public final void execute(@NotNull JavaExecSpec $this$javaexec) {
                        Intrinsics.checkNotNullParameter((Object)$this$javaexec, (String)"$receiver");
                        $this$javaexec.setClasspath((FileCollection)SignPluginTask.access$getObjectFactory$p(this.this$0).fileCollection().from(new Object[]{this.$cliPath$inlined}));
                        $this$javaexec.getMainClass().set((Object)"org.jetbrains.zip.signer.ZipSigningTool");
                        $this$javaexec.setArgs(this.$cliArgs$inlined);
                        $this$javaexec.setStandardOutput((OutputStream)new TeeOutputStream((OutputStream)System.out, (OutputStream)this.$os));
                        $this$javaexec.setErrorOutput((OutputStream)new TeeOutputStream((OutputStream)System.err, (OutputStream)this.$os));
                    }
                });
            }
            catch (ExecException e) {
                Utils.error$default(this.context, "Error during Marketplace ZIP Signer CLI execution:\n" + os, null, 4, null);
                throw (Throwable)e;
            }
            ExecResult execResult2 = execResult;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final String resolveCliPath() {
        File verifier;
        String path = (String)this.cliPath.getOrNull();
        CharSequence charSequence = path;
        if (!(charSequence == null || charSequence.length() == 0) && (verifier = new File(path)).exists()) {
            return path;
        }
        throw (Throwable)new InvalidUserDataException("Provided Marketplace ZIP Signer path doesn't exist: '" + path + "'. Downloading Marketplace ZIP Signer: " + this.cliVersion);
    }

    private final List<String> getOptions() {
        List args;
        block9: {
            SignPluginTask $this$run;
            String it;
            Object object;
            Object[] objectArray = new String[4];
            objectArray[0] = "-in";
            Object object2 = this.inputArchiveFile.get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"inputArchiveFile.get()");
            File file = ((RegularFile)object2).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"inputArchiveFile.get().asFile");
            objectArray[1] = file.getCanonicalPath();
            objectArray[2] = "-out";
            Object object3 = this.outputArchiveFile.get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"outputArchiveFile.get()");
            File file2 = ((RegularFile)object3).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"outputArchiveFile.get().asFile");
            objectArray[3] = file2.getCanonicalPath();
            args = CollectionsKt.mutableListOf((Object[])objectArray);
            String string = (String)this.privateKey.getOrNull();
            if (string != null) {
                it = object = string;
                boolean bl = false;
                args.add("-key");
                args.add(it);
                Utils.debug$default(this.context, "Using private key passed as content", null, 4, null);
            } else {
                object = this;
                $this$run = (SignPluginTask)((Object)object);
                boolean bl = false;
                args.add("-key-file");
                Object object4 = $this$run.privateKeyFile.get();
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"privateKeyFile.get()");
                File file3 = ((RegularFile)object4).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"privateKeyFile.get().asFile");
                args.add(file3.getCanonicalPath());
                Utils.debug$default($this$run.context, "Using private key passed as file", null, 4, null);
            }
            String string2 = (String)this.certificateChain.getOrNull();
            if (string2 != null) {
                it = object = string2;
                boolean bl = false;
                args.add("-cert");
                args.add(it);
                Utils.debug$default(this.context, "Using certificate chain passed as content", null, 4, null);
            } else {
                object = this;
                $this$run = (SignPluginTask)((Object)object);
                boolean bl = false;
                args.add("-cert-file");
                Object object5 = $this$run.certificateChainFile.get();
                Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"certificateChainFile.get()");
                File file4 = ((RegularFile)object5).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"certificateChainFile.get().asFile");
                args.add(file4.getCanonicalPath());
                Utils.debug$default($this$run.context, "Using certificate chain passed as file", null, 4, null);
            }
            String string3 = (String)this.password.getOrNull();
            if (string3 != null) {
                it = object = string3;
                boolean bl = false;
                args.add("-key-pass");
                args.add(it);
                Utils.debug$default(this.context, "Using private key password", null, 4, null);
            }
            String string4 = (String)this.keyStore.getOrNull();
            if (string4 != null) {
                it = object = string4;
                boolean bl = false;
                args.add("-ks");
                args.add(it);
            }
            String string5 = (String)this.keyStorePassword.getOrNull();
            if (string5 != null) {
                it = object = string5;
                boolean bl = false;
                args.add("-ks-pass");
                args.add(it);
            }
            String string6 = (String)this.keyStoreKeyAlias.getOrNull();
            if (string6 != null) {
                it = object = string6;
                boolean bl = false;
                args.add("-ks-key-alias");
                args.add(it);
            }
            String string7 = (String)this.keyStoreType.getOrNull();
            if (string7 != null) {
                it = object = string7;
                boolean bl = false;
                args.add("-ks-type");
                args.add(it);
            }
            String string8 = (String)this.keyStoreProviderName.getOrNull();
            if (string8 == null) break block9;
            it = object = string8;
            boolean bl = false;
            args.add("-ks-provider-name");
            args.add(it);
        }
        return args;
    }

    @NotNull
    public final String resolveCliVersion$gradle_intellij_plugin(@Nullable String version) {
        String string;
        block3: {
            block2: {
                String string2;
                string = version;
                if (string == null) break block2;
                String it = string2 = string;
                boolean bl = false;
                string = Intrinsics.areEqual((Object)it, (Object)"latest") ^ true ? string2 : null;
                if (string != null) break block3;
            }
            string = Companion.resolveLatestVersion();
        }
        return string;
    }

    @NotNull
    public final String resolveCliUrl$gradle_intellij_plugin(@Nullable String version) {
        String string;
        String it = string = this.resolveCliVersion$gradle_intellij_plugin(version);
        boolean bl = false;
        return StringsKt.replace$default((String)RELEASE_DOWNLOAD_URL, (String)"%VERSION%", (String)it, (boolean)false, (int)4, null);
    }

    @Inject
    public SignPluginTask(@NotNull ObjectFactory objectFactory, @NotNull ExecOperations execOperations) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
        this.objectFactory = objectFactory;
        this.execOperations = execOperations;
        RegularFileProperty regularFileProperty = this.objectFactory.fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"objectFactory.fileProperty()");
        this.inputArchiveFile = regularFileProperty;
        RegularFileProperty regularFileProperty2 = this.objectFactory.fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty2, (String)"objectFactory.fileProperty()");
        this.outputArchiveFile = regularFileProperty2;
        ObjectFactory $this$property$iv = this.objectFactory;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        this.cliVersion = property;
        $this$property$iv = this.objectFactory;
        $i$f$property = false;
        Property property2 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java)");
        this.cliPath = property2;
        $this$property$iv = this.objectFactory;
        $i$f$property = false;
        Property property3 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"property(T::class.java)");
        this.keyStore = property3;
        $this$property$iv = this.objectFactory;
        $i$f$property = false;
        Property property4 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property4, (String)"property(T::class.java)");
        this.keyStorePassword = property4;
        $this$property$iv = this.objectFactory;
        $i$f$property = false;
        Property property5 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property5, (String)"property(T::class.java)");
        this.keyStoreKeyAlias = property5;
        $this$property$iv = this.objectFactory;
        $i$f$property = false;
        Property property6 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property6, (String)"property(T::class.java)");
        this.keyStoreType = property6;
        $this$property$iv = this.objectFactory;
        $i$f$property = false;
        Property property7 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property7, (String)"property(T::class.java)");
        this.keyStoreProviderName = property7;
        $this$property$iv = this.objectFactory;
        $i$f$property = false;
        Property property8 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property8, (String)"property(T::class.java)");
        this.privateKey = property8;
        RegularFileProperty regularFileProperty3 = this.objectFactory.fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty3, (String)"objectFactory.fileProperty()");
        this.privateKeyFile = regularFileProperty3;
        $this$property$iv = this.objectFactory;
        $i$f$property = false;
        Property property9 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property9, (String)"property(T::class.java)");
        this.password = property9;
        $this$property$iv = this.objectFactory;
        $i$f$property = false;
        Property property10 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property10, (String)"property(T::class.java)");
        this.certificateChain = property10;
        RegularFileProperty regularFileProperty4 = this.objectFactory.fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty4, (String)"objectFactory.fileProperty()");
        this.certificateChainFile = regularFileProperty4;
        this.context = Utils.logCategory((Task)this);
    }

    public static final /* synthetic */ ObjectFactory access$getObjectFactory$p(SignPluginTask $this) {
        return $this.objectFactory;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/intellij/tasks/SignPluginTask$Companion;", "", "()V", "MARKETPLACE_ZIP_SIGNER_URL", "", "RELEASE_DOWNLOAD_URL", "resolveLatestVersion", "gradle-intellij-plugin"})
    public static final class Companion {
        @NotNull
        public final String resolveLatestVersion() {
            return LatestVersionResolver.Companion.fromGitHub("Marketplace ZIP Signer CLI", SignPluginTask.MARKETPLACE_ZIP_SIGNER_URL);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

