/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.Incubating;
import org.gradle.api.Task;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.JavaForkOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.model.PerformanceTestResult;
import org.jetbrains.intellij.model.PerformanceTestScript;
import org.jetbrains.intellij.model.PerformanceTestStatistic;
import org.jetbrains.intellij.performanceTest.ProfilerName;
import org.jetbrains.intellij.performanceTest.TestExecutionFailException;
import org.jetbrains.intellij.performanceTest.parsers.IdeaLogParser;
import org.jetbrains.intellij.performanceTest.parsers.SimpleIJPerformanceParser;
import org.jetbrains.intellij.tasks.RunIdeBase;
import org.jetbrains.intellij.tasks.RunIdePerformanceTestTask;

@Incubating
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0012H\u0017R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u000e\u0010\f\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/intellij/tasks/RunIdePerformanceTestTask;", "Lorg/jetbrains/intellij/tasks/RunIdeBase;", "()V", "artifactsDir", "Lorg/gradle/api/provider/Property;", "", "getArtifactsDir", "()Lorg/gradle/api/provider/Property;", "context", "profilerName", "Lorg/jetbrains/intellij/performanceTest/ProfilerName;", "getProfilerName", "scriptPath", "testArtifactsDirPath", "Ljava/nio/file/Path;", "testDataDir", "getTestDataDir", "configureJvmArgs", "", "exec", "gradle-intellij-plugin"})
public class RunIdePerformanceTestTask
extends RunIdeBase {
    private final String context = Utils.logCategory((Task)this);
    @NotNull
    private final Property<String> testDataDir;
    @NotNull
    private final Property<String> artifactsDir;
    @NotNull
    private final Property<ProfilerName> profilerName;
    private String scriptPath;
    private Path testArtifactsDirPath;

    @Input
    @NotNull
    public final Property<String> getTestDataDir() {
        return this.testDataDir;
    }

    @Input
    @NotNull
    public final Property<String> getArtifactsDir() {
        return this.artifactsDir;
    }

    @Input
    @NotNull
    public final Property<ProfilerName> getProfilerName() {
        return this.profilerName;
    }

    @Override
    @TaskAction
    public void exec() {
        Object it;
        Iterable $this$forEach$iv;
        Path path = Paths.get((String)this.artifactsDir.get(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(artifactsDir.get())");
        Path dir = FileUtilKt.createDir((Path)path);
        File testData = Path.of((String)this.testDataDir.get(), new String[0]).toFile();
        List testExecutionResults = new ArrayList();
        File file = testData;
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"testData");
        Sequence sequence = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)file, null, (int)1, null).maxDepth(1)), (Function1)exec.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (File)element$iv;
            boolean bl = false;
            String testName = FilesKt.getNameWithoutExtension((File)it);
            String string = ((File)it).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.path");
            PerformanceTestScript testScript = new SimpleIJPerformanceParser(string).parse();
            this.scriptPath = ((Object)((File)it).toPath().toAbsolutePath()).toString();
            Path path2 = dir.resolve(testName);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"dir.resolve(testName)");
            Intrinsics.checkNotNullExpressionValue((Object)FileUtilKt.createDir((Path)path2).toAbsolutePath(), (String)"dir.resolve(testName).createDir().toAbsolutePath()");
            this.testArtifactsDirPath = this.testArtifactsDirPath;
            this.setArgs(CollectionsKt.listOf((Object)((String)this.testDataDir.get() + '/' + testScript.getProjectName())));
            super.exec();
            Path path3 = this.testArtifactsDirPath;
            if (path3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"testArtifactsDirPath");
            }
            PerformanceTestStatistic testResults = new IdeaLogParser(((Object)path3.resolve("idea.log")).toString()).getTestStatistic();
            Utils.info$default(this.context, "Total time " + testResults.getTotalTime() + "ms, expected time ms " + testScript.getAssertionTimeout() + "ms", null, 4, null);
            if (testScript.getAssertionTimeout() == null) continue;
            Long l = testResults.getTotalTime();
            Intrinsics.checkNotNull((Object)l);
            if (l <= testScript.getAssertionTimeout()) continue;
            testExecutionResults.add(new PerformanceTestResult(testName, testResults, testScript));
        }
        if (testExecutionResults.size() > 0) {
            $this$forEach$iv = testExecutionResults;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (PerformanceTestResult)element$iv;
                boolean bl = false;
                Utils.error$default(this.context, "TEST `" + ((PerformanceTestResult)it).getTestName() + "` FAILED", null, 4, null);
                Utils.error$default(this.context, "Expected time of execution `" + ((PerformanceTestResult)it).getScript().getAssertionTimeout() + "ms`, but was " + ((PerformanceTestResult)it).getStatistic().getTotalTime() + "ms", null, 4, null);
            }
            throw (Throwable)new TestExecutionFailException(testExecutionResults.size() + " test(s) failed");
        }
    }

    @Override
    protected void configureJvmArgs() {
        String string;
        JavaForkOptions javaForkOptions = (JavaForkOptions)this;
        List list2 = this.getJvmArgs();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"jvmArgs");
        this.setJvmArgs(Utils.getIdeJvmArgs(javaForkOptions, list2, (File)this.getIdeDir().get()));
        Object[] objectArray = new String[13];
        objectArray[0] = "-Djdk.attach.allowAttachSelf=true";
        objectArray[1] = "-Didea.is.integration.test=true";
        objectArray[2] = "-Djb.privacy.policy.text=<!--999.999-->";
        objectArray[3] = "-Djb.consents.confirmation.enabled=false";
        objectArray[4] = "-Didea.local.statistics.without.report=true";
        objectArray[5] = "-Dlinux.native.menu.force.disable=true";
        objectArray[6] = "-Didea.fatal.error.notification=true";
        StringBuilder stringBuilder = new StringBuilder().append("-Dtestscript.filename=");
        String string2 = this.scriptPath;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scriptPath");
        }
        objectArray[7] = stringBuilder.append(string2).toString();
        StringBuilder stringBuilder2 = new StringBuilder().append("-DintegrationTests.profiler=");
        String string3 = string = ((ProfilerName)((Object)this.profilerName.get())).name();
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        objectArray[8] = stringBuilder2.append(string4).toString();
        StringBuilder stringBuilder3 = new StringBuilder().append("-Dide.performance.screenshot.before.kill=");
        Path path = this.testArtifactsDirPath;
        if (path == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testArtifactsDirPath");
        }
        objectArray[9] = stringBuilder3.append(path).toString();
        StringBuilder stringBuilder4 = new StringBuilder().append("-Didea.log.path=");
        Path path2 = this.testArtifactsDirPath;
        if (path2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testArtifactsDirPath");
        }
        objectArray[10] = stringBuilder4.append(path2).toString();
        StringBuilder stringBuilder5 = new StringBuilder().append("-Dsnapshots.path=");
        Path path3 = this.testArtifactsDirPath;
        if (path3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testArtifactsDirPath");
        }
        objectArray[11] = stringBuilder5.append(path3).toString();
        StringBuilder stringBuilder6 = new StringBuilder().append("-Dmemory.snapshots.path=");
        Path path4 = this.testArtifactsDirPath;
        if (path4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testArtifactsDirPath");
        }
        objectArray[12] = stringBuilder6.append(path4).toString();
        this.jvmArgs(CollectionsKt.mutableListOf((Object[])objectArray));
    }

    public RunIdePerformanceTestTask() {
        super(true);
        ObjectFactory objectFactory = this.getObjectFactory();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"objectFactory");
        ObjectFactory $this$property$iv = objectFactory;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        this.testDataDir = property;
        ObjectFactory objectFactory2 = this.getObjectFactory();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory2, (String)"objectFactory");
        $this$property$iv = objectFactory2;
        $i$f$property = false;
        Property property2 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java)");
        this.artifactsDir = property2;
        ObjectFactory objectFactory3 = this.getObjectFactory();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory3, (String)"objectFactory");
        $this$property$iv = objectFactory3;
        $i$f$property = false;
        Property property3 = $this$property$iv.property(ProfilerName.class);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"property(T::class.java)");
        this.profilerName = property3;
    }
}

