/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import groovy.lang.Closure;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileType;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildException;
import org.gradle.work.FileChange;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.IdeaDependency;
import org.jetbrains.intellij.tasks.IntelliJInstrumentCodeTask;
import org.jetbrains.intellij.tasks.IntelliJInstrumentCodeTask$WhenMappings;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 12\u00020\u0001:\u00011B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010#\u001a\u0010\u0012\f\u0012\n %*\u0004\u0018\u00010\u000b0\u000b0$H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0007J\u001e\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020'0.H\u0002J\u0016\u0010/\u001a\u00020,2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000b0$H\u0002R\u0016\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\bR\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\u0016\u0010\u001b\u001a\u00020\u001c8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\bR\u0016\u0010!\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\b\u00a8\u00062"}, d2={"Lorg/jetbrains/intellij/tasks/IntelliJInstrumentCodeTask;", "Lorg/gradle/api/internal/ConventionTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "classesDirs", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClassesDirs", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "compilerClassPathFromMaven", "Lorg/gradle/api/provider/ListProperty;", "Ljava/io/File;", "getCompilerClassPathFromMaven", "()Lorg/gradle/api/provider/ListProperty;", "compilerVersion", "Lorg/gradle/api/provider/Property;", "", "getCompilerVersion", "()Lorg/gradle/api/provider/Property;", "context", "formsDirs", "getFormsDirs", "ideaDependency", "Lorg/jetbrains/intellij/dependency/IdeaDependency;", "getIdeaDependency", "javac2", "getJavac2", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "sourceDirs", "getSourceDirs", "sourceSetCompileClasspath", "getSourceSetCompileClasspath", "compilerClassPath", "", "kotlin.jvm.PlatformType", "instrumentClasses", "", "inputChanges", "Lorg/gradle/work/InputChanges;", "instrumentCode", "instrumentNotNull", "", "block", "Lkotlin/Function0;", "prepareNotNullInstrumenting", "classpath", "Companion", "gradle-intellij-plugin"})
public class IntelliJInstrumentCodeTask
extends ConventionTask {
    @Internal
    @NotNull
    private final ConfigurableFileCollection sourceSetCompileClasspath;
    @Input
    @Optional
    @NotNull
    private final Property<IdeaDependency> ideaDependency;
    @Input
    @Optional
    @NotNull
    private final Property<File> javac2;
    @Input
    @NotNull
    private final Property<String> compilerVersion;
    @Incremental
    @InputFiles
    @NotNull
    private final ConfigurableFileCollection classesDirs;
    @Incremental
    @InputFiles
    @NotNull
    private final ConfigurableFileCollection formsDirs;
    @Internal
    @NotNull
    private final ConfigurableFileCollection sourceDirs;
    @OutputDirectory
    @NotNull
    private final DirectoryProperty outputDir;
    @Input
    @NotNull
    private final ListProperty<File> compilerClassPathFromMaven;
    private final String context;
    @NotNull
    public static final String FILTER_ANNOTATION_REGEXP_CLASS = "com.intellij.ant.ClassFilterAnnotationRegexp";
    @NotNull
    public static final String LOADER_REF = "java2.loader";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ConfigurableFileCollection getSourceSetCompileClasspath() {
        return this.sourceSetCompileClasspath;
    }

    @NotNull
    public final Property<IdeaDependency> getIdeaDependency() {
        return this.ideaDependency;
    }

    @NotNull
    public final Property<File> getJavac2() {
        return this.javac2;
    }

    @NotNull
    public final Property<String> getCompilerVersion() {
        return this.compilerVersion;
    }

    @NotNull
    public final ConfigurableFileCollection getClassesDirs() {
        return this.classesDirs;
    }

    @NotNull
    public final ConfigurableFileCollection getFormsDirs() {
        return this.formsDirs;
    }

    @NotNull
    public final ConfigurableFileCollection getSourceDirs() {
        return this.sourceDirs;
    }

    @NotNull
    public final DirectoryProperty getOutputDir() {
        return this.outputDir;
    }

    @NotNull
    public final ListProperty<File> getCompilerClassPathFromMaven() {
        return this.compilerClassPathFromMaven;
    }

    @TaskAction
    public final void instrumentClasses(@NotNull InputChanges inputChanges) {
        Object compiledClassRelativePath;
        Iterable<Path> relativePath;
        Comparable<File> sourceDir;
        Iterable iterable;
        Path path;
        FileChange change;
        File file;
        Intrinsics.checkNotNullParameter((Object)inputChanges, (String)"inputChanges");
        List<File> classpath = this.compilerClassPath();
        this.getAnt().invokeMethod("taskdef", (Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"name", (Object)"instrumentIdeaExtensions"), TuplesKt.to((Object)"classpath", (Object)CollectionsKt.joinToString$default((Iterable)classpath, (CharSequence)":", null, null, (int)0, null, null, (int)62, null)), TuplesKt.to((Object)"loaderref", (Object)LOADER_REF), TuplesKt.to((Object)"classname", (Object)"com.intellij.ant.InstrumentIdeaExtensions")}));
        Utils.info$default(this.context, "Compiling forms and instrumenting code with nullability preconditions", null, 4, null);
        boolean instrumentNotNull = this.prepareNotNullInstrumenting(classpath);
        Object object = this.outputDir.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"outputDir.get()");
        Path outputDirPath = ((Directory)object).getAsFile().toPath();
        File it = file = this.getTemporaryDir();
        boolean bl = false;
        it.mkdirs();
        Path temporaryDirPath = file.toPath();
        Iterable iterable2 = inputChanges.getFileChanges((FileCollection)this.formsDirs);
        Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"inputChanges.getFileChanges(formsDirs)");
        Iterable $this$forEach$iv = iterable2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object compiledClassPath;
            Comparable<File> comparable;
            Object v3;
            Object object22;
            block8: {
                Iterable iterable3;
                change = (FileChange)element$iv;
                boolean bl2 = false;
                FileChange fileChange = change;
                Intrinsics.checkNotNullExpressionValue((Object)fileChange, (String)"change");
                path = fileChange.getFile().toPath();
                iterable = iterable3 = (Iterable)this.sourceDirs;
                for (Object object22 : iterable) {
                    File sourceDir2 = (File)object22;
                    boolean bl3 = false;
                    if (!path.startsWith(sourceDir2.toPath())) continue;
                    v3 = object22;
                    break block8;
                }
                v3 = null;
            }
            if ((comparable = (File)v3) == null || (comparable = ((File)comparable).toPath()) == null) continue;
            sourceDir = comparable;
            relativePath = sourceDir.relativize(path);
            compiledClassRelativePath = StringsKt.replace$default((String)relativePath.toString(), (String)".form", (String)".class", (boolean)false, (int)4, null);
            Object it2 = object22 = outputDirPath.resolve((String)compiledClassRelativePath);
            boolean bl4 = false;
            Object object3 = it2;
            Intrinsics.checkNotNullExpressionValue(object3, (String)"it");
            if ((FileUtilKt.exists(object3) ? object22 : null) == null) continue;
            compiledClassPath = compiledClassPath;
            Path instrumentedClassPath = temporaryDirPath.resolve((String)compiledClassRelativePath);
            Files.copy(compiledClassPath, instrumentedClassPath, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
        Iterable iterable4 = inputChanges.getFileChanges((FileCollection)this.classesDirs);
        Intrinsics.checkNotNullExpressionValue((Object)iterable4, (String)"inputChanges.getFileChanges(classesDirs)");
        $this$forEach$iv = iterable4;
        $i$f$forEach = false;
        block5: for (Object element$iv : $this$forEach$iv) {
            Comparable<File> comparable;
            Path path2;
            block9: {
                change = (FileChange)element$iv;
                boolean bl5 = false;
                FileChange fileChange = change;
                Intrinsics.checkNotNullExpressionValue((Object)fileChange, (String)"change");
                if (fileChange.getFileType() != FileType.FILE) continue;
                path = change.getFile().toPath();
                relativePath = (Iterable)this.classesDirs;
                compiledClassRelativePath = relativePath;
                Iterator<Path> compiledClassPath = compiledClassRelativePath.iterator();
                while (compiledClassPath.hasNext()) {
                    Path instrumentedClassPath = compiledClassPath.next();
                    File classesDir = (File)((Object)instrumentedClassPath);
                    boolean bl6 = false;
                    if (!path.startsWith(classesDir.toPath())) continue;
                    path2 = instrumentedClassPath;
                    break block9;
                }
                path2 = null;
            }
            if ((comparable = (File)((Object)path2)) == null || (comparable = comparable.toPath()) == null) continue;
            sourceDir = comparable;
            relativePath = sourceDir.relativize(path);
            switch (IntelliJInstrumentCodeTask$WhenMappings.$EnumSwitchMapping$0[change.getChangeType().ordinal()]) {
                case 1: {
                    Iterable $this$forEach$iv2 = CollectionsKt.listOf((Object[])new Path[]{outputDirPath, temporaryDirPath});
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        Path it3 = (Path)element$iv2;
                        boolean bl7 = false;
                        Path path3 = it3.resolve((Path)relativePath);
                        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"it.resolve(relativePath)");
                        FileUtilKt.deleteLogged((Path)path3);
                    }
                    continue block5;
                }
                default: {
                    Iterable $this$apply = iterable = temporaryDirPath.resolve((Path)relativePath);
                    boolean bl8 = false;
                    FileUtilKt.createParentDirs((Path)$this$apply);
                    Files.copy(path, (Path)$this$apply, StandardCopyOption.REPLACE_EXISTING);
                }
            }
        }
        this.instrumentCode(instrumentNotNull, (Function0<Unit>)((Function0)new Function0<Unit>(temporaryDirPath, outputDirPath){
            final /* synthetic */ Path $temporaryDirPath;
            final /* synthetic */ Path $outputDirPath;

            public final void invoke() {
                Files.walk(this.$temporaryDirPath, new FileVisitOption[0]).filter(instrumentClasses.1.INSTANCE).forEach(new Consumer(this){
                    final /* synthetic */ instrumentClasses.3 this$0;

                    public final void accept(Path file) {
                        Path path;
                        Path relativePath = this.this$0.$temporaryDirPath.relativize(file);
                        Path $this$apply = path = this.this$0.$outputDirPath.resolve(relativePath);
                        boolean bl = false;
                        FileUtilKt.createParentDirs((Path)$this$apply);
                        Files.copy(file, $this$apply, StandardCopyOption.REPLACE_EXISTING);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$temporaryDirPath = path;
                this.$outputDirPath = path2;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> compilerClassPath() {
        Object object;
        block7: {
            block6: {
                Object object2;
                File file;
                File file2;
                object = (File)this.javac2.getOrNull();
                if (object == null) break block6;
                File it = file2 = object;
                boolean bl = false;
                File file3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"it");
                File p1 = file = file3;
                boolean bl2 = false;
                File file4 = p1.exists() ? file : null;
                if (file4 != null) {
                    void $this$orEmpty$iv;
                    File file5 = file = file4;
                    boolean bl3 = false;
                    File[] fileArray = new File(((IdeaDependency)this.ideaDependency.get()).getClasses() + "/lib").listFiles(compilerClassPath.1.2.1.INSTANCE);
                    boolean $i$f$orEmpty = false;
                    File[] fileArray2 = $this$orEmpty$iv;
                    if (fileArray2 == null) {
                        fileArray2 = new File[]{};
                    }
                    object2 = CollectionsKt.plus((Collection)ArraysKt.filterNotNull((Object[])fileArray2), (Object)file5);
                } else {
                    object2 = object = null;
                }
                if (object2 != null) break block7;
            }
            Object object3 = this.compilerClassPathFromMaven.get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"compilerClassPathFromMaven.get()");
            object = (List)object3;
        }
        return object;
    }

    private final boolean prepareNotNullInstrumenting(List<? extends File> classpath) {
        try {
            this.getAnt().invokeMethod("typedef", (Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"name", (Object)"skip"), TuplesKt.to((Object)"classpath", (Object)CollectionsKt.joinToString$default((Iterable)classpath, (CharSequence)":", null, null, (int)0, null, null, (int)62, null)), TuplesKt.to((Object)"loaderref", (Object)LOADER_REF), TuplesKt.to((Object)"classname", (Object)FILTER_ANNOTATION_REGEXP_CLASS)}));
        }
        catch (BuildException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ClassNotFoundException && Intrinsics.areEqual((Object)FILTER_ANNOTATION_REGEXP_CLASS, (Object)cause.getMessage())) {
                Utils.info$default(this.context, "Old version of Javac2 is used, instrumenting code with nullability will be skipped. Use IDEA >14 SDK (139.*) to fix this", null, 4, null);
                return false;
            }
            throw (Throwable)e;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void instrumentCode(boolean instrumentNotNull, Function0<Unit> block) {
        String headlessOldValue = System.setProperty("java.awt.headless", "true");
        try {
            FileCollection fileCollection = this.sourceDirs.filter((Spec)instrumentCode.dirs.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"sourceDirs.filter { it.exists() }");
            FileCollection dirs2 = fileCollection;
            if (!dirs2.isEmpty()) {
                this.getAnt().invokeMethod("instrumentIdeaExtensions", (Object)new Object[]{MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"srcdir", (Object)CollectionsKt.joinToString$default((Iterable)((Iterable)dirs2), (CharSequence)":", null, null, (int)0, null, null, (int)62, null)), TuplesKt.to((Object)"destdir", (Object)this.getTemporaryDir()), TuplesKt.to((Object)"classpath", (Object)CollectionsKt.joinToString$default((Iterable)((Iterable)this.sourceSetCompileClasspath), (CharSequence)":", null, null, (int)0, null, null, (int)62, null)), TuplesKt.to((Object)"includeantruntime", (Object)false), TuplesKt.to((Object)"instrumentNotNull", (Object)instrumentNotNull)}), new Closure<Object>(this, instrumentNotNull, (Object)this, (Object)this){
                    final /* synthetic */ IntelliJInstrumentCodeTask this$0;
                    final /* synthetic */ boolean $instrumentNotNull;

                    @Nullable
                    public final Object doCall() {
                        return this.$instrumentNotNull ? this.this$0.getAnt().invokeMethod("skip", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"pattern", (Object)"kotlin/Metadata"))) : null;
                    }
                    {
                        this.this$0 = this$0;
                        this.$instrumentNotNull = $captured_local_variable$1;
                        super($super_call_param$2, $super_call_param$3);
                    }
                }});
            }
        }
        finally {
            block.invoke();
            if (headlessOldValue != null) {
                System.setProperty("java.awt.headless", headlessOldValue);
            } else {
                System.clearProperty("java.awt.headless");
            }
        }
    }

    @Inject
    public IntelliJInstrumentCodeTask(@NotNull ObjectFactory objectFactory) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        ConfigurableFileCollection configurableFileCollection = objectFactory.fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"objectFactory.fileCollection()");
        this.sourceSetCompileClasspath = configurableFileCollection;
        ObjectFactory $this$property$iv = objectFactory;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(IdeaDependency.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        this.ideaDependency = property;
        $this$property$iv = objectFactory;
        $i$f$property = false;
        Property property2 = $this$property$iv.property(File.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java)");
        this.javac2 = property2;
        $this$property$iv = objectFactory;
        $i$f$property = false;
        Property property3 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"property(T::class.java)");
        this.compilerVersion = property3;
        ConfigurableFileCollection configurableFileCollection2 = objectFactory.fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection2, (String)"objectFactory.fileCollection()");
        this.classesDirs = configurableFileCollection2;
        ConfigurableFileCollection configurableFileCollection3 = objectFactory.fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection3, (String)"objectFactory.fileCollection()");
        this.formsDirs = configurableFileCollection3;
        ConfigurableFileCollection configurableFileCollection4 = objectFactory.fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection4, (String)"objectFactory.fileCollection()");
        this.sourceDirs = configurableFileCollection4;
        DirectoryProperty directoryProperty = objectFactory.directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objectFactory.directoryProperty()");
        this.outputDir = directoryProperty;
        ObjectFactory $this$listProperty$iv = objectFactory;
        boolean $i$f$listProperty = false;
        ListProperty listProperty = $this$listProperty$iv.listProperty(File.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"listProperty(T::class.java)");
        this.compilerClassPathFromMaven = listProperty;
        this.context = Utils.logCategory((Task)this);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/intellij/tasks/IntelliJInstrumentCodeTask$Companion;", "", "()V", "FILTER_ANNOTATION_REGEXP_CLASS", "", "LOADER_REF", "gradle-intellij-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

