/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.io.File;
import java.nio.file.Path;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0007R\u0016\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/intellij/tasks/ClasspathIndexCleanupTask;", "Lorg/gradle/api/internal/ConventionTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "classpathIndexFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClasspathIndexFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "context", "", "classpathIndexCleanup", "", "gradle-intellij-plugin"})
public class ClasspathIndexCleanupTask
extends ConventionTask {
    @InputFiles
    @NotNull
    private final ConfigurableFileCollection classpathIndexFiles;
    private final String context;

    @NotNull
    public final ConfigurableFileCollection getClasspathIndexFiles() {
        return this.classpathIndexFiles;
    }

    @TaskAction
    public final void classpathIndexCleanup() {
        Iterable $this$forEach$iv = (Iterable)this.classpathIndexFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            Path path = it.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it.toPath()");
            FileUtilKt.deleteQuietly((Path)path);
            Utils.info$default(this.context, "Removed classpath.index file: " + it, null, 4, null);
        }
    }

    @Inject
    public ClasspathIndexCleanupTask(@NotNull ObjectFactory objectFactory) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        ConfigurableFileCollection configurableFileCollection = objectFactory.fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"objectFactory.fileCollection()");
        this.classpathIndexFiles = configurableFileCollection;
        this.context = Utils.logCategory((Task)this);
    }
}

