/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.PluginDependency;
import org.jetbrains.intellij.dependency.PluginDependencyNotation;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0013\u00103\u001a\u00020\t2\b\u00104\u001a\u0004\u0018\u000105H\u0096\u0002J\b\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020:H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\r\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u001bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0014\u0010\n\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000fR\u001c\u0010!\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\r\"\u0004\b#\u0010\u0018R\u0014\u0010$\u001a\u00020%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0012R\u001c\u0010)\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0012\"\u0004\b+\u0010\u0014R \u0010,\u001a\b\u0012\u0004\u0012\u00020\u00070\u001bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u001d\"\u0004\b.\u0010\u001fR\u001c\u0010/\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0012\"\u0004\b1\u0010\u0014R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0012\u00a8\u0006;"}, d2={"Lorg/jetbrains/intellij/dependency/PluginDependencyImpl;", "Lorg/jetbrains/intellij/dependency/PluginDependency;", "id", "", "platformPluginId", "version", "artifact", "Ljava/io/File;", "builtin", "", "maven", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/io/File;ZZ)V", "getArtifact", "()Ljava/io/File;", "getBuiltin", "()Z", "channel", "getChannel", "()Ljava/lang/String;", "setChannel", "(Ljava/lang/String;)V", "classesDirectory", "getClassesDirectory", "setClassesDirectory", "(Ljava/io/File;)V", "getId", "jarFiles", "", "getJarFiles", "()Ljava/util/Collection;", "setJarFiles", "(Ljava/util/Collection;)V", "getMaven", "metaInfDirectory", "getMetaInfDirectory", "setMetaInfDirectory", "notation", "Lorg/jetbrains/intellij/dependency/PluginDependencyNotation;", "getNotation", "()Lorg/jetbrains/intellij/dependency/PluginDependencyNotation;", "getPlatformPluginId", "sinceBuild", "getSinceBuild", "setSinceBuild", "sourceJarFiles", "getSourceJarFiles", "setSourceJarFiles", "untilBuild", "getUntilBuild", "setUntilBuild", "getVersion", "equals", "other", "", "hashCode", "", "isCompatible", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "gradle-intellij-plugin"})
public final class PluginDependencyImpl
implements PluginDependency {
    @Nullable
    private String channel;
    @NotNull
    private Collection<? extends File> jarFiles;
    @NotNull
    private Collection<? extends File> sourceJarFiles;
    @Nullable
    private File classesDirectory;
    @Nullable
    private File metaInfDirectory;
    @NotNull
    private final PluginDependencyNotation notation;
    @Nullable
    private String sinceBuild;
    @Nullable
    private String untilBuild;
    @NotNull
    private final String id;
    @Nullable
    private final String platformPluginId;
    @NotNull
    private final String version;
    @NotNull
    private final File artifact;
    private final boolean builtin;
    private final boolean maven;

    @Override
    @Nullable
    public String getChannel() {
        return this.channel;
    }

    public void setChannel(@Nullable String string) {
        this.channel = string;
    }

    @Override
    @NotNull
    public Collection<File> getJarFiles() {
        return this.jarFiles;
    }

    public void setJarFiles(@NotNull Collection<? extends File> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
        this.jarFiles = collection;
    }

    @Override
    @NotNull
    public Collection<File> getSourceJarFiles() {
        return this.sourceJarFiles;
    }

    public void setSourceJarFiles(@NotNull Collection<? extends File> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
        this.sourceJarFiles = collection;
    }

    @Override
    @Nullable
    public File getClassesDirectory() {
        return this.classesDirectory;
    }

    public void setClassesDirectory(@Nullable File file) {
        this.classesDirectory = file;
    }

    @Override
    @Nullable
    public File getMetaInfDirectory() {
        return this.metaInfDirectory;
    }

    public void setMetaInfDirectory(@Nullable File file) {
        this.metaInfDirectory = file;
    }

    @Override
    @NotNull
    public PluginDependencyNotation getNotation() {
        return this.notation;
    }

    @Nullable
    public final String getSinceBuild() {
        return this.sinceBuild;
    }

    public final void setSinceBuild(@Nullable String string) {
        this.sinceBuild = string;
    }

    @Nullable
    public final String getUntilBuild() {
        return this.untilBuild;
    }

    public final void setUntilBuild(@Nullable String string) {
        this.untilBuild = string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isCompatible(@NotNull IdeVersion ideVersion) {
        boolean bl;
        String it;
        String string;
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        String string2 = this.sinceBuild;
        if (string2 != null) {
            it = string = string2;
            boolean bl2 = false;
            if (IdeVersion.createIdeVersion((String)it).compareTo(ideVersion) > 0) return false;
            bl = true;
        } else {
            bl = true;
        }
        if (!bl) return false;
        String string3 = this.untilBuild;
        if (string3 == null) return true;
        it = string = string3;
        boolean bl3 = false;
        if (ideVersion.compareTo(IdeVersion.createIdeVersion((String)it)) > 0) return false;
        return true;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.intellij.dependency.PluginDependencyImpl");
        }
        PluginDependencyImpl cfr_ignored_0 = (PluginDependencyImpl)object2;
        if (Intrinsics.areEqual((Object)this.getId(), (Object)((PluginDependencyImpl)other).getId()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.getPlatformPluginId(), (Object)((PluginDependencyImpl)other).getPlatformPluginId()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.getVersion(), (Object)((PluginDependencyImpl)other).getVersion()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.getArtifact(), (Object)((PluginDependencyImpl)other).getArtifact()) ^ true) {
            return false;
        }
        if (this.getBuiltin() != ((PluginDependencyImpl)other).getBuiltin()) {
            return false;
        }
        if (this.getMaven() != ((PluginDependencyImpl)other).getMaven()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.getChannel(), (Object)((PluginDependencyImpl)other).getChannel()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual(this.getJarFiles(), ((PluginDependencyImpl)other).getJarFiles()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual(this.getSourceJarFiles(), ((PluginDependencyImpl)other).getSourceJarFiles()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.getClassesDirectory(), (Object)((PluginDependencyImpl)other).getClassesDirectory()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.getMetaInfDirectory(), (Object)((PluginDependencyImpl)other).getMetaInfDirectory()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.getNotation(), (Object)((PluginDependencyImpl)other).getNotation()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.sinceBuild, (Object)((PluginDependencyImpl)other).sinceBuild) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.untilBuild, (Object)((PluginDependencyImpl)other).untilBuild) ^ true);
    }

    public int hashCode() {
        int result2 = this.getId().hashCode();
        Object object = this.getPlatformPluginId();
        String string = object;
        result2 = 31 * result2 + (string != null ? string.hashCode() : 0);
        result2 = 31 * result2 + this.getVersion().hashCode();
        result2 = 31 * result2 + this.getArtifact().hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.getBuiltin());
        result2 = 31 * result2 + Boolean.hashCode(this.getMaven());
        object = this.getChannel();
        String string2 = object;
        result2 = 31 * result2 + (string2 != null ? string2.hashCode() : 0);
        result2 = 31 * result2 + ((Object)this.getJarFiles()).hashCode();
        result2 = 31 * result2 + ((Object)this.getSourceJarFiles()).hashCode();
        Object object2 = object = this.getClassesDirectory();
        result2 = 31 * result2 + (object2 != null ? object2.hashCode() : 0);
        Object object3 = object = this.getMetaInfDirectory();
        result2 = 31 * result2 + (object3 != null ? object3.hashCode() : 0);
        result2 = 31 * result2 + this.getNotation().hashCode();
        Object object4 = object = this.sinceBuild;
        result2 = 31 * result2 + (object4 != null ? object4.hashCode() : 0);
        Object object5 = object = this.untilBuild;
        result2 = 31 * result2 + (object5 != null ? object5.hashCode() : 0);
        return result2;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public String getPlatformPluginId() {
        return this.platformPluginId;
    }

    @Override
    @NotNull
    public String getVersion() {
        return this.version;
    }

    @Override
    @NotNull
    public File getArtifact() {
        return this.artifact;
    }

    @Override
    public boolean getBuiltin() {
        return this.builtin;
    }

    @Override
    public boolean getMaven() {
        return this.maven;
    }

    public PluginDependencyImpl(@NotNull String id, @Nullable String platformPluginId, @NotNull String version, @NotNull File artifact, boolean builtin, boolean maven) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        this.id = id;
        this.platformPluginId = platformPluginId;
        this.version = version;
        this.artifact = artifact;
        this.builtin = builtin;
        this.maven = maven;
        this.jarFiles = CollectionsKt.emptyList();
        this.sourceJarFiles = CollectionsKt.emptyList();
        this.notation = new PluginDependencyNotation(this.getId(), this.getVersion(), this.getChannel());
        if (Utils.isJar(this.getArtifact())) {
            this.setJarFiles(CollectionsKt.listOf((Object)this.getArtifact()));
        }
        if (this.getArtifact().isDirectory()) {
            File metaInf;
            File classes;
            File lib = new File(this.getArtifact(), "lib");
            if (lib.isDirectory()) {
                this.setJarFiles(Utils.collectJars$default(lib, null, 2, null));
                this.setSourceJarFiles(Utils.collectJars$default(new File(lib, "src"), null, 2, null));
            }
            if ((classes = new File(this.getArtifact(), "classes")).isDirectory()) {
                this.setClassesDirectory(classes);
            }
            if ((metaInf = new File(this.getArtifact(), "META-INF")).isDirectory()) {
                this.setMetaInfDirectory(metaInf);
            }
        }
    }

    public /* synthetic */ PluginDependencyImpl(String string, String string2, String string3, File file, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        this(string, string2, string3, file, bl, bl2);
    }
}

