/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij;

import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.plugin.PluginProblem;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.beans.PluginBean;
import com.jetbrains.plugin.structure.intellij.extractor.PluginBeanExtractor;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginManager;
import com.jetbrains.plugin.structure.intellij.utils.JDOMUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModule;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.process.JavaForkOptions;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.IntelliJPlugin;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.IdeaDependency;
import org.jetbrains.intellij.model.ProductInfo;
import org.xml.sax.SAXParseException;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u009e\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bH\u0002\u001a$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\b2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b\u001a$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\b2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b\u001a\"\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u001a&\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\u00142\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u001a&\u0010\u001b\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\u00142\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u001a,\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00140\u001d2\b\u0010!\u001a\u0004\u0018\u00010\b\u001a8\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140#2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00140\u001d\u001a\u000e\u0010(\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\b\u001a\u0010\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010!\u001a\u00020\b\u001a\u000e\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\u0014\u001a&\u0010-\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\u00142\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u001a\u000e\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u000200\u001a\u000e\u00101\u001a\u00020\u00122\u0006\u00102\u001a\u00020\u0014\u001a\u000e\u00103\u001a\u00020\u00122\u0006\u00104\u001a\u00020\u0014\u001a,\u00105\u001a\u00020\u00162\u0006\u00106\u001a\u0002072\b\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002\u001a\u000e\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;\u001a\u001a\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010>\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0014\u001a\u000e\u0010?\u001a\u00020\u00142\u0006\u0010@\u001a\u00020\u0014\u001a\u0014\u0010A\u001a\b\u0012\u0004\u0012\u00020\b0\u001d2\u0006\u0010:\u001a\u00020;\u001a\u0016\u0010B\u001a\u00020\u00162\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\b\u001a&\u0010F\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\u00142\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u001a\u0018\u0010G\u001a\u00020\u0012*\u00020\u00122\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00160I\u001a'\u0010J\u001a\u0004\u0018\u0001HK\"\u0004\b\u0000\u0010K*\u0004\u0018\u0001HK2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00160I\u00a2\u0006\u0002\u0010L\u001a\n\u0010M\u001a\u00020\u0012*\u00020\b\u001a\n\u0010N\u001a\u00020\u0012*\u00020\b\u001a\n\u0010\u0017\u001a\u00020\u0014*\u00020;\u001a\n\u0010\u0017\u001a\u00020\u0014*\u00020O\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"MAJOR_VERSION_PATTERN", "Ljava/util/regex/Pattern;", "getMAJOR_VERSION_PATTERN", "()Ljava/util/regex/Pattern;", "json", "Lkotlinx/serialization/json/Json;", "collectFiles", "", "Ljava/io/File;", "directory", "filter", "Ljava/util/function/Predicate;", "collectJars", "collectZips", "createPlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "artifact", "validatePluginXml", "", "context", "", "debug", "", "logCategory", "message", "e", "", "error", "getIdeJvmArgs", "", "options", "Lorg/gradle/process/JavaForkOptions;", "arguments", "ideDirectory", "getIdeaSystemProperties", "", "configDirectory", "systemDirectory", "pluginsDirectory", "requirePluginIds", "ideBuildNumber", "ideProductInfo", "Lorg/jetbrains/intellij/model/ProductInfo;", "ideaDir", "path", "info", "isDependencyOnPyCharm", "dependency", "Lorg/jetbrains/intellij/dependency/IdeaDependency;", "isKotlinRuntime", "name", "isPyCharmType", "type", "log", "level", "Lorg/gradle/api/logging/LogLevel;", "mainSourceSet", "Lorg/gradle/api/tasks/SourceSet;", "project", "Lorg/gradle/api/Project;", "parsePluginXml", "Lcom/jetbrains/plugin/structure/intellij/beans/PluginBean;", "pluginXml", "releaseType", "version", "sourcePluginXmlFiles", "transformXml", "document", "Lorg/jdom2/Document;", "file", "warn", "ifFalse", "block", "Lkotlin/Function0;", "ifNull", "T", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "isJar", "isZip", "Lorg/gradle/api/Task;", "gradle-intellij-plugin"})
@JvmName(name="Utils")
public final class Utils {
    @NotNull
    private static final Pattern MAJOR_VERSION_PATTERN;
    private static final Json json;

    @NotNull
    public static final Pattern getMAJOR_VERSION_PATTERN() {
        return MAJOR_VERSION_PATTERN;
    }

    @NotNull
    public static final SourceSet mainSourceSet(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = project.getConvention().getPlugin(JavaPluginConvention.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project\n    .convention.\u2026inConvention::class.java)");
        Object object2 = ((JavaPluginConvention)object).getSourceSets().getByName("main");
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"project\n    .convention.\u2026Set.MAIN_SOURCE_SET_NAME)");
        return (SourceSet)object2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> sourcePluginXmlFiles(@NotNull Project project) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SourceDirectorySet sourceDirectorySet = Utils.mainSourceSet(project).getResources();
        Intrinsics.checkNotNullExpressionValue((Object)sourceDirectorySet, (String)"mainSourceSet(project).resources");
        Set set = sourceDirectorySet.getSrcDirs();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"mainSourceSet(project).resources.srcDirs");
        Iterable $this$mapNotNull$iv = set;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            File file;
            File file2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl2 = false;
            File file3 = file2 = new File(it, "META-INF/plugin.xml");
            boolean bl3 = false;
            if ((file3.exists() && file3.length() > 0L ? file2 : null) == null) continue;
            file = file;
            boolean bl4 = false;
            boolean bl5 = false;
            File it$iv$iv = file;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final PluginBean parsePluginXml(@NotNull File pluginXml, @Nullable String logCategory) {
        Intrinsics.checkNotNullParameter((Object)pluginXml, (String)"pluginXml");
        try {
            Object object = pluginXml;
            object = new FileInputStream((File)object);
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)object;
                boolean bl = false;
                Document document = JDOMUtil.loadDocument((InputStream)it);
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"JDOMUtil.loadDocument(it)");
                Document document2 = document;
                PluginBean pluginBean = PluginBeanExtractor.INSTANCE.extractPluginBean(document2);
                return pluginBean;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        catch (SAXParseException e) {
            Utils.warn(logCategory, "Cannot read: " + pluginXml.getCanonicalPath() + ". Skipping", e);
        }
        catch (JDOMException e) {
            Utils.warn(logCategory, "Cannot read: " + pluginXml.getCanonicalPath() + ". Skipping", e);
        }
        catch (IOException e) {
            Utils.warn(logCategory, "Cannot read: " + pluginXml.getCanonicalPath() + ". Skipping", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void transformXml(@NotNull Document document, @NotNull File file) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        XMLOutputter xmlOutput = new XMLOutputter();
        Format $this$apply = object = xmlOutput.getFormat();
        boolean bl = false;
        $this$apply.setIndent("  ");
        $this$apply.setOmitDeclaration(true);
        $this$apply.setTextMode(Format.TextMode.TRIM);
        object = new StringWriter();
        Throwable throwable = null;
        try {
            StringWriter it = (StringWriter)object;
            boolean bl2 = false;
            xmlOutput.output(document, (Writer)it);
            String string = it.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.toString()");
            FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    @NotNull
    public static final Map<String, String> getIdeaSystemProperties(@NotNull File configDirectory, @NotNull File systemDirectory, @NotNull File pluginsDirectory, @NotNull List<String> requirePluginIds) {
        Intrinsics.checkNotNullParameter((Object)configDirectory, (String)"configDirectory");
        Intrinsics.checkNotNullParameter((Object)systemDirectory, (String)"systemDirectory");
        Intrinsics.checkNotNullParameter((Object)pluginsDirectory, (String)"pluginsDirectory");
        Intrinsics.checkNotNullParameter(requirePluginIds, (String)"requirePluginIds");
        Map result2 = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"idea.config.path", (Object)configDirectory.getAbsolutePath()), TuplesKt.to((Object)"idea.system.path", (Object)systemDirectory.getAbsolutePath()), TuplesKt.to((Object)"idea.plugins.path", (Object)pluginsDirectory.getAbsolutePath())});
        Collection collection = requirePluginIds;
        if (!collection.isEmpty()) {
            return MapsKt.plus((Map)result2, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"idea.required.plugins.id", (Object)CollectionsKt.joinToString$default((Iterable)requirePluginIds, (CharSequence)",", null, null, (int)0, null, null, (int)62, null))));
        }
        return result2;
    }

    @NotNull
    public static final List<String> getIdeJvmArgs(@NotNull JavaForkOptions options, @NotNull List<String> arguments, @Nullable File ideDirectory) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        String string = options.getMaxHeapSize();
        if (string == null) {
            string = "512m";
        }
        options.setMaxHeapSize(string);
        String string2 = options.getMinHeapSize();
        if (string2 == null) {
            string2 = "256m";
        }
        options.setMinHeapSize(string2);
        File file = ideDirectory;
        if (file != null) {
            File file2;
            File it = file2 = file;
            boolean bl = false;
            File bootJar = new File(it, "lib/boot.jar");
            if (bootJar.exists()) {
                return CollectionsKt.plus((Collection)arguments, (Object)("-Xbootclasspath/a:" + bootJar.getAbsolutePath()));
            }
        }
        return arguments;
    }

    @NotNull
    public static final String ideBuildNumber(@NotNull File ideDirectory) {
        Intrinsics.checkNotNullParameter((Object)ideDirectory, (String)"ideDirectory");
        Object object = new File(ideDirectory, "Resources/build.txt");
        File it = object;
        boolean bl = false;
        OperatingSystem operatingSystem = OperatingSystem.current();
        Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"OperatingSystem.current()");
        Object object2 = operatingSystem.isMacOsX() && it.exists() ? object : null;
        if (object2 == null) {
            object2 = new File(ideDirectory, "build.txt");
        }
        Object object3 = object = FilesKt.readText$default((File)object2, null, (int)1, null);
        if (object3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)((CharSequence)object3))).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final ProductInfo ideProductInfo(@NotNull File ideDirectory) {
        Object object;
        File file;
        Intrinsics.checkNotNullParameter((Object)ideDirectory, (String)"ideDirectory");
        File it = file = new File(ideDirectory, "Resources/product-info.json");
        boolean bl = false;
        OperatingSystem operatingSystem = OperatingSystem.current();
        Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"OperatingSystem.current()");
        File file2 = operatingSystem.isMacOsX() && it.exists() ? file : null;
        if (file2 == null) {
            file2 = new File(ideDirectory, "product-info.json");
        }
        file = file2;
        try {
            void $this$decodeFromString$iv;
            object = Result.Companion;
            File $this$runCatching = file;
            boolean bl2 = false;
            StringFormat stringFormat = (StringFormat)json;
            String string$iv = FilesKt.readText$default((File)$this$runCatching, null, (int)1, null);
            boolean $i$f$decodeFromString = false;
            SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(ProductInfo.class));
            boolean $i$f$cast = false;
            ProductInfo productInfo = (ProductInfo)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, string$iv);
            boolean bl3 = false;
            object = Result.constructor-impl((Object)productInfo);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        file = object;
        return (ProductInfo)((Object)(Result.isFailure-impl((Object)file) ? null : file));
    }

    @NotNull
    public static final File ideaDir(@NotNull String path) {
        File file;
        File file2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File it = file2 = new File(path);
        boolean bl = false;
        File it2 = file = it;
        boolean bl2 = false;
        String string = it2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
        File file3 = !StringsKt.endsWith$default((String)string, (String)".app", (boolean)false, (int)2, null) ? file : null;
        if (file3 == null) {
            file3 = new File(it, "Contents");
        }
        return file3;
    }

    public static final boolean isJar(@NotNull File $this$isJar) {
        Intrinsics.checkNotNullParameter((Object)$this$isJar, (String)"$this$isJar");
        Path path = $this$isJar.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath()");
        return FileUtilKt.isJar((Path)path);
    }

    public static final boolean isZip(@NotNull File $this$isZip) {
        Intrinsics.checkNotNullParameter((Object)$this$isZip, (String)"$this$isZip");
        Path path = $this$isZip.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath()");
        return FileUtilKt.isZip((Path)path);
    }

    @NotNull
    public static final Collection<File> collectJars(@NotNull File directory, @NotNull Predicate<File> filter) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        return Utils.collectFiles(directory, new Predicate(filter){
            final /* synthetic */ Predicate $filter;

            public final boolean test(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Utils.isJar(it) && this.$filter.test(it);
            }
            {
                this.$filter = predicate;
            }
        });
    }

    public static /* synthetic */ Collection collectJars$default(File file, Predicate predicate, int n, Object object) {
        if ((n & 2) != 0) {
            predicate = collectJars.1.INSTANCE;
        }
        return Utils.collectJars(file, predicate);
    }

    @NotNull
    public static final Collection<File> collectZips(@NotNull File directory, @NotNull Predicate<File> filter) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        return Utils.collectFiles(directory, new Predicate(filter){
            final /* synthetic */ Predicate $filter;

            public final boolean test(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Utils.isZip(it) && this.$filter.test(it);
            }
            {
                this.$filter = predicate;
            }
        });
    }

    public static /* synthetic */ Collection collectZips$default(File file, Predicate predicate, int n, Object object) {
        if ((n & 2) != 0) {
            predicate = collectZips.1.INSTANCE;
        }
        return Utils.collectZips(file, predicate);
    }

    private static final Collection<File> collectFiles(File directory, Predicate<File> filter) {
        Collection collection;
        if (!directory.isDirectory()) {
            collection = CollectionsKt.emptyList();
        } else {
            Collection collection2 = FileUtils.listFiles((File)directory, (IOFileFilter)((IOFileFilter)new AbstractFileFilter(filter){
                final /* synthetic */ Predicate $filter;

                public boolean accept(@NotNull File file) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    return this.$filter.test(file);
                }
                {
                    this.$filter = $captured_local_variable$0;
                }
            }), (IOFileFilter)FalseFileFilter.FALSE);
            collection = collection2;
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"FileUtils.listFiles(dire\u2026}, FalseFileFilter.FALSE)");
        }
        return collection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final String releaseType(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (StringsKt.endsWith$default((String)version, (String)"-EAP-SNAPSHOT", (boolean)false, (int)2, null)) return "snapshots";
        if (StringsKt.endsWith$default((String)version, (String)"-EAP-CANDIDATE-SNAPSHOT", (boolean)false, (int)2, null)) return "snapshots";
        if (StringsKt.endsWith$default((String)version, (String)"-CUSTOM-SNAPSHOT", (boolean)false, (int)2, null)) return "snapshots";
        CharSequence charSequence = version;
        Pattern pattern = MAJOR_VERSION_PATTERN;
        if ((pattern = new Regex(pattern)).matches(charSequence)) {
            return "snapshots";
        }
        if (!StringsKt.endsWith$default((String)version, (String)"-SNAPSHOT", (boolean)false, (int)2, null)) return "releases";
        return "nightly";
    }

    public static final void error(@Nullable String logCategory, @NotNull String message, @Nullable Throwable e) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Utils.log(LogLevel.ERROR, logCategory, message, e);
    }

    public static /* synthetic */ void error$default(String string, String string2, Throwable throwable, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        Utils.error(string, string2, throwable);
    }

    public static final void warn(@Nullable String logCategory, @NotNull String message, @Nullable Throwable e) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Utils.log(LogLevel.WARN, logCategory, message, e);
    }

    public static /* synthetic */ void warn$default(String string, String string2, Throwable throwable, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        Utils.warn(string, string2, throwable);
    }

    public static final void info(@Nullable String logCategory, @NotNull String message, @Nullable Throwable e) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Utils.log(LogLevel.INFO, logCategory, message, e);
    }

    public static /* synthetic */ void info$default(String string, String string2, Throwable throwable, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        Utils.info(string, string2, throwable);
    }

    public static final void debug(@Nullable String logCategory, @NotNull String message, @Nullable Throwable e) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Utils.log(LogLevel.DEBUG, logCategory, message, e);
    }

    public static /* synthetic */ void debug$default(String string, String string2, Throwable throwable, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        Utils.debug(string, string2, throwable);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void log(LogLevel level, String logCategory, String message, Throwable e) {
        StringBuilder stringBuilder = new StringBuilder().append("gradle-intellij-plugin ");
        String string = logCategory;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        String string3 = string = stringBuilder.append(string2).toString();
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String category = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        Logger logger = Logging.getLogger(IntelliJPlugin.class);
        if (e != null && level != LogLevel.ERROR) {
            Logger logger2 = logger;
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"logger");
            if (!logger2.isDebugEnabled()) {
                logger.log(level, '[' + category + "] " + message + ". Run with --debug option to get more log output.");
                return;
            }
        }
        logger.log(level, '[' + category + "] " + message, e);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String logCategory(@NotNull Project $this$logCategory) {
        void it;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$logCategory, (String)"$this$logCategory");
        String string2 = string = $this$logCategory.getName();
        StringBuilder stringBuilder = new StringBuilder().append($this$logCategory.getPath());
        boolean bl = false;
        boolean bl2 = Intrinsics.areEqual((Object)(':' + (String)it), (Object)$this$logCategory.getPath()) ^ true;
        string = bl2 ? string : null;
        String string3 = string;
        if (string3 == null) {
            string3 = "";
        }
        return stringBuilder.append(string3).toString();
    }

    @NotNull
    public static final String logCategory(@NotNull Task $this$logCategory) {
        Intrinsics.checkNotNullParameter((Object)$this$logCategory, (String)"$this$logCategory");
        StringBuilder stringBuilder = new StringBuilder();
        Project project = $this$logCategory.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return stringBuilder.append(Utils.logCategory(project)).append($this$logCategory.getPath()).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final IdePlugin createPlugin(@NotNull File artifact, boolean validatePluginXml, @Nullable String context) {
        IdePlugin idePlugin;
        PluginCreationResult creationResult;
        Path extractDirectory;
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Path path = extractDirectory = Files.createTempDirectory("tmp", new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"extractDirectory");
        IdePluginManager idePluginManager = IdePluginManager.Companion.createManager(path);
        Path path2 = artifact.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"artifact.toPath()");
        PluginCreationResult pluginCreationResult = creationResult = idePluginManager.createPlugin(path2, validatePluginXml, "plugin.xml");
        if (pluginCreationResult instanceof PluginCreationSuccess) {
            idePlugin = (IdePlugin)((PluginCreationSuccess)creationResult).getPlugin();
        } else if (pluginCreationResult instanceof PluginCreationFail) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = ((PluginCreationFail)creationResult).getErrorsAndWarnings();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PluginProblem it = (PluginProblem)element$iv$iv;
                boolean bl = false;
                if (!(it.getLevel() == PluginProblem.Level.ERROR)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            String problems = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, null, (int)63, null);
            Utils.warn$default(context, "Cannot create plugin from file '" + artifact + "': " + problems, null, 4, null);
            idePlugin = null;
        } else {
            Utils.warn$default(context, "Cannot create plugin from file '" + artifact + "'. " + creationResult, null, 4, null);
            idePlugin = null;
        }
        return idePlugin;
    }

    public static final boolean isKotlinRuntime(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return Intrinsics.areEqual((Object)name, (Object)"kotlin-runtime") || Intrinsics.areEqual((Object)name, (Object)"kotlin-reflect") || StringsKt.startsWith$default((String)name, (String)"kotlin-reflect-", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name, (Object)"kotlin-stdlib") || StringsKt.startsWith$default((String)name, (String)"kotlin-stdlib-", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name, (Object)"kotlin-test") || StringsKt.startsWith$default((String)name, (String)"kotlin-test-", (boolean)false, (int)2, null);
    }

    public static final boolean isDependencyOnPyCharm(@NotNull IdeaDependency dependency) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        return Intrinsics.areEqual((Object)dependency.getName(), (Object)"pycharmPY") || Intrinsics.areEqual((Object)dependency.getName(), (Object)"pycharmPC");
    }

    public static final boolean isPyCharmType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return Intrinsics.areEqual((Object)type, (Object)"PY") || Intrinsics.areEqual((Object)type, (Object)"PC");
    }

    @Nullable
    public static final <T> T ifNull(@Nullable T $this$ifNull, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if ($this$ifNull == null) {
            block.invoke();
        }
        return $this$ifNull;
    }

    public static final boolean ifFalse(boolean $this$ifFalse, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (!$this$ifFalse) {
            block.invoke();
        }
        return $this$ifFalse;
    }

    static {
        String string = "(RIDER-|GO-)?\\d{4}\\.\\d-(EAP\\d*-)?SNAPSHOT";
        int n = 0;
        Pattern pattern = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"java.util.regex.Pattern.compile(this, flags)");
        MAJOR_VERSION_PATTERN = pattern;
        json = JsonKt.Json$default(null, (Function1)json.1.INSTANCE, (int)1, null);
    }
}

