/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.plugin.PluginProblem;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginManager;
import java.nio.file.Path;
import java.util.Collection;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.VerificationTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\nH\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR$\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0016\u0010\u0010\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/intellij/tasks/VerifyPluginTask;", "Lorg/gradle/api/internal/ConventionTask;", "Lorg/gradle/api/tasks/VerificationTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "context", "", "ignoreFailures", "Lorg/gradle/api/provider/Property;", "", "kotlin.jvm.PlatformType", "getIgnoreFailures", "()Lorg/gradle/api/provider/Property;", "ignoreWarnings", "getIgnoreWarnings", "pluginDir", "Lorg/gradle/api/file/DirectoryProperty;", "getPluginDir", "()Lorg/gradle/api/file/DirectoryProperty;", "setIgnoreFailures", "", "verifyPlugin", "gradle-intellij-plugin"})
public class VerifyPluginTask
extends ConventionTask
implements VerificationTask {
    @Input
    @NotNull
    private final Property<Boolean> ignoreFailures;
    private final String context;
    @Input
    @NotNull
    private final Property<Boolean> ignoreWarnings;
    @InputDirectory
    @NotNull
    private final DirectoryProperty pluginDir;

    @NotNull
    public final Property<Boolean> getIgnoreFailures() {
        return this.ignoreFailures;
    }

    public boolean getIgnoreFailures() {
        Object object = this.ignoreFailures.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ignoreFailures.get()");
        return (Boolean)object;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures.set((Object)ignoreFailures);
    }

    @NotNull
    public final Property<Boolean> getIgnoreWarnings() {
        return this.ignoreWarnings;
    }

    @NotNull
    public final DirectoryProperty getPluginDir() {
        return this.pluginDir;
    }

    @TaskAction
    public final void verifyPlugin() {
        boolean failBuild;
        Collection collection;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Object object = this.pluginDir.get();
        Directory it = (Directory)object;
        boolean bl = false;
        IdePluginManager idePluginManager = IdePluginManager.Companion.createManager();
        Directory directory = it;
        Intrinsics.checkNotNullExpressionValue((Object)directory, (String)"it");
        Path path = directory.getAsFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it.asFile.toPath()");
        PluginCreationResult creationResult = idePluginManager.createPlugin(path);
        object = creationResult;
        if (object instanceof PluginCreationSuccess) {
            $this$forEach$iv = ((PluginCreationSuccess)creationResult).getWarnings();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PluginProblem it2 = (PluginProblem)element$iv;
                boolean bl2 = false;
                Utils.warn$default(this.context, it2.getMessage(), null, 4, null);
            }
        } else if (object instanceof PluginCreationFail) {
            $this$forEach$iv = ((PluginCreationFail)creationResult).getErrorsAndWarnings();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PluginProblem it3 = (PluginProblem)element$iv;
                boolean bl3 = false;
                if (it3.getLevel() == PluginProblem.Level.ERROR) {
                    Utils.error$default(this.context, it3.getMessage(), null, 4, null);
                    continue;
                }
                Utils.warn$default(this.context, it3.getMessage(), null, 4, null);
            }
        } else {
            Utils.error$default(this.context, creationResult.toString(), null, 4, null);
        }
        boolean bl4 = !(creationResult instanceof PluginCreationSuccess) || (Boolean)this.ignoreWarnings.get() == false && !(collection = (Collection)((PluginCreationSuccess)creationResult).getWarnings()).isEmpty() ? true : (failBuild = false);
        if (failBuild && !((Boolean)this.ignoreFailures.get()).booleanValue()) {
            throw (Throwable)new GradleException("Plugin verification failed.");
        }
    }

    @Inject
    public VerifyPluginTask(@NotNull ObjectFactory objectFactory) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        ObjectFactory $this$property$iv = objectFactory;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(Boolean.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        Property property2 = property.convention((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"objectFactory.property<B\u2026lean>().convention(false)");
        this.ignoreFailures = property2;
        this.context = Utils.logCategory((Task)this);
        $this$property$iv = objectFactory;
        $i$f$property = false;
        Property property3 = $this$property$iv.property(Boolean.class);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"property(T::class.java)");
        Property property4 = property3.convention((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)property4, (String)"objectFactory.property<Boolean>().convention(true)");
        this.ignoreWarnings = property4;
        DirectoryProperty directoryProperty = objectFactory.directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objectFactory.directoryProperty()");
        this.pluginDir = directoryProperty;
    }
}

