/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.process.JavaForkOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.Version;
import org.jetbrains.intellij.tasks.RunIdeBase;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b&\u0018\u0000 02\u00020\u0001:\u00010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020#H\u0014J\b\u0010%\u001a\u00020#H\u0002J\b\u0010&\u001a\u00020#H\u0017J\n\u0010'\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\rH\u0002J,\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020\r2\u0006\u0010,\u001a\u00020-2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020-0/H\u0002R\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\bR\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\bR\u0016\u0010\u0014\u001a\u00020\u00158\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\bR\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\bR\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u001d8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\b\u00a8\u00061"}, d2={"Lorg/jetbrains/intellij/tasks/RunIdeBase;", "Lorg/gradle/api/tasks/JavaExec;", "runAlways", "", "(Z)V", "autoReloadPlugins", "Lorg/gradle/api/provider/Property;", "getAutoReloadPlugins", "()Lorg/gradle/api/provider/Property;", "configDir", "Ljava/io/File;", "getConfigDir", "context", "", "ideDir", "getIdeDir", "jbrVariant", "getJbrVariant", "jbrVersion", "getJbrVersion", "pluginsDir", "Lorg/gradle/api/file/DirectoryProperty;", "getPluginsDir", "()Lorg/gradle/api/file/DirectoryProperty;", "projectExecutable", "getProjectExecutable", "projectWorkingDir", "getProjectWorkingDir", "requiredPluginIds", "Lorg/gradle/api/provider/ListProperty;", "getRequiredPluginIds", "()Lorg/gradle/api/provider/ListProperty;", "systemDir", "getSystemDir", "configureClasspath", "", "configureJvmArgs", "configureSystemProperties", "exec", "findIdePrefix", "resolveToolsJar", "javaExec", "systemPropertyIfNotDefined", "name", "value", "", "userDefinedSystemProperties", "", "Companion", "gradle-intellij-plugin"})
public abstract class RunIdeBase
extends JavaExec {
    private final String context = Utils.logCategory((Task)this);
    @Input
    @NotNull
    private final Property<File> ideDir;
    @Input
    @Optional
    @NotNull
    private final Property<String> jbrVersion;
    @Input
    @Optional
    @NotNull
    private final Property<String> jbrVariant;
    @InputDirectory
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    private final DirectoryProperty pluginsDir;
    @Input
    @Optional
    @NotNull
    private final Property<Boolean> autoReloadPlugins;
    @Internal
    @NotNull
    private final ListProperty<String> requiredPluginIds;
    @Internal
    @NotNull
    private final Property<File> configDir;
    @Internal
    @NotNull
    private final Property<File> systemDir;
    @Internal
    @NotNull
    private final Property<File> projectWorkingDir;
    @Internal
    @NotNull
    private final Property<String> projectExecutable;
    private static final Regex platformPrefixSystemPropertyRegex;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Property<File> getIdeDir() {
        return this.ideDir;
    }

    @NotNull
    public final Property<String> getJbrVersion() {
        return this.jbrVersion;
    }

    @NotNull
    public final Property<String> getJbrVariant() {
        return this.jbrVariant;
    }

    @NotNull
    public final DirectoryProperty getPluginsDir() {
        return this.pluginsDir;
    }

    @NotNull
    public final Property<Boolean> getAutoReloadPlugins() {
        return this.autoReloadPlugins;
    }

    @NotNull
    public final ListProperty<String> getRequiredPluginIds() {
        return this.requiredPluginIds;
    }

    @NotNull
    public final Property<File> getConfigDir() {
        return this.configDir;
    }

    @NotNull
    public final Property<File> getSystemDir() {
        return this.systemDir;
    }

    @NotNull
    public final Property<File> getProjectWorkingDir() {
        return this.projectWorkingDir;
    }

    @NotNull
    public final Property<String> getProjectExecutable() {
        return this.projectExecutable;
    }

    @TaskAction
    public void exec() {
        this.setWorkingDir((File)this.projectWorkingDir.get());
        this.configureSystemProperties();
        this.configureJvmArgs();
        this.executable(this.projectExecutable.get());
        this.configureClasspath();
        super.exec();
    }

    /*
     * WARNING - void declaration
     */
    private final void configureClasspath() {
        void it;
        Object object;
        Object object2 = this.ideDir.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"ideDir.get()");
        File ideDirFile = (File)object2;
        Object it2 = object = this.getExecutable();
        boolean bl = false;
        Object object3 = (CharSequence)it2;
        Object object4 = !(object3 == null || object3.length() == 0) ? object : null;
        if (object4 != null) {
            it2 = object = object4;
            boolean bl2 = false;
            String string = it2;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
            Object p1 = object3 = this.resolveToolsJar(string);
            boolean bl3 = false;
            Object object5 = ((File)p1).exists() ? object3 : null;
            if (object5 == null) {
                Jvm jvm = Jvm.current();
                Intrinsics.checkNotNullExpressionValue((Object)jvm, (String)"Jvm.current()");
                object5 = object4 = jvm.getToolsJar();
            }
            if (object5 != null) {
                it2 = object = object4;
                boolean bl4 = false;
                RunIdeBase runIdeBase = this;
                runIdeBase.setClasspath(runIdeBase.getClasspath().plus((FileCollection)this.getObjectFactory().fileCollection().from(new Object[]{it2})));
            }
        }
        Object object6 = this.ideDir.get();
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"ideDir.get()");
        it2 = CollectionsKt.last((List)StringsKt.split$default((CharSequence)Utils.ideBuildNumber((File)object6), (char[])new char[]{'-'}, (boolean)false, (int)0, (int)6, null));
        Version.Companion bl4 = Version.Companion;
        String p1 = (String)it2;
        boolean $i$a$-unknown-RunIdeBase$configureClasspath$buildNumber$22 = false;
        Version buildNumber = bl4.parse(p1);
        Version build203 = Version.Companion.parse("203.0");
        Version build221 = Version.Companion.parse("221.0");
        RunIdeBase runIdeBase = this;
        Object $i$a$-unknown-RunIdeBase$configureClasspath$buildNumber$22 = object3 = buildNumber.compareTo(build221) > 0 ? CollectionsKt.listOf((Object[])new String[]{ideDirFile + "/lib/3rd-party-rt.jar", ideDirFile + "/lib/util.jar", ideDirFile + "/lib/util_rt.jar", ideDirFile + "/lib/jna.jar"}) : (buildNumber.compareTo(build203) > 0 ? CollectionsKt.listOf((Object[])new String[]{ideDirFile + "/lib/bootstrap.jar", ideDirFile + "/lib/util.jar", ideDirFile + "/lib/jdom.jar", ideDirFile + "/lib/log4j.jar", ideDirFile + "/lib/jna.jar"}) : CollectionsKt.listOf((Object[])new String[]{ideDirFile + "/lib/bootstrap.jar", ideDirFile + "/lib/extensions.jar", ideDirFile + "/lib/util.jar", ideDirFile + "/lib/jdom.jar", ideDirFile + "/lib/log4j.jar", ideDirFile + "/lib/jna.jar", ideDirFile + "/lib/trove4j.jar"}));
        FileCollection fileCollection = runIdeBase.getClasspath();
        RunIdeBase runIdeBase2 = runIdeBase;
        boolean bl5 = false;
        ConfigurableFileCollection configurableFileCollection = this.getObjectFactory().fileCollection().from(new Object[]{it});
        runIdeBase2.setClasspath(fileCollection.plus((FileCollection)configurableFileCollection));
    }

    private final void configureSystemProperties() {
        this.systemProperties(this.getSystemProperties());
        Object object = this.configDir.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"configDir.get()");
        File file = (File)object;
        Object object2 = this.systemDir.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"systemDir.get()");
        File file2 = (File)object2;
        Object object3 = this.pluginsDir.get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"pluginsDir.get()");
        File file3 = ((Directory)object3).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"pluginsDir.get().asFile");
        Object object4 = this.requiredPluginIds.get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"requiredPluginIds.get()");
        this.systemProperties(Utils.getIdeaSystemProperties(file, file2, file3, (List)object4));
        OperatingSystem operatingSystem = OperatingSystem.current();
        Map map2 = this.getSystemProperties();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"systemProperties");
        Map userDefinedSystemProperties = map2;
        OperatingSystem operatingSystem2 = operatingSystem;
        Intrinsics.checkNotNullExpressionValue((Object)operatingSystem2, (String)"operatingSystem");
        if (operatingSystem2.isMacOsX()) {
            this.systemPropertyIfNotDefined("idea.smooth.progress", false, userDefinedSystemProperties);
            this.systemPropertyIfNotDefined("apple.laf.useScreenMenuBar", true, userDefinedSystemProperties);
            this.systemPropertyIfNotDefined("apple.awt.fileDialogForDirectories", true, userDefinedSystemProperties);
        } else if (operatingSystem.isUnix()) {
            this.systemPropertyIfNotDefined("sun.awt.disablegrab", true, userDefinedSystemProperties);
        }
        this.systemPropertyIfNotDefined("idea.classpath.index.enabled", false, userDefinedSystemProperties);
        this.systemPropertyIfNotDefined("idea.is.internal", true, userDefinedSystemProperties);
        if (!userDefinedSystemProperties.containsKey("idea.auto.reload.plugins")) {
            Object object5 = this.autoReloadPlugins.get();
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"autoReloadPlugins.get()");
            if (((Boolean)object5).booleanValue()) {
                this.systemProperty("idea.auto.reload.plugins", "true");
            }
        }
        if (!this.getSystemProperties().containsKey("idea.platform.prefix")) {
            String prefix2 = this.findIdePrefix();
            if (prefix2 == null) {
                Object object6 = this.ideDir.get();
                Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"ideDir.get()");
                if (!StringsKt.startsWith$default((String)Utils.ideBuildNumber((File)object6), (String)"IU-", (boolean)false, (int)2, null)) {
                    throw (Throwable)new TaskExecutionException((Task)this, (Throwable)new GradleException("Cannot find IDE platform prefix. Please create a bug report at https://github.com/jetbrains/gradle-intellij-plugin. " + "As a workaround specify `idea.platform.prefix` system property for task `" + this.getName() + "` manually."));
                }
            }
            if (prefix2 != null) {
                this.systemProperty("idea.platform.prefix", prefix2);
            }
            Utils.info$default(this.context, "Using idea.platform.prefix=" + prefix2, null, 4, null);
        }
        Object object7 = this.ideDir.get();
        Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"ideDir.get()");
        String buildNumber = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)Utils.ideBuildNumber((File)object7), (char[])new char[]{'-'}, (boolean)false, (int)0, (int)6, null));
        if (Version.Companion.parse(buildNumber).compareTo(Version.Companion.parse("221.0")) > 0) {
            this.systemProperty("java.system.class.loader", "com.intellij.util.lang.PathClassLoader");
        }
    }

    private final String findIdePrefix() {
        String string;
        Utils.info$default(this.context, "Looking for platform prefix", null, 4, null);
        Stream<Path> stream = Files.list(((File)this.ideDir.get()).toPath().resolve("bin"));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"Files.list(ideDir.get().toPath().resolve(\"bin\"))");
        String prefix2 = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)StreamsKt.asSequence(stream), (Function1)findIdePrefix.prefix.1.INSTANCE), (Function1)findIdePrefix.prefix.2.INSTANCE), (Function1)findIdePrefix.prefix.3.INSTANCE));
        if (prefix2 != null) {
            string = prefix2;
        } else {
            OperatingSystem operatingSystem = OperatingSystem.current();
            Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"OperatingSystem.current()");
            if (operatingSystem.isMacOsX()) {
                String string2;
                Path infoPlist = ((File)this.ideDir.get()).toPath().resolve("Info.plist");
                try {
                    Stream<String> stream2 = Files.lines(infoPlist);
                    Intrinsics.checkNotNullExpressionValue(stream2, (String)"Files.lines(infoPlist)");
                    string2 = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.windowed$default((Sequence)StreamsKt.asSequence(stream2), (int)2, (int)0, (boolean)false, (int)6, null), (Function1)findIdePrefix.1.INSTANCE), (Function1)findIdePrefix.2.INSTANCE));
                }
                catch (FileNotFoundException e) {
                    string2 = null;
                }
                catch (Throwable t) {
                    Utils.error(this.context, "Cannot find prefix in " + infoPlist, t);
                    string2 = null;
                }
                string = string2;
            } else {
                string = null;
            }
        }
        return string;
    }

    private final void systemPropertyIfNotDefined(String name, Object value, Map<String, ? extends Object> userDefinedSystemProperties) {
        if (!userDefinedSystemProperties.containsKey(name)) {
            this.systemProperty(name, value);
        }
    }

    protected void configureJvmArgs() {
        JavaForkOptions javaForkOptions = (JavaForkOptions)this;
        List list2 = this.getJvmArgs();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"jvmArgs");
        this.setJvmArgs(Utils.getIdeJvmArgs(javaForkOptions, list2, (File)this.ideDir.get()));
    }

    private final File resolveToolsJar(String javaExec) {
        String binDir = new File(javaExec).getParent();
        OperatingSystem operatingSystem = OperatingSystem.current();
        Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"OperatingSystem.current()");
        String path = operatingSystem.isMacOsX() ? "../../lib/tools.jar" : "../lib/tools.jar";
        return new File(binDir, path);
    }

    public RunIdeBase(boolean runAlways) {
        ObjectFactory objectFactory = this.getObjectFactory();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"objectFactory");
        ObjectFactory $this$property$iv = objectFactory;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(File.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        this.ideDir = property;
        ObjectFactory objectFactory2 = this.getObjectFactory();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory2, (String)"objectFactory");
        $this$property$iv = objectFactory2;
        $i$f$property = false;
        Property property2 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java)");
        this.jbrVersion = property2;
        ObjectFactory objectFactory3 = this.getObjectFactory();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory3, (String)"objectFactory");
        $this$property$iv = objectFactory3;
        $i$f$property = false;
        Property property3 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"property(T::class.java)");
        this.jbrVariant = property3;
        DirectoryProperty directoryProperty = this.getObjectFactory().directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objectFactory.directoryProperty()");
        this.pluginsDir = directoryProperty;
        ObjectFactory objectFactory4 = this.getObjectFactory();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory4, (String)"objectFactory");
        $this$property$iv = objectFactory4;
        $i$f$property = false;
        Property property4 = $this$property$iv.property(Boolean.class);
        Intrinsics.checkNotNullExpressionValue((Object)property4, (String)"property(T::class.java)");
        this.autoReloadPlugins = property4;
        ObjectFactory objectFactory5 = this.getObjectFactory();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory5, (String)"objectFactory");
        ObjectFactory $this$listProperty$iv = objectFactory5;
        boolean $i$f$listProperty = false;
        ListProperty listProperty = $this$listProperty$iv.listProperty(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"listProperty(T::class.java)");
        this.requiredPluginIds = listProperty;
        ObjectFactory objectFactory6 = this.getObjectFactory();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory6, (String)"objectFactory");
        $this$property$iv = objectFactory6;
        $i$f$property = false;
        Property property5 = $this$property$iv.property(File.class);
        Intrinsics.checkNotNullExpressionValue((Object)property5, (String)"property(T::class.java)");
        this.configDir = property5;
        ObjectFactory objectFactory7 = this.getObjectFactory();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory7, (String)"objectFactory");
        $this$property$iv = objectFactory7;
        $i$f$property = false;
        Property property6 = $this$property$iv.property(File.class);
        Intrinsics.checkNotNullExpressionValue((Object)property6, (String)"property(T::class.java)");
        this.systemDir = property6;
        ObjectFactory objectFactory8 = this.getObjectFactory();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory8, (String)"objectFactory");
        $this$property$iv = objectFactory8;
        $i$f$property = false;
        Property property7 = $this$property$iv.property(File.class);
        Intrinsics.checkNotNullExpressionValue((Object)property7, (String)"property(T::class.java)");
        this.projectWorkingDir = property7;
        ObjectFactory objectFactory9 = this.getObjectFactory();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory9, (String)"objectFactory");
        $this$property$iv = objectFactory9;
        $i$f$property = false;
        Property property8 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property8, (String)"property(T::class.java)");
        this.projectExecutable = property8;
        this.getMainClass().set((Object)"com.intellij.idea.Main");
        this.setEnableAssertions(true);
        if (runAlways) {
            this.getOutputs().upToDateWhen((Spec)1.INSTANCE);
        }
    }

    static {
        Companion = new Companion(null);
        platformPrefixSystemPropertyRegex = new Regex("-Didea.platform.prefix=([A-z]+)");
    }

    public static final /* synthetic */ Regex access$getPlatformPrefixSystemPropertyRegex$cp() {
        return platformPrefixSystemPropertyRegex;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/intellij/tasks/RunIdeBase$Companion;", "", "()V", "platformPrefixSystemPropertyRegex", "Lkotlin/text/Regex;", "gradle-intellij-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

