/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.jetbrains.plugin.structure.intellij.utils.JDOMUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007H\u0002J\b\u0010%\u001a\u00020\u001fH\u0007J \u0010&\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0007H\u0002R\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\tR\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\tR\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\t\u00a8\u0006)"}, d2={"Lorg/jetbrains/intellij/tasks/PatchPluginXmlTask;", "Lorg/gradle/api/internal/ConventionTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "changeNotes", "Lorg/gradle/api/provider/Property;", "", "getChangeNotes", "()Lorg/gradle/api/provider/Property;", "context", "destinationDir", "Lorg/gradle/api/file/DirectoryProperty;", "getDestinationDir", "()Lorg/gradle/api/file/DirectoryProperty;", "pluginDescription", "getPluginDescription", "pluginId", "getPluginId", "pluginXmlFiles", "Lorg/gradle/api/provider/ListProperty;", "Ljava/io/File;", "getPluginXmlFiles", "()Lorg/gradle/api/provider/ListProperty;", "sinceBuild", "getSinceBuild", "untilBuild", "getUntilBuild", "version", "getVersion", "patchAttribute", "", "document", "Lorg/jdom2/Document;", "tagName", "attributeName", "attributeValue", "patchPluginXmlFiles", "patchTag", "name", "content", "gradle-intellij-plugin"})
public class PatchPluginXmlTask
extends ConventionTask {
    @OutputDirectory
    @NotNull
    private final DirectoryProperty destinationDir;
    @SkipWhenEmpty
    @InputFiles
    @NotNull
    private final ListProperty<File> pluginXmlFiles;
    @Input
    @Optional
    @NotNull
    private final Property<String> pluginDescription;
    @Input
    @Optional
    @NotNull
    private final Property<String> sinceBuild;
    @Input
    @Optional
    @NotNull
    private final Property<String> untilBuild;
    @Input
    @Optional
    @NotNull
    private final Property<String> version;
    @Input
    @Optional
    @NotNull
    private final Property<String> changeNotes;
    @Input
    @Optional
    @NotNull
    private final Property<String> pluginId;
    private final String context;

    @NotNull
    public final DirectoryProperty getDestinationDir() {
        return this.destinationDir;
    }

    @NotNull
    public final ListProperty<File> getPluginXmlFiles() {
        return this.pluginXmlFiles;
    }

    @NotNull
    public final Property<String> getPluginDescription() {
        return this.pluginDescription;
    }

    @NotNull
    public final Property<String> getSinceBuild() {
        return this.sinceBuild;
    }

    @NotNull
    public final Property<String> getUntilBuild() {
        return this.untilBuild;
    }

    @NotNull
    public final Property<String> getVersion() {
        return this.version;
    }

    @NotNull
    public final Property<String> getChangeNotes() {
        return this.changeNotes;
    }

    @NotNull
    public final Property<String> getPluginId() {
        return this.pluginId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void patchPluginXmlFiles() {
        Object object = this.pluginXmlFiles.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pluginXmlFiles.get()");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            File file2 = file;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
            Object object2 = file2;
            object2 = new FileInputStream((File)object2);
            Throwable throwable = null;
            try {
                Document document;
                Object it;
                Object object3;
                FileInputStream inputStream = (FileInputStream)object2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)JDOMUtil.loadDocument((InputStream)inputStream), (String)"JDOMUtil.loadDocument(inputStream)");
                String string = (String)this.sinceBuild.getOrNull();
                if (string != null) {
                    it = object3 = string;
                    boolean bl3 = false;
                    String string2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it");
                    this.patchAttribute(document, "idea-version", "since-build", string2);
                }
                String string3 = (String)this.untilBuild.getOrNull();
                if (string3 != null) {
                    it = object3 = string3;
                    boolean bl4 = false;
                    String string4 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it");
                    this.patchAttribute(document, "idea-version", "until-build", string4);
                }
                String string5 = (String)this.pluginDescription.getOrNull();
                if (string5 != null) {
                    it = object3 = string5;
                    boolean bl5 = false;
                    String string6 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"it");
                    this.patchTag(document, "description", string6);
                }
                String string7 = (String)this.changeNotes.getOrNull();
                if (string7 != null) {
                    it = object3 = string7;
                    boolean bl6 = false;
                    String string8 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"it");
                    this.patchTag(document, "change-notes", string8);
                }
                object3 = this.version.getOrNull();
                it = (String)object3;
                boolean bl7 = false;
                String string9 = (String)(Intrinsics.areEqual((Object)it, (Object)"unspecified") ^ true ? object3 : null);
                if (string9 != null) {
                    it = object3 = string9;
                    boolean bl8 = false;
                    Object object4 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"it");
                    this.patchTag(document, "version", (String)object4);
                }
                String string10 = (String)this.pluginId.getOrNull();
                if (string10 != null) {
                    it = object3 = string10;
                    boolean bl9 = false;
                    Object object5 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"it");
                    this.patchTag(document, "id", (String)object5);
                }
                Object object6 = this.destinationDir.get();
                Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"destinationDir.get()");
                File destination = new File(((Directory)object6).getAsFile(), file.getName());
                Utils.transformXml(document, destination);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void patchTag(Document document, String name, String content) {
        Element element;
        CharSequence charSequence = content;
        if (charSequence.length() == 0) {
            return;
        }
        Element it = element = document.getRootElement();
        boolean bl2 = false;
        Element element2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"it");
        Object object = Intrinsics.areEqual((Object)element2.getName(), (Object)"idea-plugin") ? element : null;
        if (object == null) {
            return;
        }
        Element pluginXml = object;
        Element tag = pluginXml.getChild(name);
        if (tag != null) {
            String existingValue;
            String string = existingValue = tag.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"existingValue");
            CharSequence bl2 = string;
            if (bl2.length() > 0) {
                Utils.warn$default(this.context, "Patching plugin.xml: value of '" + name + '[' + existingValue + "]' tag will be set to '" + content + '\'', null, 4, null);
            }
            tag.setText(content);
        } else {
            void $this$apply;
            Element element3;
            Element bl2 = element3 = new Element(name);
            int n = 0;
            Element element4 = pluginXml;
            boolean bl3 = false;
            $this$apply.setText(content);
            Unit unit = Unit.INSTANCE;
            element4.addContent(n, (Content)element3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void patchAttribute(Document document, String tagName, String attributeName, String attributeValue) {
        Element element;
        CharSequence charSequence = attributeValue;
        if (charSequence.length() == 0) {
            return;
        }
        Element it = element = document.getRootElement();
        boolean bl2 = false;
        Element element2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"it");
        Object object = Intrinsics.areEqual((Object)element2.getName(), (Object)"idea-plugin") ? element : null;
        if (object == null) {
            return;
        }
        Element pluginXml = object;
        Element tag = pluginXml.getChild(tagName);
        if (tag != null) {
            Attribute attribute = tag.getAttribute(attributeName);
            String existingValue = attribute != null ? attribute.getValue() : null;
            CharSequence bl2 = existingValue;
            if (!(bl2 == null || bl2.length() == 0)) {
                Utils.warn$default(this.context, "Patching plugin.xml: attribute '" + attributeName + "=[" + existingValue + "]' of '" + tagName + "' tag will be set to '" + attributeValue + '\'', null, 4, null);
            }
            tag.setAttribute(attributeName, attributeValue);
        } else {
            void $this$apply;
            Element element3;
            Element bl2 = element3 = new Element(tagName);
            int n = 0;
            Element element4 = pluginXml;
            boolean bl3 = false;
            $this$apply.setAttribute(attributeName, attributeValue);
            Unit unit = Unit.INSTANCE;
            element4.addContent(n, (Content)element3);
        }
    }

    @Inject
    public PatchPluginXmlTask(@NotNull ObjectFactory objectFactory) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        DirectoryProperty directoryProperty = objectFactory.directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objectFactory.directoryProperty()");
        this.destinationDir = directoryProperty;
        ObjectFactory $this$listProperty$iv = objectFactory;
        boolean $i$f$listProperty = false;
        ListProperty listProperty = $this$listProperty$iv.listProperty(File.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"listProperty(T::class.java)");
        this.pluginXmlFiles = listProperty;
        ObjectFactory $this$property$iv = objectFactory;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        this.pluginDescription = property;
        $this$property$iv = objectFactory;
        $i$f$property = false;
        Property property2 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java)");
        this.sinceBuild = property2;
        $this$property$iv = objectFactory;
        $i$f$property = false;
        Property property3 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"property(T::class.java)");
        this.untilBuild = property3;
        $this$property$iv = objectFactory;
        $i$f$property = false;
        Property property4 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property4, (String)"property(T::class.java)");
        this.version = property4;
        $this$property$iv = objectFactory;
        $i$f$property = false;
        Property property5 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property5, (String)"property(T::class.java)");
        this.changeNotes = property5;
        $this$property$iv = objectFactory;
        $i$f$property = false;
        Property property6 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property6, (String)"property(T::class.java)");
        this.pluginId = property6;
        this.context = Utils.logCategory((Task)this);
    }
}

