/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.Task;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.IdeaDependency;
import org.jetbrains.intellij.tasks.IntelliJInstrumentCodeTask;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u0000 02\u00020\u0001:\u00010B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010#\u001a\u0010\u0012\f\u0012\n %*\u0004\u0018\u00010\t0\t0$H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0017\u001a\u00020\tH\u0002J\u0016\u0010(\u001a\u0010\u0012\f\u0012\n %*\u0004\u0018\u00010\t0\t0$H\u0007J\b\u0010)\u001a\u00020'H\u0007J&\u0010*\u001a\u00020'2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\t0$2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010,\u001a\u00020-H\u0002J\u0016\u0010.\u001a\u00020-2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\t0$H\u0002R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\r8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\r8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0016\u0010\u0017\u001a\u00020\u00188\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000bR\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u000bR\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000bR\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u000b\u00a8\u00061"}, d2={"Lorg/jetbrains/intellij/tasks/IntelliJInstrumentCodeTask;", "Lorg/gradle/api/internal/ConventionTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "fileSystemOperations", "Lorg/gradle/api/file/FileSystemOperations;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/api/file/FileSystemOperations;)V", "compilerClassPathFromMaven", "Lorg/gradle/api/provider/ListProperty;", "Ljava/io/File;", "getCompilerClassPathFromMaven", "()Lorg/gradle/api/provider/ListProperty;", "compilerVersion", "Lorg/gradle/api/provider/Property;", "", "getCompilerVersion", "()Lorg/gradle/api/provider/Property;", "context", "ideaDependency", "Lorg/jetbrains/intellij/dependency/IdeaDependency;", "getIdeaDependency", "javac2", "getJavac2", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "sourceSetAllDirs", "getSourceSetAllDirs", "sourceSetCompileClasspath", "getSourceSetCompileClasspath", "sourceSetOutputClassesDirs", "getSourceSetOutputClassesDirs", "sourceSetResources", "getSourceSetResources", "compilerClassPath", "", "kotlin.jvm.PlatformType", "copyOriginalClasses", "", "getSourceDirs", "instrumentClasses", "instrumentCode", "srcDirs", "instrumentNotNull", "", "prepareNotNullInstrumenting", "classpath", "Companion", "gradle-intellij-plugin"})
public class IntelliJInstrumentCodeTask
extends ConventionTask {
    @Internal
    @NotNull
    private final ListProperty<File> sourceSetOutputClassesDirs;
    @Internal
    @NotNull
    private final ListProperty<File> sourceSetAllDirs;
    @Internal
    @NotNull
    private final ListProperty<File> sourceSetResources;
    @Internal
    @NotNull
    private final ListProperty<File> sourceSetCompileClasspath;
    @Input
    @Optional
    @NotNull
    private final Property<IdeaDependency> ideaDependency;
    @Input
    @Optional
    @NotNull
    private final Property<File> javac2;
    @Input
    @NotNull
    private final Property<String> compilerVersion;
    @OutputDirectory
    @NotNull
    private final DirectoryProperty outputDir;
    private final String context;
    @Input
    @NotNull
    private final ListProperty<File> compilerClassPathFromMaven;
    private final FileSystemOperations fileSystemOperations;
    @NotNull
    public static final String FILTER_ANNOTATION_REGEXP_CLASS = "com.intellij.ant.ClassFilterAnnotationRegexp";
    @NotNull
    public static final String LOADER_REF = "java2.loader";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ListProperty<File> getSourceSetOutputClassesDirs() {
        return this.sourceSetOutputClassesDirs;
    }

    @NotNull
    public final ListProperty<File> getSourceSetAllDirs() {
        return this.sourceSetAllDirs;
    }

    @NotNull
    public final ListProperty<File> getSourceSetResources() {
        return this.sourceSetResources;
    }

    @NotNull
    public final ListProperty<File> getSourceSetCompileClasspath() {
        return this.sourceSetCompileClasspath;
    }

    @NotNull
    public final Property<IdeaDependency> getIdeaDependency() {
        return this.ideaDependency;
    }

    @NotNull
    public final Property<File> getJavac2() {
        return this.javac2;
    }

    @NotNull
    public final Property<String> getCompilerVersion() {
        return this.compilerVersion;
    }

    @NotNull
    public final DirectoryProperty getOutputDir() {
        return this.outputDir;
    }

    /*
     * WARNING - void declaration
     */
    @InputFiles
    @NotNull
    public final List<File> getSourceDirs() {
        void $this$filterTo$iv$iv;
        Object object = this.sourceSetAllDirs.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sourceSetAllDirs.get()");
        Iterable $this$filter$iv = (Iterable)object;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!(it.exists() && !((List)this.sourceSetResources.get()).contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final ListProperty<File> getCompilerClassPathFromMaven() {
        return this.compilerClassPathFromMaven;
    }

    @TaskAction
    public final void instrumentClasses() {
        Object object = this.outputDir.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"outputDir.get()");
        File file = ((Directory)object).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputDir.get().asFile");
        this.copyOriginalClasses(file);
        List<File> classpath = this.compilerClassPath();
        this.getAnt().invokeMethod("taskdef", (Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"name", (Object)"instrumentIdeaExtensions"), TuplesKt.to((Object)"classpath", (Object)CollectionsKt.joinToString$default((Iterable)classpath, (CharSequence)":", null, null, (int)0, null, null, (int)62, null)), TuplesKt.to((Object)"loaderref", (Object)LOADER_REF), TuplesKt.to((Object)"classname", (Object)"com.intellij.ant.InstrumentIdeaExtensions")}));
        Utils.info$default(this.context, "Compiling forms and instrumenting code with nullability preconditions", null, 4, null);
        boolean instrumentNotNull = this.prepareNotNullInstrumenting(classpath);
        List<File> list2 = this.getSourceDirs();
        Object object2 = this.outputDir.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"outputDir.get()");
        File file2 = ((Directory)object2).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"outputDir.get().asFile");
        this.instrumentCode(list2, file2, instrumentNotNull);
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> compilerClassPath() {
        Object object;
        block7: {
            block6: {
                Object object2;
                File file;
                File file2;
                object = (File)this.javac2.getOrNull();
                if (object == null) break block6;
                File it = file2 = object;
                boolean bl = false;
                File file3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"it");
                File p1 = file = file3;
                boolean bl2 = false;
                File file4 = p1.exists() ? file : null;
                if (file4 != null) {
                    void $this$orEmpty$iv;
                    File file5 = file = file4;
                    boolean bl3 = false;
                    File[] fileArray = new File(((IdeaDependency)this.ideaDependency.get()).getClasses() + "/lib").listFiles(compilerClassPath.1.2.1.INSTANCE);
                    boolean $i$f$orEmpty = false;
                    File[] fileArray2 = $this$orEmpty$iv;
                    if (fileArray2 == null) {
                        fileArray2 = new File[]{};
                    }
                    object2 = CollectionsKt.plus((Collection)ArraysKt.filterNotNull((Object[])fileArray2), (Object)file5);
                } else {
                    object2 = object = null;
                }
                if (object2 != null) break block7;
            }
            Object object3 = this.compilerClassPathFromMaven.get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"compilerClassPathFromMaven.get()");
            object = (List)object3;
        }
        return object;
    }

    private final void copyOriginalClasses(File outputDir) {
        FilesKt.deleteRecursively((File)outputDir);
        outputDir.mkdir();
        this.fileSystemOperations.copy(new Action(this, outputDir){
            final /* synthetic */ IntelliJInstrumentCodeTask this$0;
            final /* synthetic */ File $outputDir;

            public final void execute(@NotNull CopySpec $this$copy) {
                Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"$receiver");
                $this$copy.from(new Object[]{this.this$0.getSourceSetOutputClassesDirs().get()});
                $this$copy.into((Object)this.$outputDir);
            }
            {
                this.this$0 = intelliJInstrumentCodeTask;
                this.$outputDir = file;
            }
        });
    }

    private final boolean prepareNotNullInstrumenting(List<? extends File> classpath) {
        try {
            this.getAnt().invokeMethod("typedef", (Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"name", (Object)"skip"), TuplesKt.to((Object)"classpath", (Object)CollectionsKt.joinToString$default((Iterable)classpath, (CharSequence)":", null, null, (int)0, null, null, (int)62, null)), TuplesKt.to((Object)"loaderref", (Object)LOADER_REF), TuplesKt.to((Object)"classname", (Object)FILTER_ANNOTATION_REGEXP_CLASS)}));
        }
        catch (BuildException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ClassNotFoundException && Intrinsics.areEqual((Object)FILTER_ANNOTATION_REGEXP_CLASS, (Object)cause.getMessage())) {
                Utils.info$default(this.context, "Old version of Javac2 is used, instrumenting code with nullability will be skipped. Use IDEA >14 SDK (139.*) to fix this", null, 4, null);
                return false;
            }
            throw (Throwable)e;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void instrumentCode(List<? extends File> srcDirs, File outputDir, boolean instrumentNotNull) {
        if (srcDirs.isEmpty()) {
            return;
        }
        String headlessOldValue = System.setProperty("java.awt.headless", "true");
        try {
            AntBuilder antBuilder = this.getAnt();
            Object[] objectArray = new Object[2];
            Pair[] pairArray = new Pair[5];
            pairArray[0] = TuplesKt.to((Object)"srcdir", (Object)CollectionsKt.joinToString$default((Iterable)srcDirs, (CharSequence)":", null, null, (int)0, null, null, (int)62, null));
            pairArray[1] = TuplesKt.to((Object)"destdir", (Object)outputDir);
            Object object = this.sourceSetCompileClasspath.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sourceSetCompileClasspath.get()");
            pairArray[2] = TuplesKt.to((Object)"classpath", (Object)CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)":", null, null, (int)0, null, null, (int)62, null));
            pairArray[3] = TuplesKt.to((Object)"includeantruntime", (Object)false);
            pairArray[4] = TuplesKt.to((Object)"instrumentNotNull", (Object)instrumentNotNull);
            objectArray[0] = MapsKt.mapOf((Pair[])pairArray);
            objectArray[1] = new Closure<Object>(this, instrumentNotNull, (Object)this, (Object)this){
                final /* synthetic */ IntelliJInstrumentCodeTask this$0;
                final /* synthetic */ boolean $instrumentNotNull;

                @Nullable
                public final Object doCall() {
                    if (this.$instrumentNotNull) {
                        return this.this$0.getAnt().invokeMethod("skip", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"pattern", (Object)"kotlin/Metadata")));
                    }
                    return null;
                }
                {
                    this.this$0 = this$0;
                    this.$instrumentNotNull = $captured_local_variable$1;
                    super($super_call_param$2, $super_call_param$3);
                }
            };
            antBuilder.invokeMethod("instrumentIdeaExtensions", (Object)objectArray);
        }
        finally {
            if (headlessOldValue != null) {
                System.setProperty("java.awt.headless", headlessOldValue);
            } else {
                System.clearProperty("java.awt.headless");
            }
        }
    }

    @Inject
    public IntelliJInstrumentCodeTask(@NotNull ObjectFactory objectFactory, @NotNull FileSystemOperations fileSystemOperations) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)fileSystemOperations, (String)"fileSystemOperations");
        this.fileSystemOperations = fileSystemOperations;
        ObjectFactory $this$listProperty$iv = objectFactory;
        boolean $i$f$listProperty = false;
        ListProperty listProperty = $this$listProperty$iv.listProperty(File.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"listProperty(T::class.java)");
        this.sourceSetOutputClassesDirs = listProperty;
        $this$listProperty$iv = objectFactory;
        $i$f$listProperty = false;
        ListProperty listProperty2 = $this$listProperty$iv.listProperty(File.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty2, (String)"listProperty(T::class.java)");
        this.sourceSetAllDirs = listProperty2;
        $this$listProperty$iv = objectFactory;
        $i$f$listProperty = false;
        ListProperty listProperty3 = $this$listProperty$iv.listProperty(File.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty3, (String)"listProperty(T::class.java)");
        this.sourceSetResources = listProperty3;
        $this$listProperty$iv = objectFactory;
        $i$f$listProperty = false;
        ListProperty listProperty4 = $this$listProperty$iv.listProperty(File.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty4, (String)"listProperty(T::class.java)");
        this.sourceSetCompileClasspath = listProperty4;
        ObjectFactory $this$property$iv = objectFactory;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(IdeaDependency.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        this.ideaDependency = property;
        $this$property$iv = objectFactory;
        $i$f$property = false;
        Property property2 = $this$property$iv.property(File.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java)");
        this.javac2 = property2;
        $this$property$iv = objectFactory;
        $i$f$property = false;
        Property property3 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"property(T::class.java)");
        this.compilerVersion = property3;
        DirectoryProperty directoryProperty = objectFactory.directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objectFactory.directoryProperty()");
        this.outputDir = directoryProperty;
        this.context = Utils.logCategory((Task)this);
        $this$listProperty$iv = objectFactory;
        $i$f$listProperty = false;
        ListProperty listProperty5 = $this$listProperty$iv.listProperty(File.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty5, (String)"listProperty(T::class.java)");
        this.compilerClassPathFromMaven = listProperty5;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/intellij/tasks/IntelliJInstrumentCodeTask$Companion;", "", "()V", "FILTER_ANNOTATION_REGEXP_CLASS", "", "LOADER_REF", "gradle-intellij-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

