/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.PluginDependency;
import org.jetbrains.intellij.dependency.PluginDependencyNotation;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0013\u00100\u001a\u00020\b2\b\u00101\u001a\u0004\u0018\u000102H\u0096\u0002J\b\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\b2\u0006\u00106\u001a\u000207H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\f\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001aX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0014\u0010\t\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000eR\u001c\u0010 \u001a\u0004\u0018\u00010\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\f\"\u0004\b\"\u0010\u0017R\u0014\u0010#\u001a\u00020$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001c\u0010'\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0011\"\u0004\b)\u0010\u0013R\u0016\u0010*\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\fR\u001c\u0010,\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0011\"\u0004\b.\u0010\u0013R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0011\u00a8\u00068"}, d2={"Lorg/jetbrains/intellij/dependency/PluginDependencyImpl;", "Lorg/jetbrains/intellij/dependency/PluginDependency;", "id", "", "version", "artifact", "Ljava/io/File;", "builtin", "", "maven", "(Ljava/lang/String;Ljava/lang/String;Ljava/io/File;ZZ)V", "getArtifact", "()Ljava/io/File;", "getBuiltin", "()Z", "channel", "getChannel", "()Ljava/lang/String;", "setChannel", "(Ljava/lang/String;)V", "classesDirectory", "getClassesDirectory", "setClassesDirectory", "(Ljava/io/File;)V", "getId", "jarFiles", "", "getJarFiles", "()Ljava/util/Collection;", "setJarFiles", "(Ljava/util/Collection;)V", "getMaven", "metaInfDirectory", "getMetaInfDirectory", "setMetaInfDirectory", "notation", "Lorg/jetbrains/intellij/dependency/PluginDependencyNotation;", "getNotation", "()Lorg/jetbrains/intellij/dependency/PluginDependencyNotation;", "sinceBuild", "getSinceBuild", "setSinceBuild", "sourcesDirectory", "getSourcesDirectory", "untilBuild", "getUntilBuild", "setUntilBuild", "getVersion", "equals", "other", "", "hashCode", "", "isCompatible", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "gradle-intellij-plugin"})
public final class PluginDependencyImpl
implements PluginDependency {
    @Nullable
    private String channel;
    @NotNull
    private Collection<? extends File> jarFiles;
    @Nullable
    private File classesDirectory;
    @Nullable
    private File metaInfDirectory;
    @Nullable
    private final File sourcesDirectory;
    @NotNull
    private final PluginDependencyNotation notation;
    @Nullable
    private String sinceBuild;
    @Nullable
    private String untilBuild;
    @NotNull
    private final String id;
    @NotNull
    private final String version;
    @NotNull
    private final File artifact;
    private final boolean builtin;
    private final boolean maven;

    @Override
    @Nullable
    public String getChannel() {
        return this.channel;
    }

    public void setChannel(@Nullable String string) {
        this.channel = string;
    }

    @Override
    @NotNull
    public Collection<File> getJarFiles() {
        return this.jarFiles;
    }

    public void setJarFiles(@NotNull Collection<? extends File> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
        this.jarFiles = collection;
    }

    @Override
    @Nullable
    public File getClassesDirectory() {
        return this.classesDirectory;
    }

    public void setClassesDirectory(@Nullable File file) {
        this.classesDirectory = file;
    }

    @Override
    @Nullable
    public File getMetaInfDirectory() {
        return this.metaInfDirectory;
    }

    public void setMetaInfDirectory(@Nullable File file) {
        this.metaInfDirectory = file;
    }

    @Override
    @Nullable
    public File getSourcesDirectory() {
        return this.sourcesDirectory;
    }

    @Override
    @NotNull
    public PluginDependencyNotation getNotation() {
        return this.notation;
    }

    @Nullable
    public final String getSinceBuild() {
        return this.sinceBuild;
    }

    public final void setSinceBuild(@Nullable String string) {
        this.sinceBuild = string;
    }

    @Nullable
    public final String getUntilBuild() {
        return this.untilBuild;
    }

    public final void setUntilBuild(@Nullable String string) {
        this.untilBuild = string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isCompatible(@NotNull IdeVersion ideVersion) {
        boolean bl;
        String it;
        String string;
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        String string2 = this.sinceBuild;
        if (string2 != null) {
            it = string = string2;
            boolean bl2 = false;
            if (IdeVersion.createIdeVersion((String)it).compareTo(ideVersion) > 0) return false;
            bl = true;
        } else {
            bl = true;
        }
        if (!bl) return false;
        String string3 = this.untilBuild;
        if (string3 == null) return true;
        it = string = string3;
        boolean bl3 = false;
        if (ideVersion.compareTo(IdeVersion.createIdeVersion((String)it)) > 0) return false;
        return true;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.intellij.dependency.PluginDependencyImpl");
        }
        PluginDependencyImpl cfr_ignored_0 = (PluginDependencyImpl)object2;
        if (Intrinsics.areEqual((Object)this.getId(), (Object)((PluginDependencyImpl)other).getId()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.getVersion(), (Object)((PluginDependencyImpl)other).getVersion()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.getArtifact(), (Object)((PluginDependencyImpl)other).getArtifact()) ^ true) {
            return false;
        }
        if (this.getBuiltin() != ((PluginDependencyImpl)other).getBuiltin()) {
            return false;
        }
        if (this.getMaven() != ((PluginDependencyImpl)other).getMaven()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.getChannel(), (Object)((PluginDependencyImpl)other).getChannel()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual(this.getJarFiles(), ((PluginDependencyImpl)other).getJarFiles()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.getClassesDirectory(), (Object)((PluginDependencyImpl)other).getClassesDirectory()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.getMetaInfDirectory(), (Object)((PluginDependencyImpl)other).getMetaInfDirectory()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.getSourcesDirectory(), (Object)((PluginDependencyImpl)other).getSourcesDirectory()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.getNotation(), (Object)((PluginDependencyImpl)other).getNotation()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.sinceBuild, (Object)((PluginDependencyImpl)other).sinceBuild) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.untilBuild, (Object)((PluginDependencyImpl)other).untilBuild) ^ true);
    }

    public int hashCode() {
        int result2 = this.getId().hashCode();
        result2 = 31 * result2 + this.getVersion().hashCode();
        result2 = 31 * result2 + this.getArtifact().hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.getBuiltin());
        result2 = 31 * result2 + Boolean.hashCode(this.getMaven());
        String string = this.getChannel();
        result2 = 31 * result2 + (string != null ? string.hashCode() : 0);
        result2 = 31 * result2 + ((Object)this.getJarFiles()).hashCode();
        File file = this.getClassesDirectory();
        result2 = 31 * result2 + (file != null ? file.hashCode() : 0);
        File file2 = this.getMetaInfDirectory();
        result2 = 31 * result2 + (file2 != null ? file2.hashCode() : 0);
        File file3 = this.getSourcesDirectory();
        result2 = 31 * result2 + (file3 != null ? file3.hashCode() : 0);
        result2 = 31 * result2 + this.getNotation().hashCode();
        String string2 = this.sinceBuild;
        result2 = 31 * result2 + (string2 != null ? string2.hashCode() : 0);
        String string3 = this.untilBuild;
        result2 = 31 * result2 + (string3 != null ? string3.hashCode() : 0);
        return result2;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getVersion() {
        return this.version;
    }

    @Override
    @NotNull
    public File getArtifact() {
        return this.artifact;
    }

    @Override
    public boolean getBuiltin() {
        return this.builtin;
    }

    @Override
    public boolean getMaven() {
        return this.maven;
    }

    public PluginDependencyImpl(@NotNull String id, @NotNull String version, @NotNull File artifact, boolean builtin, boolean maven) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        this.id = id;
        this.version = version;
        this.artifact = artifact;
        this.builtin = builtin;
        this.maven = maven;
        this.jarFiles = CollectionsKt.emptyList();
        this.notation = new PluginDependencyNotation(this.getId(), this.getVersion(), this.getChannel());
        if (Utils.isJar(this.getArtifact())) {
            this.setJarFiles(CollectionsKt.listOf((Object)this.getArtifact()));
        }
        if (this.getArtifact().isDirectory()) {
            File metaInf;
            File classes;
            File lib = new File(this.getArtifact(), "lib");
            if (lib.isDirectory()) {
                this.setJarFiles(Utils.collectJars(lib, 1.INSTANCE));
            }
            if ((classes = new File(this.getArtifact(), "classes")).isDirectory()) {
                this.setClassesDirectory(classes);
            }
            if ((metaInf = new File(this.getArtifact(), "META-INF")).isDirectory()) {
                this.setMetaInfDirectory(metaInf);
            }
        }
    }

    public /* synthetic */ PluginDependencyImpl(String string, String string2, File file, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        this(string, string2, file, bl, bl2);
    }
}

