/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.plugin.PluginProblem;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginManager;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.pluginRepository.PluginRepository;
import org.jetbrains.intellij.pluginRepository.PluginRepositoryFactory;
import org.jetbrains.intellij.pluginRepository.PluginUploader;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0007J\b\u0010\u0017\u001a\u00020\u0016H\u0002R\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00108\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00108\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/intellij/tasks/PublishPluginTask;", "Lorg/gradle/api/internal/ConventionTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "channels", "Lorg/gradle/api/provider/ListProperty;", "", "getChannels", "()Lorg/gradle/api/provider/ListProperty;", "context", "distributionFile", "Lorg/gradle/api/file/RegularFileProperty;", "getDistributionFile", "()Lorg/gradle/api/file/RegularFileProperty;", "host", "Lorg/gradle/api/provider/Property;", "getHost", "()Lorg/gradle/api/provider/Property;", "token", "getToken", "publishPlugin", "", "validateInput", "gradle-intellij-plugin"})
public class PublishPluginTask
extends ConventionTask {
    @InputFile
    @Optional
    @NotNull
    private final RegularFileProperty distributionFile;
    @Input
    @Optional
    @NotNull
    private final Property<String> host;
    @Input
    @Optional
    @NotNull
    private final Property<String> token;
    @Input
    @Optional
    @NotNull
    private final ListProperty<String> channels;
    private final String context;

    @NotNull
    public final RegularFileProperty getDistributionFile() {
        return this.distributionFile;
    }

    @NotNull
    public final Property<String> getHost() {
        return this.host;
    }

    @NotNull
    public final Property<String> getToken() {
        return this.token;
    }

    @NotNull
    public final ListProperty<String> getChannels() {
        return this.channels;
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void publishPlugin() {
        this.validateInput();
        Object object = this.distributionFile.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"distributionFile.get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"distributionFile.get().asFile");
        File file2 = file;
        IdePluginManager idePluginManager = IdePluginManager.Companion.createManager();
        Path path = file2.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file.toPath()");
        PluginCreationResult creationResult = idePluginManager.createPlugin(path);
        if (creationResult instanceof PluginCreationSuccess) {
            String pluginId = ((IdePlugin)((PluginCreationSuccess)creationResult).getPlugin()).getPluginId();
            Object object2 = this.channels.get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"channels.get()");
            Iterable $this$forEach$iv = (Iterable)object2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String channel = (String)element$iv;
                boolean bl = false;
                Utils.info$default(this.context, "Uploading plugin '" + pluginId + "' from '" + file2.getAbsolutePath() + "' to '" + (String)this.host.get() + "', channel: '" + channel + '\'', null, 4, null);
                try {
                    String string;
                    void it;
                    String string2;
                    Object object3 = this.host.get();
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"host.get()");
                    PluginRepository repositoryClient = PluginRepositoryFactory.create((String)((String)object3), (String)((String)this.token.get()));
                    if (pluginId == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.intellij.pluginRepository.model.PluginXmlId /* = kotlin.String */");
                    }
                    String string3 = string2 = channel;
                    File file3 = file2;
                    PluginUploader pluginUploader = repositoryClient.getUploader();
                    boolean bl2 = false;
                    boolean bl3 = Intrinsics.areEqual((Object)it, (Object)"default") ^ true;
                    pluginUploader.uploadPlugin(string, file3, bl3 ? string2 : null, null);
                    Utils.info$default(this.context, "Uploaded successfully", null, 4, null);
                }
                catch (Exception exception) {
                    throw (Throwable)new TaskExecutionException((Task)this, (Throwable)new GradleException("Failed to upload plugin: " + exception.getMessage(), (Throwable)exception));
                }
            }
        } else {
            if (creationResult instanceof PluginCreationFail) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = ((PluginCreationFail)creationResult).getErrorsAndWarnings();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PluginProblem it = (PluginProblem)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getLevel() == PluginProblem.Level.ERROR)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                String problems = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, null, (int)63, null);
                throw (Throwable)new TaskExecutionException((Task)this, (Throwable)new GradleException("Cannot upload plugin: " + problems));
            }
            throw (Throwable)new TaskExecutionException((Task)this, (Throwable)new GradleException("Cannot upload plugin: " + creationResult));
        }
    }

    private final void validateInput() {
        CharSequence charSequence = (CharSequence)this.token.getOrNull();
        if (charSequence == null || charSequence.length() == 0) {
            throw (Throwable)new TaskExecutionException((Task)this, (Throwable)new GradleException("token property must be specified for plugin publishing"));
        }
    }

    @Inject
    public PublishPluginTask(@NotNull ObjectFactory objectFactory) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        RegularFileProperty regularFileProperty = objectFactory.fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"objectFactory.fileProperty()");
        this.distributionFile = regularFileProperty;
        ObjectFactory $this$property$iv = objectFactory;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        this.host = property;
        $this$property$iv = objectFactory;
        $i$f$property = false;
        Property property2 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java)");
        this.token = property2;
        ObjectFactory $this$listProperty$iv = objectFactory;
        boolean $i$f$listProperty = false;
        ListProperty listProperty = $this$listProperty$iv.listProperty(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"listProperty(T::class.java)");
        this.channels = listProperty;
        this.context = Utils.logCategory((Task)this);
    }
}

