/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.jetbrains.plugin.structure.intellij.utils.JDOMUtil;
import groovy.lang.Closure;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.AbstractCopyTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.jvm.Jvm;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.PluginDependency;
import org.jetbrains.intellij.dependency.PluginProjectDependency;
import org.jetbrains.intellij.tasks.PrepareSandboxTask;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0016J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0013J\b\u0010$\u001a\u00020 H\u0002J\b\u0010%\u001a\u00020 H\u0015J\b\u0010&\u001a\u00020 H\u0002J\b\u0010'\u001a\u00020\fH\u0016R\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0016\u0010\u0015\u001a\u00020\u00168\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\t\u00a8\u0006("}, d2={"Lorg/jetbrains/intellij/tasks/PrepareSandboxTask;", "Lorg/gradle/api/tasks/Sync;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "configDir", "Lorg/gradle/api/provider/Property;", "", "getConfigDir", "()Lorg/gradle/api/provider/Property;", "context", "defaultDestinationDir", "Ljava/io/File;", "getDefaultDestinationDir", "librariesToIgnore", "Lorg/gradle/api/provider/ListProperty;", "getLibrariesToIgnore", "()Lorg/gradle/api/provider/ListProperty;", "pluginDependencies", "Lorg/jetbrains/intellij/dependency/PluginDependency;", "getPluginDependencies", "pluginJar", "Lorg/gradle/api/file/RegularFileProperty;", "getPluginJar", "()Lorg/gradle/api/file/RegularFileProperty;", "pluginName", "getPluginName", "configure", "Lorg/gradle/api/Task;", "closure", "Lgroovy/lang/Closure;", "configureCompositePlugin", "", "pluginDependency", "Lorg/jetbrains/intellij/dependency/PluginProjectDependency;", "configureExternalPlugin", "configurePlugin", "copy", "disableIdeUpdate", "getDestinationDir", "gradle-intellij-plugin"})
public class PrepareSandboxTask
extends Sync {
    @Input
    @NotNull
    private final Property<String> pluginName;
    @Input
    @NotNull
    private final Property<String> configDir;
    @InputFile
    @NotNull
    private final RegularFileProperty pluginJar;
    @Input
    @Optional
    @NotNull
    private final ListProperty<File> librariesToIgnore;
    @Input
    @Optional
    @NotNull
    private final ListProperty<PluginDependency> pluginDependencies;
    @Internal
    @NotNull
    private final Property<File> defaultDestinationDir;
    private final String context;

    @NotNull
    public final Property<String> getPluginName() {
        return this.pluginName;
    }

    @NotNull
    public final Property<String> getConfigDir() {
        return this.configDir;
    }

    @NotNull
    public final RegularFileProperty getPluginJar() {
        return this.pluginJar;
    }

    @NotNull
    public final ListProperty<File> getLibrariesToIgnore() {
        return this.librariesToIgnore;
    }

    @NotNull
    public final ListProperty<PluginDependency> getPluginDependencies() {
        return this.pluginDependencies;
    }

    @NotNull
    public final Property<File> getDefaultDestinationDir() {
        return this.defaultDestinationDir;
    }

    @TaskAction
    protected void copy() {
        this.disableIdeUpdate();
        super.copy();
    }

    @NotNull
    public File getDestinationDir() {
        File file = super.getDestinationDir();
        if (file == null) {
            Object object = this.defaultDestinationDir.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"defaultDestinationDir.get()");
            file = (File)object;
        }
        return file;
    }

    @NotNull
    public Task configure(@NotNull Closure<?> closure) {
        Intrinsics.checkNotNullParameter(closure, (String)"closure");
        Task task = super.configure(closure);
        Intrinsics.checkNotNullExpressionValue((Object)task, (String)"super.configure(closure)");
        return task;
    }

    /*
     * WARNING - void declaration
     */
    private final void configurePlugin() {
        void $this$mapTo$iv$iv;
        CopySpec copySpec = this.getMainSpec().addChild().into((Object)this.getProject().provider(new Callable(this){
            final /* synthetic */ PrepareSandboxTask this$0;

            public final String call() {
                return (String)this.this$0.getPluginName().get() + "/lib";
            }
            {
                this.this$0 = prepareSandboxTask;
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)copySpec, (String)"mainSpec.addChild().into\u2026pluginName.get()}/lib\" })");
        CopySpec plugin2 = copySpec;
        Map usedNames = new LinkedHashMap();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Configuration configuration = project.getConfigurations().getByName("runtimeClasspath");
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.configurations.g\u2026SPATH_CONFIGURATION_NAME)");
        Configuration runtimeConfiguration = configuration;
        Object object = this.librariesToIgnore.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"librariesToIgnore.get()");
        Set set = CollectionsKt.toSet((Iterable)((Iterable)object));
        Jvm jvm = Jvm.current();
        Intrinsics.checkNotNullExpressionValue((Object)jvm, (String)"Jvm.current()");
        Set librariesToIgnore = SetsKt.plus((Set)set, (Object)jvm.getToolsJar());
        Object object2 = this.pluginDependencies.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"pluginDependencies.get()");
        Iterable $this$map$iv = (Iterable)object2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PluginDependency pluginDependency2 = (PluginDependency)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getArtifact().getAbsolutePath();
            collection.add(string);
        }
        List pluginDirectories = (List)destination$iv$iv;
        plugin2.from(new Object[]{this.getProject().provider(new Callable(this, runtimeConfiguration, librariesToIgnore, pluginDirectories){
            final /* synthetic */ PrepareSandboxTask this$0;
            final /* synthetic */ Configuration $runtimeConfiguration;
            final /* synthetic */ Set $librariesToIgnore;
            final /* synthetic */ List $pluginDirectories;

            /*
             * WARNING - void declaration
             */
            public final List<File> call() {
                Collection<FileCollection> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object object = this.this$0.getPluginJar().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pluginJar.get()");
                Collection collection2 = CollectionsKt.listOf((Object)((RegularFile)object).getAsFile());
                DependencySet dependencySet = this.$runtimeConfiguration.getAllDependencies();
                Intrinsics.checkNotNullExpressionValue((Object)dependencySet, (String)"runtimeConfiguration.allDependencies");
                Iterable iterable = (Iterable)dependencySet;
                Collection collection3 = collection2;
                boolean $i$f$map = false;
                void var3_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Dependency dependency = (Dependency)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    FileCollection fileCollection = this.$runtimeConfiguration.fileCollection(new Dependency[]{it}).filter(new Spec(this){
                        final /* synthetic */ configurePlugin.1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean isSatisfiedBy(File file) {
                            boolean bl;
                            if (this.this$0.$librariesToIgnore.contains(file)) return false;
                            Iterable $this$any$iv = this.this$0.$pluginDirectories;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                return true;
                            }
                            Iterator<T> iterator = $this$any$iv.iterator();
                            do {
                                if (!iterator.hasNext()) return true;
                                T element$iv = iterator.next();
                                String p = (String)element$iv;
                                boolean bl2 = false;
                                File file2 = file;
                                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                                if (Intrinsics.areEqual((Object)file2.getAbsolutePath(), (Object)p)) return false;
                                String string = file.getAbsolutePath();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.absolutePath");
                                if (StringsKt.startsWith$default((String)string, (String)(p + File.separator), (boolean)false, (int)2, null)) {
                                    return false;
                                }
                                bl = false;
                            } while (!bl);
                            return false;
                        }
                    });
                    collection.add(fileCollection);
                }
                collection = (List)destination$iv$iv;
                return CollectionsKt.plus((Collection)collection3, (Iterable)CollectionsKt.flatten((Iterable)collection));
            }
            {
                this.this$0 = prepareSandboxTask;
                this.$runtimeConfiguration = configuration;
                this.$librariesToIgnore = set;
                this.$pluginDirectories = list2;
            }
        })}).eachFile(new Action(usedNames){
            final /* synthetic */ Map $usedNames;

            public final void execute(@NotNull FileCopyDetails $this$eachFile) {
                String string;
                String string2;
                Intrinsics.checkNotNullParameter((Object)$this$eachFile, (String)"$receiver");
                String string3 = $this$eachFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name");
                int dotIndex = StringsKt.lastIndexOf$default((CharSequence)string3, (char)'.', (int)0, (boolean)false, (int)6, null);
                if (dotIndex != -1) {
                    String string4 = $this$eachFile.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"name");
                    String string5 = string4;
                    int n = 0;
                    String string6 = string5;
                    if (string6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string7 = string6.substring(n, dotIndex);
                    string2 = string7;
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                } else {
                    String string8 = $this$eachFile.getName();
                    string2 = string8;
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"name");
                }
                String originalName = string2;
                if (dotIndex != -1) {
                    String string9;
                    String string10 = $this$eachFile.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"name");
                    String string11 = string9 = string10;
                    if (string11 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string12 = string11.substring(dotIndex);
                    string = string12;
                    Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"(this as java.lang.String).substring(startIndex)");
                } else {
                    string = "";
                }
                String originalExtension = string;
                int index = 1;
                String string13 = $this$eachFile.getName();
                File file = $this$eachFile.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                String previousPath = this.$usedNames.putIfAbsent(string13, file.getAbsolutePath());
                while (previousPath != null) {
                    File file2 = $this$eachFile.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                    if (!(Intrinsics.areEqual((Object)previousPath, (Object)file2.getAbsolutePath()) ^ true)) break;
                    $this$eachFile.setName(originalName + '_' + index++ + originalExtension);
                    String string14 = $this$eachFile.getName();
                    File file3 = $this$eachFile.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"file");
                    previousPath = this.$usedNames.putIfAbsent(string14, file3.getAbsolutePath());
                }
            }
            {
                this.$usedNames = map2;
            }
        });
    }

    public final void configureCompositePlugin(@NotNull PluginProjectDependency pluginDependency2) {
        Intrinsics.checkNotNullParameter((Object)pluginDependency2, (String)"pluginDependency");
        this.from(pluginDependency2.getArtifact(), new Action(pluginDependency2){
            final /* synthetic */ PluginProjectDependency $pluginDependency;

            public final void execute(@NotNull CopySpec $this$from) {
                Intrinsics.checkNotNullParameter((Object)$this$from, (String)"$receiver");
                $this$from.into((Object)this.$pluginDependency.getArtifact().getName());
            }
            {
                this.$pluginDependency = pluginProjectDependency;
            }
        });
    }

    public final void configureExternalPlugin(@NotNull PluginDependency pluginDependency2) {
        File file;
        Intrinsics.checkNotNullParameter((Object)pluginDependency2, (String)"pluginDependency");
        if (pluginDependency2.getBuiltin()) {
            return;
        }
        File $this$run = file = pluginDependency2.getArtifact();
        boolean bl = false;
        AbstractCopyTask abstractCopyTask = $this$run.isDirectory() ? this.from($this$run, new Action($this$run){
            final /* synthetic */ File $this_run;

            public final void execute(@NotNull CopySpec $this$from) {
                Intrinsics.checkNotNullParameter((Object)$this$from, (String)"$receiver");
                $this$from.into((Object)this.$this_run.getName());
            }
            {
                this.$this_run = file;
            }
        }) : this.from(new Object[]{$this$run});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void disableIdeUpdate() {
        File file;
        File $this$apply = file = new File((String)this.configDir.get(), "/options");
        boolean bl = false;
        if (!$this$apply.exists() && !$this$apply.mkdirs()) {
            Utils.error$default(this.context, "Cannot disable update checking in host IDE", null, 4, null);
            return;
        }
        File optionsDir = file;
        Object object = new File(optionsDir, "updates.xml");
        File $this$apply2 = object;
        boolean bl2 = false;
        if (!$this$apply2.exists() && !$this$apply2.createNewFile()) {
            Utils.error$default(this.context, "Cannot disable update checking in host IDE", null, 4, null);
            return;
        }
        File updatesConfig = object;
        Object object2 = object = FilesKt.readText$default((File)updatesConfig, null, (int)1, null);
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString();
        if (object.length() == 0) {
            FilesKt.writeText$default((File)updatesConfig, (String)"<application/>", null, (int)2, null);
        }
        object = updatesConfig;
        object = new FileInputStream((File)object);
        Throwable throwable = null;
        try {
            Object object3;
            Object v8;
            Iterable iterable;
            Element updatesConfigurable;
            Document document;
            block15: {
                Object object4;
                Object v5;
                Element application;
                Object it;
                block14: {
                    FileInputStream inputStream = (FileInputStream)object;
                    boolean bl3 = false;
                    Document document2 = JDOMUtil.loadDocument((InputStream)inputStream);
                    Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"JDOMUtil.loadDocument(inputStream)");
                    document = document2;
                    Element element = document.getRootElement();
                    it = element;
                    boolean $i$a$-takeIf-PrepareSandboxTask$disableIdeUpdate$1$application$22 = false;
                    Element element2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"it");
                    Object object5 = Intrinsics.areEqual((Object)element2.getName(), (Object)"application") ? element : null;
                    if (object5 == null) {
                        throw (Throwable)new GradleException("Invalid content of '" + updatesConfig + "' \u2013 '<application>' root element was expected.");
                    }
                    application = object5;
                    List list2 = application.getChildren("component");
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"application.getChildren(\"component\")");
                    Object $i$a$-takeIf-PrepareSandboxTask$disableIdeUpdate$1$application$22 = it = (Iterable)list2;
                    Iterator iterator = $i$a$-takeIf-PrepareSandboxTask$disableIdeUpdate$1$application$22.iterator();
                    while (iterator.hasNext()) {
                        Object t = iterator.next();
                        Element it2 = (Element)t;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it2.getAttributeValue("name"), (Object)"UpdatesConfigurable")) continue;
                        v5 = t;
                        break block14;
                    }
                    v5 = null;
                }
                if ((object4 = (Element)v5) == null) {
                    Object $this$apply3 = it = new Element("component");
                    boolean bl5 = false;
                    $this$apply3.setAttribute("name", "UpdatesConfigurable");
                    application.addContent((Content)$this$apply3);
                    object4 = it;
                }
                updatesConfigurable = object4;
                List list3 = updatesConfigurable.getChildren("option");
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"updatesConfigurable.getChildren(\"option\")");
                Iterable bl5 = iterable = (Iterable)list3;
                for (Object e : bl5) {
                    Element it3 = (Element)e;
                    boolean bl6 = false;
                    if (!Intrinsics.areEqual((Object)it3.getAttributeValue("name"), (Object)"CHECK_NEEDED")) continue;
                    v8 = e;
                    break block15;
                }
                v8 = null;
            }
            if ((object3 = (Element)v8) == null) {
                Iterable $this$apply4 = iterable = new Element("option");
                boolean bl7 = false;
                $this$apply4.setAttribute("name", "CHECK_NEEDED");
                updatesConfigurable.addContent((Content)$this$apply4);
                object3 = iterable;
            }
            Element option = object3;
            option.setAttribute("value", "false");
            Utils.transformXml(document, updatesConfig);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    @Inject
    public PrepareSandboxTask(@NotNull ObjectFactory objectFactory) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        ObjectFactory $this$property$iv = objectFactory;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        this.pluginName = property;
        $this$property$iv = objectFactory;
        $i$f$property = false;
        Property property2 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java)");
        this.configDir = property2;
        RegularFileProperty regularFileProperty = objectFactory.fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"objectFactory.fileProperty()");
        this.pluginJar = regularFileProperty;
        ObjectFactory $this$listProperty$iv = objectFactory;
        boolean $i$f$listProperty = false;
        ListProperty listProperty = $this$listProperty$iv.listProperty(File.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"listProperty(T::class.java)");
        this.librariesToIgnore = listProperty;
        $this$listProperty$iv = objectFactory;
        $i$f$listProperty = false;
        ListProperty listProperty2 = $this$listProperty$iv.listProperty(PluginDependency.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty2, (String)"listProperty(T::class.java)");
        this.pluginDependencies = listProperty2;
        $this$property$iv = objectFactory;
        $i$f$property = false;
        Property property3 = $this$property$iv.property(File.class);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"property(T::class.java)");
        this.defaultDestinationDir = property3;
        this.context = Utils.logCategory((Task)this);
        this.setDuplicatesStrategy(DuplicatesStrategy.FAIL);
        this.configurePlugin();
    }
}

