/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.jvm.tasks.Jar;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0016\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/intellij/tasks/JarSearchableOptionsTask;", "Lorg/gradle/jvm/tasks/Jar;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "pluginName", "Lorg/gradle/api/provider/Property;", "", "getPluginName", "()Lorg/gradle/api/provider/Property;", "sandboxDir", "getSandboxDir", "gradle-intellij-plugin"})
public class JarSearchableOptionsTask
extends Jar {
    @OutputDirectory
    @Optional
    @NotNull
    private final DirectoryProperty outputDir;
    @Input
    @Optional
    @NotNull
    private final Property<String> pluginName;
    @Input
    @Optional
    @NotNull
    private final Property<String> sandboxDir;

    @NotNull
    public final DirectoryProperty getOutputDir() {
        return this.outputDir;
    }

    @NotNull
    public final Property<String> getPluginName() {
        return this.pluginName;
    }

    @NotNull
    public final Property<String> getSandboxDir() {
        return this.sandboxDir;
    }

    @Inject
    public JarSearchableOptionsTask(@NotNull ObjectFactory objectFactory) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        DirectoryProperty directoryProperty = objectFactory.directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objectFactory.directoryProperty()");
        this.outputDir = directoryProperty;
        ObjectFactory $this$property$iv = objectFactory;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        this.pluginName = property;
        $this$property$iv = objectFactory;
        $i$f$property = false;
        Property property2 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java)");
        this.sandboxDir = property2;
        final Set pluginJarFiles = new LinkedHashSet();
        this.from(new Object[]{new Function0<String>(){

            public final String invoke() {
                this.include(new Spec(){

                    public final boolean isSatisfiedBy(FileTreeElement it) {
                        boolean bl;
                        FileTreeElement fileTreeElement = it;
                        Intrinsics.checkNotNullExpressionValue((Object)fileTreeElement, (String)"it");
                        if (fileTreeElement.isDirectory()) {
                            bl = true;
                        } else {
                            String suffix = ".searchableOptions.xml";
                            String string = it.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                            if (StringsKt.endsWith$default((String)string, (String)suffix, (boolean)false, (int)2, null) && pluginJarFiles.isEmpty()) {
                                Object[] objectArray = new File((String)this.getSandboxDir().get(), (String)this.getPluginName().get() + "/lib").list();
                                if (objectArray != null) {
                                    Object[] objectArray2;
                                    Object[] files2 = objectArray2 = objectArray;
                                    boolean bl2 = false;
                                    CollectionsKt.addAll((Collection)pluginJarFiles, (Object[])files2);
                                }
                            }
                            String string2 = it.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                            String jarName = StringsKt.replace$default((String)string2, (String)suffix, (String)"", (boolean)false, (int)4, null);
                            bl = pluginJarFiles.contains(jarName);
                        }
                        return bl;
                    }
                });
                Object object = this.getOutputDir().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"outputDir.get()");
                File file = ((Directory)object).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputDir.get().asFile");
                return file.getCanonicalPath();
            }
        }});
        this.eachFile(2.INSTANCE);
        this.setIncludeEmptyDirs(false);
    }
}

