/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.Version;
import org.jetbrains.intellij.model.SpacePackagesMavenMetadata;
import org.jetbrains.intellij.model.SpacePackagesMavenMetadataVersioning;
import org.jetbrains.intellij.model.XmlExtractor;
import org.jetbrains.intellij.utils.ArchiveUtils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/intellij/tasks/DownloadRobotServerPluginTask;", "Lorg/gradle/api/internal/ConventionTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "archiveUtils", "Lorg/jetbrains/intellij/utils/ArchiveUtils;", "context", "", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "pluginArchive", "Lorg/gradle/api/provider/Property;", "Ljava/io/File;", "getPluginArchive", "()Lorg/gradle/api/provider/Property;", "version", "getVersion", "downloadPlugin", "", "Companion", "gradle-intellij-plugin"})
public class DownloadRobotServerPluginTask
extends ConventionTask {
    @Input
    @NotNull
    private final Property<String> version;
    @Input
    @NotNull
    private final Property<File> pluginArchive;
    @OutputDirectory
    @NotNull
    private final DirectoryProperty outputDir;
    private final ArchiveUtils archiveUtils;
    private final String context;
    private static final String METADATA_URL = "https://cache-redirector.jetbrains.com/intellij-dependencies/com/intellij/remoterobot/robot-server-plugin/maven-metadata.xml";
    private static final String OLD_ROBOT_SERVER_DEPENDENCY = "org.jetbrains.test:robot-server-plugin";
    private static final String NEW_ROBOT_SERVER_DEPENDENCY = "com.intellij.remoterobot:robot-server-plugin";
    private static final String NEW_ROBOT_SERVER_VERSION = "0.11.0";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Property<String> getVersion() {
        return this.version;
    }

    @NotNull
    public final Property<File> getPluginArchive() {
        return this.pluginArchive;
    }

    @NotNull
    public final DirectoryProperty getOutputDir() {
        return this.outputDir;
    }

    @TaskAction
    public final void downloadPlugin() {
        Object object = this.outputDir.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"outputDir.get()");
        File file = ((Directory)object).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputDir.get().asFile");
        File target = file;
        Object object2 = this.pluginArchive.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"pluginArchive.get()");
        ArchiveUtils.extract$default(this.archiveUtils, (File)object2, target, this.context, null, null, 24, null);
    }

    @Inject
    public DownloadRobotServerPluginTask(@NotNull ObjectFactory objectFactory) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        ObjectFactory $this$property$iv = objectFactory;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        this.version = property;
        $this$property$iv = objectFactory;
        $i$f$property = false;
        Property property2 = $this$property$iv.property(File.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java)");
        this.pluginArchive = property2;
        DirectoryProperty directoryProperty = objectFactory.directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objectFactory.directoryProperty()");
        this.outputDir = directoryProperty;
        Object object = objectFactory.newInstance(ArchiveUtils.class, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"objectFactory.newInstanc\u2026ArchiveUtils::class.java)");
        this.archiveUtils = (ArchiveUtils)object;
        this.context = Utils.logCategory((Task)this);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004J\u0006\u0010\n\u001a\u00020\u0004J\u0010\u0010\u000b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/intellij/tasks/DownloadRobotServerPluginTask$Companion;", "", "()V", "METADATA_URL", "", "NEW_ROBOT_SERVER_DEPENDENCY", "NEW_ROBOT_SERVER_VERSION", "OLD_ROBOT_SERVER_DEPENDENCY", "getDependency", "version", "resolveLatestVersion", "resolveVersion", "gradle-intellij-plugin"})
    public static final class Companion {
        @NotNull
        public final String resolveLatestVersion() {
            Utils.debug$default(null, "Resolving latest Robot Server Plugin version", null, 5, null);
            URL url = new URL(DownloadRobotServerPluginTask.METADATA_URL);
            XmlExtractor xmlExtractor = new XmlExtractor(null, 1, null);
            InputStream inputStream = url.openStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"url.openStream()");
            Object object = ((SpacePackagesMavenMetadata)xmlExtractor.unmarshal(inputStream)).getVersioning();
            if (object == null || (object = ((SpacePackagesMavenMetadataVersioning)object).getLatest()) == null) {
                throw (Throwable)new GradleException("Cannot resolve the latest Robot Server Plugin version");
            }
            return object;
        }

        @NotNull
        public final String resolveVersion(@Nullable String version) {
            String string;
            block3: {
                block2: {
                    String string2;
                    string = version;
                    if (string == null) break block2;
                    String it = string2 = string;
                    boolean bl = false;
                    string = Intrinsics.areEqual((Object)it, (Object)"latest") ^ true ? string2 : null;
                    if (string != null) break block3;
                }
                string = this.resolveLatestVersion();
            }
            return string;
        }

        @NotNull
        public final String getDependency(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return Version.Companion.parse(version).compareTo(Version.Companion.parse(DownloadRobotServerPluginTask.NEW_ROBOT_SERVER_VERSION)) >= 0 ? DownloadRobotServerPluginTask.NEW_ROBOT_SERVER_DEPENDENCY : DownloadRobotServerPluginTask.OLD_ROBOT_SERVER_DEPENDENCY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

