/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.jbr;

import java.io.File;
import java.io.FileReader;
import java.nio.file.Path;
import java.util.Properties;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Incubating;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.kotlin.dsl.DependencyHandlerExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.Version;
import org.jetbrains.intellij.jbr.Jbr;
import org.jetbrains.intellij.jbr.JbrResolver;
import org.jetbrains.intellij.utils.ArchiveUtils;
import org.jetbrains.intellij.utils.DependenciesDownloader;
import org.jetbrains.intellij.utils.DependenciesDownloaderKt;

@Incubating
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001:\u0001)B1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003J[\u0010\u001e\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\"\u001a\u00020\u00052#\b\u0002\u0010#\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0004\u0012\u00020\u00050$JQ\u0010(\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u00122#\b\u0002\u0010#\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0004\u0012\u00020\u00050$R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/intellij/jbr/JbrResolver;", "", "jreRepository", "", "isOffline", "", "archiveUtils", "Lorg/jetbrains/intellij/utils/ArchiveUtils;", "dependenciesDownloader", "Lorg/jetbrains/intellij/utils/DependenciesDownloader;", "context", "(Ljava/lang/String;ZLorg/jetbrains/intellij/utils/ArchiveUtils;Lorg/jetbrains/intellij/utils/DependenciesDownloader;Ljava/lang/String;)V", "operatingSystem", "Lorg/gradle/internal/os/OperatingSystem;", "kotlin.jvm.PlatformType", "findJavaExecutable", "Ljava/nio/file/Path;", "javaHome", "Ljava/io/File;", "fromDir", "Lorg/jetbrains/intellij/jbr/Jbr;", "javaDir", "version", "getBuiltinJbrVersion", "ideDirectory", "getJavaArchive", "jbrArtifact", "Lorg/jetbrains/intellij/jbr/JbrResolver$JbrArtifact;", "getJbrRoot", "resolve", "resolveRuntime", "runtimeDir", "jbrVersion", "ideDir", "resolveExecutable", "validate", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "executable", "resolveRuntimeDir", "JbrArtifact", "gradle-intellij-plugin"})
public class JbrResolver {
    private final OperatingSystem operatingSystem;
    private final String jreRepository;
    private final boolean isOffline;
    private final ArchiveUtils archiveUtils;
    private final DependenciesDownloader dependenciesDownloader;
    private final String context;

    @Nullable
    public final String resolveRuntimeDir(@Nullable String runtimeDir, @Nullable String jbrVersion, @Nullable File ideDir, @NotNull Function1<? super String, Boolean> validate) {
        Intrinsics.checkNotNullParameter(validate, (String)"validate");
        return this.resolveRuntime(runtimeDir, jbrVersion, ideDir, false, validate);
    }

    public static /* synthetic */ String resolveRuntimeDir$default(JbrResolver jbrResolver, String string, String string2, File file, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resolveRuntimeDir");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            file = null;
        }
        if ((n & 8) != 0) {
            function1 = resolveRuntimeDir.1.INSTANCE;
        }
        return jbrResolver.resolveRuntimeDir(string, string2, file, (Function1<? super String, Boolean>)function1);
    }

    @Nullable
    public final String resolveRuntime(@Nullable String runtimeDir, @Nullable String jbrVersion, @Nullable File ideDir, boolean resolveExecutable, @NotNull Function1<? super String, Boolean> validate) {
        String string;
        Intrinsics.checkNotNullParameter(validate, (String)"validate");
        Utils.debug$default(this.context, "Resolving runtime directory.", null, 4, null);
        String string2 = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.listOf((Object[])new Function0[]{(Function0)new Function0<String>(this, runtimeDir, resolveExecutable){
            final /* synthetic */ JbrResolver this$0;
            final /* synthetic */ String $runtimeDir;
            final /* synthetic */ boolean $resolveExecutable;

            @Nullable
            public final String invoke() {
                String string;
                String string2 = this.$runtimeDir;
                if (string2 != null) {
                    Object object;
                    String string3;
                    String path = string3 = string2;
                    boolean bl = false;
                    Object p1 = object = path;
                    boolean bl2 = false;
                    object = new File((String)p1);
                    p1 = this.this$0;
                    Object p12 = object;
                    boolean bl3 = false;
                    Object $this$run = object = JbrResolver.access$getJbrRoot((JbrResolver)p1, (File)p12);
                    boolean bl4 = false;
                    boolean bl5 = this.$resolveExecutable;
                    p1 = object = bl5 ? FilesKt.resolve((File)$this$run, (String)"bin/java") : $this$run;
                    boolean bl6 = false;
                    Object object2 = ((File)p1).exists() ? object : null;
                    Object it = object = object2 != null ? ((File)object2).getCanonicalPath() : null;
                    boolean bl7 = false;
                    Utils.debug$default(JbrResolver.access$getContext$p(this.this$0), "Runtime specified with runtimeDir='" + path + "' resolved as: " + (String)it, null, 4, null);
                    string = (String)Utils.ifNull(object, (Function0<Unit>)((Function0)new Function0<Unit>(path, this){
                        final /* synthetic */ String $path;
                        final /* synthetic */ resolveRuntime.2 this$0;
                        {
                            this.$path = string;
                            this.this$0 = var2_2;
                            super(0);
                        }

                        public final void invoke() {
                            Utils.warn$default(JbrResolver.access$getContext$p(this.this$0.this$0), "Cannot resolve runtime with runtimeDir='" + this.$path + '\'', null, 4, null);
                        }
                    }));
                } else {
                    string = null;
                }
                return string;
            }
            {
                this.this$0 = jbrResolver;
                this.$runtimeDir = string;
                this.$resolveExecutable = bl;
                super(0);
            }
        }, (Function0)new Function0<String>(this, jbrVersion, resolveExecutable){
            final /* synthetic */ JbrResolver this$0;
            final /* synthetic */ String $jbrVersion;
            final /* synthetic */ boolean $resolveExecutable;

            @Nullable
            public final String invoke() {
                String string;
                String string2 = this.$jbrVersion;
                if (string2 != null) {
                    String string3;
                    String string4;
                    String version = string4 = string2;
                    boolean bl = false;
                    Object object = version;
                    JbrResolver jbrResolver = this.this$0;
                    String p1 = object;
                    boolean bl2 = false;
                    Jbr jbr = jbrResolver.resolve(p1);
                    if (jbr != null) {
                        Object $this$run = object = jbr;
                        boolean bl3 = false;
                        boolean bl4 = this.$resolveExecutable;
                        if (bl4) {
                            string3 = ((Jbr)$this$run).getJavaExecutable();
                        } else {
                            File file = ((Jbr)$this$run).getJavaHome();
                            JbrResolver jbrResolver2 = this.this$0;
                            File p12 = file;
                            boolean bl5 = false;
                            string3 = JbrResolver.access$getJbrRoot(jbrResolver2, p12).getCanonicalPath();
                        }
                    } else {
                        string3 = null;
                    }
                    Object it = object = string3;
                    boolean bl6 = false;
                    Utils.debug$default(JbrResolver.access$getContext$p(this.this$0), "Runtime specified with jbrVersion='" + version + "' resolved as: " + (String)it, null, 4, null);
                    string = (String)Utils.ifNull(object, (Function0<Unit>)((Function0)new Function0<Unit>(version, this){
                        final /* synthetic */ String $version;
                        final /* synthetic */ resolveRuntime.3 this$0;
                        {
                            this.$version = string;
                            this.this$0 = var2_2;
                            super(0);
                        }

                        public final void invoke() {
                            Utils.warn$default(JbrResolver.access$getContext$p(this.this$0.this$0), "Cannot resolve runtime with jbrVersion='" + this.$version + '\'', null, 4, null);
                        }
                    }));
                } else {
                    string = null;
                }
                return string;
            }
            {
                this.this$0 = jbrResolver;
                this.$jbrVersion = string;
                this.$resolveExecutable = bl;
                super(0);
            }
        }, (Function0)new Function0<String>(this, ideDir, resolveExecutable){
            final /* synthetic */ JbrResolver this$0;
            final /* synthetic */ File $ideDir;
            final /* synthetic */ boolean $resolveExecutable;

            @Nullable
            public final String invoke() {
                String string;
                File file = this.$ideDir;
                if (file != null) {
                    String string2;
                    File file2;
                    File file3;
                    File file4 = file3 = file;
                    boolean bl = false;
                    File file5 = file4;
                    JbrResolver jbrResolver = this.this$0;
                    File p1 = file5;
                    boolean bl2 = false;
                    File $this$run = file5 = JbrResolver.access$getJbrRoot(jbrResolver, p1);
                    boolean bl3 = false;
                    File p12 = file2 = FilesKt.resolve((File)$this$run, (String)"bin/java");
                    boolean bl4 = false;
                    File file6 = p12.exists() ? file2 : null;
                    if (file6 != null) {
                        File executable = file2 = file6;
                        boolean bl5 = false;
                        boolean bl6 = this.$resolveExecutable;
                        if (bl6) {
                            string2 = executable.getCanonicalPath();
                        } else {
                            String string3;
                            String it = string3 = $this$run.getCanonicalPath();
                            boolean bl7 = false;
                            string2 = executable.exists() ? string3 : null;
                        }
                    } else {
                        string2 = null;
                    }
                    File it = file5 = string2;
                    boolean bl8 = false;
                    Utils.debug$default(JbrResolver.access$getContext$p(this.this$0), "Runtime specified with ideDir='" + file4 + "' resolved as: " + (String)((Object)it), null, 4, null);
                    string = (String)((Object)Utils.ifNull(file5, (Function0<Unit>)((Function0)new Function0<Unit>(file4, this){
                        final /* synthetic */ File $file;
                        final /* synthetic */ resolveRuntime.4 this$0;
                        {
                            this.$file = file;
                            this.this$0 = var2_2;
                            super(0);
                        }

                        public final void invoke() {
                            Utils.warn$default(JbrResolver.access$getContext$p(this.this$0.this$0), "Cannot resolve runtime with ideDir='" + this.$file + '\'', null, 4, null);
                        }
                    })));
                } else {
                    string = null;
                }
                return string;
            }
            {
                this.this$0 = jbrResolver;
                this.$ideDir = file;
                this.$resolveExecutable = bl;
                super(0);
            }
        }, (Function0)new Function0<String>(this, ideDir, resolveExecutable){
            final /* synthetic */ JbrResolver this$0;
            final /* synthetic */ File $ideDir;
            final /* synthetic */ boolean $resolveExecutable;

            @Nullable
            public final String invoke() {
                String string;
                File file = this.$ideDir;
                if (file != null) {
                    String string2;
                    File file2;
                    File file3 = file2 = file;
                    boolean bl = false;
                    String string3 = JbrResolver.access$getBuiltinJbrVersion(this.this$0, file3);
                    if (string3 != null) {
                        String string4;
                        Jbr jbr;
                        String string5;
                        String version = string5 = string3;
                        boolean bl2 = false;
                        Jbr jbr2 = this.this$0.resolve(version);
                        if (jbr2 != null) {
                            Jbr $this$run = jbr = jbr2;
                            boolean bl3 = false;
                            boolean bl4 = this.$resolveExecutable;
                            if (bl4) {
                                string4 = $this$run.getJavaExecutable();
                            } else {
                                File file4 = $this$run.getJavaHome();
                                JbrResolver jbrResolver = this.this$0;
                                File p1 = file4;
                                boolean bl5 = false;
                                string4 = JbrResolver.access$getJbrRoot(jbrResolver, p1).getCanonicalPath();
                            }
                        } else {
                            string4 = null;
                        }
                        Jbr it = jbr = string4;
                        boolean bl6 = false;
                        Utils.debug$default(JbrResolver.access$getContext$p(this.this$0), "Runtime specified with ideDir='" + file3 + "', version='" + version + "' resolved as: " + (String)((Object)it), null, 4, null);
                        string2 = (String)((Object)Utils.ifNull(jbr, (Function0<Unit>)((Function0)new Function0<Unit>(version, file3, this){
                            final /* synthetic */ String $version;
                            final /* synthetic */ File $file$inlined;
                            final /* synthetic */ resolveRuntime.5 this$0;
                            {
                                this.$version = string;
                                this.$file$inlined = file;
                                this.this$0 = var3_3;
                                super(0);
                            }

                            public final void invoke() {
                                Utils.warn$default(JbrResolver.access$getContext$p(this.this$0.this$0), "Cannot resolve runtime with ideDir='" + this.$file$inlined + "', version='" + this.$version + '\'', null, 4, null);
                            }
                        })));
                    } else {
                        string2 = null;
                    }
                    string = Utils.ifNull(string2, (Function0<Unit>)((Function0)new Function0<Unit>(file3, this){
                        final /* synthetic */ File $file;
                        final /* synthetic */ resolveRuntime.5 this$0;
                        {
                            this.$file = file;
                            this.this$0 = var2_2;
                            super(0);
                        }

                        public final void invoke() {
                            Utils.warn$default(JbrResolver.access$getContext$p(this.this$0.this$0), "Cannot resolve runtime with ideDir='" + this.$file + '\'', null, 4, null);
                        }
                    }));
                } else {
                    string = null;
                }
                return string;
            }
            {
                this.this$0 = jbrResolver;
                this.$ideDir = file;
                this.$resolveExecutable = bl;
                super(0);
            }
        }, (Function0)new Function0<String>(this, resolveExecutable){
            final /* synthetic */ JbrResolver this$0;
            final /* synthetic */ boolean $resolveExecutable;

            @Nullable
            public final String invoke() {
                String string;
                Object object;
                Jvm $this$run = object = Jvm.current();
                boolean bl = false;
                boolean bl2 = this.$resolveExecutable;
                if (bl2) {
                    File file = $this$run.getJavaExecutable();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"javaExecutable");
                    string = file.getCanonicalPath();
                } else {
                    File file = $this$run.getJavaHome();
                    JbrResolver jbrResolver = this.this$0;
                    File p1 = file;
                    boolean bl3 = false;
                    string = JbrResolver.access$getJbrRoot(jbrResolver, p1).getCanonicalPath();
                }
                Object it = object = string;
                boolean bl4 = false;
                Utils.debug$default(JbrResolver.access$getContext$p(this.this$0), "Using current JVM: " + (String)it, null, 4, null);
                return (String)Utils.ifNull(object, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ resolveRuntime.6 this$0;

                    public final void invoke() {
                        Utils.warn$default(JbrResolver.access$getContext$p(this.this$0.this$0), "Cannot resolve current JVM", null, 4, null);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
            {
                this.this$0 = jbrResolver;
                this.$resolveExecutable = bl;
                super(0);
            }
        }})), (Function1)((Function1)new Function1<Function0<? extends String>, String>(validate){
            final /* synthetic */ Function1 $validate;

            @Nullable
            public final String invoke(@NotNull Function0<String> it) {
                String string;
                Function1 function1;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                String string2 = (String)it.invoke();
                return string2 != null ? (((Boolean)(function1 = this.$validate).invoke((Object)(string = string2))).booleanValue() ? string : null) : null;
            }
            {
                this.$validate = function1;
                super(1);
            }
        })));
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            Utils.debug$default(this.context, "Resolved JVM Runtime directory: " + it, null, 4, null);
            string = string3;
        } else {
            string = null;
        }
        return string;
    }

    public static /* synthetic */ String resolveRuntime$default(JbrResolver jbrResolver, String string, String string2, File file, boolean bl, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resolveRuntime");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            file = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            function1 = resolveRuntime.1.INSTANCE;
        }
        return jbrResolver.resolveRuntime(string, string2, file, bl, (Function1<? super String, Boolean>)function1);
    }

    @Nullable
    public final Jbr resolve(@Nullable String version) {
        Jbr jbr;
        CharSequence charSequence = version;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        Object object = "8";
        String string = object;
        StringBuilder stringBuilder = new StringBuilder();
        JbrArtifact.Companion companion = JbrArtifact.Companion;
        boolean bl = false;
        boolean bl2 = StringsKt.startsWith$default((CharSequence)version, (char)'u', (boolean)false, (int)2, null);
        Object object2 = bl2 ? object : null;
        if (object2 == null) {
            object2 = "";
        }
        String string2 = stringBuilder.append((String)object2).append(version).toString();
        OperatingSystem operatingSystem = this.operatingSystem;
        Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"operatingSystem");
        JbrArtifact jbrArtifact = companion.from(string2, operatingSystem);
        File file = this.getJavaArchive(jbrArtifact);
        if (file != null) {
            Object it = object = file;
            boolean bl3 = false;
            String string3 = ((File)it).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.path");
            File javaDir = FilesKt.resolve((File)new File(StringsKt.replaceAfter$default((String)string3, (String)jbrArtifact.getName(), (String)"", null, (int)4, null)), (String)"extracted");
            ArchiveUtils.extract$default(this.archiveUtils, (File)it, javaDir, this.context, null, null, 24, null);
            jbr = this.fromDir(javaDir, version);
        } else {
            jbr = null;
        }
        return jbr;
    }

    private final Jbr fromDir(File javaDir, String version) {
        Path javaExecutable = this.findJavaExecutable(javaDir);
        if (javaExecutable == null) {
            Utils.warn$default(this.context, "Cannot find java executable in: " + javaDir, null, 4, null);
            return null;
        }
        File file = javaExecutable.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"javaExecutable.toFile()");
        return new Jbr(version, javaDir, file.getAbsolutePath());
    }

    private final File getJavaArchive(JbrArtifact jbrArtifact) {
        if (this.isOffline) {
            Utils.warn$default(this.context, "Cannot download JetBrains Java Runtime '" + jbrArtifact.getName() + "'. Gradle runs in offline mode.", null, 4, null);
            return null;
        }
        Object object = this.jreRepository;
        String it = object;
        boolean bl = false;
        CharSequence charSequence = it;
        Object object2 = charSequence.length() > 0 ? object : null;
        if (object2 == null) {
            object2 = jbrArtifact.getRepositoryUrl();
        }
        String url = object2;
        try {
            object = (File)CollectionsKt.first(this.dependenciesDownloader.downloadFromRepository(this.context, (Function1<? super DependencyHandler, ? extends Dependency>)((Function1)new Function1<DependencyHandler, Dependency>(jbrArtifact){
                final /* synthetic */ JbrArtifact $jbrArtifact;

                @NotNull
                public final Dependency invoke(@NotNull DependencyHandler $this$downloadFromRepository) {
                    Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$receiver");
                    return (Dependency)DependencyHandlerExtensionsKt.create$default((DependencyHandler)$this$downloadFromRepository, (String)"com.jetbrains", (String)"jbre", (String)this.$jbrArtifact.getName(), null, null, (String)"tar.gz", (int)24, null);
                }
                {
                    this.$jbrArtifact = jbrArtifact;
                    super(1);
                }
            }), (Function1<? super RepositoryHandler, ? extends ArtifactRepository>)((Function1)new Function1<RepositoryHandler, ArtifactRepository>(url){
                final /* synthetic */ String $url;

                @NotNull
                public final ArtifactRepository invoke(@NotNull RepositoryHandler $this$downloadFromRepository) {
                    Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$receiver");
                    return (ArtifactRepository)DependenciesDownloaderKt.ivyRepository($this$downloadFromRepository, this.$url, "[revision].tar.gz");
                }
                {
                    this.$url = string;
                    super(1);
                }
            })));
        }
        catch (Exception e) {
            Utils.warn$default(this.context, "Cannot download JetBrains Java Runtime '" + jbrArtifact.getName() + '\'', null, 4, null);
            object = null;
        }
        return object;
    }

    private final Path findJavaExecutable(File javaHome) {
        Object object;
        File root = this.getJbrRoot(javaHome);
        File jre = new File(root, "jre");
        Object it = object = jre;
        boolean bl = false;
        boolean bl2 = ((File)it).exists();
        Object object2 = bl2 ? object : null;
        if (object2 == null) {
            object2 = root;
        }
        it = object = ".exe";
        StringBuilder stringBuilder = new StringBuilder().append("bin/java");
        File file = object2;
        boolean bl3 = false;
        OperatingSystem operatingSystem = this.operatingSystem;
        Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"operatingSystem");
        boolean bl4 = operatingSystem.isWindows();
        Object object3 = bl4 ? object : null;
        if (object3 == null) {
            object3 = "";
        }
        String string = stringBuilder.append((String)object3).toString();
        File file2 = file;
        File java = new File(file2, string);
        it = object = java.toPath();
        boolean bl5 = false;
        return java.exists() ? object : null;
    }

    private final File getJbrRoot(File javaHome) {
        File file;
        File jbr;
        block12: {
            File file2;
            File[] fileArray = javaHome.listFiles();
            if (fileArray != null) {
                File[] $this$firstOrNull$iv = fileArray;
                boolean $i$f$firstOrNull = false;
                File[] fileArray2 = $this$firstOrNull$iv;
                int n = fileArray2.length;
                for (int j = 0; j < n; ++j) {
                    File element$iv;
                    File it = element$iv = fileArray2[j];
                    boolean bl = false;
                    File file3 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"it");
                    if (!(Intrinsics.areEqual((Object)file3.getName(), (Object)"jbr") || Intrinsics.areEqual((Object)it.getName(), (Object)"jbrsdk"))) continue;
                    file2 = element$iv;
                    break block12;
                }
                file2 = null;
            } else {
                file2 = jbr = null;
            }
        }
        if (jbr != null && jbr.exists()) {
            File file4;
            OperatingSystem operatingSystem = this.operatingSystem;
            Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"operatingSystem");
            boolean bl = operatingSystem.isMacOsX();
            if (bl) {
                file4 = FilesKt.resolve((File)jbr, (String)"Contents/Home");
            } else if (!bl) {
                file4 = jbr;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return file4;
        }
        OperatingSystem operatingSystem = this.operatingSystem;
        Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"operatingSystem");
        boolean bl = operatingSystem.isMacOsX();
        if (bl) {
            file = FilesKt.resolve((File)javaHome, (String)"jdk/Contents/Home");
        } else if (!bl) {
            file = javaHome;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getBuiltinJbrVersion(File ideDirectory) {
        File dependenciesFile = new File(ideDirectory, "dependencies.txt");
        if (dependenciesFile.exists()) {
            Properties properties = new Properties();
            try (FileReader reader = new FileReader(dependenciesFile);){
                properties.load(reader);
                String string = properties.getProperty("jdkBuild");
                return string;
            }
        }
        return null;
    }

    @Inject
    public JbrResolver(@NotNull String jreRepository, boolean isOffline, @NotNull ArchiveUtils archiveUtils, @NotNull DependenciesDownloader dependenciesDownloader, @Nullable String context) {
        Intrinsics.checkNotNullParameter((Object)jreRepository, (String)"jreRepository");
        Intrinsics.checkNotNullParameter((Object)archiveUtils, (String)"archiveUtils");
        Intrinsics.checkNotNullParameter((Object)dependenciesDownloader, (String)"dependenciesDownloader");
        this.jreRepository = jreRepository;
        this.isOffline = isOffline;
        this.archiveUtils = archiveUtils;
        this.dependenciesDownloader = dependenciesDownloader;
        this.context = context;
        this.operatingSystem = OperatingSystem.current();
    }

    public static final /* synthetic */ File access$getJbrRoot(JbrResolver $this, File javaHome) {
        return $this.getJbrRoot(javaHome);
    }

    public static final /* synthetic */ String access$getContext$p(JbrResolver $this) {
        return $this.context;
    }

    public static final /* synthetic */ String access$getBuiltinJbrVersion(JbrResolver $this, File ideDirectory) {
        return $this.getBuiltinJbrVersion(ideDirectory);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/intellij/jbr/JbrResolver$JbrArtifact;", "", "name", "", "repositoryUrl", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getRepositoryUrl", "Companion", "gradle-intellij-plugin"})
    public static final class JbrArtifact {
        @NotNull
        private final String name;
        @NotNull
        private final String repositoryUrl;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getRepositoryUrl() {
            return this.repositoryUrl;
        }

        public JbrArtifact(@NotNull String name, @NotNull String repositoryUrl) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)repositoryUrl, (String)"repositoryUrl");
            this.name = name;
            this.repositoryUrl = repositoryUrl;
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u0015\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/intellij/jbr/JbrResolver$JbrArtifact$Companion;", "", "()V", "arch", "", "newFormat", "", "arch$gradle_intellij_plugin", "from", "Lorg/jetbrains/intellij/jbr/JbrResolver$JbrArtifact;", "version", "operatingSystem", "Lorg/gradle/internal/os/OperatingSystem;", "getPrefix", "platform", "platform$gradle_intellij_plugin", "gradle-intellij-plugin"})
        public static final class Companion {
            @NotNull
            public final JbrArtifact from(@NotNull String version, @NotNull OperatingSystem operatingSystem) {
                boolean oldFormat;
                String string;
                boolean bl;
                String string2;
                int n;
                String string3;
                boolean bl2;
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                Intrinsics.checkNotNullParameter((Object)operatingSystem, (String)"operatingSystem");
                String prefix2 = this.getPrefix(version);
                int lastIndexOfB = StringsKt.lastIndexOf$default((CharSequence)version, (char)'b', (int)0, (boolean)false, (int)6, null);
                boolean bl3 = bl2 = lastIndexOfB > -1;
                if (bl2) {
                    string3 = version;
                    n = prefix2.length();
                    String string4 = string3.substring(n, lastIndexOfB);
                    string2 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                } else if (!bl2) {
                    string3 = version;
                    n = prefix2.length();
                    String string5 = string3.substring(n);
                    string2 = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                String majorVersion = string2;
                boolean bl4 = bl = lastIndexOfB > -1;
                if (bl) {
                    String string6 = version;
                    int n2 = lastIndexOfB + 1;
                    String string7 = string6.substring(n2);
                    string = string7;
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                } else {
                    string = "";
                }
                String buildNumberString = string;
                Version buildNumber = Version.Companion.parse(buildNumberString);
                boolean isJava8 = StringsKt.startsWith$default((CharSequence)majorVersion, (char)'8', (boolean)false, (int)2, null);
                boolean bl5 = oldFormat = Intrinsics.areEqual((Object)prefix2, (Object)"jbrex") || isJava8 && buildNumber.compareTo(Version.Companion.parse("1483.24")) < 0;
                if (oldFormat) {
                    return new JbrArtifact("jbrex" + majorVersion + 'b' + buildNumberString + '_' + this.platform$gradle_intellij_plugin(operatingSystem) + '_' + this.arch$gradle_intellij_plugin(false), "https://cache-redirector.jetbrains.com/intellij-jbr");
                }
                CharSequence charSequence = prefix2;
                if (charSequence.length() == 0) {
                    prefix2 = isJava8 ? "jbrx-" : (buildNumber.compareTo(Version.Companion.parse("1319.6")) < 0 ? "jbr-" : "jbr_jcef-");
                }
                return new JbrArtifact(prefix2 + majorVersion + '-' + this.platform$gradle_intellij_plugin(operatingSystem) + '-' + this.arch$gradle_intellij_plugin(isJava8) + "-b" + buildNumberString, "https://cache-redirector.jetbrains.com/intellij-jbr");
            }

            private final String getPrefix(String version) {
                return StringsKt.startsWith$default((String)version, (String)"jbrsdk-", (boolean)false, (int)2, null) ? "jbrsdk-" : (StringsKt.startsWith$default((String)version, (String)"jbr_jcef-", (boolean)false, (int)2, null) ? "jbr_jcef-" : (StringsKt.startsWith$default((String)version, (String)"jbr_dcevm-", (boolean)false, (int)2, null) ? "jbr_dcevm-" : (StringsKt.startsWith$default((String)version, (String)"jbr_fd-", (boolean)false, (int)2, null) ? "jbr_fd-" : (StringsKt.startsWith$default((String)version, (String)"jbr_nomod-", (boolean)false, (int)2, null) ? "jbr_nomod-" : (StringsKt.startsWith$default((String)version, (String)"jbr-", (boolean)false, (int)2, null) ? "jbr-" : (StringsKt.startsWith$default((String)version, (String)"jbrx-", (boolean)false, (int)2, null) ? "jbrx-" : (StringsKt.startsWith$default((String)version, (String)"jbrex8", (boolean)false, (int)2, null) ? "jbrex" : "")))))));
            }

            @NotNull
            public final String platform$gradle_intellij_plugin(@NotNull OperatingSystem operatingSystem) {
                Intrinsics.checkNotNullParameter((Object)operatingSystem, (String)"operatingSystem");
                return operatingSystem.isWindows() ? "windows" : (operatingSystem.isMacOsX() ? "osx" : "linux");
            }

            @NotNull
            public final String arch$gradle_intellij_plugin(boolean newFormat) {
                String string;
                String name;
                String arch = System.getProperty("os.arch");
                if (Intrinsics.areEqual((Object)"aarch64", (Object)arch) || Intrinsics.areEqual((Object)"arm64", (Object)arch)) {
                    return "aarch64";
                }
                if (Intrinsics.areEqual((Object)"x86_64", (Object)arch) || Intrinsics.areEqual((Object)"amd64", (Object)arch)) {
                    return "x64";
                }
                String string2 = name = System.getProperty("os.name");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
                if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"Windows", (boolean)false, (int)2, null) && System.getenv("ProgramFiles(x86)") != null) {
                    return "x64";
                }
                boolean bl = newFormat;
                if (bl) {
                    string = "i586";
                } else if (!bl) {
                    string = "x86";
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return string;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

