/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.publish.ivy.IvyConfiguration;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyConfiguration;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyPublicationIdentity;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.kotlin.dsl.DependencyHandlerExtensionsKt;
import org.gradle.tooling.BuildException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.IntelliJIvyDescriptorFileGenerator;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.BuiltinPluginsRegistry;
import org.jetbrains.intellij.dependency.IdeaDependency;
import org.jetbrains.intellij.dependency.IdeaExtraDependency;
import org.jetbrains.intellij.dependency.IntellijIvyArtifact;
import org.jetbrains.intellij.dependency.JpsIdeaDependency;
import org.jetbrains.intellij.dependency.LocalIdeaDependency;
import org.jetbrains.intellij.utils.ArchiveUtils;
import org.jetbrains.intellij.utils.DependenciesDownloader;
import org.jetbrains.intellij.utils.DependenciesDownloaderKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0016\u0018\u00002\u00020\u0001B1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\nJR\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J \u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010!\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020 H\u0002J\u001e\u0010$\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'J\u0018\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J,\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00032\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0002J\"\u0010+\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J \u0010,\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010-\u001a\u00020\u00032\b\u0010.\u001a\u0004\u0018\u00010\u0003J4\u0010/\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u00100\u001a\u00020 2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\fJ\u001a\u00101\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\"\u00102\u001a\u00020%2\u0006\u00103\u001a\u00020\u00142\u0006\u00104\u001a\u00020\u00032\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0002J\u0018\u00105\u001a\u00020%2\u0006\u00106\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0014H\u0002J(\u00107\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u00108\u001a\u00020 H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/jetbrains/intellij/dependency/IdeaDependencyManager;", "", "repositoryUrl", "", "ideaDependencyCachePath", "archiveUtils", "Lorg/jetbrains/intellij/utils/ArchiveUtils;", "dependenciesDownloader", "Lorg/jetbrains/intellij/utils/DependenciesDownloader;", "context", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/intellij/utils/ArchiveUtils;Lorg/jetbrains/intellij/utils/DependenciesDownloader;Ljava/lang/String;)V", "mainDependencies", "", "createDependency", "Lorg/jetbrains/intellij/dependency/IdeaDependency;", "name", "type", "version", "buildNumber", "classesDirectory", "Ljava/io/File;", "sourcesDirectory", "project", "Lorg/gradle/api/Project;", "extraDependencies", "", "Lorg/jetbrains/intellij/dependency/IdeaExtraDependency;", "getOrCreateIvyXml", "dependency", "getZipCacheDirectory", "zipFile", "hasKotlinDependency", "", "isCacheUpToDate", "markerFile", "checkVersion", "register", "", "dependencies", "Lorg/gradle/api/artifacts/DependencySet;", "resetExecutablePermissions", "cacheDirectory", "resolveExtraDependencies", "resolveExtraDependency", "resolveLocal", "localPath", "localPathSources", "resolveRemote", "sources", "resolveSources", "setExecutable", "parent", "child", "storeCache", "directoryToCache", "unzipDependencyFile", "checkVersionChange", "gradle-intellij-plugin"})
public class IdeaDependencyManager {
    private final List<String> mainDependencies;
    private final String repositoryUrl;
    private final String ideaDependencyCachePath;
    private final ArchiveUtils archiveUtils;
    private final DependenciesDownloader dependenciesDownloader;
    private final String context;

    public final void register(@NotNull Project project, @NotNull IdeaDependency dependency, @NotNull DependencySet dependencies) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        File ivyFile = this.getOrCreateIvyXml(dependency);
        String string = ivyFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ivyFile.name");
        String string2 = string;
        int n = (dependency.getName() + '-' + dependency.getVersion()).length();
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        String ivyFileSuffix = StringsKt.removeSuffix((String)string4, (CharSequence)".xml");
        project.getRepositories().ivy(new Action(dependency, ivyFile, ivyFileSuffix){
            final /* synthetic */ IdeaDependency $dependency;
            final /* synthetic */ File $ivyFile;
            final /* synthetic */ String $ivyFileSuffix;

            public final void execute(@NotNull IvyArtifactRepository $this$ivy) {
                Intrinsics.checkNotNullParameter((Object)$this$ivy, (String)"$receiver");
                $this$ivy.setUrl(this.$dependency.getClasses().toURI());
                $this$ivy.ivyPattern(this.$ivyFile.getParent() + "/[module]-[revision]" + this.$ivyFileSuffix + ".[ext]");
                $this$ivy.artifactPattern(this.$dependency.getClasses().getPath() + "/[artifact].[ext]");
                if (this.$dependency.getSources() != null) {
                    $this$ivy.artifactPattern(this.$dependency.getSources().getParent() + "/[artifact]-[revision]-[classifier].[ext]");
                }
            }
            {
                this.$dependency = ideaDependency;
                this.$ivyFile = file;
                this.$ivyFileSuffix = string;
            }
        });
        DependencyHandler dependencyHandler = project.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependencyHandler, (String)"project.dependencies");
        dependencies.add((Object)DependencyHandlerExtensionsKt.create$default((DependencyHandler)dependencyHandler, (String)"com.jetbrains", (String)dependency.getName(), (String)dependency.getVersion(), (String)"compile", null, null, (int)48, null));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final IdeaDependency createDependency(String name, String type, String version, String buildNumber, File classesDirectory2, File sourcesDirectory, Project project, Collection<IdeaExtraDependency> extraDependencies) {
        IdeaDependency ideaDependency;
        String string = type;
        if (string != null) {
            String string2 = string;
            switch (string2.hashCode()) {
                case 73677: {
                    if (!string2.equals("JPS")) break;
                    ideaDependency = new JpsIdeaDependency(version, buildNumber, classesDirectory2, sourcesDirectory, !this.hasKotlinDependency(project), this.context);
                    return ideaDependency;
                }
            }
        }
        BuiltinPluginsRegistry pluginsRegistry = BuiltinPluginsRegistry.Companion.fromDirectory(new File(classesDirectory2, "plugins"), this.context);
        String string3 = type;
        if (string3 == null) {
            ideaDependency = new LocalIdeaDependency(name, version, buildNumber, classesDirectory2, sourcesDirectory, !this.hasKotlinDependency(project), pluginsRegistry, extraDependencies);
            return ideaDependency;
        }
        ideaDependency = new IdeaDependency(name, version, buildNumber, classesDirectory2, sourcesDirectory, !this.hasKotlinDependency(project), pluginsRegistry, extraDependencies);
        return ideaDependency;
    }

    private final File resolveSources(String version, String type) {
        Utils.info$default(this.context, "Adding IDE sources repository", null, 4, null);
        try {
            String releaseType = Utils.releaseType(version);
            boolean forPyCharm = Utils.isPyCharmType(type);
            List<File> sourcesFiles2 = this.dependenciesDownloader.downloadFromRepository(this.context, (Function1<? super DependencyHandler, ? extends Dependency>)((Function1)new Function1<DependencyHandler, Dependency>(forPyCharm, version){
                final /* synthetic */ boolean $forPyCharm;
                final /* synthetic */ String $version;

                @NotNull
                public final Dependency invoke(@NotNull DependencyHandler $this$downloadFromRepository) {
                    Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$receiver");
                    return (Dependency)DependencyHandlerExtensionsKt.create$default((DependencyHandler)$this$downloadFromRepository, (String)(this.$forPyCharm ? "com.jetbrains.intellij.pycharm" : "com.jetbrains.intellij.idea"), (String)(this.$forPyCharm ? "pycharmPC" : "ideaIC"), (String)this.$version, null, (String)"sources", (String)"jar", (int)8, null);
                }
                {
                    this.$forPyCharm = bl;
                    this.$version = string;
                    super(1);
                }
            }), (Function1<? super RepositoryHandler, ? extends ArtifactRepository>)((Function1)new Function1<RepositoryHandler, ArtifactRepository>(this, releaseType){
                final /* synthetic */ IdeaDependencyManager this$0;
                final /* synthetic */ String $releaseType;

                @NotNull
                public final ArtifactRepository invoke(@NotNull RepositoryHandler $this$downloadFromRepository) {
                    Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$receiver");
                    return (ArtifactRepository)DependenciesDownloaderKt.mavenRepository($this$downloadFromRepository, IdeaDependencyManager.access$getRepositoryUrl$p(this.this$0) + '/' + this.$releaseType);
                }
                {
                    this.this$0 = ideaDependencyManager;
                    this.$releaseType = string;
                    super(1);
                }
            }));
            if (sourcesFiles2.size() == 1) {
                File sourcesDirectory = (File)CollectionsKt.first(sourcesFiles2);
                Utils.debug$default(this.context, "IDE sources jar: " + sourcesDirectory.getPath(), null, 4, null);
                return sourcesDirectory;
            }
            Utils.warn$default(this.context, "Cannot attach IDE sources. Found files: " + sourcesFiles2, null, 4, null);
        }
        catch (ResolveException e) {
            Utils.warn(this.context, "Cannot resolve IDE sources dependency", e);
        }
        return null;
    }

    private final File unzipDependencyFile(File cacheDirectory, File zipFile, String type, boolean checkVersionChange) {
        String string = zipFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"zipFile.name");
        return this.archiveUtils.extract(zipFile, FilesKt.resolve((File)cacheDirectory, (String)StringsKt.removeSuffix((String)string, (CharSequence)".zip")), this.context, new Predicate(this, zipFile, checkVersionChange){
            final /* synthetic */ IdeaDependencyManager this$0;
            final /* synthetic */ File $zipFile;
            final /* synthetic */ boolean $checkVersionChange;

            public final boolean test(@NotNull File markerFile) {
                Intrinsics.checkNotNullParameter((Object)markerFile, (String)"markerFile");
                return IdeaDependencyManager.access$isCacheUpToDate(this.this$0, this.$zipFile, markerFile, this.$checkVersionChange);
            }
            {
                this.this$0 = ideaDependencyManager;
                this.$zipFile = file;
                this.$checkVersionChange = bl;
            }
        }, new BiConsumer(this, type){
            final /* synthetic */ IdeaDependencyManager this$0;
            final /* synthetic */ String $type;

            public final void accept(@NotNull File unzippedDirectory, @NotNull File markerFile) {
                Intrinsics.checkNotNullParameter((Object)unzippedDirectory, (String)"unzippedDirectory");
                Intrinsics.checkNotNullParameter((Object)markerFile, (String)"markerFile");
                IdeaDependencyManager.access$resetExecutablePermissions(this.this$0, unzippedDirectory, this.$type);
                IdeaDependencyManager.access$storeCache(this.this$0, unzippedDirectory, markerFile);
            }
            {
                this.this$0 = ideaDependencyManager;
                this.$type = string;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isCacheUpToDate(File zipFile, File markerFile, boolean checkVersion) {
        if (!checkVersion) {
            return markerFile.exists();
        }
        if (!markerFile.exists()) {
            return false;
        }
        Closeable closeable = new ZipFile(zipFile);
        Throwable throwable = null;
        try {
            ZipFile zip = (ZipFile)closeable;
            boolean bl = false;
            ZipEntry entry = zip.getEntry("build.txt");
            if (entry != null) {
                String string;
                InputStream inputStream = zip.getInputStream(entry);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"zip.getInputStream(entry)");
                Closeable closeable2 = inputStream;
                Object object = Charsets.UTF_8;
                Closeable closeable3 = closeable2;
                int n = 0;
                closeable3 = new InputStreamReader((InputStream)closeable3, (Charset)object);
                n = 8192;
                boolean bl2 = false;
                closeable2 = closeable3 instanceof BufferedReader ? (BufferedReader)closeable3 : new BufferedReader((Reader)closeable3, n);
                object = null;
                try {
                    BufferedReader it = (BufferedReader)closeable2;
                    boolean bl3 = false;
                    string = TextStreamsKt.readText((Reader)it);
                }
                catch (Throwable throwable2) {
                    object = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
                }
                if (Intrinsics.areEqual((Object)string, (Object)FilesKt.readText$default((File)markerFile, null, (int)1, null)) ^ true) {
                    boolean bl4 = false;
                    return bl4;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return true;
    }

    private final void storeCache(File directoryToCache, File markerFile) {
        block1: {
            String string;
            File file;
            File it = file = new File(directoryToCache, "build.txt");
            boolean bl = false;
            File file2 = it.exists() ? file : null;
            if (file2 == null) break block1;
            it = file = file2;
            boolean bl2 = false;
            String string2 = string = FilesKt.readText$default((File)it, null, (int)1, null);
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            FilesKt.writeText$default((File)markerFile, (String)((Object)StringsKt.trim((CharSequence)string2)).toString(), null, (int)2, null);
        }
    }

    private final void resetExecutablePermissions(File cacheDirectory, String type) {
        if (Intrinsics.areEqual((Object)type, (Object)"RD")) {
            OperatingSystem operatingSystem = OperatingSystem.current();
            Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"OperatingSystem.current()");
            if (!operatingSystem.isWindows()) {
                this.setExecutable(cacheDirectory, "lib/ReSharperHost/dupfinder.sh", this.context);
                this.setExecutable(cacheDirectory, "lib/ReSharperHost/inspectcode.sh", this.context);
                this.setExecutable(cacheDirectory, "lib/ReSharperHost/JetBrains.ReSharper.Host.sh", this.context);
                this.setExecutable(cacheDirectory, "lib/ReSharperHost/runtime.sh", this.context);
                this.setExecutable(cacheDirectory, "lib/ReSharperHost/macos-x64/mono/bin/env-wrapper", this.context);
                this.setExecutable(cacheDirectory, "lib/ReSharperHost/macos-x64/mono/bin/mono-sgen", this.context);
                this.setExecutable(cacheDirectory, "lib/ReSharperHost/macos-x64/mono/bin/mono-sgen-gdb.py", this.context);
                this.setExecutable(cacheDirectory, "lib/ReSharperHost/linux-x64/mono/bin/mono-sgen", this.context);
                this.setExecutable(cacheDirectory, "lib/ReSharperHost/linux-x64/mono/bin/mono-sgen-gdb.py", this.context);
            }
        }
    }

    private final void setExecutable(File parent, String child, String context) {
        File file;
        File $this$apply = file = new File(parent, child);
        boolean bl = false;
        Utils.debug$default(context, "Resetting executable permissions for: " + $this$apply.getPath(), null, 4, null);
        $this$apply.setExecutable(true, true);
    }

    private final File getOrCreateIvyXml(IdeaDependency dependency) {
        File ivyFile;
        File directory = dependency.getIvyRepositoryDirectory();
        File file = ivyFile = directory != null ? new File(directory, dependency.getFqn() + ".xml") : File.createTempFile(dependency.getFqn(), ".xml");
        if (directory == null || !ivyFile.exists()) {
            IntelliJIvyDescriptorFileGenerator intelliJIvyDescriptorFileGenerator;
            DefaultIvyPublicationIdentity identity = new DefaultIvyPublicationIdentity("com.jetbrains", dependency.getName(), dependency.getVersion());
            IntelliJIvyDescriptorFileGenerator $this$apply = intelliJIvyDescriptorFileGenerator = new IntelliJIvyDescriptorFileGenerator((IvyPublicationIdentity)identity);
            boolean bl = false;
            $this$apply.addConfiguration((IvyConfiguration)new DefaultIvyConfiguration("default"));
            $this$apply.addConfiguration((IvyConfiguration)new DefaultIvyConfiguration("compile"));
            $this$apply.addConfiguration((IvyConfiguration)new DefaultIvyConfiguration("sources"));
            Iterable $this$forEach$iv = dependency.getJarFiles();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl2 = false;
                $this$apply.addArtifact(IntellijIvyArtifact.Companion.createJarDependency(it, "compile", dependency.getClasses(), null));
            }
            if (dependency.getSources() != null) {
                String name = Utils.isDependencyOnPyCharm(dependency) ? "pycharmPC" : "ideaIC";
                IntellijIvyArtifact artifact = new IntellijIvyArtifact(dependency.getSources(), name, "jar", "sources", "sources");
                artifact.setConf("sources");
                $this$apply.addArtifact(artifact);
            }
            File file2 = ivyFile;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"ivyFile");
            $this$apply.writeTo(file2);
        }
        File file3 = ivyFile;
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"ivyFile");
        return file3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasKotlinDependency(Project project) {
        boolean bl;
        Configuration configuration = project.getConfigurations().getByName("runtimeClasspath");
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.configurations.g\u2026SPATH_CONFIGURATION_NAME)");
        DependencySet dependencySet = configuration.getAllDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependencySet, (String)"project.configurations.g\u2026ION_NAME).allDependencies");
        Iterable $this$any$iv = (Iterable)dependencySet;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            Dependency it = (Dependency)element$iv;
            boolean bl2 = false;
            Dependency dependency = it;
            Intrinsics.checkNotNullExpressionValue((Object)dependency, (String)"it");
            if (Intrinsics.areEqual((Object)"org.jetbrains.kotlin", (Object)dependency.getGroup())) {
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                if (Utils.isKotlinRuntime(string)) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IdeaDependency resolveRemote(@NotNull Project project, @NotNull String version, @NotNull String type, boolean sources, @NotNull List<String> extraDependencies) {
        void dependencyGroup;
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(extraDependencies, (String)"extraDependencies");
        String releaseType = Utils.releaseType(version);
        Utils.debug$default(this.context, "Adding IDE repository: " + this.repositoryUrl + '/' + releaseType, null, 4, null);
        Utils.debug$default(this.context, "Adding IDE dependency", null, 4, null);
        boolean hasSources = sources;
        if (Intrinsics.areEqual((Object)type, (Object)"IU")) {
            pair = TuplesKt.to((Object)"com.jetbrains.intellij.idea", (Object)"ideaIU");
        } else if (Intrinsics.areEqual((Object)type, (Object)"IC")) {
            pair = TuplesKt.to((Object)"com.jetbrains.intellij.idea", (Object)"ideaIC");
        } else if (Intrinsics.areEqual((Object)type, (Object)"CL")) {
            pair = TuplesKt.to((Object)"com.jetbrains.intellij.clion", (Object)"clion");
        } else if (Utils.isPyCharmType(type)) {
            pair = TuplesKt.to((Object)"com.jetbrains.intellij.pycharm", (Object)("pycharm" + type));
        } else if (Intrinsics.areEqual((Object)type, (Object)"GO")) {
            pair = TuplesKt.to((Object)"com.jetbrains.intellij.goland", (Object)"goland");
        } else if (Intrinsics.areEqual((Object)type, (Object)"RD")) {
            if (sources && Intrinsics.areEqual((Object)releaseType, (Object)"snapshots")) {
                Utils.warn$default(this.context, "IDE sources are not available for Rider SNAPSHOTS", null, 4, null);
                hasSources = false;
            }
            pair = TuplesKt.to((Object)"com.jetbrains.intellij.rider", (Object)"riderRD");
        } else if (Intrinsics.areEqual((Object)type, (Object)"GW")) {
            hasSources = false;
            pair = TuplesKt.to((Object)"com.jetbrains.gateway", (Object)"JetBrainsGateway");
        } else {
            throw (Throwable)new BuildException("Specified type '" + type + "' is unknown. Supported values: IC, IU, CL, PY, PC, GO, RD, GW", null);
        }
        Pair pair2 = pair;
        String string = (String)pair2.component1();
        String dependencyName = (String)pair2.component2();
        Object object = CollectionsKt.first(this.dependenciesDownloader.downloadFromRepository(this.context, (Function1<? super DependencyHandler, ? extends Dependency>)((Function1)new Function1<DependencyHandler, Dependency>((String)dependencyGroup, dependencyName, version){
            final /* synthetic */ String $dependencyGroup;
            final /* synthetic */ String $dependencyName;
            final /* synthetic */ String $version;

            @NotNull
            public final Dependency invoke(@NotNull DependencyHandler $this$downloadFromRepository) {
                Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$receiver");
                return (Dependency)DependencyHandlerExtensionsKt.create$default((DependencyHandler)$this$downloadFromRepository, (String)this.$dependencyGroup, (String)this.$dependencyName, (String)this.$version, null, null, null, (int)56, null);
            }
            {
                this.$dependencyGroup = string;
                this.$dependencyName = string2;
                this.$version = string3;
                super(1);
            }
        }), (Function1<? super RepositoryHandler, ? extends ArtifactRepository>)((Function1)new Function1<RepositoryHandler, ArtifactRepository>(this, releaseType){
            final /* synthetic */ IdeaDependencyManager this$0;
            final /* synthetic */ String $releaseType;

            @NotNull
            public final ArtifactRepository invoke(@NotNull RepositoryHandler $this$downloadFromRepository) {
                Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$receiver");
                return (ArtifactRepository)DependenciesDownloaderKt.mavenRepository($this$downloadFromRepository, IdeaDependencyManager.access$getRepositoryUrl$p(this.this$0) + '/' + this.$releaseType);
            }
            {
                this.this$0 = ideaDependencyManager;
                this.$releaseType = string;
                super(1);
            }
        })));
        File it = (File)object;
        boolean bl = false;
        Utils.debug$default(this.context, "IDE zip: " + it.getPath(), null, 4, null);
        File classesDirectory2 = this.unzipDependencyFile(this.getZipCacheDirectory(it, project, type), it, type, StringsKt.endsWith$default((String)version, (String)"-SNAPSHOT", (boolean)false, (int)2, null));
        Utils.info$default(this.context, "IDE dependency cache directory: " + classesDirectory2, null, 4, null);
        String buildNumber = Utils.ideBuildNumber(classesDirectory2);
        File sourcesDirectory = hasSources ? this.resolveSources(version, type) : null;
        Collection<IdeaExtraDependency> resolvedExtraDependencies = this.resolveExtraDependencies(project, version, extraDependencies);
        return this.createDependency(dependencyName, type, version, buildNumber, classesDirectory2, sourcesDirectory, project, resolvedExtraDependencies);
    }

    @NotNull
    public final IdeaDependency resolveLocal(@NotNull Project project, @NotNull String localPath, @Nullable String localPathSources) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        Utils.debug$default(this.context, "Adding local IDE dependency", null, 4, null);
        File ideaDir = Utils.ideaDir(localPath);
        if (!ideaDir.exists() || !ideaDir.isDirectory()) {
            throw (Throwable)new BuildException("Specified localPath '" + localPath + "' doesn't exist or is not a directory", null);
        }
        String buildNumber = Utils.ideBuildNumber(ideaDir);
        CharSequence charSequence = localPathSources;
        File sources = !(charSequence == null || charSequence.length() == 0) ? new File(localPathSources) : null;
        return this.createDependency("ideaLocal", null, buildNumber, buildNumber, ideaDir, sources, project, CollectionsKt.emptyList());
    }

    private final File getZipCacheDirectory(File zipFile, Project project, String type) {
        Object object = this.ideaDependencyCachePath;
        if (object.length() > 0) {
            Object $this$apply = object = new File(this.ideaDependencyCachePath);
            boolean bl = false;
            ((File)$this$apply).mkdirs();
            return object;
        }
        if (Intrinsics.areEqual((Object)type, (Object)"RD")) {
            OperatingSystem operatingSystem = OperatingSystem.current();
            Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"OperatingSystem.current()");
            if (operatingSystem.isWindows()) {
                File file = project.getBuildDir();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
                return file;
            }
        }
        File file = zipFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"zipFile.parentFile");
        return file;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<IdeaExtraDependency> resolveExtraDependencies(Project project, String version, List<String> extraDependencies) {
        void $this$filterTo$iv$iv;
        List $this$filter$iv;
        if (extraDependencies.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Utils.info$default(this.context, "Configuring IDE extra dependencies: " + extraDependencies, null, 4, null);
        Iterable iterable = extraDependencies;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block8: {
                String dep = (String)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = this.mainDependencies;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)dep)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it = $this$filter$iv = (List)destination$iv$iv;
        boolean bl = false;
        Collection collection = it;
        List list2 = !collection.isEmpty() ? $this$filter$iv : null;
        if (list2 != null) {
            it = $this$filter$iv = list2;
            boolean bl4 = false;
            throw (Throwable)new GradleException("The items '" + it + "' cannot be used as extra dependencies");
        }
        List resolvedExtraDependencies = new ArrayList();
        Iterable $this$forEach$iv = extraDependencies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl5 = false;
            if (this.resolveExtraDependency(project, version, it2) != null) {
                File file;
                File dependencyFile = file;
                boolean bl6 = false;
                IdeaExtraDependency extraDependency = new IdeaExtraDependency(it2, dependencyFile);
                Utils.debug$default(this.context, "IDE extra dependency '" + it2 + "' in '" + dependencyFile + "' files: " + extraDependency.getJarFiles(), null, 4, null);
                resolvedExtraDependencies.add(extraDependency);
                continue;
            }
            Utils.debug$default(this.context, "IDE extra dependency for '" + it2 + "' was resolved as null", null, 4, null);
        }
        return resolvedExtraDependencies;
    }

    private final File resolveExtraDependency(Project project, String version, String name) {
        try {
            String releaseType = Utils.releaseType(version);
            List<File> files2 = this.dependenciesDownloader.downloadFromRepository(this.context, (Function1<? super DependencyHandler, ? extends Dependency>)((Function1)new Function1<DependencyHandler, Dependency>(name, version){
                final /* synthetic */ String $name;
                final /* synthetic */ String $version;

                @NotNull
                public final Dependency invoke(@NotNull DependencyHandler $this$downloadFromRepository) {
                    Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$receiver");
                    return (Dependency)DependencyHandlerExtensionsKt.create$default((DependencyHandler)$this$downloadFromRepository, (String)"com.jetbrains.intellij.idea", (String)this.$name, (String)this.$version, null, null, null, (int)56, null);
                }
                {
                    this.$name = string;
                    this.$version = string2;
                    super(1);
                }
            }), (Function1<? super RepositoryHandler, ? extends ArtifactRepository>)((Function1)new Function1<RepositoryHandler, ArtifactRepository>(this, releaseType){
                final /* synthetic */ IdeaDependencyManager this$0;
                final /* synthetic */ String $releaseType;

                @NotNull
                public final ArtifactRepository invoke(@NotNull RepositoryHandler $this$downloadFromRepository) {
                    Intrinsics.checkNotNullParameter((Object)$this$downloadFromRepository, (String)"$receiver");
                    return (ArtifactRepository)DependenciesDownloaderKt.mavenRepository($this$downloadFromRepository, IdeaDependencyManager.access$getRepositoryUrl$p(this.this$0) + '/' + this.$releaseType);
                }
                {
                    this.this$0 = ideaDependencyManager;
                    this.$releaseType = string;
                    super(1);
                }
            }));
            if (files2.size() == 1) {
                File file;
                File depFile = (File)CollectionsKt.first(files2);
                String string = depFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"depFile.name");
                if (StringsKt.endsWith$default((String)string, (String)".zip", (boolean)false, (int)2, null)) {
                    File cacheDirectory = this.getZipCacheDirectory(depFile, project, "IC");
                    Utils.debug$default(this.context, "IDE extra dependency '" + name + "': " + cacheDirectory.getPath(), null, 4, null);
                    file = this.unzipDependencyFile(cacheDirectory, depFile, "IC", StringsKt.endsWith$default((String)version, (String)"-SNAPSHOT", (boolean)false, (int)2, null));
                } else {
                    Utils.debug$default(this.context, "IDE extra dependency '" + name + "': " + depFile.getPath(), null, 4, null);
                    file = depFile;
                }
                return file;
            }
            Utils.warn$default(this.context, "Cannot attach IDE extra dependency '" + name + "'. Found files: " + files2, null, 4, null);
        }
        catch (ResolveException e) {
            Utils.warn(this.context, "Cannot resolve IDE extra dependency '" + name + '\'', e);
        }
        return null;
    }

    @Inject
    public IdeaDependencyManager(@NotNull String repositoryUrl, @NotNull String ideaDependencyCachePath, @NotNull ArchiveUtils archiveUtils, @NotNull DependenciesDownloader dependenciesDownloader, @Nullable String context) {
        Intrinsics.checkNotNullParameter((Object)repositoryUrl, (String)"repositoryUrl");
        Intrinsics.checkNotNullParameter((Object)ideaDependencyCachePath, (String)"ideaDependencyCachePath");
        Intrinsics.checkNotNullParameter((Object)archiveUtils, (String)"archiveUtils");
        Intrinsics.checkNotNullParameter((Object)dependenciesDownloader, (String)"dependenciesDownloader");
        this.repositoryUrl = repositoryUrl;
        this.ideaDependencyCachePath = ideaDependencyCachePath;
        this.archiveUtils = archiveUtils;
        this.dependenciesDownloader = dependenciesDownloader;
        this.context = context;
        this.mainDependencies = CollectionsKt.listOf((Object[])new String[]{"ideaIC", "ideaIU", "riderRD", "riderRS"});
    }

    public static final /* synthetic */ String access$getRepositoryUrl$p(IdeaDependencyManager $this) {
        return $this.repositoryUrl;
    }

    public static final /* synthetic */ boolean access$isCacheUpToDate(IdeaDependencyManager $this, File zipFile, File markerFile, boolean checkVersion) {
        return $this.isCacheUpToDate(zipFile, markerFile, checkVersion);
    }

    public static final /* synthetic */ void access$resetExecutablePermissions(IdeaDependencyManager $this, File cacheDirectory, String type) {
        $this.resetExecutablePermissions(cacheDirectory, type);
    }

    public static final /* synthetic */ void access$storeCache(IdeaDependencyManager $this, File directoryToCache, File markerFile) {
        $this.storeCache(directoryToCache, markerFile);
    }
}

