/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.utils;

import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJN\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\b\u00112\u001d\u0010\u0012\u001a\u0019\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\n0\u000f\u00a2\u0006\u0002\b\u0011JL\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\b\u00112\u001b\b\u0002\u0010\u0012\u001a\u0015\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u000f\u00a2\u0006\u0002\b\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/intellij/utils/DependenciesDownloader;", "", "configurationContainer", "Lorg/gradle/api/artifacts/ConfigurationContainer;", "dependencyHandler", "Lorg/gradle/api/artifacts/dsl/DependencyHandler;", "repositoryHandler", "Lorg/gradle/api/artifacts/dsl/RepositoryHandler;", "(Lorg/gradle/api/artifacts/ConfigurationContainer;Lorg/gradle/api/artifacts/dsl/DependencyHandler;Lorg/gradle/api/artifacts/dsl/RepositoryHandler;)V", "downloadFromMultipleRepositories", "", "Ljava/io/File;", "context", "", "dependenciesBlock", "Lkotlin/Function1;", "Lorg/gradle/api/artifacts/Dependency;", "Lkotlin/ExtensionFunctionType;", "repositoriesBlock", "Lorg/gradle/api/artifacts/repositories/ArtifactRepository;", "downloadFromRepository", "gradle-intellij-plugin"})
public class DependenciesDownloader {
    @NotNull
    private final ConfigurationContainer configurationContainer;
    @NotNull
    private final DependencyHandler dependencyHandler;
    @NotNull
    private final RepositoryHandler repositoryHandler;

    @Inject
    public DependenciesDownloader(@NotNull ConfigurationContainer configurationContainer, @NotNull DependencyHandler dependencyHandler, @NotNull RepositoryHandler repositoryHandler) {
        Intrinsics.checkParameterIsNotNull((Object)configurationContainer, (String)"configurationContainer");
        Intrinsics.checkParameterIsNotNull((Object)dependencyHandler, (String)"dependencyHandler");
        Intrinsics.checkParameterIsNotNull((Object)repositoryHandler, (String)"repositoryHandler");
        this.configurationContainer = configurationContainer;
        this.dependencyHandler = dependencyHandler;
        this.repositoryHandler = repositoryHandler;
    }

    @NotNull
    public final List<File> downloadFromRepository(@Nullable String context, @NotNull Function1<? super DependencyHandler, ? extends Dependency> dependenciesBlock, @Nullable Function1<? super RepositoryHandler, ? extends ArtifactRepository> repositoriesBlock) {
        Intrinsics.checkParameterIsNotNull(dependenciesBlock, (String)"dependenciesBlock");
        return this.downloadFromMultipleRepositories(context, dependenciesBlock, (Function1<? super RepositoryHandler, ? extends List<? extends ArtifactRepository>>)((Function1)new Function1<RepositoryHandler, List<? extends ArtifactRepository>>(repositoriesBlock){
            final /* synthetic */ Function1<RepositoryHandler, ArtifactRepository> $repositoriesBlock;
            {
                this.$repositoriesBlock = $repositoriesBlock;
                super(1);
            }

            @NotNull
            public final List<ArtifactRepository> invoke(@NotNull RepositoryHandler $this$downloadFromMultipleRepositories) {
                Intrinsics.checkParameterIsNotNull((Object)$this$downloadFromMultipleRepositories, (String)"$this$downloadFromMultipleRepositories");
                Function1<RepositoryHandler, ArtifactRepository> function1 = this.$repositoriesBlock;
                return CollectionsKt.listOfNotNull(function1 == null ? null : (ArtifactRepository)function1.invoke((Object)$this$downloadFromMultipleRepositories));
            }
        }));
    }

    public static /* synthetic */ List downloadFromRepository$default(DependenciesDownloader dependenciesDownloader, String string, Function1 function1, Function1 function12, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: downloadFromRepository");
        }
        if ((n & 4) != 0) {
            function12 = null;
        }
        return dependenciesDownloader.downloadFromRepository(string, (Function1<? super DependencyHandler, ? extends Dependency>)function1, (Function1<? super RepositoryHandler, ? extends ArtifactRepository>)function12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<File> downloadFromMultipleRepositories(@Nullable String context, @NotNull Function1<? super DependencyHandler, ? extends Dependency> dependenciesBlock, @NotNull Function1<? super RepositoryHandler, ? extends List<? extends ArtifactRepository>> repositoriesBlock) {
        Intrinsics.checkParameterIsNotNull(dependenciesBlock, (String)"dependenciesBlock");
        Intrinsics.checkParameterIsNotNull(repositoriesBlock, (String)"repositoriesBlock");
        Dependency dependency = (Dependency)dependenciesBlock.invoke((Object)this.dependencyHandler);
        List repositories = CollectionsKt.plus((Collection)((Collection)repositoriesBlock.invoke((Object)this.repositoryHandler)), (Object)this.repositoryHandler.mavenCentral());
        try {
            Dependency[] dependencyArray = new Dependency[]{dependency};
            Collection collection = this.configurationContainer.detachedConfiguration(dependencyArray).getFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"configurationContainer.d\u2026uration(dependency).files");
            collection = CollectionsKt.toList((Iterable)collection);
            return collection;
        }
        catch (Exception e) {
            Utils.error(context, "Error when resolving dependency: " + dependency, e);
            throw e;
        }
        finally {
            this.repositoryHandler.removeAll((Collection)repositories);
        }
    }
}

