/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.utils;

import java.io.File;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KFunction;
import kotlin.text.StringsKt;
import org.gradle.api.Incubating;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.FileTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JL\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000e2\u0016\b\u0002\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0010H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/intellij/utils/ArchiveUtils;", "", "archiveOperations", "Lorg/gradle/api/file/ArchiveOperations;", "fileSystemOperations", "Lorg/gradle/api/file/FileSystemOperations;", "(Lorg/gradle/api/file/ArchiveOperations;Lorg/gradle/api/file/FileSystemOperations;)V", "extract", "Ljava/io/File;", "archiveFile", "targetDirectory", "context", "", "isUpToDate", "Ljava/util/function/Predicate;", "markUpToDate", "Ljava/util/function/BiConsumer;", "gradle-intellij-plugin"})
public class ArchiveUtils {
    @NotNull
    private final ArchiveOperations archiveOperations;
    @NotNull
    private final FileSystemOperations fileSystemOperations;

    @Inject
    public ArchiveUtils(@NotNull ArchiveOperations archiveOperations, @NotNull FileSystemOperations fileSystemOperations) {
        Intrinsics.checkParameterIsNotNull((Object)archiveOperations, (String)"archiveOperations");
        Intrinsics.checkParameterIsNotNull((Object)fileSystemOperations, (String)"fileSystemOperations");
        this.archiveOperations = archiveOperations;
        this.fileSystemOperations = fileSystemOperations;
    }

    @Incubating
    @NotNull
    public final File extract(@NotNull File archiveFile, @NotNull File targetDirectory, @Nullable String context, @Nullable Predicate<File> isUpToDate, @Nullable BiConsumer<File, File> markUpToDate) {
        KFunction kFunction;
        Intrinsics.checkParameterIsNotNull((Object)archiveFile, (String)"archiveFile");
        Intrinsics.checkParameterIsNotNull((Object)targetDirectory, (String)"targetDirectory");
        String name = archiveFile.getName();
        File markerFile = new File(targetDirectory, "markerFile");
        if (markerFile.exists() && (isUpToDate == null || isUpToDate.test(markerFile))) {
            return targetDirectory;
        }
        FilesKt.deleteRecursively((File)targetDirectory);
        targetDirectory.mkdirs();
        Utils.debug$default(context, "Extracting: " + name, null, 4, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"name");
        if (StringsKt.endsWith$default((String)name, (String)".zip", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)".sit", (boolean)false, (int)2, null)) {
            kFunction = (KFunction)new Function1<Object, FileTree>((Object)this.archiveOperations){

                public final FileTree invoke(Object p0) {
                    return ((ArchiveOperations)this.receiver).zipTree(p0);
                }

                @NotNull
                public final String getSignature() {
                    return "zipTree(Ljava/lang/Object;)Lorg/gradle/api/file/FileTree;";
                }

                @NotNull
                public final String getName() {
                    return "zipTree";
                }

                @NotNull
                public final KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(ArchiveOperations.class);
                }
            };
        } else if (StringsKt.endsWith$default((String)name, (String)".tar.gz", (boolean)false, (int)2, null)) {
            kFunction = (KFunction)new Function1<Object, FileTree>((Object)this.archiveOperations){

                public final FileTree invoke(Object p0) {
                    return ((ArchiveOperations)this.receiver).tarTree(p0);
                }

                @NotNull
                public final String getSignature() {
                    return "tarTree(Ljava/lang/Object;)Lorg/gradle/api/file/FileTree;";
                }

                @NotNull
                public final String getName() {
                    return "tarTree";
                }

                @NotNull
                public final KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(ArchiveOperations.class);
                }
            };
        } else {
            throw new IllegalArgumentException("Unknown type archive type: " + name);
        }
        KFunction decompressor2 = kFunction;
        this.fileSystemOperations.copy(arg_0 -> ArchiveUtils.extract$lambda-0(decompressor2, archiveFile, targetDirectory, arg_0));
        Utils.debug$default(context, "Extracted: " + name, null, 4, null);
        markerFile.createNewFile();
        BiConsumer<File, File> biConsumer = markUpToDate;
        if (biConsumer != null) {
            biConsumer.accept(targetDirectory, markerFile);
        }
        return targetDirectory;
    }

    public static /* synthetic */ File extract$default(ArchiveUtils archiveUtils, File file, File file2, String string, Predicate predicate, BiConsumer biConsumer, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: extract");
        }
        if ((n & 8) != 0) {
            predicate = null;
        }
        if ((n & 0x10) != 0) {
            biConsumer = null;
        }
        return archiveUtils.extract(file, file2, string, predicate, biConsumer);
    }

    private static final void extract$lambda-0(KFunction $decompressor, File $archiveFile, File $targetDirectory, CopySpec it) {
        Intrinsics.checkParameterIsNotNull((Object)$decompressor, (String)"$decompressor");
        Intrinsics.checkParameterIsNotNull((Object)$archiveFile, (String)"$archiveFile");
        Intrinsics.checkParameterIsNotNull((Object)$targetDirectory, (String)"$targetDirectory");
        Object[] objectArray = new Object[]{((Function1)$decompressor).invoke((Object)$archiveFile)};
        it.from(objectArray);
        it.into((Object)$targetDirectory);
    }
}

