/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.util.TeeOutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecSpec;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.internal.ExecException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.Version;
import org.jetbrains.intellij.jbr.JbrResolver;
import org.jetbrains.intellij.model.SpacePackagesMavenMetadata;
import org.jetbrains.intellij.model.SpacePackagesMavenMetadataVersioning;
import org.jetbrains.intellij.model.XmlExtractor;
import org.jetbrains.intellij.utils.ArchiveUtils;
import org.jetbrains.intellij.utils.DependenciesDownloader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Incubating
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 E2\u00020\u0001:\u0002EFB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u00109\u001a\b\u0012\u0004\u0012\u00020\u000b0:H\u0002J\u0006\u0010;\u001a\u00020<J\b\u0010=\u001a\u00020)H\u0002J\b\u0010>\u001a\u00020\u000bH\u0002J\b\u0010?\u001a\u00020\u000bH\u0002J\b\u0010@\u001a\u00020AH\u0007J\u0010\u0010B\u001a\u00020)2\u0006\u0010C\u001a\u00020\u000bH\u0002J\b\u0010D\u001a\u00020<H\u0002R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00118\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00158\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00158\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00118\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0013R\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00158\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0017R\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0\u00158\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0017R\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00118\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0013R\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00118\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0013R\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00158\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00118\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0013R\u001c\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00118\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0013R\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00118\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0013R\u001c\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00118\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0013R\u001c\u00101\u001a\b\u0012\u0004\u0012\u00020)0\u00118\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0013R\u001c\u00103\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00118\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u0013R\u001c\u00105\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00118\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u0013R\u001c\u00107\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00118\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u0013\u00a8\u0006G"}, d2={"Lorg/jetbrains/intellij/tasks/RunPluginVerifierTask;", "Lorg/gradle/api/internal/ConventionTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "execOperations", "Lorg/gradle/process/ExecOperations;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/process/ExecOperations;)V", "archiveUtils", "Lorg/jetbrains/intellij/utils/ArchiveUtils;", "kotlin.jvm.PlatformType", "context", "", "distributionFile", "Lorg/gradle/api/file/RegularFileProperty;", "getDistributionFile", "()Lorg/gradle/api/file/RegularFileProperty;", "downloadDir", "Lorg/gradle/api/provider/Property;", "getDownloadDir", "()Lorg/gradle/api/provider/Property;", "externalPrefixes", "Lorg/gradle/api/provider/ListProperty;", "getExternalPrefixes", "()Lorg/gradle/api/provider/ListProperty;", "failureLevel", "Lorg/jetbrains/intellij/tasks/RunPluginVerifierTask$FailureLevel;", "getFailureLevel", "ideDir", "Ljava/io/File;", "getIdeDir", "ideVersions", "getIdeVersions", "ides", "getIdes", "jbrVersion", "getJbrVersion", "jreRepository", "getJreRepository", "localPaths", "getLocalPaths", "offline", "", "getOffline", "productsReleasesFile", "getProductsReleasesFile", "runtimeDir", "getRuntimeDir", "subsystemsToCheck", "getSubsystemsToCheck", "teamCityOutputFormat", "getTeamCityOutputFormat", "verificationReportsDir", "getVerificationReportsDir", "verifierPath", "getVerifierPath", "verifierVersion", "getVerifierVersion", "getOptions", "", "ideDownloadDir", "Ljava/nio/file/Path;", "requiresJava11", "resolveRuntimeDir", "resolveVerifierPath", "runPluginVerifier", "", "validateRuntimeDir", "executable", "verifierHomeDir", "Companion", "FailureLevel", "gradle-intellij-plugin"})
public class RunPluginVerifierTask
extends ConventionTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ObjectFactory objectFactory;
    @NotNull
    private final ExecOperations execOperations;
    @Input
    @NotNull
    private final ListProperty<FailureLevel> failureLevel;
    @Input
    @Optional
    @NotNull
    private final Property<File> productsReleasesFile;
    @Input
    @Optional
    @NotNull
    private final ListProperty<String> ideVersions;
    @Input
    @NotNull
    private final ListProperty<File> ides;
    @Input
    @NotNull
    private final ListProperty<File> localPaths;
    @Input
    @Optional
    @NotNull
    private final Property<String> verifierVersion;
    @Input
    @Optional
    @NotNull
    private final Property<String> verifierPath;
    @InputFile
    @SkipWhenEmpty
    @NotNull
    private final RegularFileProperty distributionFile;
    @OutputDirectory
    @Optional
    @NotNull
    private final Property<String> verificationReportsDir;
    @Input
    @Optional
    @NotNull
    private final Property<String> downloadDir;
    @Input
    @Optional
    @NotNull
    private final Property<String> jbrVersion;
    @Input
    @Optional
    @NotNull
    private final Property<String> jreRepository;
    @Input
    @Optional
    @NotNull
    private final Property<String> runtimeDir;
    @Input
    @Optional
    @NotNull
    private final ListProperty<String> externalPrefixes;
    @Input
    @Optional
    @NotNull
    private final Property<Boolean> teamCityOutputFormat;
    @Input
    @Optional
    @NotNull
    private final Property<String> subsystemsToCheck;
    @Internal
    @NotNull
    private final Property<File> ideDir;
    @Internal
    @NotNull
    private final Property<Boolean> offline;
    private final ArchiveUtils archiveUtils;
    @NotNull
    private final String context;
    @NotNull
    private static final String METADATA_URL = "https://cache-redirector.jetbrains.com/packages.jetbrains.team/maven/p/intellij-plugin-verifier/intellij-plugin-verifier/org/jetbrains/intellij/plugins/verifier-cli/maven-metadata.xml";
    @NotNull
    private static final String IDE_DOWNLOAD_URL = "https://data.services.jetbrains.com/products/download";

    @Inject
    public RunPluginVerifierTask(@NotNull ObjectFactory objectFactory, @NotNull ExecOperations execOperations) {
        Intrinsics.checkParameterIsNotNull((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkParameterIsNotNull((Object)execOperations, (String)"execOperations");
        this.objectFactory = objectFactory;
        this.execOperations = execOperations;
        ListProperty listProperty = this.objectFactory.listProperty(FailureLevel.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)listProperty, (String)"objectFactory.listProper\u2026FailureLevel::class.java)");
        this.failureLevel = listProperty;
        listProperty = this.objectFactory.property(File.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)listProperty, (String)"objectFactory.property(File::class.java)");
        this.productsReleasesFile = listProperty;
        listProperty = this.objectFactory.listProperty(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)listProperty, (String)"objectFactory.listProperty(String::class.java)");
        this.ideVersions = listProperty;
        listProperty = this.objectFactory.listProperty(File.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)listProperty, (String)"objectFactory.listProperty(File::class.java)");
        this.ides = listProperty;
        listProperty = this.objectFactory.listProperty(File.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)listProperty, (String)"objectFactory.listProperty(File::class.java)");
        this.localPaths = listProperty;
        listProperty = this.objectFactory.property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)listProperty, (String)"objectFactory.property(String::class.java)");
        this.verifierVersion = listProperty;
        listProperty = this.objectFactory.property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)listProperty, (String)"objectFactory.property(String::class.java)");
        this.verifierPath = listProperty;
        listProperty = this.objectFactory.fileProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)listProperty, (String)"objectFactory.fileProperty()");
        this.distributionFile = listProperty;
        listProperty = this.objectFactory.property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)listProperty, (String)"objectFactory.property(String::class.java)");
        this.verificationReportsDir = listProperty;
        listProperty = this.objectFactory.property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)listProperty, (String)"objectFactory.property(String::class.java)");
        this.downloadDir = listProperty;
        listProperty = this.objectFactory.property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)listProperty, (String)"objectFactory.property(String::class.java)");
        this.jbrVersion = listProperty;
        listProperty = this.objectFactory.property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)listProperty, (String)"objectFactory.property(String::class.java)");
        this.jreRepository = listProperty;
        listProperty = this.objectFactory.property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)listProperty, (String)"objectFactory.property(String::class.java)");
        this.runtimeDir = listProperty;
        listProperty = this.objectFactory.listProperty(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)listProperty, (String)"objectFactory.listProperty(String::class.java)");
        this.externalPrefixes = listProperty;
        listProperty = this.objectFactory.property(Boolean.TYPE);
        Intrinsics.checkExpressionValueIsNotNull((Object)listProperty, (String)"objectFactory.property(Boolean::class.java)");
        this.teamCityOutputFormat = listProperty;
        listProperty = this.objectFactory.property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)listProperty, (String)"objectFactory.property(String::class.java)");
        this.subsystemsToCheck = listProperty;
        listProperty = this.objectFactory.property(File.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)listProperty, (String)"objectFactory.property(File::class.java)");
        this.ideDir = listProperty;
        listProperty = this.objectFactory.property(Boolean.TYPE);
        Intrinsics.checkExpressionValueIsNotNull((Object)listProperty, (String)"objectFactory.property(Boolean::class.java)");
        this.offline = listProperty;
        this.archiveUtils = (ArchiveUtils)this.objectFactory.newInstance(ArchiveUtils.class, new Object[0]);
        this.context = Utils.logCategory((Task)this);
    }

    @NotNull
    public final ListProperty<FailureLevel> getFailureLevel() {
        return this.failureLevel;
    }

    @NotNull
    public final Property<File> getProductsReleasesFile() {
        return this.productsReleasesFile;
    }

    @NotNull
    public final ListProperty<String> getIdeVersions() {
        return this.ideVersions;
    }

    @NotNull
    public final ListProperty<File> getIdes() {
        return this.ides;
    }

    @NotNull
    public final ListProperty<File> getLocalPaths() {
        return this.localPaths;
    }

    @NotNull
    public final Property<String> getVerifierVersion() {
        return this.verifierVersion;
    }

    @NotNull
    public final Property<String> getVerifierPath() {
        return this.verifierPath;
    }

    @NotNull
    public final RegularFileProperty getDistributionFile() {
        return this.distributionFile;
    }

    @NotNull
    public final Property<String> getVerificationReportsDir() {
        return this.verificationReportsDir;
    }

    @NotNull
    public final Property<String> getDownloadDir() {
        return this.downloadDir;
    }

    @NotNull
    public final Property<String> getJbrVersion() {
        return this.jbrVersion;
    }

    @NotNull
    public final Property<String> getJreRepository() {
        return this.jreRepository;
    }

    @NotNull
    public final Property<String> getRuntimeDir() {
        return this.runtimeDir;
    }

    @NotNull
    public final ListProperty<String> getExternalPrefixes() {
        return this.externalPrefixes;
    }

    @NotNull
    public final Property<Boolean> getTeamCityOutputFormat() {
        return this.teamCityOutputFormat;
    }

    @NotNull
    public final Property<String> getSubsystemsToCheck() {
        return this.subsystemsToCheck;
    }

    @NotNull
    public final Property<File> getIdeDir() {
        return this.ideDir;
    }

    @NotNull
    public final Property<Boolean> getOffline() {
        return this.offline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void runPluginVerifier() {
        void $this$mapNotNullTo$iv$iv;
        RegularFile file = (RegularFile)this.distributionFile.getOrNull();
        if (file == null || !file.getAsFile().exists()) {
            throw new IllegalStateException("Plugin file does not exist: " + file);
        }
        Object object = this.ides.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ides.get()");
        Collection collection = (Collection)object;
        object = this.localPaths.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"localPaths.get()");
        Iterable $this$mapNotNull$iv = CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object));
        boolean $i$f$mapNotNull = false;
        Object object2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            File p0 = (File)element$iv$iv;
            boolean bl2 = false;
            if (p0.getCanonicalPath() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List paths = (List)destination$iv$iv;
        if (paths.isEmpty()) {
            throw new GradleException("'ideVersions' and 'localPaths' properties should not be empty");
        }
        String verifierPath = this.resolveVerifierPath();
        List verifierArgs = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"check-plugin"), (Iterable)this.getOptions()), (Object)file.getAsFile().getCanonicalPath()), (Iterable)paths);
        Utils.debug$default(this.context, "Distribution file: " + file.getAsFile().getCanonicalPath(), null, 4, null);
        Utils.debug$default(this.context, "Verifier path: " + verifierPath, null, 4, null);
        object2 = new ByteArrayOutputStream();
        boolean bl = false;
        boolean bl6 = false;
        Throwable throwable = null;
        try {
            ByteArrayOutputStream os = (ByteArrayOutputStream)object2;
            boolean bl7 = false;
            try {
                this.execOperations.javaexec(arg_0 -> RunPluginVerifierTask.runPluginVerifier$lambda-2$lambda-0(this, verifierPath, verifierArgs, os, arg_0));
            }
            catch (ExecException e) {
                Utils.error$default(this.context, "Error during Plugin Verifier CLI execution:\n" + os, null, 4, null);
                throw e;
            }
            Utils.debug$default(this.context, "Current failure levels: " + ArraysKt.joinToString$default((Object[])FailureLevel.values(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null), null, 4, null);
            FailureLevel[] $this$forEach$iv = FailureLevel.values();
            boolean $i$f$forEach2 = false;
            FailureLevel[] failureLevelArray = $this$forEach$iv;
            int n = failureLevelArray.length;
            for (int i = 0; i < n; ++i) {
                FailureLevel element$iv;
                FailureLevel level = element$iv = failureLevelArray[i];
                boolean bl8 = false;
                if (!((List)this.getFailureLevel().get()).contains((Object)level)) continue;
                String string = os.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"os.toString()");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)level.getTestValue(), (boolean)false, (int)2, null)) continue;
                Utils.debug$default(this.context, "Failing task on '" + this.getFailureLevel() + "' failure level", null, 4, null);
                throw new GradleException(level.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
        }
    }

    private final String resolveVerifierPath() {
        String path = (String)this.verifierPath.getOrNull();
        if (path != null) {
            File verifier;
            CharSequence charSequence = path;
            boolean bl = false;
            if (charSequence.length() > 0 && (verifier = new File(path)).exists()) {
                return path;
            }
        }
        throw new InvalidUserDataException("Provided Plugin Verifier path doesn't exist: '" + path + "'. Downloading Plugin Verifier: " + this.verifierVersion);
    }

    private final String resolveRuntimeDir() {
        DependenciesDownloader dependenciesDownloader = (DependenciesDownloader)this.objectFactory.newInstance(DependenciesDownloader.class, new Object[0]);
        String string = (String)this.jreRepository.getOrNull();
        Object object = new Object[]{string == null ? "" : string, this.offline.get(), this.archiveUtils, dependenciesDownloader, this.context};
        JbrResolver jbrResolver = (JbrResolver)this.objectFactory.newInstance(JbrResolver.class, object);
        if ((object = jbrResolver.resolveRuntimeDir((String)this.runtimeDir.getOrNull(), (String)this.jbrVersion.getOrNull(), (File)this.ideDir.getOrNull(), (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull String p0) {
                Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
                return RunPluginVerifierTask.access$validateRuntimeDir((RunPluginVerifierTask)((Object)this.receiver), p0);
            }

            @NotNull
            public final String getSignature() {
                return "validateRuntimeDir(Ljava/lang/String;)Z";
            }

            @NotNull
            public final String getName() {
                return "validateRuntimeDir";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(RunPluginVerifierTask.class);
            }
        }))) == null) {
            throw new InvalidUserDataException(this.requiresJava11() ? "Java Runtime directory couldn't be resolved. Note: Plugin Verifier 1.260+ requires Java 11" : "Java Runtime directory couldn't be resolved");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean validateRuntimeDir(String executable) {
        boolean bl;
        Closeable closeable = new ByteArrayOutputStream();
        boolean bl2 = false;
        boolean bl3 = false;
        Throwable throwable = null;
        try {
            ByteArrayOutputStream os = (ByteArrayOutputStream)closeable;
            boolean bl4 = false;
            Utils.debug$default(this.context, "Plugin Verifier JRE verification: " + executable, null, 4, null);
            if (!this.requiresJava11()) {
                boolean bl5 = true;
                return bl5;
            }
            this.execOperations.exec(arg_0 -> RunPluginVerifierTask.validateRuntimeDir$lambda-4$lambda-3(executable, os, arg_0));
            String string = os.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"os.toString()");
            Version version = Version.Companion.parse(string);
            boolean result2 = version.compareTo(new Version(11, 0, 0, null, 14, null)) >= 0;
            bl = Utils.ifFalse(result2, (Function0<Unit>)((Function0)new Function0<Unit>(this, version, executable){
                final /* synthetic */ RunPluginVerifierTask this$0;
                final /* synthetic */ Version $version;
                final /* synthetic */ String $executable;
                {
                    this.this$0 = $receiver;
                    this.$version = $version;
                    this.$executable = $executable;
                    super(0);
                }

                public final void invoke() {
                    Utils.debug$default(RunPluginVerifierTask.access$getContext$p(this.this$0), "Plugin Verifier 1.260+ requires Java 11, but '" + this.$version + "' was provided with 'runtimeDir': " + this.$executable, null, 4, null);
                }
            }));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return bl;
    }

    private final boolean requiresJava11() {
        return Version.Companion.parse(Companion.resolveVerifierVersion((String)this.verifierVersion.getOrNull())).compareTo(new Version(1, 260, 0, null, 12, null)) >= 0;
    }

    private final List<String> getOptions() {
        Object object = new String[]{"-verification-reports-dir", (String)this.verificationReportsDir.get(), "-runtime-dir", this.resolveRuntimeDir()};
        List args = CollectionsKt.mutableListOf((Object[])object);
        Object object2 = this.externalPrefixes.get();
        boolean bl = false;
        boolean bl2 = false;
        Object it = object2;
        boolean bl3 = false;
        Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
        Collection collection = (Collection)it;
        boolean bl4 = false;
        object = (List)(!collection.isEmpty() ? object2 : null);
        if (object != null) {
            object2 = object;
            bl = false;
            bl2 = false;
            it = object2;
            boolean bl5 = false;
            args.add("-external-prefixes");
            args.add(CollectionsKt.joinToString$default((Iterable)((Iterable)it), (CharSequence)":", null, null, (int)0, null, null, (int)62, null));
        }
        object = this.teamCityOutputFormat.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"teamCityOutputFormat.get()");
        if (((Boolean)object).booleanValue()) {
            args.add("-team-city");
        }
        if (this.subsystemsToCheck.getOrNull() != null) {
            args.add("-subsystems-to-check");
            args.add(this.subsystemsToCheck.get());
        }
        object = this.offline.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"offline.get()");
        if (((Boolean)object).booleanValue()) {
            args.add("-offline");
        }
        return args;
    }

    private final Path verifierHomeDir() {
        Object object = System.getProperty("plugin.verifier.home.dir");
        if (object != null) {
            String string = object;
            boolean bl = false;
            boolean bl2 = false;
            String it = string;
            boolean bl3 = false;
            Path path = Paths.get(it, new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"get(it)");
            return path;
        }
        object = System.getProperty("user.home");
        if (object != null) {
            String string = object;
            boolean bl = false;
            boolean bl4 = false;
            String it = string;
            boolean bl5 = false;
            String[] stringArray = new String[]{".pluginVerifier"};
            Path path = Paths.get(it, stringArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"get(it, \".pluginVerifier\")");
            return path;
        }
        object = FileUtils.getTempDirectory().toPath().resolve(".pluginVerifier");
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getTempDirectory().toPat\u2026esolve(\".pluginVerifier\")");
        return object;
    }

    @NotNull
    public final Path ideDownloadDir() {
        Path path = this.verifierHomeDir().resolve("ides");
        boolean bl = false;
        boolean bl2 = false;
        Path it = path;
        boolean bl3 = false;
        Files.createDirectories(it, new FileAttribute[0]);
        Path path2 = path;
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"verifierHomeDir().resolv\u2026eateDirectories(it)\n    }");
        return path2;
    }

    private static final void runPluginVerifier$lambda-2$lambda-0(RunPluginVerifierTask this$0, String $verifierPath, List $verifierArgs, ByteArrayOutputStream $os, JavaExecSpec it) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkParameterIsNotNull((Object)$verifierPath, (String)"$verifierPath");
        Intrinsics.checkParameterIsNotNull((Object)$verifierArgs, (String)"$verifierArgs");
        Intrinsics.checkParameterIsNotNull((Object)$os, (String)"$os");
        Object[] objectArray = new Object[]{$verifierPath};
        it.setClasspath((FileCollection)this$0.objectFactory.fileCollection().from(objectArray));
        it.getMainClass().set((Object)"com.jetbrains.pluginverifier.PluginVerifierMain");
        it.setArgs($verifierArgs);
        it.setStandardOutput((OutputStream)new TeeOutputStream((OutputStream)System.out, (OutputStream)$os));
    }

    private static final void validateRuntimeDir$lambda-4$lambda-3(String $executable, ByteArrayOutputStream $os, ExecSpec it) {
        Intrinsics.checkParameterIsNotNull((Object)$executable, (String)"$executable");
        Intrinsics.checkParameterIsNotNull((Object)$os, (String)"$os");
        it.setExecutable($executable);
        it.setArgs(CollectionsKt.listOf((Object)"-version"));
        it.setErrorOutput((OutputStream)$os);
    }

    public static final /* synthetic */ boolean access$validateRuntimeDir(RunPluginVerifierTask $this, String executable) {
        return $this.validateRuntimeDir(executable);
    }

    public static final /* synthetic */ String access$getContext$p(RunPluginVerifierTask $this) {
        return $this.context;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jm\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00042K\u0010\u000b\u001aG\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\t0\fJ(\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0004J\u0006\u0010\u0013\u001a\u00020\u0004J\u0010\u0010\u0014\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/intellij/tasks/RunPluginVerifierTask$Companion;", "", "()V", "IDE_DOWNLOAD_URL", "", "METADATA_URL", "resolveIdePath", "ideVersion", "downloadDir", "Ljava/io/File;", "context", "block", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "type", "version", "buildType", "resolveIdeUrl", "resolveLatestVersion", "resolveVerifierVersion", "versionParameterName", "gradle-intellij-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String resolveLatestVersion() {
            String string;
            Utils.debug$default(null, "Resolving latest Plugin Verifier version", null, 5, null);
            URL url = new URL(RunPluginVerifierTask.METADATA_URL);
            XmlExtractor xmlExtractor = new XmlExtractor();
            InputStream inputStream = url.openStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"url.openStream()");
            SpacePackagesMavenMetadataVersioning spacePackagesMavenMetadataVersioning = ((SpacePackagesMavenMetadata)xmlExtractor.unmarshal(inputStream)).getVersioning();
            String string2 = string = spacePackagesMavenMetadataVersioning == null ? null : spacePackagesMavenMetadataVersioning.getLatest();
            if (string == null) {
                throw new GradleException("Cannot resolve the latest Plugin Verifier version");
            }
            return string;
        }

        @NotNull
        public final String resolveVerifierVersion(@Nullable String version) {
            String string;
            String string2 = version;
            if (string2 == null) {
                string = null;
            } else {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                string = !Intrinsics.areEqual((Object)it, (Object)"latest") ? string3 : null;
            }
            String string4 = string;
            return string4 == null ? this.resolveLatestVersion() : string4;
        }

        @NotNull
        public final String resolveIdePath(@NotNull String ideVersion, @NotNull File downloadDir, @Nullable String context, @NotNull Function3<? super String, ? super String, ? super String, ? extends File> block) {
            String name;
            File ideDir;
            Intrinsics.checkParameterIsNotNull((Object)ideVersion, (String)"ideVersion");
            Intrinsics.checkParameterIsNotNull((Object)downloadDir, (String)"downloadDir");
            Intrinsics.checkParameterIsNotNull(block, (String)"block");
            Utils.debug$default(context, "Resolving IDE path for: " + ideVersion, null, 4, null);
            Object object = ideVersion;
            boolean bl = false;
            CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
            object = new char[1];
            object[0] = 45;
            List list2 = CollectionsKt.plus((Collection)StringsKt.split$default((CharSequence)charSequence, (char[])object, (boolean)false, (int)2, (int)2, null), null);
            String type = null;
            List list3 = list2;
            boolean bl2 = false;
            type = (String)list3.get(0);
            String version = null;
            List list4 = list2;
            boolean bl3 = false;
            version = (String)list4.get(1);
            if (version == null) {
                Utils.debug$default(context, "IDE type not specified, setting type to IC", null, 4, null);
                version = type;
                type = "IC";
            }
            if ((ideDir = FilesKt.resolve((File)downloadDir, (String)(name = type + "-" + version))).exists()) {
                Utils.debug$default(context, "IDE already available in: " + ideDir, null, 4, null);
                String string = ideDir.getCanonicalPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ideDir.canonicalPath");
                return string;
            }
            Object[] objectArray = new String[]{"release", "rc", "eap", "beta"};
            Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String buildType = (String)element$iv;
                boolean bl4 = false;
                Utils.debug$default(context, "Downloading IDE '" + type + "-" + version + "' from '" + buildType + "' channel to: " + downloadDir, null, 4, null);
                try {
                    String string = type;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    String string2 = version;
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    String string3 = ((File)block.invoke((Object)string, (Object)string2, (Object)buildType)).getAbsolutePath();
                    boolean bl5 = false;
                    boolean bl6 = false;
                    String it = string3;
                    boolean bl7 = false;
                    Utils.debug$default(context, "Resolved IDE '" + type + "-" + version + "' path: " + it, null, 4, null);
                    String string4 = string3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"block(type!!, version!!,\u2026t\")\n                    }");
                    return string4;
                }
                catch (IOException e) {
                    Utils.debug(context, "Cannot download IDE '" + type + "-" + version + "' from '" + buildType + "' channel. Trying another channel...", e);
                }
            }
            throw new GradleException("IDE '" + ideVersion + "' cannot be downloaded. Please verify the specified IDE version against the products available for testing: https://jb.gg/intellij-platform-builds-list");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String resolveIdeUrl(@NotNull String type, @NotNull String version, @NotNull String buildType, @Nullable String context) {
            Object redirectUrl;
            HttpURLConnection connection;
            String url;
            block7: {
                Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
                Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
                Intrinsics.checkParameterIsNotNull((Object)buildType, (String)"buildType");
                url = "https://data.services.jetbrains.com/products/download?code=" + type + "&platform=linux&type=" + buildType + "&" + this.versionParameterName(version) + "=" + version;
                Utils.debug$default(context, "Resolving direct IDE download URL for: " + url, null, 4, null);
                connection = null;
                URLConnection uRLConnection = new URL(url).openConnection();
                if (uRLConnection == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
                }
                connection = (HttpURLConnection)uRLConnection;
                connection.setInstanceFollowRedirects(false);
                connection.getInputStream();
                if (connection.getResponseCode() != 301 && connection.getResponseCode() != 302) break block7;
                redirectUrl = new URL(connection.getHeaderField("Location"));
                connection.disconnect();
                Utils.debug$default(context, "Resolved IDE download URL: " + url, null, 4, null);
                String string = "https://cache-redirector.jetbrains.com/" + ((URL)redirectUrl).getHost() + ((URL)redirectUrl).getFile();
                HttpURLConnection httpURLConnection = connection;
                httpURLConnection.disconnect();
                return string;
            }
            try {
                Utils.debug$default(context, "IDE download URL has no redirection provided. Skipping", null, 4, null);
                redirectUrl = connection;
                ((HttpURLConnection)redirectUrl).disconnect();
            }
            catch (Exception e) {
                try {
                    Utils.info$default(context, "Cannot resolve direct download URL for: " + url, null, 4, null);
                    Utils.debug(context, "Download exception stacktrace:", e);
                    throw e;
                }
                catch (Throwable throwable) {
                    HttpURLConnection httpURLConnection = connection;
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                    throw throwable;
                }
            }
            return url;
        }

        private final String versionParameterName(String version) {
            CharSequence charSequence = version;
            String string = "\\d{3}(\\.\\d+)+";
            boolean bl = false;
            string = new Regex(string);
            bl = false;
            return string.matches(charSequence) ? "build" : "version";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0086\u0001\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0012B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/intellij/tasks/RunPluginVerifierTask$FailureLevel;", "", "testValue", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getTestValue", "()Ljava/lang/String;", "COMPATIBILITY_WARNINGS", "COMPATIBILITY_PROBLEMS", "DEPRECATED_API_USAGES", "EXPERIMENTAL_API_USAGES", "INTERNAL_API_USAGES", "OVERRIDE_ONLY_API_USAGES", "NON_EXTENDABLE_API_USAGES", "PLUGIN_STRUCTURE_WARNINGS", "MISSING_DEPENDENCIES", "INVALID_PLUGIN", "NOT_DYNAMIC", "Companion", "gradle-intellij-plugin"})
    public static final class FailureLevel
    extends Enum<FailureLevel> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String testValue;
        @NotNull
        private static final EnumSet<FailureLevel> ALL;
        @NotNull
        private static final EnumSet<FailureLevel> NONE;
        public static final /* enum */ FailureLevel COMPATIBILITY_WARNINGS;
        public static final /* enum */ FailureLevel COMPATIBILITY_PROBLEMS;
        public static final /* enum */ FailureLevel DEPRECATED_API_USAGES;
        public static final /* enum */ FailureLevel EXPERIMENTAL_API_USAGES;
        public static final /* enum */ FailureLevel INTERNAL_API_USAGES;
        public static final /* enum */ FailureLevel OVERRIDE_ONLY_API_USAGES;
        public static final /* enum */ FailureLevel NON_EXTENDABLE_API_USAGES;
        public static final /* enum */ FailureLevel PLUGIN_STRUCTURE_WARNINGS;
        public static final /* enum */ FailureLevel MISSING_DEPENDENCIES;
        public static final /* enum */ FailureLevel INVALID_PLUGIN;
        public static final /* enum */ FailureLevel NOT_DYNAMIC;
        private static final /* synthetic */ FailureLevel[] $VALUES;

        private FailureLevel(String testValue) {
            this.testValue = testValue;
        }

        @NotNull
        public final String getTestValue() {
            return this.testValue;
        }

        public static FailureLevel[] values() {
            return (FailureLevel[])$VALUES.clone();
        }

        public static FailureLevel valueOf(String value) {
            return Enum.valueOf(FailureLevel.class, value);
        }

        static {
            COMPATIBILITY_WARNINGS = new FailureLevel("Compatibility warnings");
            COMPATIBILITY_PROBLEMS = new FailureLevel("Compatibility problems");
            DEPRECATED_API_USAGES = new FailureLevel("Deprecated API usages");
            EXPERIMENTAL_API_USAGES = new FailureLevel("Experimental API usages");
            INTERNAL_API_USAGES = new FailureLevel("Internal API usages");
            OVERRIDE_ONLY_API_USAGES = new FailureLevel("Override-only API usages");
            NON_EXTENDABLE_API_USAGES = new FailureLevel("Non-extendable API usages");
            PLUGIN_STRUCTURE_WARNINGS = new FailureLevel("Plugin structure warnings");
            MISSING_DEPENDENCIES = new FailureLevel("Missing dependencies");
            INVALID_PLUGIN = new FailureLevel("The following files specified for the verification are not valid plugins");
            NOT_DYNAMIC = new FailureLevel("Plugin cannot be loaded/unloaded without IDE restart");
            $VALUES = failureLevelArray = new FailureLevel[]{FailureLevel.COMPATIBILITY_WARNINGS, FailureLevel.COMPATIBILITY_PROBLEMS, FailureLevel.DEPRECATED_API_USAGES, FailureLevel.EXPERIMENTAL_API_USAGES, FailureLevel.INTERNAL_API_USAGES, FailureLevel.OVERRIDE_ONLY_API_USAGES, FailureLevel.NON_EXTENDABLE_API_USAGES, FailureLevel.PLUGIN_STRUCTURE_WARNINGS, FailureLevel.MISSING_DEPENDENCIES, FailureLevel.INVALID_PLUGIN, FailureLevel.NOT_DYNAMIC};
            Companion = new Companion(null);
            EnumSet<FailureLevel> enumSet = EnumSet.allOf(FailureLevel.class);
            Intrinsics.checkExpressionValueIsNotNull(enumSet, (String)"allOf(FailureLevel::class.java)");
            ALL = enumSet;
            enumSet = EnumSet.noneOf(FailureLevel.class);
            Intrinsics.checkExpressionValueIsNotNull(enumSet, (String)"noneOf(FailureLevel::class.java)");
            NONE = enumSet;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/intellij/tasks/RunPluginVerifierTask$FailureLevel$Companion;", "", "()V", "ALL", "Ljava/util/EnumSet;", "Lorg/jetbrains/intellij/tasks/RunPluginVerifierTask$FailureLevel;", "getALL", "()Ljava/util/EnumSet;", "NONE", "getNONE", "gradle-intellij-plugin"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final EnumSet<FailureLevel> getALL() {
                return ALL;
            }

            @NotNull
            public final EnumSet<FailureLevel> getNONE() {
                return NONE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

