/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.Version;
import org.jetbrains.intellij.model.SpacePackagesMavenMetadata;
import org.jetbrains.intellij.model.SpacePackagesMavenMetadataVersioning;
import org.jetbrains.intellij.model.XmlExtractor;
import org.jetbrains.intellij.utils.ArchiveUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0007R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/intellij/tasks/DownloadRobotServerPluginTask;", "Lorg/gradle/api/internal/ConventionTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "archiveUtils", "Lorg/jetbrains/intellij/utils/ArchiveUtils;", "kotlin.jvm.PlatformType", "context", "", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "pluginArchive", "Lorg/gradle/api/provider/Property;", "Ljava/io/File;", "getPluginArchive", "()Lorg/gradle/api/provider/Property;", "version", "getVersion", "downloadPlugin", "", "Companion", "gradle-intellij-plugin"})
public class DownloadRobotServerPluginTask
extends ConventionTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Input
    @NotNull
    private final Property<String> version;
    @Input
    @NotNull
    private final Property<File> pluginArchive;
    @OutputDirectory
    @NotNull
    private final DirectoryProperty outputDir;
    private final ArchiveUtils archiveUtils;
    @NotNull
    private final String context;
    @NotNull
    private static final String METADATA_URL = "https://cache-redirector.jetbrains.com/intellij-dependencies/com/intellij/remoterobot/robot-server-plugin/maven-metadata.xml";
    @NotNull
    private static final String OLD_ROBOT_SERVER_DEPENDENCY = "org.jetbrains.test:robot-server-plugin";
    @NotNull
    private static final String NEW_ROBOT_SERVER_DEPENDENCY = "com.intellij.remoterobot:robot-server-plugin";
    @NotNull
    private static final String NEW_ROBOT_SERVER_VERSION = "0.11.0";

    @Inject
    public DownloadRobotServerPluginTask(@NotNull ObjectFactory objectFactory) {
        Intrinsics.checkParameterIsNotNull((Object)objectFactory, (String)"objectFactory");
        Property property = objectFactory.property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property, (String)"objectFactory.property(String::class.java)");
        this.version = property;
        property = objectFactory.property(File.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property, (String)"objectFactory.property(File::class.java)");
        this.pluginArchive = property;
        property = objectFactory.directoryProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)property, (String)"objectFactory.directoryProperty()");
        this.outputDir = property;
        this.archiveUtils = (ArchiveUtils)objectFactory.newInstance(ArchiveUtils.class, new Object[0]);
        this.context = Utils.logCategory((Task)this);
    }

    @NotNull
    public final Property<String> getVersion() {
        return this.version;
    }

    @NotNull
    public final Property<File> getPluginArchive() {
        return this.pluginArchive;
    }

    @NotNull
    public final DirectoryProperty getOutputDir() {
        return this.outputDir;
    }

    @TaskAction
    public final void downloadPlugin() {
        File target = ((Directory)this.outputDir.get()).getAsFile();
        Object object = this.archiveUtils;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"archiveUtils");
        ArchiveUtils archiveUtils = object;
        object = this.pluginArchive.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"pluginArchive.get()");
        File file = (File)object;
        Intrinsics.checkExpressionValueIsNotNull((Object)target, (String)"target");
        ArchiveUtils.extract$default(archiveUtils, file, target, this.context, null, null, 24, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004J\u0006\u0010\n\u001a\u00020\u0004J\u0010\u0010\u000b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/intellij/tasks/DownloadRobotServerPluginTask$Companion;", "", "()V", "METADATA_URL", "", "NEW_ROBOT_SERVER_DEPENDENCY", "NEW_ROBOT_SERVER_VERSION", "OLD_ROBOT_SERVER_DEPENDENCY", "getDependency", "version", "resolveLatestVersion", "resolveVersion", "gradle-intellij-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String resolveLatestVersion() {
            String string;
            Utils.debug$default(null, "Resolving latest Robot Server Plugin version", null, 5, null);
            URL url = new URL(DownloadRobotServerPluginTask.METADATA_URL);
            XmlExtractor xmlExtractor = new XmlExtractor();
            InputStream inputStream = url.openStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"url.openStream()");
            SpacePackagesMavenMetadataVersioning spacePackagesMavenMetadataVersioning = ((SpacePackagesMavenMetadata)xmlExtractor.unmarshal(inputStream)).getVersioning();
            String string2 = string = spacePackagesMavenMetadataVersioning == null ? null : spacePackagesMavenMetadataVersioning.getLatest();
            if (string == null) {
                throw new GradleException("Cannot resolve the latest Robot Server Plugin version");
            }
            return string;
        }

        @NotNull
        public final String resolveVersion(@Nullable String version) {
            String string;
            String string2 = version;
            if (string2 == null) {
                string = null;
            } else {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                string = !Intrinsics.areEqual((Object)it, (Object)"latest") ? string3 : null;
            }
            String string4 = string;
            return string4 == null ? this.resolveLatestVersion() : string4;
        }

        @NotNull
        public final String getDependency(@NotNull String version) {
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            return Version.Companion.parse(version).compareTo(Version.Companion.parse(DownloadRobotServerPluginTask.NEW_ROBOT_SERVER_VERSION)) >= 0 ? DownloadRobotServerPluginTask.NEW_ROBOT_SERVER_DEPENDENCY : DownloadRobotServerPluginTask.OLD_ROBOT_SERVER_DEPENDENCY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

