/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import com.jetbrains.plugin.structure.intellij.repository.CustomPluginRepositoryListingParser;
import com.jetbrains.plugin.structure.intellij.repository.CustomPluginRepositoryListingType;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.PluginDependencyNotation;
import org.jetbrains.intellij.dependency.PluginsRepository;
import org.jetbrains.intellij.utils.DependenciesDownloader;
import org.jetbrains.intellij.utils.DependenciesDownloaderKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0002J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J$\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\"\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/intellij/dependency/CustomPluginsRepository;", "Lorg/jetbrains/intellij/dependency/PluginsRepository;", "repositoryUrl", "", "(Ljava/lang/String;)V", "pluginsXmlUri", "Ljava/net/URI;", "downloadZipArtifact", "Ljava/io/File;", "project", "Lorg/gradle/api/Project;", "url", "Ljava/net/URL;", "plugin", "Lorg/jetbrains/intellij/dependency/PluginDependencyNotation;", "context", "postResolve", "", "resolve", "resolveDownloadUrl", "type", "Lcom/jetbrains/plugin/structure/intellij/repository/CustomPluginRepositoryListingType;", "gradle-intellij-plugin"})
public final class CustomPluginsRepository
implements PluginsRepository {
    @NotNull
    private final URI pluginsXmlUri;
    @NotNull
    private final String repositoryUrl;

    /*
     * WARNING - void declaration
     */
    public CustomPluginsRepository(@NotNull String repositoryUrl) {
        Intrinsics.checkParameterIsNotNull((Object)repositoryUrl, (String)"repositoryUrl");
        URI uri = new URI(repositoryUrl);
        Object object = uri.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"uri.path");
        if (StringsKt.endsWith$default((String)object, (String)".xml", (boolean)false, (int)2, null)) {
            object = repositoryUrl;
            int n = 0;
            int n2 = StringsKt.lastIndexOf$default((CharSequence)repositoryUrl, (char)'/', (int)0, (boolean)false, (int)6, null);
            boolean bl = false;
            String string = ((String)object).substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            this.repositoryUrl = string;
            this.pluginsXmlUri = uri;
        } else {
            void $this$_init__u24lambda_u2d0;
            this.repositoryUrl = repositoryUrl;
            URI uRI = uri;
            boolean bl = false;
            boolean bl2 = false;
            URI uRI2 = uRI;
            CustomPluginsRepository customPluginsRepository = this;
            boolean bl3 = false;
            URI uRI3 = new URI($this$_init__u24lambda_u2d0.getScheme(), $this$_init__u24lambda_u2d0.getUserInfo(), $this$_init__u24lambda_u2d0.getHost(), $this$_init__u24lambda_u2d0.getPort(), $this$_init__u24lambda_u2d0.getPath() + "/", $this$_init__u24lambda_u2d0.getQuery(), $this$_init__u24lambda_u2d0.getFragment()).resolve("updatePlugins.xml");
            object = uRI3;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"uri.run { URI(scheme, us\u2026ve(\"updatePlugins.xml\") }");
            customPluginsRepository.pluginsXmlUri = object;
        }
    }

    @Override
    @Nullable
    public File resolve(@NotNull Project project, @NotNull PluginDependencyNotation plugin, @Nullable String context) {
        URL uRL;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)plugin, (String)"plugin");
        Utils.debug$default(context, "Loading list of plugins from: " + this.pluginsXmlUri, null, 4, null);
        URL url = this.pluginsXmlUri.toURL();
        Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"url");
        URL uRL2 = this.resolveDownloadUrl(url, plugin, CustomPluginRepositoryListingType.PLUGIN_REPOSITORY);
        if (uRL2 == null) {
            URL uRL3 = this.resolveDownloadUrl(url, plugin, CustomPluginRepositoryListingType.SIMPLE);
            if (uRL3 == null) {
                return null;
            }
            uRL = uRL3;
        } else {
            uRL = uRL2;
        }
        URL downloadUrl = uRL;
        return this.downloadZipArtifact(project, downloadUrl, plugin, context);
    }

    private final URL resolveDownloadUrl(URL url, PluginDependencyNotation plugin, CustomPluginRepositoryListingType type) {
        Object v0;
        block1: {
            Object object = url;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = TextStreamsKt.readBytes((URL)object);
            boolean bl2 = false;
            boolean bl3 = false;
            object = CustomPluginRepositoryListingParser.INSTANCE.parseListOfPlugins(new String(byArray, charset), url, new URL(this.repositoryUrl), type);
            boolean bl4 = false;
            Object object2 = object;
            boolean bl5 = false;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                CustomPluginRepositoryListingParser.PluginInfo it = (CustomPluginRepositoryListingParser.PluginInfo)t;
                boolean bl6 = false;
                if (!(StringsKt.equals((String)it.getPluginId(), (String)plugin.getId(), (boolean)true) && StringsKt.equals((String)it.getVersion(), (String)plugin.getVersion(), (boolean)true))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        CustomPluginRepositoryListingParser.PluginInfo pluginInfo = v0;
        return pluginInfo == null ? null : pluginInfo.getDownloadUrl();
    }

    private final File downloadZipArtifact(Project project, URL url, PluginDependencyNotation plugin, String context) {
        return (File)CollectionsKt.first(((DependenciesDownloader)project.getObjects().newInstance(DependenciesDownloader.class, new Object[0])).downloadFromRepository(context, (Function1<? super DependencyHandler, ? extends Dependency>)((Function1)new Function1<DependencyHandler, Dependency>(plugin){
            final /* synthetic */ PluginDependencyNotation $plugin;
            {
                this.$plugin = $plugin;
                super(1);
            }

            @NotNull
            public final Dependency invoke(@NotNull DependencyHandler $this$downloadFromRepository) {
                Intrinsics.checkParameterIsNotNull((Object)$this$downloadFromRepository, (String)"$this$downloadFromRepository");
                return DependenciesDownloaderKt.create$default($this$downloadFromRepository, "com.jetbrains.plugins", this.$plugin.getId(), this.$plugin.getVersion(), null, "zip", null, 40, null);
            }
        }), (Function1<? super RepositoryHandler, ? extends ArtifactRepository>)((Function1)new Function1<RepositoryHandler, ArtifactRepository>(url){
            final /* synthetic */ URL $url;
            {
                this.$url = $url;
                super(1);
            }

            @NotNull
            public final ArtifactRepository invoke(@NotNull RepositoryHandler $this$downloadFromRepository) {
                Intrinsics.checkParameterIsNotNull((Object)$this$downloadFromRepository, (String)"$this$downloadFromRepository");
                String string = this.$url.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toString()");
                IvyArtifactRepository ivyArtifactRepository = DependenciesDownloaderKt.ivyRepository$default($this$downloadFromRepository, string, null, 2, null);
                Intrinsics.checkExpressionValueIsNotNull((Object)ivyArtifactRepository, (String)"ivyRepository(url.toString())");
                return (ArtifactRepository)ivyArtifactRepository;
            }
        })));
    }

    @Override
    public void postResolve(@NotNull Project project, @Nullable String context) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
    }
}

