/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.model;

import com.jetbrains.plugin.structure.intellij.utils.JDOMUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jdom2.Document;
import org.jdom2.transform.JDOMSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.model.XmlExtractor;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001b\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018R#\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/intellij/model/XmlExtractor;", "T", "", "()V", "jaxbContext", "Ljavax/xml/bind/JAXBContext;", "kotlin.jvm.PlatformType", "getJaxbContext", "()Ljavax/xml/bind/JAXBContext;", "jaxbContext$delegate", "Lkotlin/Lazy;", "marshal", "", "bean", "file", "Ljava/io/File;", "(Ljava/lang/Object;Ljava/io/File;)V", "unmarshal", "(Ljava/io/File;)Ljava/lang/Object;", "inputStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)Ljava/lang/Object;", "document", "Lorg/jdom2/Document;", "(Lorg/jdom2/Document;)Ljava/lang/Object;", "gradle-intellij-plugin"})
public final class XmlExtractor<T> {
    @NotNull
    private final Lazy jaxbContext$delegate = LazyKt.lazy((Function0)jaxbContext.2.INSTANCE);

    private final JAXBContext getJaxbContext() {
        Lazy lazy = this.jaxbContext$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (JAXBContext)lazy.getValue();
    }

    public final T unmarshal(@NotNull File file) throws JAXBException {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        File file2 = file;
        boolean bl = false;
        return this.unmarshal(new FileInputStream(file2));
    }

    public final T unmarshal(@NotNull InputStream inputStream) throws JAXBException {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        Document document = JDOMUtil.loadDocument((InputStream)inputStream);
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"loadDocument(inputStream)");
        return this.unmarshal(document);
    }

    public final T unmarshal(@NotNull Document document) throws JAXBException {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        return (T)this.getJaxbContext().createUnmarshaller().unmarshal((Source)new JDOMSource(document));
    }

    public final void marshal(T bean, @NotNull File file) throws JAXBException {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.getJaxbContext().createMarshaller().marshal(bean, file);
        File file2 = file;
        boolean bl = false;
        Document document = JDOMUtil.loadDocument((InputStream)new FileInputStream(file2));
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"loadDocument(file.inputStream())");
        Document document2 = document;
        Utils.transformXml(document2, file);
    }
}

