/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.jbr;

import java.io.File;
import java.io.FileReader;
import java.nio.file.Path;
import java.util.Properties;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Incubating;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.os.OperatingSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.Version;
import org.jetbrains.intellij.jbr.Jbr;
import org.jetbrains.intellij.jbr.JbrResolver;
import org.jetbrains.intellij.utils.ArchiveUtils;
import org.jetbrains.intellij.utils.DependenciesDownloader;
import org.jetbrains.intellij.utils.DependenciesDownloaderKt;

@Incubating
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001:\u0001'B1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003JQ\u0010\u001e\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u00122#\b\u0002\u0010\"\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0004\u0012\u00020\u00050#R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/intellij/jbr/JbrResolver;", "", "jreRepository", "", "isOffline", "", "archiveUtils", "Lorg/jetbrains/intellij/utils/ArchiveUtils;", "dependenciesDownloader", "Lorg/jetbrains/intellij/utils/DependenciesDownloader;", "context", "(Ljava/lang/String;ZLorg/jetbrains/intellij/utils/ArchiveUtils;Lorg/jetbrains/intellij/utils/DependenciesDownloader;Ljava/lang/String;)V", "operatingSystem", "Lorg/gradle/internal/os/OperatingSystem;", "kotlin.jvm.PlatformType", "findJavaExecutable", "Ljava/nio/file/Path;", "javaHome", "Ljava/io/File;", "fromDir", "Lorg/jetbrains/intellij/jbr/Jbr;", "javaDir", "version", "getBuiltinJbrVersion", "ideDirectory", "getJavaArchive", "jbrArtifact", "Lorg/jetbrains/intellij/jbr/JbrResolver$JbrArtifact;", "getJbrRoot", "resolve", "resolveRuntimeDir", "runtimeDir", "jbrVersion", "ideDir", "validate", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "executable", "JbrArtifact", "gradle-intellij-plugin"})
public class JbrResolver {
    @NotNull
    private final String jreRepository;
    private final boolean isOffline;
    @NotNull
    private final ArchiveUtils archiveUtils;
    @NotNull
    private final DependenciesDownloader dependenciesDownloader;
    @Nullable
    private final String context;
    private final OperatingSystem operatingSystem;

    @Inject
    public JbrResolver(@NotNull String jreRepository, boolean isOffline, @NotNull ArchiveUtils archiveUtils, @NotNull DependenciesDownloader dependenciesDownloader, @Nullable String context) {
        Intrinsics.checkParameterIsNotNull((Object)jreRepository, (String)"jreRepository");
        Intrinsics.checkParameterIsNotNull((Object)archiveUtils, (String)"archiveUtils");
        Intrinsics.checkParameterIsNotNull((Object)dependenciesDownloader, (String)"dependenciesDownloader");
        this.jreRepository = jreRepository;
        this.isOffline = isOffline;
        this.archiveUtils = archiveUtils;
        this.dependenciesDownloader = dependenciesDownloader;
        this.context = context;
        this.operatingSystem = OperatingSystem.current();
    }

    @Nullable
    public final String resolveRuntimeDir(@Nullable String runtimeDir, @Nullable String jbrVersion, @Nullable File ideDir, @NotNull Function1<? super String, Boolean> validate) {
        Object object;
        String string;
        Intrinsics.checkParameterIsNotNull(validate, (String)"validate");
        Utils.debug$default(this.context, "Resolving runtime directory.", null, 4, null);
        boolean bl = OperatingSystem.current().isMacOsX();
        if (bl) {
            string = "jbr/Contents/Home";
        } else if (!bl) {
            string = "jbr";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String jbrPath = string;
        Object object2 = new Function0[]{(Function0)new Function0<String>(runtimeDir, jbrPath, this){
            final /* synthetic */ String $runtimeDir;
            final /* synthetic */ String $jbrPath;
            final /* synthetic */ JbrResolver this$0;
            {
                this.$runtimeDir = $runtimeDir;
                this.$jbrPath = $jbrPath;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                String string;
                String string2 = this.$runtimeDir;
                if (string2 == null) {
                    string = null;
                } else {
                    String string3 = string2;
                    String string4 = this.$jbrPath;
                    JbrResolver jbrResolver = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    String path = string3;
                    boolean bl3 = false;
                    String string5 = path;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    String it = string5;
                    boolean bl6 = false;
                    File file = FilesKt.resolve((File)FilesKt.resolve((File)new File(it), (String)string4), (String)"bin/java");
                    boolean bl7 = false;
                    boolean bl8 = false;
                    File p0 = file;
                    boolean bl9 = false;
                    File file2 = p0.exists() ? file : null;
                    string5 = file2 == null ? null : file2.getCanonicalPath();
                    bl4 = false;
                    bl5 = false;
                    it = string5;
                    boolean bl10 = false;
                    Utils.debug$default(JbrResolver.access$getContext$p(jbrResolver), "Runtime specified with runtimeDir='" + path + "' resolved as: " + it, null, 4, null);
                    string = Utils.ifNull(string5, (Function0<Unit>)((Function0)new Function0<Unit>(jbrResolver, path){
                        final /* synthetic */ JbrResolver this$0;
                        final /* synthetic */ String $path;
                        {
                            this.this$0 = $receiver;
                            this.$path = $path;
                            super(0);
                        }

                        public final void invoke() {
                            Utils.warn$default(JbrResolver.access$getContext$p(this.this$0), "Cannot resolve runtime with runtimeDir='" + this.$path + "'", null, 4, null);
                        }
                    }));
                }
                return string;
            }
        }, (Function0)new Function0<String>(jbrVersion, this){
            final /* synthetic */ String $jbrVersion;
            final /* synthetic */ JbrResolver this$0;
            {
                this.$jbrVersion = $jbrVersion;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                String string;
                String string2 = this.$jbrVersion;
                if (string2 == null) {
                    string = null;
                } else {
                    String string3 = string2;
                    JbrResolver jbrResolver = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    String version = string3;
                    boolean bl3 = false;
                    Object object = jbrResolver.resolve(version);
                    object = object == null ? null : ((Jbr)object).getJavaExecutable();
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Object it = object;
                    boolean bl6 = false;
                    Utils.debug$default(JbrResolver.access$getContext$p(jbrResolver), "Runtime specified with jbrVersion='" + version + "' resolved as: " + (String)it, null, 4, null);
                    string = (String)Utils.ifNull(object, (Function0<Unit>)((Function0)new Function0<Unit>(jbrResolver, version){
                        final /* synthetic */ JbrResolver this$0;
                        final /* synthetic */ String $version;
                        {
                            this.this$0 = $receiver;
                            this.$version = $version;
                            super(0);
                        }

                        public final void invoke() {
                            Utils.warn$default(JbrResolver.access$getContext$p(this.this$0), "Cannot resolve runtime with jbrVersion='" + this.$version + "'", null, 4, null);
                        }
                    }));
                }
                return string;
            }
        }, (Function0)new Function0<String>(ideDir, jbrPath, this){
            final /* synthetic */ File $ideDir;
            final /* synthetic */ String $jbrPath;
            final /* synthetic */ JbrResolver this$0;
            {
                this.$ideDir = $ideDir;
                this.$jbrPath = $jbrPath;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                Object object;
                File file = this.$ideDir;
                if (file == null) {
                    object = null;
                } else {
                    File file2 = file;
                    String string = this.$jbrPath;
                    JbrResolver jbrResolver = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    File file3 = file2;
                    boolean bl3 = false;
                    Object object2 = file3;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Object it = object2;
                    boolean bl6 = false;
                    File file4 = FilesKt.resolve((File)FilesKt.resolve((File)file3, (String)string), (String)"bin/java");
                    boolean bl7 = false;
                    boolean bl8 = false;
                    File p0 = file4;
                    boolean bl9 = false;
                    File file5 = p0.exists() ? file4 : null;
                    object2 = file5 == null ? null : file5.getCanonicalPath();
                    bl4 = false;
                    bl5 = false;
                    it = object2;
                    boolean bl10 = false;
                    Utils.debug$default(JbrResolver.access$getContext$p(jbrResolver), "Runtime specified with ideDir='" + file3 + "' resolved as: " + (String)it, null, 4, null);
                    object = object2;
                }
                return object;
            }
        }, (Function0)new Function0<String>(ideDir, this){
            final /* synthetic */ File $ideDir;
            final /* synthetic */ JbrResolver this$0;
            {
                this.$ideDir = $ideDir;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                String string;
                File file = this.$ideDir;
                if (file == null) {
                    string = null;
                } else {
                    String string2;
                    File file2 = file;
                    JbrResolver jbrResolver = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    File file3 = file2;
                    boolean bl3 = false;
                    String string3 = JbrResolver.access$getBuiltinJbrVersion(jbrResolver, file3);
                    if (string3 == null) {
                        string2 = null;
                    } else {
                        String string4 = string3;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        String version = string4;
                        boolean bl6 = false;
                        Object object = jbrResolver.resolve(version);
                        object = object == null ? null : ((Jbr)object).getJavaExecutable();
                        boolean bl7 = false;
                        boolean bl8 = false;
                        Object it = object;
                        boolean bl9 = false;
                        Utils.debug$default(JbrResolver.access$getContext$p(jbrResolver), "Runtime specified with ideDir='" + file3 + "', version='version' resolved as: " + (String)it, null, 4, null);
                        string2 = (String)Utils.ifNull(object, (Function0<Unit>)((Function0)new Function0<Unit>(jbrResolver, file3){
                            final /* synthetic */ JbrResolver this$0;
                            final /* synthetic */ File $file;
                            {
                                this.this$0 = $receiver;
                                this.$file = $file;
                                super(0);
                            }

                            public final void invoke() {
                                Utils.warn$default(JbrResolver.access$getContext$p(this.this$0), "Cannot resolve runtime with ideDir='" + this.$file + "', version='version'", null, 4, null);
                            }
                        }));
                    }
                    string = Utils.ifNull(string2, (Function0<Unit>)((Function0)new Function0<Unit>(jbrResolver, file3){
                        final /* synthetic */ JbrResolver this$0;
                        final /* synthetic */ File $file;
                        {
                            this.this$0 = $receiver;
                            this.$file = $file;
                            super(0);
                        }

                        public final void invoke() {
                            Utils.warn$default(JbrResolver.access$getContext$p(this.this$0), "Cannot resolve runtime with ideDir='" + this.$file + "'", null, 4, null);
                        }
                    }));
                }
                return string;
            }
        }, (Function0)new Function0<String>(this){
            final /* synthetic */ JbrResolver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                String string = Jvm.current().getJavaExecutable().getCanonicalPath();
                JbrResolver jbrResolver = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                String it = string;
                boolean bl3 = false;
                Utils.debug$default(JbrResolver.access$getContext$p(jbrResolver), "Using current JVM: " + it, null, 4, null);
                return string;
            }
        }};
        String string2 = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.listOf((Object[])object2)), (Function1)((Function1)new Function1<Function0<? extends String>, String>(validate){
            final /* synthetic */ Function1<String, Boolean> $validate;
            {
                this.$validate = $validate;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull Function0<String> it) {
                String string;
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                String string2 = (String)it.invoke();
                if (string2 == null) {
                    string = null;
                } else {
                    String string3 = string2;
                    Function1<String, Boolean> function1 = this.$validate;
                    boolean bl = false;
                    boolean bl2 = false;
                    string = (Boolean)function1.invoke((Object)string3) != false ? string3 : null;
                }
                return string;
            }
        })));
        if (string2 == null) {
            object = null;
        } else {
            object2 = string2;
            boolean bl2 = false;
            boolean bl3 = false;
            Object it = object2;
            boolean bl4 = false;
            Utils.debug$default(this.context, "Resolved JVM Runtime directory: " + (String)it, null, 4, null);
            object = object2;
        }
        return object;
    }

    public static /* synthetic */ String resolveRuntimeDir$default(JbrResolver jbrResolver, String string, String string2, File file, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resolveRuntimeDir");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            file = null;
        }
        if ((n & 8) != 0) {
            function1 = resolveRuntimeDir.1.INSTANCE;
        }
        return jbrResolver.resolveRuntimeDir(string, string2, file, (Function1<? super String, Boolean>)function1);
    }

    @Nullable
    public final Jbr resolve(@Nullable String version) {
        Jbr jbr;
        CharSequence charSequence = version;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        Object object = "8";
        boolean bl3 = false;
        boolean bl4 = false;
        String string = object;
        JbrArtifact.Companion companion = JbrArtifact.Companion;
        boolean bl5 = false;
        boolean bl6 = StringsKt.startsWith$default((CharSequence)version, (char)'u', (boolean)false, (int)2, null);
        Object object2 = bl6 ? object : null;
        String string2 = (String)(object2 == null ? "" : object2) + version;
        object2 = this.operatingSystem;
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"operatingSystem");
        JbrArtifact jbrArtifact = companion.from(string2, (OperatingSystem)object2);
        object2 = this.getJavaArchive(jbrArtifact);
        if (object2 == null) {
            jbr = null;
        } else {
            object = object2;
            bl3 = false;
            bl4 = false;
            Object it = object;
            boolean bl7 = false;
            String string3 = ((File)it).getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.path");
            File javaDir = FilesKt.resolve((File)new File(StringsKt.replaceAfter$default((String)string3, (String)jbrArtifact.getName(), (String)"", null, (int)4, null)), (String)"extracted");
            ArchiveUtils.extract$default(this.archiveUtils, (File)it, javaDir, this.context, null, null, 24, null);
            jbr = this.fromDir(javaDir, version);
        }
        return jbr;
    }

    private final Jbr fromDir(File javaDir, String version) {
        Path javaExecutable = this.findJavaExecutable(javaDir);
        if (javaExecutable == null) {
            Utils.warn$default(this.context, "Cannot find java executable in: " + javaDir, null, 4, null);
            return null;
        }
        return new Jbr(version, javaDir, javaExecutable.toFile().getAbsolutePath());
    }

    private final File getJavaArchive(JbrArtifact jbrArtifact) {
        if (this.isOffline) {
            Utils.warn$default(this.context, "Cannot download JetBrains Java Runtime '" + jbrArtifact.getName() + "'. Gradle runs in offline mode.", null, 4, null);
            return null;
        }
        String string = this.jreRepository;
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        Object object = charSequence.length() > 0 ? string : null;
        String url = object == null ? jbrArtifact.getRepositoryUrl() : object;
        try {
            object = (File)CollectionsKt.first(this.dependenciesDownloader.downloadFromRepository(this.context, (Function1<? super DependencyHandler, ? extends Dependency>)((Function1)new Function1<DependencyHandler, Dependency>(jbrArtifact){
                final /* synthetic */ JbrArtifact $jbrArtifact;
                {
                    this.$jbrArtifact = $jbrArtifact;
                    super(1);
                }

                @NotNull
                public final Dependency invoke(@NotNull DependencyHandler $this$downloadFromRepository) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$downloadFromRepository, (String)"$this$downloadFromRepository");
                    return DependenciesDownloaderKt.create$default($this$downloadFromRepository, "com.jetbrains", "jbre", this.$jbrArtifact.getName(), null, "tar.gz", null, 40, null);
                }
            }), (Function1<? super RepositoryHandler, ? extends ArtifactRepository>)((Function1)new Function1<RepositoryHandler, ArtifactRepository>(url){
                final /* synthetic */ String $url;
                {
                    this.$url = $url;
                    super(1);
                }

                @NotNull
                public final ArtifactRepository invoke(@NotNull RepositoryHandler $this$downloadFromRepository) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$downloadFromRepository, (String)"$this$downloadFromRepository");
                    IvyArtifactRepository ivyArtifactRepository = DependenciesDownloaderKt.ivyRepository($this$downloadFromRepository, this.$url, "[revision].tar.gz");
                    Intrinsics.checkExpressionValueIsNotNull((Object)ivyArtifactRepository, (String)"ivyRepository(url, \"[revision].tar.gz\")");
                    return (ArtifactRepository)ivyArtifactRepository;
                }
            })));
        }
        catch (Exception e) {
            Utils.warn(this.context, "Cannot download JetBrains Java Runtime '" + jbrArtifact.getName() + "'", e);
            object = null;
        }
        return object;
    }

    private final Path findJavaExecutable(File javaHome) {
        File root = this.getJbrRoot(javaHome);
        File jre = new File(root, "jre");
        Object object = jre;
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        boolean bl4 = ((File)it).exists();
        Object object2 = bl4 ? object : null;
        object = ".exe";
        bl = false;
        bl2 = false;
        it = object;
        File file = object2 == null ? root : object2;
        boolean bl5 = false;
        boolean bl6 = this.operatingSystem.isWindows();
        object2 = bl6 ? object : null;
        String string = "bin/java" + (String)(object2 == null ? "" : object2);
        File file2 = file;
        File java = new File(file2, string);
        object2 = java.toPath();
        boolean bl7 = false;
        bl = false;
        Object it2 = object2;
        boolean bl8 = false;
        return java.exists() ? object2 : null;
    }

    private final File getJbrRoot(File javaHome) {
        String string;
        File jbr;
        block12: {
            File file;
            File[] fileArray = javaHome.listFiles();
            if (fileArray == null) {
                file = null;
            } else {
                File[] $this$firstOrNull$iv = fileArray;
                boolean $i$f$firstOrNull = false;
                File[] fileArray2 = $this$firstOrNull$iv;
                int n = fileArray2.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File it = element$iv = fileArray2[i];
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"jbr") || Intrinsics.areEqual((Object)it.getName(), (Object)"jbrsdk"))) continue;
                    file = element$iv;
                    break block12;
                }
                file = jbr = null;
            }
        }
        if (jbr != null && jbr.exists()) {
            File file;
            boolean bl = this.operatingSystem.isMacOsX();
            if (bl) {
                file = new File(jbr, "Contents/Home");
            } else if (!bl) {
                file = jbr;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return file;
        }
        boolean bl = this.operatingSystem.isMacOsX();
        if (bl) {
            string = "jdk/Contents/Home";
        } else if (!bl) {
            string = "";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return new File(javaHome, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getBuiltinJbrVersion(File ideDirectory) {
        File dependenciesFile = new File(ideDirectory, "dependencies.txt");
        if (dependenciesFile.exists()) {
            Properties properties = new Properties();
            try (FileReader reader = new FileReader(dependenciesFile);){
                properties.load(reader);
                String string = properties.getProperty("jdkBuild");
                return string;
            }
        }
        return null;
    }

    public static final /* synthetic */ String access$getContext$p(JbrResolver $this) {
        return $this.context;
    }

    public static final /* synthetic */ String access$getBuiltinJbrVersion(JbrResolver $this, File ideDirectory) {
        return $this.getBuiltinJbrVersion(ideDirectory);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/intellij/jbr/JbrResolver$JbrArtifact;", "", "name", "", "repositoryUrl", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getRepositoryUrl", "Companion", "gradle-intellij-plugin"})
    private static final class JbrArtifact {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;
        @NotNull
        private final String repositoryUrl;

        public JbrArtifact(@NotNull String name, @NotNull String repositoryUrl) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)repositoryUrl, (String)"repositoryUrl");
            this.name = name;
            this.repositoryUrl = repositoryUrl;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getRepositoryUrl() {
            return this.repositoryUrl;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/intellij/jbr/JbrResolver$JbrArtifact$Companion;", "", "()V", "arch", "", "newFormat", "", "from", "Lorg/jetbrains/intellij/jbr/JbrResolver$JbrArtifact;", "version", "operatingSystem", "Lorg/gradle/internal/os/OperatingSystem;", "getPrefix", "platform", "gradle-intellij-plugin"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final JbrArtifact from(@NotNull String version, @NotNull OperatingSystem operatingSystem) {
                boolean oldFormat;
                String string;
                boolean bl;
                String string2;
                int n;
                int n2;
                String string3;
                boolean bl2;
                Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
                Intrinsics.checkParameterIsNotNull((Object)operatingSystem, (String)"operatingSystem");
                String prefix2 = this.getPrefix(version);
                int lastIndexOfB = StringsKt.lastIndexOf$default((CharSequence)version, (char)'b', (int)0, (boolean)false, (int)6, null);
                boolean bl3 = bl2 = lastIndexOfB > -1;
                if (bl2) {
                    string3 = version;
                    n2 = prefix2.length();
                    n = 0;
                    String string4 = string3.substring(n2, lastIndexOfB);
                    string2 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                } else if (!bl2) {
                    string3 = version;
                    n2 = prefix2.length();
                    n = 0;
                    String string5 = string3.substring(n2);
                    string2 = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                String majorVersion = string2;
                boolean bl4 = bl = lastIndexOfB > -1;
                if (bl) {
                    String string6 = version;
                    n = lastIndexOfB + 1;
                    boolean bl5 = false;
                    String string7 = string6.substring(n);
                    string = string7;
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                } else {
                    string = "";
                }
                String buildNumberString = string;
                Version buildNumber = Version.Companion.parse(buildNumberString);
                boolean isJava8 = StringsKt.startsWith$default((CharSequence)majorVersion, (char)'8', (boolean)false, (int)2, null);
                String repositoryUrl = "https://cache-redirector.jetbrains.com/intellij-jbr";
                boolean bl6 = oldFormat = Intrinsics.areEqual((Object)prefix2, (Object)"jbrex") || isJava8 && buildNumber.compareTo(Version.Companion.parse("1483.24")) < 0;
                if (oldFormat) {
                    return new JbrArtifact("jbrex" + majorVersion + "b" + buildNumberString + "_" + this.platform(operatingSystem) + "_" + this.arch(false), repositoryUrl);
                }
                CharSequence charSequence = prefix2;
                boolean bl7 = false;
                if (charSequence.length() == 0) {
                    prefix2 = isJava8 ? "jbrx-" : (buildNumber.compareTo(Version.Companion.parse("1319.6")) < 0 ? "jbr-" : "jbr_jcef-");
                }
                return new JbrArtifact(prefix2 + majorVersion + "-" + this.platform(operatingSystem) + "-" + this.arch(isJava8) + "-b" + buildNumberString, repositoryUrl);
            }

            private final String getPrefix(String version) {
                return StringsKt.startsWith$default((String)version, (String)"jbrsdk-", (boolean)false, (int)2, null) ? "jbrsdk-" : (StringsKt.startsWith$default((String)version, (String)"jbr_jcef-", (boolean)false, (int)2, null) ? "jbr_jcef-" : (StringsKt.startsWith$default((String)version, (String)"jbr-", (boolean)false, (int)2, null) ? "jbr-" : (StringsKt.startsWith$default((String)version, (String)"jbrx-", (boolean)false, (int)2, null) ? "jbrx-" : (StringsKt.startsWith$default((String)version, (String)"jbrex8", (boolean)false, (int)2, null) ? "jbrex" : ""))));
            }

            private final String platform(OperatingSystem operatingSystem) {
                return operatingSystem.isWindows() ? "windows" : (operatingSystem.isMacOsX() ? "osx" : "linux");
            }

            private final String arch(boolean newFormat) {
                String string;
                String arch = System.getProperty("os.arch");
                if (Intrinsics.areEqual((Object)"aarch64", (Object)arch) || Intrinsics.areEqual((Object)"arm64", (Object)arch)) {
                    return "aarch64";
                }
                if (Intrinsics.areEqual((Object)"x86_64", (Object)arch) || Intrinsics.areEqual((Object)"amd64", (Object)arch)) {
                    return "x64";
                }
                String name = System.getProperty("os.name");
                Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"name");
                if (StringsKt.contains$default((CharSequence)name, (CharSequence)"Windows", (boolean)false, (int)2, null) && System.getenv("ProgramFiles(x86)") != null) {
                    return "x64";
                }
                boolean bl = newFormat;
                if (bl) {
                    string = "i586";
                } else if (!bl) {
                    string = "x86";
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return string;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

