/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.publish.ivy.IvyConfiguration;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyConfiguration;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyPublicationIdentity;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.tooling.BuildException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.IntelliJIvyDescriptorFileGenerator;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.BuiltinPluginsRegistry;
import org.jetbrains.intellij.dependency.IdeaDependency;
import org.jetbrains.intellij.dependency.IdeaExtraDependency;
import org.jetbrains.intellij.dependency.IntellijIvyArtifact;
import org.jetbrains.intellij.dependency.JpsIdeaDependency;
import org.jetbrains.intellij.dependency.LocalIdeaDependency;
import org.jetbrains.intellij.utils.ArchiveUtils;
import org.jetbrains.intellij.utils.DependenciesDownloader;
import org.jetbrains.intellij.utils.DependenciesDownloaderKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0016\u0018\u00002\u00020\u0001B1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\nJR\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J \u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010!\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020 H\u0002J\u001e\u0010$\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'J\u0018\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J,\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00032\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0002J\"\u0010+\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J \u0010,\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010-\u001a\u00020\u00032\b\u0010.\u001a\u0004\u0018\u00010\u0003J4\u0010/\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u00100\u001a\u00020 2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\fJ\u001a\u00101\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\"\u00102\u001a\u00020%2\u0006\u00103\u001a\u00020\u00142\u0006\u00104\u001a\u00020\u00032\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0002J\u0018\u00105\u001a\u00020%2\u0006\u00106\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0014H\u0002J(\u00107\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u00108\u001a\u00020 H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/jetbrains/intellij/dependency/IdeaDependencyManager;", "", "repositoryUrl", "", "ideaDependencyCachePath", "archiveUtils", "Lorg/jetbrains/intellij/utils/ArchiveUtils;", "dependenciesDownloader", "Lorg/jetbrains/intellij/utils/DependenciesDownloader;", "context", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/intellij/utils/ArchiveUtils;Lorg/jetbrains/intellij/utils/DependenciesDownloader;Ljava/lang/String;)V", "mainDependencies", "", "createDependency", "Lorg/jetbrains/intellij/dependency/IdeaDependency;", "name", "type", "version", "buildNumber", "classesDirectory", "Ljava/io/File;", "sourcesDirectory", "project", "Lorg/gradle/api/Project;", "extraDependencies", "", "Lorg/jetbrains/intellij/dependency/IdeaExtraDependency;", "getOrCreateIvyXml", "dependency", "getZipCacheDirectory", "zipFile", "hasKotlinDependency", "", "isCacheUpToDate", "markerFile", "checkVersion", "register", "", "dependencies", "Lorg/gradle/api/artifacts/DependencySet;", "resetExecutablePermissions", "cacheDirectory", "resolveExtraDependencies", "resolveExtraDependency", "resolveLocal", "localPath", "localPathSources", "resolveRemote", "sources", "resolveSources", "setExecutable", "parent", "child", "storeCache", "directoryToCache", "unzipDependencyFile", "checkVersionChange", "gradle-intellij-plugin"})
public class IdeaDependencyManager {
    @NotNull
    private final String repositoryUrl;
    @NotNull
    private final String ideaDependencyCachePath;
    @NotNull
    private final ArchiveUtils archiveUtils;
    @NotNull
    private final DependenciesDownloader dependenciesDownloader;
    @Nullable
    private final String context;
    @NotNull
    private final List<String> mainDependencies;

    @Inject
    public IdeaDependencyManager(@NotNull String repositoryUrl, @NotNull String ideaDependencyCachePath, @NotNull ArchiveUtils archiveUtils, @NotNull DependenciesDownloader dependenciesDownloader, @Nullable String context) {
        Intrinsics.checkParameterIsNotNull((Object)repositoryUrl, (String)"repositoryUrl");
        Intrinsics.checkParameterIsNotNull((Object)ideaDependencyCachePath, (String)"ideaDependencyCachePath");
        Intrinsics.checkParameterIsNotNull((Object)archiveUtils, (String)"archiveUtils");
        Intrinsics.checkParameterIsNotNull((Object)dependenciesDownloader, (String)"dependenciesDownloader");
        this.repositoryUrl = repositoryUrl;
        this.ideaDependencyCachePath = ideaDependencyCachePath;
        this.archiveUtils = archiveUtils;
        this.dependenciesDownloader = dependenciesDownloader;
        this.context = context;
        Object[] objectArray = new String[]{"ideaIC", "ideaIU", "riderRD", "riderRS"};
        this.mainDependencies = CollectionsKt.listOf((Object[])objectArray);
    }

    public final void register(@NotNull Project project, @NotNull IdeaDependency dependency, @NotNull DependencySet dependencies) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
        Intrinsics.checkParameterIsNotNull((Object)dependencies, (String)"dependencies");
        File ivyFile = this.getOrCreateIvyXml(dependency);
        String string = ivyFile.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ivyFile.name");
        int n = (dependency.getName() + "-" + dependency.getVersion()).length();
        boolean bl = false;
        String string2 = string.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        String ivyFileSuffix = StringsKt.removeSuffix((String)string2, (CharSequence)".xml");
        project.getRepositories().ivy(arg_0 -> IdeaDependencyManager.register$lambda-0(dependency, ivyFile, ivyFileSuffix, arg_0));
        string = project.getDependencies();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.dependencies");
        dependencies.add((Object)DependenciesDownloaderKt.create$default((DependencyHandler)string, "com.jetbrains", dependency.getName(), dependency.getVersion(), null, null, "compile", 24, null));
    }

    private final IdeaDependency createDependency(String name, String type, String version, String buildNumber, File classesDirectory2, File sourcesDirectory, Project project, Collection<IdeaExtraDependency> extraDependencies) {
        IdeaDependency ideaDependency;
        String string = type;
        if (Intrinsics.areEqual((Object)string, (Object)"JPS")) {
            ideaDependency = new JpsIdeaDependency(version, buildNumber, classesDirectory2, sourcesDirectory, !this.hasKotlinDependency(project), this.context);
        } else {
            BuiltinPluginsRegistry pluginsRegistry = BuiltinPluginsRegistry.Companion.fromDirectory(new File(classesDirectory2, "plugins"), this.context);
            String string2 = type;
            ideaDependency = string2 == null ? (IdeaDependency)new LocalIdeaDependency(name, version, buildNumber, classesDirectory2, sourcesDirectory, !this.hasKotlinDependency(project), pluginsRegistry, extraDependencies) : new IdeaDependency(name, version, buildNumber, classesDirectory2, sourcesDirectory, !this.hasKotlinDependency(project), pluginsRegistry, extraDependencies);
        }
        return ideaDependency;
    }

    private final File resolveSources(String version, String type) {
        Utils.info$default(this.context, "Adding IDE sources repository", null, 4, null);
        try {
            String releaseType = Utils.releaseType(version);
            boolean forPyCharm = Utils.isPyCharmType(type);
            List<File> sourcesFiles2 = this.dependenciesDownloader.downloadFromRepository(this.context, (Function1<? super DependencyHandler, ? extends Dependency>)((Function1)new Function1<DependencyHandler, Dependency>(forPyCharm, version){
                final /* synthetic */ boolean $forPyCharm;
                final /* synthetic */ String $version;
                {
                    this.$forPyCharm = $forPyCharm;
                    this.$version = $version;
                    super(1);
                }

                @NotNull
                public final Dependency invoke(@NotNull DependencyHandler $this$downloadFromRepository) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$downloadFromRepository, (String)"$this$downloadFromRepository");
                    return DependenciesDownloaderKt.create$default($this$downloadFromRepository, this.$forPyCharm ? "com.jetbrains.intellij.pycharm" : "com.jetbrains.intellij.idea", this.$forPyCharm ? "pycharmPC" : "ideaIC", this.$version, "sources", "jar", null, 32, null);
                }
            }), (Function1<? super RepositoryHandler, ? extends ArtifactRepository>)((Function1)new Function1<RepositoryHandler, ArtifactRepository>(this, releaseType){
                final /* synthetic */ IdeaDependencyManager this$0;
                final /* synthetic */ String $releaseType;
                {
                    this.this$0 = $receiver;
                    this.$releaseType = $releaseType;
                    super(1);
                }

                @NotNull
                public final ArtifactRepository invoke(@NotNull RepositoryHandler $this$downloadFromRepository) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$downloadFromRepository, (String)"$this$downloadFromRepository");
                    MavenArtifactRepository mavenArtifactRepository = DependenciesDownloaderKt.mavenRepository($this$downloadFromRepository, IdeaDependencyManager.access$getRepositoryUrl$p(this.this$0) + "/" + this.$releaseType);
                    Intrinsics.checkExpressionValueIsNotNull((Object)mavenArtifactRepository, (String)"mavenRepository(\"$repositoryUrl/$releaseType\")");
                    return (ArtifactRepository)mavenArtifactRepository;
                }
            }));
            if (sourcesFiles2.size() == 1) {
                File sourcesDirectory = (File)CollectionsKt.first(sourcesFiles2);
                Utils.debug$default(this.context, "IDE sources jar: " + sourcesDirectory.getPath(), null, 4, null);
                return sourcesDirectory;
            }
            Utils.warn$default(this.context, "Cannot attach IDE sources. Found files: " + sourcesFiles2, null, 4, null);
        }
        catch (ResolveException e) {
            Utils.warn(this.context, "Cannot resolve IDE sources dependency", e);
        }
        return null;
    }

    private final File unzipDependencyFile(File cacheDirectory, File zipFile, String type, boolean checkVersionChange) {
        String string = zipFile.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"zipFile.name");
        return this.archiveUtils.extract(zipFile, FilesKt.resolve((File)cacheDirectory, (String)StringsKt.removeSuffix((String)string, (CharSequence)".zip")), this.context, arg_0 -> IdeaDependencyManager.unzipDependencyFile$lambda-1(this, zipFile, checkVersionChange, arg_0), (arg_0, arg_1) -> IdeaDependencyManager.unzipDependencyFile$lambda-2(this, type, arg_0, arg_1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isCacheUpToDate(File zipFile, File markerFile, boolean checkVersion) {
        if (!checkVersion) {
            return markerFile.exists();
        }
        if (!markerFile.exists()) {
            return false;
        }
        Closeable closeable = new ZipFile(zipFile);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ZipFile zip = (ZipFile)closeable;
            boolean bl3 = false;
            ZipEntry entry = zip.getEntry("build.txt");
            if (entry != null) {
                Closeable closeable2 = zip.getInputStream(entry);
                Intrinsics.checkExpressionValueIsNotNull((Object)closeable2, (String)"zip.getInputStream(entry)");
                Charset charset = Charsets.UTF_8;
                boolean bl4 = false;
                Object object = closeable2;
                int n = 0;
                object = new InputStreamReader((InputStream)object, charset);
                n = 8192;
                boolean bl5 = false;
                closeable2 = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
                boolean bl6 = false;
                bl4 = false;
                Throwable throwable2 = null;
                try {
                    BufferedReader it = (BufferedReader)closeable2;
                    boolean bl7 = false;
                    object = TextStreamsKt.readText((Reader)it);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                if (!Intrinsics.areEqual((Object)object, (Object)FilesKt.readText$default((File)markerFile, null, (int)1, null))) {
                    boolean bl8 = false;
                    return bl8;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return true;
    }

    private final void storeCache(File directoryToCache, File markerFile) {
        File file;
        File file2 = new File(directoryToCache, "build.txt");
        boolean bl = false;
        boolean bl2 = false;
        File it = file2;
        boolean bl3 = false;
        File file3 = file = it.exists() ? file2 : null;
        if (file != null) {
            file2 = file;
            bl = false;
            bl2 = false;
            it = file2;
            boolean bl4 = false;
            String string = FilesKt.readText$default((File)it, null, (int)1, null);
            boolean bl5 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            FilesKt.writeText$default((File)markerFile, (String)((Object)StringsKt.trim((CharSequence)string2)).toString(), null, (int)2, null);
        }
    }

    private final void resetExecutablePermissions(File cacheDirectory, String type) {
        if (Intrinsics.areEqual((Object)type, (Object)"RD") && !OperatingSystem.current().isWindows()) {
            this.setExecutable(cacheDirectory, "lib/ReSharperHost/dupfinder.sh", this.context);
            this.setExecutable(cacheDirectory, "lib/ReSharperHost/inspectcode.sh", this.context);
            this.setExecutable(cacheDirectory, "lib/ReSharperHost/JetBrains.ReSharper.Host.sh", this.context);
            this.setExecutable(cacheDirectory, "lib/ReSharperHost/runtime.sh", this.context);
            this.setExecutable(cacheDirectory, "lib/ReSharperHost/macos-x64/mono/bin/env-wrapper", this.context);
            this.setExecutable(cacheDirectory, "lib/ReSharperHost/macos-x64/mono/bin/mono-sgen", this.context);
            this.setExecutable(cacheDirectory, "lib/ReSharperHost/macos-x64/mono/bin/mono-sgen-gdb.py", this.context);
            this.setExecutable(cacheDirectory, "lib/ReSharperHost/linux-x64/mono/bin/mono-sgen", this.context);
            this.setExecutable(cacheDirectory, "lib/ReSharperHost/linux-x64/mono/bin/mono-sgen-gdb.py", this.context);
        }
    }

    private final void setExecutable(File parent, String child, String context) {
        File file = new File(parent, child);
        boolean bl = false;
        boolean bl2 = false;
        File $this$setExecutable_u24lambda_u2d7 = file;
        boolean bl3 = false;
        Utils.debug$default(context, "Resetting executable permissions for: " + $this$setExecutable_u24lambda_u2d7.getPath(), null, 4, null);
        $this$setExecutable_u24lambda_u2d7.setExecutable(true, true);
    }

    private final File getOrCreateIvyXml(IdeaDependency dependency) {
        File ivyFile;
        File directory = dependency.getIvyRepositoryDirectory();
        File file = ivyFile = directory != null ? new File(directory, dependency.getFqn() + ".xml") : File.createTempFile(dependency.getFqn(), ".xml");
        if (directory == null || !ivyFile.exists()) {
            DefaultIvyPublicationIdentity identity = new DefaultIvyPublicationIdentity("com.jetbrains", dependency.getName(), dependency.getVersion());
            IntelliJIvyDescriptorFileGenerator intelliJIvyDescriptorFileGenerator = new IntelliJIvyDescriptorFileGenerator((IvyPublicationIdentity)identity);
            boolean bl = false;
            boolean bl2 = false;
            IntelliJIvyDescriptorFileGenerator $this$getOrCreateIvyXml_u24lambda_u2d9 = intelliJIvyDescriptorFileGenerator;
            boolean bl3 = false;
            $this$getOrCreateIvyXml_u24lambda_u2d9.addConfiguration((IvyConfiguration)new DefaultIvyConfiguration("default"));
            $this$getOrCreateIvyXml_u24lambda_u2d9.addConfiguration((IvyConfiguration)new DefaultIvyConfiguration("compile"));
            $this$getOrCreateIvyXml_u24lambda_u2d9.addConfiguration((IvyConfiguration)new DefaultIvyConfiguration("sources"));
            Iterable $this$forEach$iv = dependency.getJarFiles();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl4 = false;
                $this$getOrCreateIvyXml_u24lambda_u2d9.addArtifact(IntellijIvyArtifact.Companion.createJarDependency(it, "compile", dependency.getClasses(), null));
            }
            if (dependency.getSources() != null) {
                String name = Utils.isDependencyOnPyCharm(dependency) ? "pycharmPC" : "ideaIC";
                IntellijIvyArtifact artifact = new IntellijIvyArtifact(dependency.getSources(), name, "jar", "sources", "sources");
                artifact.setConf("sources");
                $this$getOrCreateIvyXml_u24lambda_u2d9.addArtifact(artifact);
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ivyFile, (String)"ivyFile");
            $this$getOrCreateIvyXml_u24lambda_u2d9.writeTo(ivyFile);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ivyFile, (String)"ivyFile");
        return ivyFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasKotlinDependency(Project project) {
        boolean bl;
        DependencySet dependencySet = project.getConfigurations().getByName("runtimeClasspath").getAllDependencies();
        Intrinsics.checkExpressionValueIsNotNull((Object)dependencySet, (String)"project.configurations.g\u2026ION_NAME).allDependencies");
        Iterable $this$any$iv = (Iterable)dependencySet;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            Dependency it = (Dependency)element$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)"org.jetbrains.kotlin", (Object)it.getGroup())) {
                String string = it.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
                if (Utils.isKotlinRuntime(string)) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @NotNull
    public final IdeaDependency resolveRemote(@NotNull Project project, @NotNull String version, @NotNull String type, boolean sources, @NotNull List<String> extraDependencies) {
        Pair pair;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull(extraDependencies, (String)"extraDependencies");
        String releaseType = Utils.releaseType(version);
        Utils.debug$default(this.context, "Adding IDE repository: " + this.repositoryUrl + "/" + releaseType, null, 4, null);
        Utils.debug$default(this.context, "Adding IDE dependency", null, 4, null);
        boolean hasSources = sources;
        if (Intrinsics.areEqual((Object)type, (Object)"IU")) {
            pair = TuplesKt.to((Object)"com.jetbrains.intellij.idea", (Object)"ideaIU");
        } else if (Intrinsics.areEqual((Object)type, (Object)"IC")) {
            pair = TuplesKt.to((Object)"com.jetbrains.intellij.idea", (Object)"ideaIC");
        } else if (Intrinsics.areEqual((Object)type, (Object)"CL")) {
            pair = TuplesKt.to((Object)"com.jetbrains.intellij.clion", (Object)"clion");
        } else if (Utils.isPyCharmType(type)) {
            pair = TuplesKt.to((Object)"com.jetbrains.intellij.pycharm", (Object)("pycharm" + type));
        } else if (Intrinsics.areEqual((Object)type, (Object)"GO")) {
            pair = TuplesKt.to((Object)"com.jetbrains.intellij.goland", (Object)"goland");
        } else if (Intrinsics.areEqual((Object)type, (Object)"RD")) {
            if (sources && Intrinsics.areEqual((Object)releaseType, (Object)"snapshots")) {
                Utils.warn$default(this.context, "IDE sources are not available for Rider SNAPSHOTS", null, 4, null);
                hasSources = false;
            }
            pair = TuplesKt.to((Object)"com.jetbrains.intellij.rider", (Object)"riderRD");
        } else if (Intrinsics.areEqual((Object)type, (Object)"GW")) {
            hasSources = false;
            pair = TuplesKt.to((Object)"com.jetbrains.gateway", (Object)"JetBrainsGateway");
        } else {
            throw new BuildException("Specified type '" + type + "' is unknown. Supported values: IC, IU, CL, PY, PC, GO, RD, GW", null);
        }
        Pair pair2 = pair;
        String dependencyGroup = (String)pair2.component1();
        String dependencyName = (String)pair2.component2();
        Object object = CollectionsKt.first(this.dependenciesDownloader.downloadFromRepository(this.context, (Function1<? super DependencyHandler, ? extends Dependency>)((Function1)new Function1<DependencyHandler, Dependency>(dependencyGroup, dependencyName, version){
            final /* synthetic */ String $dependencyGroup;
            final /* synthetic */ String $dependencyName;
            final /* synthetic */ String $version;
            {
                this.$dependencyGroup = $dependencyGroup;
                this.$dependencyName = $dependencyName;
                this.$version = $version;
                super(1);
            }

            @NotNull
            public final Dependency invoke(@NotNull DependencyHandler $this$downloadFromRepository) {
                Intrinsics.checkParameterIsNotNull((Object)$this$downloadFromRepository, (String)"$this$downloadFromRepository");
                return DependenciesDownloaderKt.create$default($this$downloadFromRepository, this.$dependencyGroup, this.$dependencyName, this.$version, null, null, null, 56, null);
            }
        }), (Function1<? super RepositoryHandler, ? extends ArtifactRepository>)((Function1)new Function1<RepositoryHandler, ArtifactRepository>(this, releaseType){
            final /* synthetic */ IdeaDependencyManager this$0;
            final /* synthetic */ String $releaseType;
            {
                this.this$0 = $receiver;
                this.$releaseType = $releaseType;
                super(1);
            }

            @NotNull
            public final ArtifactRepository invoke(@NotNull RepositoryHandler $this$downloadFromRepository) {
                Intrinsics.checkParameterIsNotNull((Object)$this$downloadFromRepository, (String)"$this$downloadFromRepository");
                MavenArtifactRepository mavenArtifactRepository = DependenciesDownloaderKt.mavenRepository($this$downloadFromRepository, IdeaDependencyManager.access$getRepositoryUrl$p(this.this$0) + "/" + this.$releaseType);
                Intrinsics.checkExpressionValueIsNotNull((Object)mavenArtifactRepository, (String)"mavenRepository(\"$repositoryUrl/$releaseType\")");
                return (ArtifactRepository)mavenArtifactRepository;
            }
        })));
        boolean bl = false;
        boolean bl2 = false;
        File it = (File)object;
        boolean bl3 = false;
        Utils.debug$default(this.context, "IDE zip: " + it.getPath(), null, 4, null);
        File classesDirectory2 = this.unzipDependencyFile(this.getZipCacheDirectory(it, project, type), it, type, StringsKt.endsWith$default((String)version, (String)"-SNAPSHOT", (boolean)false, (int)2, null));
        Utils.info$default(this.context, "IDE dependency cache directory: " + classesDirectory2, null, 4, null);
        String buildNumber = Utils.ideBuildNumber(classesDirectory2);
        File sourcesDirectory = hasSources ? this.resolveSources(version, type) : null;
        Collection<IdeaExtraDependency> resolvedExtraDependencies = this.resolveExtraDependencies(project, version, extraDependencies);
        return this.createDependency(dependencyName, type, version, buildNumber, classesDirectory2, sourcesDirectory, project, resolvedExtraDependencies);
    }

    @NotNull
    public final IdeaDependency resolveLocal(@NotNull Project project, @NotNull String localPath, @Nullable String localPathSources) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)localPath, (String)"localPath");
        Utils.debug$default(this.context, "Adding local IDE dependency", null, 4, null);
        File ideaDir = Utils.ideaDir(localPath);
        if (!ideaDir.exists() || !ideaDir.isDirectory()) {
            throw new BuildException("Specified localPath '" + localPath + "' doesn't exist or is not a directory", null);
        }
        String buildNumber = Utils.ideBuildNumber(ideaDir);
        CharSequence charSequence = localPathSources;
        boolean bl = false;
        boolean bl2 = false;
        File sources = !(charSequence == null || charSequence.length() == 0) ? new File(localPathSources) : null;
        return this.createDependency("ideaLocal", null, buildNumber, buildNumber, ideaDir, sources, project, CollectionsKt.emptyList());
    }

    private final File getZipCacheDirectory(File zipFile, Project project, String type) {
        Object object = this.ideaDependencyCachePath;
        boolean bl = false;
        if (object.length() > 0) {
            object = new File(this.ideaDependencyCachePath);
            bl = false;
            boolean bl2 = false;
            Object $this$getZipCacheDirectory_u24lambda_u2d12 = object;
            boolean bl3 = false;
            ((File)$this$getZipCacheDirectory_u24lambda_u2d12).mkdirs();
            return object;
        }
        if (Intrinsics.areEqual((Object)type, (Object)"RD") && OperatingSystem.current().isWindows()) {
            object = project.getBuildDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.buildDir");
            return object;
        }
        object = zipFile.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"zipFile.parentFile");
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<IdeaExtraDependency> resolveExtraDependencies(Project project, String version, List<String> extraDependencies) {
        List list2;
        void $this$filterTo$iv$iv;
        List $this$filter$iv22;
        if (extraDependencies.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Utils.info$default(this.context, "Configuring IDE extra dependencies: " + extraDependencies, null, 4, null);
        Iterable iterable = extraDependencies;
        boolean $i$f$filter = false;
        void var7_8 = $this$filter$iv22;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block9: {
                String dep = (String)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = this.mainDependencies;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)dep)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv22 = (List)destination$iv$iv;
        $i$f$filter = false;
        boolean bl = false;
        List it = $this$filter$iv22;
        boolean bl4 = false;
        Collection collection = it;
        boolean bl5 = false;
        List list3 = list2 = !collection.isEmpty() ? $this$filter$iv22 : null;
        if (list2 != null) {
            $this$filter$iv22 = list2;
            $i$f$filter = false;
            bl = false;
            it = $this$filter$iv22;
            boolean bl6 = false;
            throw new GradleException("The items '" + it + "' cannot be used as extra dependencies");
        }
        boolean $this$filter$iv22 = false;
        List resolvedExtraDependencies = new ArrayList();
        Iterable $this$forEach$iv = extraDependencies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Boolean bl7;
            Boolean bl8;
            String it2 = (String)element$iv;
            boolean bl9 = false;
            File file = this.resolveExtraDependency(project, version, it2);
            if (file == null) {
                bl8 = null;
            } else {
                File file2 = file;
                boolean bl10 = false;
                boolean bl11 = false;
                File dependencyFile = file2;
                boolean bl12 = false;
                IdeaExtraDependency extraDependency = new IdeaExtraDependency(it2, dependencyFile);
                Utils.debug$default(this.context, "IDE extra dependency '" + it2 + "' in '" + dependencyFile + "' files: " + extraDependency.getJarFiles(), null, 4, null);
                bl8 = resolvedExtraDependencies.add(extraDependency);
            }
            if ((bl7 = bl8) != null) continue;
            Utils.debug$default(this.context, "IDE extra dependency for '" + it2 + "' was resolved as null", null, 4, null);
        }
        return resolvedExtraDependencies;
    }

    private final File resolveExtraDependency(Project project, String version, String name) {
        try {
            String releaseType = Utils.releaseType(version);
            List<File> files2 = this.dependenciesDownloader.downloadFromRepository(this.context, (Function1<? super DependencyHandler, ? extends Dependency>)((Function1)new Function1<DependencyHandler, Dependency>(name, version){
                final /* synthetic */ String $name;
                final /* synthetic */ String $version;
                {
                    this.$name = $name;
                    this.$version = $version;
                    super(1);
                }

                @NotNull
                public final Dependency invoke(@NotNull DependencyHandler $this$downloadFromRepository) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$downloadFromRepository, (String)"$this$downloadFromRepository");
                    return DependenciesDownloaderKt.create$default($this$downloadFromRepository, "com.jetbrains.intellij.idea", this.$name, this.$version, null, null, null, 56, null);
                }
            }), (Function1<? super RepositoryHandler, ? extends ArtifactRepository>)((Function1)new Function1<RepositoryHandler, ArtifactRepository>(this, releaseType){
                final /* synthetic */ IdeaDependencyManager this$0;
                final /* synthetic */ String $releaseType;
                {
                    this.this$0 = $receiver;
                    this.$releaseType = $releaseType;
                    super(1);
                }

                @NotNull
                public final ArtifactRepository invoke(@NotNull RepositoryHandler $this$downloadFromRepository) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$downloadFromRepository, (String)"$this$downloadFromRepository");
                    MavenArtifactRepository mavenArtifactRepository = DependenciesDownloaderKt.mavenRepository($this$downloadFromRepository, IdeaDependencyManager.access$getRepositoryUrl$p(this.this$0) + "/" + this.$releaseType);
                    Intrinsics.checkExpressionValueIsNotNull((Object)mavenArtifactRepository, (String)"mavenRepository(\"$repositoryUrl/$releaseType\")");
                    return (ArtifactRepository)mavenArtifactRepository;
                }
            }));
            if (files2.size() == 1) {
                File file;
                File depFile = (File)CollectionsKt.first(files2);
                String string = depFile.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"depFile.name");
                if (StringsKt.endsWith$default((String)string, (String)".zip", (boolean)false, (int)2, null)) {
                    File cacheDirectory = this.getZipCacheDirectory(depFile, project, "IC");
                    Utils.debug$default(this.context, "IDE extra dependency '" + name + "': " + cacheDirectory.getPath(), null, 4, null);
                    file = this.unzipDependencyFile(cacheDirectory, depFile, "IC", StringsKt.endsWith$default((String)version, (String)"-SNAPSHOT", (boolean)false, (int)2, null));
                } else {
                    Utils.debug$default(this.context, "IDE extra dependency '" + name + "': " + depFile.getPath(), null, 4, null);
                    file = depFile;
                }
                return file;
            }
            Utils.warn$default(this.context, "Cannot attach IDE extra dependency '" + name + "'. Found files: " + files2, null, 4, null);
        }
        catch (ResolveException e) {
            Utils.warn(this.context, "Cannot resolve IDE extra dependency '" + name + "'", e);
        }
        return null;
    }

    private static final void register$lambda-0(IdeaDependency $dependency, File $ivyFile, String $ivyFileSuffix, IvyArtifactRepository it) {
        Intrinsics.checkParameterIsNotNull((Object)$dependency, (String)"$dependency");
        Intrinsics.checkParameterIsNotNull((Object)$ivyFile, (String)"$ivyFile");
        Intrinsics.checkParameterIsNotNull((Object)$ivyFileSuffix, (String)"$ivyFileSuffix");
        it.setUrl($dependency.getClasses().toURI());
        it.ivyPattern($ivyFile.getParent() + "/[module]-[revision]" + $ivyFileSuffix + ".[ext]");
        it.artifactPattern($dependency.getClasses().getPath() + "/[artifact].[ext]");
        if ($dependency.getSources() != null) {
            it.artifactPattern($dependency.getSources().getParent() + "/[artifact]-[revision]-[classifier].[ext]");
        }
    }

    private static final boolean unzipDependencyFile$lambda-1(IdeaDependencyManager this$0, File $zipFile, boolean $checkVersionChange, File markerFile) {
        Intrinsics.checkParameterIsNotNull((Object)this$0, (String)"this$0");
        Intrinsics.checkParameterIsNotNull((Object)$zipFile, (String)"$zipFile");
        Intrinsics.checkParameterIsNotNull((Object)markerFile, (String)"markerFile");
        return this$0.isCacheUpToDate($zipFile, markerFile, $checkVersionChange);
    }

    private static final void unzipDependencyFile$lambda-2(IdeaDependencyManager this$0, String $type, File unzippedDirectory, File markerFile) {
        Intrinsics.checkParameterIsNotNull((Object)this$0, (String)"this$0");
        Intrinsics.checkParameterIsNotNull((Object)$type, (String)"$type");
        Intrinsics.checkParameterIsNotNull((Object)unzippedDirectory, (String)"unzippedDirectory");
        Intrinsics.checkParameterIsNotNull((Object)markerFile, (String)"markerFile");
        this$0.resetExecutablePermissions(unzippedDirectory, $type);
        this$0.storeCache(unzippedDirectory, markerFile);
    }

    public static final /* synthetic */ String access$getRepositoryUrl$p(IdeaDependencyManager $this) {
        return $this.repositoryUrl;
    }
}

